/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.secure;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.app.AppInfo;
import com.crosspaste.db.secure.SecureIO;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.platform.macos.MacosKeychainHelper;
import com.crosspaste.presist.FilePersist;
import com.crosspaste.presist.OneFilePersist;
import com.crosspaste.secure.GeneralSecureStore;
import com.crosspaste.secure.SecureKeyPair;
import com.crosspaste.secure.SecureKeyPairSerializer;
import com.crosspaste.secure.SecureStore;
import com.crosspaste.secure.SecureStoreFactory;
import com.crosspaste.utils.AppEnvUtils;
import com.crosspaste.utils.AppEnvUtils_desktopKt;
import com.crosspaste.utils.CryptographyUtils;
import com.crosspaste.utils.EncryptUtils;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0010R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/crosspaste/secure/MacosSecureStoreFactory;", "Lcom/crosspaste/secure/SecureStoreFactory;", "Lcom/crosspaste/app/AppInfo;", "appInfo", "Lcom/crosspaste/path/AppPathProvider;", "appPathProvider", "Lcom/crosspaste/secure/SecureKeyPairSerializer;", "secureKeyPairSerializer", "Lcom/crosspaste/db/secure/SecureIO;", "secureIO", "<init>", "(Lcom/crosspaste/app/AppInfo;Lcom/crosspaste/path/AppPathProvider;Lcom/crosspaste/secure/SecureKeyPairSerializer;Lcom/crosspaste/db/secure/SecureIO;)V", "Lcom/crosspaste/secure/SecureStore;", "createSecureStore", "()Lcom/crosspaste/secure/SecureStore;", "Lcom/crosspaste/app/AppInfo;", "Lcom/crosspaste/secure/SecureKeyPairSerializer;", "Lcom/crosspaste/db/secure/SecureIO;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/AppEnvUtils;", "appEnvUtils", "Lcom/crosspaste/utils/AppEnvUtils;", "Lcom/crosspaste/presist/OneFilePersist;", "filePersist", "Lcom/crosspaste/presist/OneFilePersist;", "app"})
@StabilityInferred(parameters=0)
public final class MacosSecureStoreFactory
implements SecureStoreFactory {
    @NotNull
    private final AppInfo appInfo;
    @NotNull
    private final SecureKeyPairSerializer secureKeyPairSerializer;
    @NotNull
    private final SecureIO secureIO;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final AppEnvUtils appEnvUtils;
    @NotNull
    private final OneFilePersist filePersist;
    public static final int $stable = 8;

    public MacosSecureStoreFactory(@NotNull AppInfo appInfo, @NotNull AppPathProvider appPathProvider, @NotNull SecureKeyPairSerializer secureKeyPairSerializer, @NotNull SecureIO secureIO) {
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        Intrinsics.checkNotNullParameter((Object)appPathProvider, (String)"appPathProvider");
        Intrinsics.checkNotNullParameter((Object)secureKeyPairSerializer, (String)"secureKeyPairSerializer");
        Intrinsics.checkNotNullParameter((Object)secureIO, (String)"secureIO");
        this.appInfo = appInfo;
        this.secureKeyPairSerializer = secureKeyPairSerializer;
        this.secureIO = secureIO;
        this.logger = KotlinLogging.INSTANCE.logger(MacosSecureStoreFactory::logger$lambda$0);
        this.appEnvUtils = AppEnvUtils_desktopKt.getAppEnvUtils();
        this.filePersist = FilePersist.INSTANCE.createOneFilePersist(appPathProvider.resolve("secure.data", AppFileType.ENCRYPT));
    }

    @Override
    @NotNull
    public SecureStore createSecureStore() {
        Object object;
        byte[] data;
        SecureKeyPair secureKeyPair;
        block13: {
            String service;
            block12: {
                service = "crosspaste-" + this.appEnvUtils.getCurrentAppEnv().name() + "-" + this.appInfo.getAppInstanceId();
                File file = this.filePersist.getPath().toFile();
                if (file.exists()) {
                    String password;
                    this.logger.info(MacosSecureStoreFactory::createSecureStore$lambda$1);
                    byte[] bytes = FilesKt.readBytes((File)file);
                    String string2 = password = MacosKeychainHelper.INSTANCE.getPassword(service, this.appInfo.getUserName());
                    if (string2 != null) {
                        String it = string2;
                        boolean bl = false;
                        this.logger.info(() -> MacosSecureStoreFactory.createSecureStore$lambda$6$lambda$2(service, this));
                        Object object2 = this;
                        try {
                            MacosSecureStoreFactory $this$createSecureStore_u24lambda_u246_u24lambda_u243 = object2;
                            boolean bl2 = false;
                            SecretKey secretKey = EncryptUtils.INSTANCE.stringToSecretKey(it);
                            byte[] decryptData = EncryptUtils.INSTANCE.decryptData(secretKey, bytes);
                            SecureKeyPair secureKeyPair2 = $this$createSecureStore_u24lambda_u246_u24lambda_u243.secureKeyPairSerializer.decodeSecureKeyPair(decryptData);
                            return new GeneralSecureStore(secureKeyPair2, $this$createSecureStore_u24lambda_u246_u24lambda_u243.secureKeyPairSerializer, $this$createSecureStore_u24lambda_u246_u24lambda_u243.secureIO);
                        }
                        catch (Throwable bl2) {
                            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                            if (throwable != null) {
                                Throwable $this$createSecureStore_u24lambda_u246_u24lambda_u243;
                                Throwable e = $this$createSecureStore_u24lambda_u246_u24lambda_u243 = throwable;
                                boolean bl3 = false;
                                this.logger.error(e, MacosSecureStoreFactory::createSecureStore$lambda$6$lambda$5$lambda$4);
                            }
                            Result.box-impl((Object)object2);
                        }
                    }
                    if (file.delete()) {
                        this.logger.info(MacosSecureStoreFactory::createSecureStore$lambda$7);
                    }
                } else {
                    this.logger.info(MacosSecureStoreFactory::createSecureStore$lambda$8);
                }
                this.logger.info(MacosSecureStoreFactory::createSecureStore$lambda$9);
                secureKeyPair = CryptographyUtils.INSTANCE.generateSecureKeyPair();
                data = this.secureKeyPairSerializer.encodeSecureKeyPair(secureKeyPair);
                String password = MacosKeychainHelper.INSTANCE.getPassword(service, this.appInfo.getUserName());
                object = password;
                if (object == null) break block12;
                String it = object;
                boolean bl = false;
                this.logger.info(() -> MacosSecureStoreFactory.createSecureStore$lambda$11$lambda$10(service, this));
                SecretKey secretKey = EncryptUtils.INSTANCE.stringToSecretKey(it);
                object = secretKey;
                if (secretKey != null) break block13;
            }
            MacosSecureStoreFactory $this$createSecureStore_u24lambda_u2413 = this;
            boolean bl = false;
            $this$createSecureStore_u24lambda_u2413.logger.info(() -> MacosSecureStoreFactory.createSecureStore$lambda$13$lambda$12(service, $this$createSecureStore_u24lambda_u2413));
            SecretKey secretKey = EncryptUtils.INSTANCE.generateAESKey();
            MacosKeychainHelper.INSTANCE.setPassword(service, $this$createSecureStore_u24lambda_u2413.appInfo.getUserName(), EncryptUtils.INSTANCE.secretKeyToString(secretKey));
            object = secretKey;
        }
        Object secretKey = object;
        byte[] encryptData = EncryptUtils.INSTANCE.encryptData((SecretKey)secretKey, data);
        this.filePersist.saveBytes(encryptData);
        return new GeneralSecureStore(secureKeyPair, this.secureKeyPairSerializer, this.secureIO);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object createSecureStore$lambda$1() {
        return "Found secureKeyPair encrypt file";
    }

    private static final Object createSecureStore$lambda$6$lambda$2(String $service, MacosSecureStoreFactory this$0) {
        return "Found password in keychain by " + $service + " " + this$0.appInfo.getUserName();
    }

    private static final Object createSecureStore$lambda$6$lambda$5$lambda$4() {
        return "Decrypt secureKeyPair error";
    }

    private static final Object createSecureStore$lambda$7() {
        return "Delete secureKeyPair encrypt file";
    }

    private static final Object createSecureStore$lambda$8() {
        return "Not found secureKeyPair encrypt file";
    }

    private static final Object createSecureStore$lambda$9() {
        return "Generate secureKeyPair";
    }

    private static final Object createSecureStore$lambda$11$lambda$10(String $service, MacosSecureStoreFactory this$0) {
        return "Found password in keychain by " + $service + " " + this$0.appInfo.getUserName();
    }

    private static final Object createSecureStore$lambda$13$lambda$12(String $service, MacosSecureStoreFactory $this_run) {
        return "Not found password in keychain by " + $service + " " + $this_run.appInfo.getUserName();
    }
}

