/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.secure;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.db.secure.SecureIO;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.presist.FilePersist;
import com.crosspaste.presist.OneFilePersist;
import com.crosspaste.secure.GeneralSecureStore;
import com.crosspaste.secure.SecureKeyPair;
import com.crosspaste.secure.SecureKeyPairSerializer;
import com.crosspaste.secure.SecureStore;
import com.crosspaste.secure.SecureStoreFactory;
import com.crosspaste.utils.CryptographyUtils;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\rR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/crosspaste/secure/LinuxSecureStoreFactory;", "Lcom/crosspaste/secure/SecureStoreFactory;", "Lcom/crosspaste/path/AppPathProvider;", "appPathProvider", "Lcom/crosspaste/secure/SecureKeyPairSerializer;", "secureKeyPairSerializer", "Lcom/crosspaste/db/secure/SecureIO;", "secureIO", "<init>", "(Lcom/crosspaste/path/AppPathProvider;Lcom/crosspaste/secure/SecureKeyPairSerializer;Lcom/crosspaste/db/secure/SecureIO;)V", "Lcom/crosspaste/secure/SecureStore;", "createSecureStore", "()Lcom/crosspaste/secure/SecureStore;", "Lcom/crosspaste/secure/SecureKeyPairSerializer;", "Lcom/crosspaste/db/secure/SecureIO;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/presist/OneFilePersist;", "filePersist", "Lcom/crosspaste/presist/OneFilePersist;", "app"})
@StabilityInferred(parameters=0)
public final class LinuxSecureStoreFactory
implements SecureStoreFactory {
    @NotNull
    private final SecureKeyPairSerializer secureKeyPairSerializer;
    @NotNull
    private final SecureIO secureIO;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final OneFilePersist filePersist;
    public static final int $stable = 8;

    public LinuxSecureStoreFactory(@NotNull AppPathProvider appPathProvider, @NotNull SecureKeyPairSerializer secureKeyPairSerializer, @NotNull SecureIO secureIO) {
        Intrinsics.checkNotNullParameter((Object)appPathProvider, (String)"appPathProvider");
        Intrinsics.checkNotNullParameter((Object)secureKeyPairSerializer, (String)"secureKeyPairSerializer");
        Intrinsics.checkNotNullParameter((Object)secureIO, (String)"secureIO");
        this.secureKeyPairSerializer = secureKeyPairSerializer;
        this.secureIO = secureIO;
        this.logger = KotlinLogging.INSTANCE.logger(LinuxSecureStoreFactory::logger$lambda$0);
        this.filePersist = FilePersist.INSTANCE.createOneFilePersist(appPathProvider.resolve("secure.data", AppFileType.ENCRYPT));
    }

    @Override
    @NotNull
    public SecureStore createSecureStore() {
        File file = this.filePersist.getPath().toFile();
        if (file.exists()) {
            this.logger.info(LinuxSecureStoreFactory::createSecureStore$lambda$1);
            byte[] byArray = this.filePersist.readBytes();
            if (byArray != null) {
                byte[] it = byArray;
                boolean bl = false;
                Object object = this;
                try {
                    LinuxSecureStoreFactory $this$createSecureStore_u24lambda_u245_u24lambda_u242 = object;
                    boolean bl2 = false;
                    SecureKeyPair secureKeyPair = $this$createSecureStore_u24lambda_u245_u24lambda_u242.secureKeyPairSerializer.decodeSecureKeyPair(it);
                    return new GeneralSecureStore(secureKeyPair, $this$createSecureStore_u24lambda_u245_u24lambda_u242.secureKeyPairSerializer, $this$createSecureStore_u24lambda_u245_u24lambda_u242.secureIO);
                }
                catch (Throwable bl2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable != null) {
                        Throwable throwable2;
                        Throwable e = throwable2 = throwable;
                        boolean bl3 = false;
                        this.logger.error(e, LinuxSecureStoreFactory::createSecureStore$lambda$5$lambda$4$lambda$3);
                    }
                    Result.box-impl((Object)object);
                }
            }
            if (file.delete()) {
                this.logger.info(LinuxSecureStoreFactory::createSecureStore$lambda$6);
            }
        } else {
            this.logger.info(LinuxSecureStoreFactory::createSecureStore$lambda$7);
        }
        this.logger.info(LinuxSecureStoreFactory::createSecureStore$lambda$8);
        SecureKeyPair secureKeyPair = CryptographyUtils.INSTANCE.generateSecureKeyPair();
        byte[] data = this.secureKeyPairSerializer.encodeSecureKeyPair(secureKeyPair);
        this.filePersist.saveBytes(data);
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rw-------");
        Files.setPosixFilePermissions(this.filePersist.getPath().toNioPath(), permissions);
        return new GeneralSecureStore(secureKeyPair, this.secureKeyPairSerializer, this.secureIO);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object createSecureStore$lambda$1() {
        return "Found secureKeyPair encrypt file";
    }

    private static final Object createSecureStore$lambda$5$lambda$4$lambda$3() {
        return "Failed to read secureKeyPair";
    }

    private static final Object createSecureStore$lambda$6() {
        return "Delete secureKeyPair encrypt file";
    }

    private static final Object createSecureStore$lambda$7() {
        return "Not found secureKeyPair encrypt file";
    }

    private static final Object createSecureStore$lambda$8() {
        return "Generate secureKeyPair";
    }
}

