/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.secure;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.db.secure.SecureIO;
import com.crosspaste.exception.PasteException;
import com.crosspaste.exception.StandardErrorCode;
import com.crosspaste.secure.GeneralSecureStore;
import com.crosspaste.secure.SecureKeyPair;
import com.crosspaste.secure.SecureKeyPairSerializer;
import com.crosspaste.secure.SecureMessageProcessor;
import com.crosspaste.secure.SecureSession;
import com.crosspaste.secure.SecureStore;
import dev.whyoleg.cryptography.algorithms.ECDH;
import io.ktor.util.collections.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\nH\u0096@\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0096@\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\nH\u0096@\u00a2\u0006\u0004\b\u001a\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001fR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/crosspaste/secure/GeneralSecureStore;", "Lcom/crosspaste/secure/SecureStore;", "Lcom/crosspaste/secure/SecureKeyPair;", "secureKeyPair", "Lcom/crosspaste/secure/SecureKeyPairSerializer;", "secureKeyPairSerializer", "Lcom/crosspaste/db/secure/SecureIO;", "secureIO", "<init>", "(Lcom/crosspaste/secure/SecureKeyPair;Lcom/crosspaste/secure/SecureKeyPairSerializer;Lcom/crosspaste/db/secure/SecureIO;)V", "", "appInstanceId", "Lcom/crosspaste/secure/SecureSession;", "getSecureSession", "(Ljava/lang/String;)Lcom/crosspaste/secure/SecureSession;", "removeSecureSession", "", "cryptPublicKey", "", "saveCryptPublicKey", "(Ljava/lang/String;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "existCryptPublicKey", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteCryptPublicKey", "Lcom/crosspaste/secure/SecureMessageProcessor;", "getMessageProcessor", "Lcom/crosspaste/secure/SecureKeyPair;", "getSecureKeyPair", "()Lcom/crosspaste/secure/SecureKeyPair;", "Lcom/crosspaste/secure/SecureKeyPairSerializer;", "Lcom/crosspaste/db/secure/SecureIO;", "Lio/ktor/util/collections/ConcurrentMap;", "sessions", "Lio/ktor/util/collections/ConcurrentMap;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGeneralSecureStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralSecureStore.kt\ncom/crosspaste/secure/GeneralSecureStore\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n116#2,11:73\n116#2,11:84\n116#2,11:95\n116#2,11:107\n1#3:106\n*S KotlinDebug\n*F\n+ 1 GeneralSecureStore.kt\ncom/crosspaste/secure/GeneralSecureStore\n*L\n28#1:73,11\n36#1:84,11\n43#1:95,11\n53#1:107,11\n*E\n"})
public final class GeneralSecureStore
implements SecureStore {
    @NotNull
    private final SecureKeyPair secureKeyPair;
    @NotNull
    private final SecureKeyPairSerializer secureKeyPairSerializer;
    @NotNull
    private final SecureIO secureIO;
    @NotNull
    private final ConcurrentMap<String, SecureSession> sessions;
    public static final int $stable = 8;

    public GeneralSecureStore(@NotNull SecureKeyPair secureKeyPair, @NotNull SecureKeyPairSerializer secureKeyPairSerializer, @NotNull SecureIO secureIO) {
        Intrinsics.checkNotNullParameter((Object)secureKeyPair, (String)"secureKeyPair");
        Intrinsics.checkNotNullParameter((Object)secureKeyPairSerializer, (String)"secureKeyPairSerializer");
        Intrinsics.checkNotNullParameter((Object)secureIO, (String)"secureIO");
        this.secureKeyPair = secureKeyPair;
        this.secureKeyPairSerializer = secureKeyPairSerializer;
        this.secureIO = secureIO;
        this.sessions = new ConcurrentMap(0, 1, null);
    }

    @Override
    @NotNull
    public SecureKeyPair getSecureKeyPair() {
        return this.secureKeyPair;
    }

    private final SecureSession getSecureSession(String appInstanceId) {
        return (SecureSession)this.sessions.computeIfAbsent((Object)appInstanceId, GeneralSecureStore::getSecureSession$lambda$0);
    }

    private final SecureSession removeSecureSession(String appInstanceId) {
        return (SecureSession)this.sessions.remove((Object)appInstanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object saveCryptPublicKey(@NotNull String appInstanceId, @NotNull byte[] cryptPublicKey, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof saveCryptPublicKey.1)) ** GOTO lbl-1000
        var12_4 = $completion;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ GeneralSecureStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveCryptPublicKey(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                session = this.getSecureSession(appInstanceId);
                $this$withLock_u24default$iv = session.getMutex();
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = appInstanceId;
                $continuation.L$1 = cryptPublicKey;
                $continuation.L$2 = session;
                $continuation.L$3 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl35
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                session = (SecureSession)$continuation.L$2;
                cryptPublicKey = (byte[])$continuation.L$1;
                appInstanceId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                try {
                    $i$a$-withLock$default-GeneralSecureStore$saveCryptPublicKey$2 = false;
                    session.setProcessor(null);
                    var9_13 = this.secureIO.saveCryptPublicKey(appInstanceId, cryptPublicKey);
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object existCryptPublicKey(@NotNull String appInstanceId, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof existCryptPublicKey.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ GeneralSecureStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.existCryptPublicKey(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                session = this.getSecureSession(appInstanceId);
                $this$withLock_u24default$iv = session.getMutex();
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = appInstanceId;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)session);
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                session = (SecureSession)$continuation.L$1;
                appInstanceId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                try {
                    $i$a$-withLock$default-GeneralSecureStore$existCryptPublicKey$2 = false;
                    var8_13 = Boxing.boxBoolean((boolean)this.secureIO.existCryptPublicKey(appInstanceId));
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var8_13;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object deleteCryptPublicKey(@NotNull String appInstanceId, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof deleteCryptPublicKey.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ GeneralSecureStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.deleteCryptPublicKey(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                session = this.removeSecureSession(appInstanceId);
                v0 = session;
                if (v0 == null || (v0 = v0.getMutex()) == null) break;
                $this$withLock_u24default$iv /* !! */  = v0;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = appInstanceId;
                $continuation.L$1 = session;
                $continuation.L$2 = $this$withLock_u24default$iv /* !! */ ;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v1 = $this$withLock_u24default$iv /* !! */ .lock(owner$iv, (Continuation)$continuation);
                if (v1 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl35
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv /* !! */  = (Mutex)$continuation.L$2;
                session = (SecureSession)$continuation.L$1;
                appInstanceId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                try {
                    $i$a$-withLock$default-GeneralSecureStore$deleteCryptPublicKey$2 = false;
                    session.setProcessor(null);
                    this.secureIO.deleteCryptPublicKey(appInstanceId);
                    var8_12 = Unit.INSTANCE;
                    break;
                }
                finally {
                    $this$withLock_u24default$iv /* !! */ .unlock(owner$iv);
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getMessageProcessor(@NotNull String appInstanceId, @NotNull Continuation<? super SecureMessageProcessor> $completion) {
        if (!($completion instanceof getMessageProcessor.1)) ** GOTO lbl-1000
        var20_3 = $completion;
        if ((var20_3.label & -2147483648) != 0) {
            var20_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ GeneralSecureStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getMessageProcessor(null, (Continuation<? super SecureMessageProcessor>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                session = this.getSecureSession(appInstanceId);
                v0 = session.getProcessor();
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-GeneralSecureStore$getMessageProcessor$2 = false;
                    return it;
                }
                $this$withLock_u24default$iv = session.getMutex();
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = appInstanceId;
                $continuation.L$1 = session;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v1 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v1 == var21_5) {
                    return var21_5;
                }
                ** GOTO lbl38
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                session = (SecureSession)$continuation.L$1;
                appInstanceId = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                try {
                    $i$a$-withLock$default-GeneralSecureStore$getMessageProcessor$3 = false;
                    v2 = session.getProcessor();
                    if (v2 != null) {
                        it = v2;
                        $i$a$-let-GeneralSecureStore$getMessageProcessor$3$1 = false;
                        var18_18 = it;
                        return var18_18;
                    }
                    v3 = this.secureIO.serializedPublicKey(appInstanceId);
                    if (v3 == null) {
                        $this$getMessageProcessor_u24lambda_u249_u24lambda_u248 = this;
                        $i$a$-run-GeneralSecureStore$getMessageProcessor$3$3 = false;
                        throw new PasteException(StandardErrorCode.ENCRYPT_FAIL.toErrorCode(), "Crypt public key not found by appInstanceId: " + appInstanceId);
                    }
                    publicKey = v3;
                    $i$a$-let-GeneralSecureStore$getMessageProcessor$3$2 = false;
                    cryptPublicKey = this.secureKeyPairSerializer.decodeCryptPublicKey(publicKey);
                    cryptPrivateKey = (ECDH.PrivateKey)this.getSecureKeyPair().getCryptKeyPair().getPrivateKey();
                    it = var13_23 = new SecureMessageProcessor(cryptPrivateKey, cryptPublicKey);
                    $i$a$-also-GeneralSecureStore$getMessageProcessor$3$2$1 = false;
                    session.setProcessor(it);
                    var16_26 = var13_23;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var16_26;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final SecureSession getSecureSession$lambda$0() {
        return new SecureSession(null, null, 3, null);
    }
}

