/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.secure;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppInfo;
import com.crosspaste.db.secure.SecureIO;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.platform.Platform;
import com.crosspaste.secure.LinuxSecureStoreFactory;
import com.crosspaste.secure.MacosSecureStoreFactory;
import com.crosspaste.secure.SecureKeyPairSerializer;
import com.crosspaste.secure.SecureStore;
import com.crosspaste.secure.SecureStoreFactory;
import com.crosspaste.secure.WindowsSecureStoreFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0015R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/crosspaste/secure/DesktopSecureStoreFactory;", "Lcom/crosspaste/secure/SecureStoreFactory;", "Lcom/crosspaste/app/AppInfo;", "appInfo", "Lcom/crosspaste/path/AppPathProvider;", "appPathProvider", "Lcom/crosspaste/platform/Platform;", "platform", "Lcom/crosspaste/secure/SecureKeyPairSerializer;", "secureKeyPairSerializer", "Lcom/crosspaste/db/secure/SecureIO;", "secureIO", "<init>", "(Lcom/crosspaste/app/AppInfo;Lcom/crosspaste/path/AppPathProvider;Lcom/crosspaste/platform/Platform;Lcom/crosspaste/secure/SecureKeyPairSerializer;Lcom/crosspaste/db/secure/SecureIO;)V", "Lcom/crosspaste/secure/SecureStore;", "createSecureStore", "()Lcom/crosspaste/secure/SecureStore;", "getSecureStoreFactory", "()Lcom/crosspaste/secure/SecureStoreFactory;", "Lcom/crosspaste/app/AppInfo;", "Lcom/crosspaste/path/AppPathProvider;", "Lcom/crosspaste/platform/Platform;", "Lcom/crosspaste/secure/SecureKeyPairSerializer;", "Lcom/crosspaste/db/secure/SecureIO;", "app"})
@StabilityInferred(parameters=0)
public final class DesktopSecureStoreFactory
implements SecureStoreFactory {
    @NotNull
    private final AppInfo appInfo;
    @NotNull
    private final AppPathProvider appPathProvider;
    @NotNull
    private final Platform platform;
    @NotNull
    private final SecureKeyPairSerializer secureKeyPairSerializer;
    @NotNull
    private final SecureIO secureIO;
    public static final int $stable = 8;

    public DesktopSecureStoreFactory(@NotNull AppInfo appInfo, @NotNull AppPathProvider appPathProvider, @NotNull Platform platform, @NotNull SecureKeyPairSerializer secureKeyPairSerializer, @NotNull SecureIO secureIO) {
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        Intrinsics.checkNotNullParameter((Object)appPathProvider, (String)"appPathProvider");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)secureKeyPairSerializer, (String)"secureKeyPairSerializer");
        Intrinsics.checkNotNullParameter((Object)secureIO, (String)"secureIO");
        this.appInfo = appInfo;
        this.appPathProvider = appPathProvider;
        this.platform = platform;
        this.secureKeyPairSerializer = secureKeyPairSerializer;
        this.secureIO = secureIO;
    }

    @Override
    @NotNull
    public SecureStore createSecureStore() {
        return this.getSecureStoreFactory().createSecureStore();
    }

    private final SecureStoreFactory getSecureStoreFactory() {
        SecureStoreFactory secureStoreFactory;
        if (this.platform.isMacos()) {
            secureStoreFactory = new MacosSecureStoreFactory(this.appInfo, this.appPathProvider, this.secureKeyPairSerializer, this.secureIO);
        } else if (this.platform.isWindows()) {
            secureStoreFactory = new WindowsSecureStoreFactory(this.appPathProvider, this.secureKeyPairSerializer, this.secureIO);
        } else if (this.platform.isLinux()) {
            secureStoreFactory = new LinuxSecureStoreFactory(this.appPathProvider, this.secureKeyPairSerializer, this.secureIO);
        } else {
            throw new IllegalStateException("Unsupported platform: " + this.platform.getName());
        }
        return secureStoreFactory;
    }
}

