/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.rendering;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.image.GenerateImageService;
import com.crosspaste.paste.PasteData;
import com.crosspaste.paste.item.RtfPasteItem;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.presist.FilePersist;
import com.crosspaste.rendering.RenderingDimension;
import com.crosspaste.rendering.RenderingHelper;
import com.crosspaste.rendering.RenderingService;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import javax.swing.text.rtf.RTFEditorKit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0096@\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0016R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0017R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/crosspaste/rendering/DesktopRtfRenderingService;", "Lcom/crosspaste/rendering/RenderingService;", "", "Lcom/crosspaste/presist/FilePersist;", "filePersist", "Lcom/crosspaste/image/GenerateImageService;", "generateImageService", "Lcom/crosspaste/rendering/RenderingHelper;", "renderingHelper", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/presist/FilePersist;Lcom/crosspaste/image/GenerateImageService;Lcom/crosspaste/rendering/RenderingHelper;Lcom/crosspaste/path/UserDataPathProvider;)V", "Lcom/crosspaste/paste/PasteData;", "pasteData", "", "render", "(Lcom/crosspaste/paste/PasteData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "start", "()V", "stop", "Lcom/crosspaste/presist/FilePersist;", "Lcom/crosspaste/image/GenerateImageService;", "Lcom/crosspaste/rendering/RenderingHelper;", "Lcom/crosspaste/path/UserDataPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "app"})
@StabilityInferred(parameters=0)
public final class DesktopRtfRenderingService
implements RenderingService<String> {
    @NotNull
    private final FilePersist filePersist;
    @NotNull
    private final GenerateImageService generateImageService;
    @NotNull
    private final RenderingHelper renderingHelper;
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final FileUtils fileUtils;
    public static final int $stable = 8;

    public DesktopRtfRenderingService(@NotNull FilePersist filePersist, @NotNull GenerateImageService generateImageService, @NotNull RenderingHelper renderingHelper, @NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)filePersist, (String)"filePersist");
        Intrinsics.checkNotNullParameter((Object)generateImageService, (String)"generateImageService");
        Intrinsics.checkNotNullParameter((Object)renderingHelper, (String)"renderingHelper");
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.filePersist = filePersist;
        this.generateImageService = generateImageService;
        this.renderingHelper = renderingHelper;
        this.userDataPathProvider = userDataPathProvider;
        this.logger = KotlinLogging.INSTANCE.logger(DesktopRtfRenderingService::logger$lambda$0);
        this.fileUtils = FileUtils_desktopKt.getFileUtils();
    }

    @Override
    @Nullable
    public Object render(@NotNull PasteData pasteData, @NotNull Continuation<? super Unit> $completion) {
        RtfPasteItem rtfPasteItem = (RtfPasteItem)pasteData.getPasteItem(Reflection.getOrCreateKotlinClass(RtfPasteItem.class));
        if (rtfPasteItem != null) {
            RtfPasteItem rtfPasteItem2 = rtfPasteItem;
            boolean bl = false;
            Path rtf2ImagePath = rtfPasteItem2.getRenderingFilePath(PasteData.getPasteCoordinate$default((PasteData)pasteData, null, (int)1, null), this.userDataPathProvider);
            if (this.fileUtils.existFile(rtf2ImagePath)) {
                this.logger.info(() -> DesktopRtfRenderingService.render$lambda$2$lambda$1(rtf2ImagePath));
            } else {
                JEditorPane editorPane = new JEditorPane();
                editorPane.setEditorKit(new RTFEditorKit());
                editorPane.setContentType("text/rtf");
                editorPane.setText(rtfPasteItem2.getRtf());
                double scale = this.renderingHelper.getScale();
                RenderingDimension dimension = this.renderingHelper.getDimension();
                int scaledWidth = (int)((double)dimension.getWidth() * scale);
                int scaledHeight = (int)((double)dimension.getHeight() * scale);
                editorPane.setSize(scaledWidth, Integer.MAX_VALUE);
                Dimension preferredSize = editorPane.getPreferredSize();
                int width = Math.max(preferredSize.width, scaledWidth);
                int height = Math.max(preferredSize.height, scaledHeight);
                editorPane.setSize(width, height);
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D graphics = image.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics.scale(1.0, 1.0);
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, 0, width, height);
                editorPane.print(graphics);
                graphics.dispose();
                this.filePersist.createOneFilePersist(rtf2ImagePath).createEmptyFile();
                ImageIO.write((RenderedImage)image, "png", rtf2ImagePath.toFile());
                Object object = this.generateImageService.markGenerationComplete(rtf2ImagePath, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
        }
        return Unit.INSTANCE;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void restart() {
        RenderingService.super.restart();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object render$lambda$2$lambda$1(Path $rtf2ImagePath) {
        return "RTF file " + $rtf2ImagePath + " exists";
    }
}

