/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.rendering;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpSize;
import com.crosspaste.app.DesktopAppSize;
import com.crosspaste.rendering.RenderingDimension;
import com.crosspaste.rendering.RenderingHelper;
import com.crosspaste.ui.theme.AppUISize;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u00020\u00068\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\b\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u00020\t8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u000b\"\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/crosspaste/rendering/DesktopRenderingHelper;", "Lcom/crosspaste/rendering/RenderingHelper;", "Lcom/crosspaste/app/DesktopAppSize;", "appSize", "<init>", "(Lcom/crosspaste/app/DesktopAppSize;)V", "", "readScale", "()D", "Lcom/crosspaste/rendering/RenderingDimension;", "readWindowDimension", "()Lcom/crosspaste/rendering/RenderingDimension;", "", "refresh", "()V", "Lcom/crosspaste/app/DesktopAppSize;", "Landroidx/compose/ui/unit/Density;", "globalDensity", "Landroidx/compose/ui/unit/Density;", "Ljava/awt/GraphicsConfiguration;", "getDensity", "(Ljava/awt/GraphicsConfiguration;)Landroidx/compose/ui/unit/Density;", "density", "scale", "D", "getScale", "setScale", "(D)V", "dimension", "Lcom/crosspaste/rendering/RenderingDimension;", "getDimension", "setDimension", "(Lcom/crosspaste/rendering/RenderingDimension;)V", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesktopRenderingHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopRenderingHelper.kt\ncom/crosspaste/rendering/DesktopRenderingHelper\n+ 2 Dp.kt\nandroidx/compose/ui/unit/Dp\n*L\n1#1,47:1\n52#2:48\n52#2:49\n*S KotlinDebug\n*F\n+ 1 DesktopRenderingHelper.kt\ncom/crosspaste/rendering/DesktopRenderingHelper\n*L\n35#1:48\n36#1:49\n*E\n"})
public final class DesktopRenderingHelper
implements RenderingHelper {
    @NotNull
    private final DesktopAppSize appSize;
    @NotNull
    private final Density globalDensity;
    private double scale;
    @NotNull
    private RenderingDimension dimension;
    public static final int $stable = 8;

    public DesktopRenderingHelper(@NotNull DesktopAppSize appSize) {
        Intrinsics.checkNotNullParameter((Object)appSize, (String)"appSize");
        this.appSize = appSize;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getDefaultConfiguration(...)");
        this.globalDensity = this.getDensity(graphicsConfiguration);
        this.scale = this.globalDensity.getDensity();
        this.dimension = this.readWindowDimension();
    }

    private final Density getDensity(GraphicsConfiguration $this$density) {
        return DensityKt.Density((float)((float)$this$density.getDefaultTransform().getScaleX()), (float)1.0f);
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public void setScale(double d) {
        this.scale = d;
    }

    @Override
    @NotNull
    public RenderingDimension getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(@NotNull RenderingDimension renderingDimension) {
        Intrinsics.checkNotNullParameter((Object)renderingDimension, (String)"<set-?>");
        this.dimension = renderingDimension;
    }

    private final double readScale() {
        return this.globalDensity.getDensity();
    }

    /*
     * WARNING - void declaration
     */
    private final RenderingDimension readWindowDimension() {
        void arg0$iv;
        void arg0$iv2;
        long detailViewDpSize = this.appSize.getCenterSearchWindowDetailViewDpSize-MYxV2XQ();
        float f = DpSize.getWidth-D9Ej5fM((long)detailViewDpSize);
        float other$iv = AppUISize.INSTANCE.getLarge2X-D9Ej5fM();
        boolean bl = false;
        float htmlWidthValue = Dp.constructor-impl((float)(arg0$iv2 - other$iv));
        other$iv = DpSize.getHeight-D9Ej5fM((long)detailViewDpSize);
        float other$iv2 = AppUISize.INSTANCE.getLarge2X-D9Ej5fM();
        $i$f$minus-5rwHm24 = false;
        float htmlHeightValue = Dp.constructor-impl((float)(arg0$iv - other$iv2));
        int width = (int)htmlWidthValue;
        int height = (int)htmlHeightValue;
        return new RenderingDimension(width, height);
    }

    @Override
    public void refresh() {
        this.setScale(this.readScale());
        this.setDimension(this.readWindowDimension());
    }
}

