/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.recommend;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.i18n.GlobalCopywriter;
import com.crosspaste.notification.NotificationManager;
import com.crosspaste.paste.PasteboardService;
import com.crosspaste.recommend.Clipboard;
import com.crosspaste.recommend.Facebook;
import com.crosspaste.recommend.LinkedIn;
import com.crosspaste.recommend.Mail;
import com.crosspaste.recommend.RecommendationPlatform;
import com.crosspaste.recommend.RecommendationService;
import com.crosspaste.recommend.Reddit;
import com.crosspaste.recommend.Telegram;
import com.crosspaste.recommend.Weibo;
import com.crosspaste.recommend.X;
import com.crosspaste.ui.base.UISupport;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u000f\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0012R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0013R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u000eR\u001a\u0010\u001d\u001a\u00020\f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001b\u001a\u0004\b\u001e\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/crosspaste/recommend/DesktopRecommendationService;", "Lcom/crosspaste/recommend/RecommendationService;", "Lcom/crosspaste/i18n/GlobalCopywriter;", "copywriter", "Lcom/crosspaste/notification/NotificationManager;", "notificationManager", "Lcom/crosspaste/paste/PasteboardService;", "pasteboardService", "Lcom/crosspaste/ui/base/UISupport;", "uiSupport", "<init>", "(Lcom/crosspaste/i18n/GlobalCopywriter;Lcom/crosspaste/notification/NotificationManager;Lcom/crosspaste/paste/PasteboardService;Lcom/crosspaste/ui/base/UISupport;)V", "", "getRecommendText", "()Ljava/lang/String;", "getRecommendTitle", "getRecommendContent", "getRecommendUrl", "Lcom/crosspaste/i18n/GlobalCopywriter;", "Lcom/crosspaste/ui/base/UISupport;", "", "Lcom/crosspaste/recommend/RecommendationPlatform;", "recommendPlatformList", "Ljava/util/List;", "getRecommendPlatformList", "()Ljava/util/List;", "recommendContentKey", "Ljava/lang/String;", "getRecommendContentKey", "recommendTitleKey", "getRecommendTitleKey", "app"})
@StabilityInferred(parameters=0)
public final class DesktopRecommendationService
implements RecommendationService {
    @NotNull
    private final GlobalCopywriter copywriter;
    @NotNull
    private final UISupport uiSupport;
    @NotNull
    private final List<RecommendationPlatform> recommendPlatformList;
    @NotNull
    private final String recommendContentKey;
    @NotNull
    private final String recommendTitleKey;
    public static final int $stable = 8;

    public DesktopRecommendationService(@NotNull GlobalCopywriter copywriter, @NotNull NotificationManager notificationManager, @NotNull PasteboardService pasteboardService, @NotNull UISupport uiSupport) {
        Intrinsics.checkNotNullParameter((Object)copywriter, (String)"copywriter");
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        Intrinsics.checkNotNullParameter((Object)pasteboardService, (String)"pasteboardService");
        Intrinsics.checkNotNullParameter((Object)uiSupport, (String)"uiSupport");
        this.copywriter = copywriter;
        this.uiSupport = uiSupport;
        Object[] objectArray = new RecommendationPlatform[]{new X(this.uiSupport), new Weibo(this.uiSupport), new Facebook(notificationManager, pasteboardService, this.uiSupport), new Reddit(this.uiSupport), new LinkedIn(notificationManager, pasteboardService, this.uiSupport), new Telegram(this.uiSupport), new Mail(notificationManager, this.uiSupport), new Clipboard(notificationManager, pasteboardService)};
        this.recommendPlatformList = CollectionsKt.listOf((Object[])objectArray);
        this.recommendContentKey = "recommend_content";
        this.recommendTitleKey = "recommend_title";
    }

    @Override
    @NotNull
    public List<RecommendationPlatform> getRecommendPlatformList() {
        return this.recommendPlatformList;
    }

    @Override
    @NotNull
    public String getRecommendContentKey() {
        return this.recommendContentKey;
    }

    @Override
    @NotNull
    public String getRecommendTitleKey() {
        return this.recommendTitleKey;
    }

    @Override
    @NotNull
    public String getRecommendText() {
        return this.copywriter.getText(this.getRecommendContentKey(), new Object[0]) + "\n" + this.uiSupport.getCrossPasteWebUrl("download");
    }

    @Override
    @NotNull
    public String getRecommendTitle() {
        return this.copywriter.getText(this.getRecommendTitleKey(), new Object[0]);
    }

    @Override
    @NotNull
    public String getRecommendContent() {
        return this.copywriter.getText(this.getRecommendContentKey(), new Object[0]);
    }

    @Override
    @NotNull
    public String getRecommendUrl() {
        return this.uiSupport.getCrossPasteWebUrl("download");
    }
}

