/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.platform.windows.html;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.platform.windows.html.EHTMLReadMode;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0001\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\r\u0010\tR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0018R\u0016\u0010\u001b\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0018R\u0016\u0010\u001c\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0018R\u0016\u0010\u001d\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0018R\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u0004\u0018\u00010\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010 R\u0016\u0010\"\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010\u0018R\u0016\u0010#\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010\u0018R\u0016\u0010$\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010\u0018R\u0013\u0010'\u001a\u0004\u0018\u00010\u001e8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lcom/crosspaste/platform/windows/html/HTMLCodec;", "Ljava/io/InputStream;", "byteStream", "Lcom/crosspaste/platform/windows/html/EHTMLReadMode;", "readMode", "<init>", "(Ljava/io/InputStream;Lcom/crosspaste/platform/windows/html/EHTMLReadMode;)V", "", "parseDescription", "()V", "", "read", "()I", "close", "Lcom/crosspaste/platform/windows/html/EHTMLReadMode;", "Ljava/io/BufferedInputStream;", "bufferedStream", "Ljava/io/BufferedInputStream;", "", "descriptionParsed", "Z", "closed", "", "iHTMLStart", "J", "iHTMLEnd", "iFragStart", "iFragEnd", "iSelStart", "iSelEnd", "", "stBaseURL", "Ljava/lang/String;", "stVersion", "iStartOffset", "iEndOffset", "iReadCount", "getVersion", "()Ljava/lang/String;", "version", "Companion", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHtmlCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlCodec.kt\ncom/crosspaste/platform/windows/html/HTMLCodec\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,493:1\n106#2:494\n78#2,22:495\n*S KotlinDebug\n*F\n+ 1 HtmlCodec.kt\ncom/crosspaste/platform/windows/html/HTMLCodec\n*L\n125#1:494\n125#1:495,22\n*E\n"})
public final class HTMLCodec
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EHTMLReadMode readMode;
    @NotNull
    private final BufferedInputStream bufferedStream;
    private boolean descriptionParsed;
    private boolean closed;
    private long iHTMLStart;
    private long iHTMLEnd;
    private long iFragStart;
    private long iFragEnd;
    private long iSelStart;
    private long iSelEnd;
    @Nullable
    private String stBaseURL;
    @Nullable
    private String stVersion;
    private long iStartOffset;
    private long iEndOffset;
    private long iReadCount;
    public static final int $stable = 8;
    @NotNull
    public static final String ENCODING = "UTF-8";
    @NotNull
    public static final String VERSION = "Version:";
    @NotNull
    public static final String START_HTML = "StartHTML:";
    @NotNull
    public static final String END_HTML = "EndHTML:";
    @NotNull
    public static final String START_FRAGMENT = "StartFragment:";
    @NotNull
    public static final String END_FRAGMENT = "EndFragment:";
    @NotNull
    public static final String START_SELECTION = "StartSelection:";
    @NotNull
    public static final String END_SELECTION = "EndSelection:";
    @NotNull
    private static final String START_FRAGMENT_CMT = "<!--StartFragment-->";
    @NotNull
    private static final String END_FRAGMENT_CMT = "<!--EndFragment-->";
    @NotNull
    public static final String SOURCE_URL = "SourceURL:";
    @NotNull
    private static final String DEF_SOURCE_URL = "about:blank";
    @NotNull
    public static final String EOLN = "\r\n";
    @NotNull
    private static final String VERSION_NUM = "1.0";
    private static final int PADDED_WIDTH = 10;
    public static final int BYTE_BUFFER_LEN = 8192;
    public static final int CHAR_BUFFER_LEN = 2730;
    @NotNull
    private static final String FAILURE_MSG = "Unable to parse HTML description: ";
    @NotNull
    private static final String INVALID_MSG = " invalid";

    public HTMLCodec(@NotNull InputStream byteStream, @NotNull EHTMLReadMode readMode) {
        Intrinsics.checkNotNullParameter((Object)byteStream, (String)"byteStream");
        Intrinsics.checkNotNullParameter((Object)((Object)readMode), (String)"readMode");
        this.readMode = readMode;
        this.bufferedStream = new BufferedInputStream(byteStream, 8192);
    }

    @Nullable
    public final synchronized String getVersion() throws IOException {
        if (!this.descriptionParsed) {
            this.parseDescription();
        }
        return this.stVersion;
    }

    /*
     * WARNING - void declaration
     */
    private final void parseDescription() throws IOException {
        this.stBaseURL = null;
        this.stVersion = null;
        this.iHTMLEnd = this.iHTMLStart = (this.iFragEnd = (this.iFragStart = (this.iSelEnd = (this.iSelStart = -1L))));
        this.bufferedStream.mark(8192);
        String[] stringArray = new String[]{VERSION, START_HTML, END_HTML, START_FRAGMENT, END_FRAGMENT, START_SELECTION, END_SELECTION, SOURCE_URL};
        String[] astEntries = stringArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)this.bufferedStream, ENCODING), 2730);
        long iHeadSize = 0L;
        long iCRSize = 2L;
        int iEntCount = astEntries.length;
        block17: for (int iEntry = 0; iEntry < iEntCount && bufferedReader.readLine() != null; ++iEntry) {
            while (iEntry < iEntCount) {
                Object object;
                void $this$trim$iv;
                String stLine;
                if (!StringsKt.startsWith$default((String)stLine, (String)astEntries[iEntry], (boolean)false, (int)2, null)) {
                    ++iEntry;
                    continue;
                }
                iHeadSize += (long)stLine.length() + iCRSize;
                String string2 = stLine.substring(astEntries[iEntry].length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                Object object2 = string2;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String stValue = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                object2 = this;
                try {
                    HTMLCodec $this$parseDescription_u24lambda_u241 = (HTMLCodec)object2;
                    boolean bl = false;
                    switch (iEntry) {
                        case 0: {
                            $this$parseDescription_u24lambda_u241.stVersion = stValue;
                            break;
                        }
                        case 1: {
                            $this$parseDescription_u24lambda_u241.iHTMLStart = Integer.parseInt(stValue);
                            break;
                        }
                        case 2: {
                            $this$parseDescription_u24lambda_u241.iHTMLEnd = Integer.parseInt(stValue);
                            break;
                        }
                        case 3: {
                            $this$parseDescription_u24lambda_u241.iFragStart = Integer.parseInt(stValue);
                            break;
                        }
                        case 4: {
                            $this$parseDescription_u24lambda_u241.iFragEnd = Integer.parseInt(stValue);
                            break;
                        }
                        case 5: {
                            $this$parseDescription_u24lambda_u241.iSelStart = Integer.parseInt(stValue);
                            break;
                        }
                        case 6: {
                            $this$parseDescription_u24lambda_u241.iSelEnd = Integer.parseInt(stValue);
                            break;
                        }
                        case 7: {
                            $this$parseDescription_u24lambda_u241.stBaseURL = stValue;
                        }
                    }
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) continue block17;
                Object e = object = throwable;
                boolean bl = false;
                if (e instanceof NumberFormatException) {
                    throw new IOException(FAILURE_MSG + astEntries[iEntry] + " value " + (Throwable)e + INVALID_MSG);
                }
                throw new IOException(FAILURE_MSG + astEntries[iEntry] + " value " + (Throwable)e);
            }
        }
        if (-1L == this.iHTMLStart) {
            this.iHTMLStart = iHeadSize;
        }
        if (-1L == this.iFragStart) {
            this.iFragStart = this.iHTMLStart;
        }
        if (-1L == this.iFragEnd) {
            this.iFragEnd = this.iHTMLEnd;
        }
        if (-1L == this.iSelStart) {
            this.iSelStart = this.iFragStart;
        }
        if (-1L == this.iSelEnd) {
            this.iSelEnd = this.iFragEnd;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.readMode.ordinal()]) {
            case 1: {
                this.iStartOffset = this.iHTMLStart;
                this.iEndOffset = this.iHTMLEnd;
                break;
            }
            case 2: {
                this.iStartOffset = this.iFragStart;
                this.iEndOffset = this.iFragEnd;
                break;
            }
            case 3: {
                this.iStartOffset = this.iSelStart;
                this.iEndOffset = this.iSelEnd;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.bufferedStream.reset();
        if (-1L == this.iStartOffset) {
            throw new IOException("Unable to parse HTML description: invalid HTML format.");
        }
        int curOffset = 0;
        while ((long)curOffset < this.iStartOffset) {
            curOffset += (int)this.bufferedStream.skip(this.iStartOffset - (long)curOffset);
        }
        this.iReadCount = curOffset;
        if (this.iStartOffset != this.iReadCount) {
            throw new IOException("Unable to parse HTML description: Byte stream ends in description.");
        }
        this.descriptionParsed = true;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (!this.descriptionParsed) {
            this.parseDescription();
        }
        if (-1L != this.iEndOffset && this.iReadCount >= this.iEndOffset) {
            return -1;
        }
        int retval = this.bufferedStream.read();
        if (retval == -1) {
            return -1;
        }
        ++this.iReadCount;
        return retval;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.bufferedStream.close();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b!\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J3\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u000f2\b\b\u0002\u0010\u0015\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001cR\u0014\u0010 \u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b \u0010\u001cR\u0014\u0010!\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b!\u0010\u001cR\u0014\u0010\"\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001cR\u0014\u0010#\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b#\u0010\u001cR\u0014\u0010$\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010\u001cR\u0014\u0010%\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010\u001cR\u0014\u0010&\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010\u001cR\u0014\u0010'\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010\u001cR\u0014\u0010(\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b(\u0010\u001cR\u0014\u0010)\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b)\u0010\u001cR\u0014\u0010*\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b,\u0010+R\u0014\u0010-\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b-\u0010+R\u0014\u0010.\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b.\u0010\u001cR\u0014\u0010/\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b/\u0010\u001c\u00a8\u00060"}, d2={"Lcom/crosspaste/platform/windows/html/HTMLCodec$Companion;", "", "<init>", "()V", "", "textBytes", "patternBytes", "", "kmpSearch", "([B[B)I", "", "computeLPSArray", "([B)[I", "n", "width", "", "toPaddedString", "(II)Ljava/lang/String;", "input", "index", "oldValue", "newValue", "replaceFromIndex", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "html", "convertToHTMLFormat", "(Ljava/lang/String;)[B", "ENCODING", "Ljava/lang/String;", "VERSION", "START_HTML", "END_HTML", "START_FRAGMENT", "END_FRAGMENT", "START_SELECTION", "END_SELECTION", "START_FRAGMENT_CMT", "END_FRAGMENT_CMT", "SOURCE_URL", "DEF_SOURCE_URL", "EOLN", "VERSION_NUM", "PADDED_WIDTH", "I", "BYTE_BUFFER_LEN", "CHAR_BUFFER_LEN", "FAILURE_MSG", "INVALID_MSG", "app"})
    public static final class Companion {
        private Companion() {
        }

        private final int kmpSearch(byte[] textBytes, byte[] patternBytes) {
            int[] lps = this.computeLPSArray(patternBytes);
            int i = 0;
            int j = 0;
            while (i < textBytes.length) {
                if (patternBytes[j] == textBytes[i]) {
                    ++i;
                    ++j;
                }
                if (j == patternBytes.length) {
                    return i - j;
                }
                if (i >= textBytes.length || patternBytes[j] == textBytes[i]) continue;
                if (j != 0) {
                    j = lps[j - 1];
                    continue;
                }
                ++i;
            }
            return -1;
        }

        private final int[] computeLPSArray(byte[] patternBytes) {
            int[] lps = new int[patternBytes.length];
            int length = 0;
            int i = 1;
            lps[0] = 0;
            while (i < patternBytes.length) {
                if (patternBytes[i] == patternBytes[length]) {
                    lps[i] = ++length;
                    ++i;
                    continue;
                }
                if (length != 0) {
                    length = lps[length - 1];
                    continue;
                }
                lps[i] = 0;
                ++i;
            }
            return lps;
        }

        private final String toPaddedString(int n, int width) {
            String string2 = "" + n;
            int len = string2.length();
            if (n >= 0 && len < width) {
                char[] array2 = new char[width - len];
                Arrays.fill(array2, '0');
                string2 = new String(array2) + string2;
            }
            return string2;
        }

        static /* synthetic */ String toPaddedString$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 10;
            }
            return companion.toPaddedString(n, n2);
        }

        private final String replaceFromIndex(String input, int index, String oldValue, String newValue) {
            if (!(0 <= index ? index <= input.length() : false)) {
                throw new IllegalArgumentException("Index out of bounds");
            }
            String string2 = input.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String substring = string2;
            String replacedSubstring = StringsKt.replace$default((String)substring, (String)oldValue, (String)newValue, (boolean)false, (int)4, null);
            String string3 = input.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return string3 + replacedSubstring;
        }

        static /* synthetic */ String replaceFromIndex$default(Companion companion, String string2, int n, String string3, String string4, int n2, Object object) {
            if ((n2 & 4) != 0) {
                string3 = "\n";
            }
            if ((n2 & 8) != 0) {
                string4 = "";
            }
            return companion.replaceFromIndex(string2, n, string3, string4);
        }

        @NotNull
        public final byte[] convertToHTMLFormat(@NotNull String html) {
            String stContext;
            Intrinsics.checkNotNullParameter((Object)html, (String)"html");
            Object htmlPrefix = "";
            Object htmlSuffix = null;
            htmlSuffix = "";
            String string2 = stContext = html;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            String stUpContext = string3;
            int htmlIndex = StringsKt.indexOf$default((CharSequence)stUpContext, (String)"<HTML", (int)0, (boolean)false, (int)6, null);
            if (-1 == htmlIndex) {
                htmlPrefix = "<HTML>";
                htmlSuffix = "</HTML>";
                if (-1 == StringsKt.indexOf$default((CharSequence)stUpContext, (String)"<BODY", (int)0, (boolean)false, (int)6, null)) {
                    htmlPrefix = (String)htmlPrefix + "<BODY>";
                    htmlSuffix = "</BODY>" + htmlSuffix;
                }
            } else {
                stContext = com.crosspaste.platform.windows.html.HTMLCodec$Companion.replaceFromIndex$default(this, stContext, htmlIndex, null, null, 12, null);
            }
            byte[] bytes = StringsKt.encodeToByteArray((String)stContext);
            int searchStartFragment = this.kmpSearch(bytes, StringsKt.encodeToByteArray((String)HTMLCodec.START_FRAGMENT_CMT));
            int searchEndFragment = this.kmpSearch(bytes, StringsKt.encodeToByteArray((String)HTMLCodec.END_FRAGMENT_CMT));
            String stBaseUrl = HTMLCodec.DEF_SOURCE_URL;
            int nStartHTML = 115 + stBaseUrl.length() + 2;
            int startFragment = searchStartFragment > 0 ? searchStartFragment + 20 : 0;
            int nStartFragment = nStartHTML + ((String)htmlPrefix).length() + startFragment;
            int nEndFragment = searchEndFragment > 0 ? nStartHTML + ((String)htmlPrefix).length() + searchEndFragment : nStartFragment + bytes.length - 1;
            int nEndHTML = nEndFragment + ((String)htmlSuffix).length();
            StringBuilder header = new StringBuilder(nStartFragment + 20);
            header.append(HTMLCodec.VERSION);
            header.append(HTMLCodec.VERSION_NUM);
            header.append(HTMLCodec.EOLN);
            header.append(HTMLCodec.START_HTML);
            header.append(com.crosspaste.platform.windows.html.HTMLCodec$Companion.toPaddedString$default(this, nStartHTML, 0, 2, null));
            header.append(HTMLCodec.EOLN);
            header.append(HTMLCodec.END_HTML);
            header.append(com.crosspaste.platform.windows.html.HTMLCodec$Companion.toPaddedString$default(this, nEndHTML, 0, 2, null));
            header.append(HTMLCodec.EOLN);
            header.append(HTMLCodec.START_FRAGMENT);
            header.append(com.crosspaste.platform.windows.html.HTMLCodec$Companion.toPaddedString$default(this, nStartFragment, 0, 2, null));
            header.append(HTMLCodec.EOLN);
            header.append(HTMLCodec.END_FRAGMENT);
            header.append(com.crosspaste.platform.windows.html.HTMLCodec$Companion.toPaddedString$default(this, nEndFragment, 0, 2, null));
            header.append(HTMLCodec.EOLN);
            header.append(HTMLCodec.SOURCE_URL);
            header.append(stBaseUrl);
            header.append(HTMLCodec.EOLN);
            header.append((String)htmlPrefix);
            byte[] headerBytes = null;
            byte[] trailerBytes = null;
            Companion companion = this;
            try {
                Companion $this$convertToHTMLFormat_u24lambda_u240 = companion;
                boolean bl = false;
                String string4 = header.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                headerBytes = StringsKt.encodeToByteArray((String)string4);
                trailerBytes = StringsKt.encodeToByteArray((String)htmlSuffix);
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Intrinsics.checkNotNull(headerBytes);
            int n = headerBytes.length + bytes.length;
            Intrinsics.checkNotNull((Object)trailerBytes);
            byte[] retval = new byte[n + trailerBytes.length];
            System.arraycopy(headerBytes, 0, retval, 0, headerBytes.length);
            System.arraycopy(bytes, 0, retval, headerBytes.length, bytes.length - 1);
            System.arraycopy(trailerBytes, 0, retval, headerBytes.length + bytes.length - 1, trailerBytes.length);
            retval[retval.length - 1] = 0;
            return retval;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EHTMLReadMode.values().length];
            try {
                nArray[EHTMLReadMode.HTML_READ_ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EHTMLReadMode.HTML_READ_FRAGMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EHTMLReadMode.HTML_READ_SELECTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

