/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.platform.windows.api;

import com.crosspaste.app.WinAppInfo;
import com.crosspaste.platform.windows.JIconExtract;
import com.crosspaste.platform.windows.api.Shell32;
import com.crosspaste.platform.windows.api.WndEnumProc;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.Version;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinGDI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0019\n\u0002\b\u001b\bf\u0018\u0000 Q2\u00020\u0001:\u0002RQJ+\u0010\b\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H&\u00a2\u0006\u0004\b\b\u0010\tJ+\u0010\n\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H&\u00a2\u0006\u0004\b\n\u0010\tJy\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H&\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001c\u001a\u0004\u0018\u00010\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0004\b\u001c\u0010\u001dJ#\u0010!\u001a\u00020 2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00022\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0004\b!\u0010\"JA\u0010*\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0010\u0010&\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010%\u0018\u00010$2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H&\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\u0004H&\u00a2\u0006\u0004\b,\u0010-J!\u00102\u001a\u00020 2\u0006\u0010/\u001a\u00020.2\b\u00101\u001a\u0004\u0018\u000100H&\u00a2\u0006\u0004\b2\u00103J\u0017\u00104\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b4\u00105J\u0017\u00106\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b6\u00107J'\u0010;\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020\u0004H&\u00a2\u0006\u0004\b;\u0010<J\u0019\u0010>\u001a\u00020 2\b\u0010=\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0004\b>\u00105J\u000f\u0010?\u001a\u00020 H&\u00a2\u0006\u0004\b?\u0010@J\u000f\u0010A\u001a\u00020 H&\u00a2\u0006\u0004\bA\u0010@J#\u0010D\u001a\u0004\u0018\u00010%2\u0006\u0010B\u001a\u00020\u00042\b\u0010C\u001a\u0004\u0018\u00010%H&\u00a2\u0006\u0004\bD\u0010EJ\u0019\u0010F\u001a\u0004\u0018\u00010%2\u0006\u0010B\u001a\u00020\u0004H&\u00a2\u0006\u0004\bF\u0010GJ\u0017\u0010I\u001a\u00020 2\u0006\u0010H\u001a\u00020\u0004H&\u00a2\u0006\u0004\bI\u0010JJ\u0017\u0010K\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004H&\u00a2\u0006\u0004\bK\u0010LJ'\u0010O\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u00042\u0006\u0010M\u001a\u0002082\u0006\u0010N\u001a\u00020\u0004H&\u00a2\u0006\u0004\bO\u0010P\u00a8\u0006S\u00c0\u0006\u0003"}, d2={"Lcom/crosspaste/platform/windows/api/User32;", "Lcom/sun/jna/platform/win32/User32;", "Lcom/sun/jna/platform/win32/WinDef$HWND;", "hWnd", "", "nIndex", "Lcom/crosspaste/platform/windows/api/User32$WNDPROC;", "proc", "SetWindowLongPtr", "(Lcom/sun/jna/platform/win32/WinDef$HWND;ILcom/crosspaste/platform/windows/api/User32$WNDPROC;)I", "SetWindowLong", "styleEx", "", "className", "windowName", "style", "x", "y", "width", "height", "hndParent", "hndMenu", "hndInst", "", "param", "CreateWindowEx", "(ILjava/lang/String;Ljava/lang/String;IIIIILcom/sun/jna/platform/win32/WinDef$HWND;IILjava/lang/Object;)Lcom/sun/jna/platform/win32/WinDef$HWND;", "hWndNewViewer", "SetClipboardViewer", "(Lcom/sun/jna/platform/win32/WinDef$HWND;)Lcom/sun/jna/platform/win32/WinDef$HWND;", "hWndRemove", "hWndNewNext", "", "ChangeClipboardChain", "(Lcom/sun/jna/platform/win32/WinDef$HWND;Lcom/sun/jna/platform/win32/WinDef$HWND;)Z", "nCount", "", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "pHandles", "bWaitAll", "dwMilliseconds", "dwWakeMask", "MsgWaitForMultipleObjects", "(I[Lcom/sun/jna/platform/win32/WinNT$HANDLE;ZII)I", "GetClipboardSequenceNumber", "()I", "Lcom/crosspaste/platform/windows/api/WndEnumProc;", "lpEnumFunc", "Lcom/sun/jna/Pointer;", "lParam", "EnumWindows", "(Lcom/crosspaste/platform/windows/api/WndEnumProc;Lcom/sun/jna/Pointer;)Z", "IsIconic", "(Lcom/sun/jna/platform/win32/WinDef$HWND;)Z", "GetWindowTextLengthW", "(Lcom/sun/jna/platform/win32/WinDef$HWND;)I", "", "lpString", "nMaxCount", "GetWindowTextW", "(Lcom/sun/jna/platform/win32/WinDef$HWND;[CI)I", "hWndNewOwner", "OpenClipboard", "CloseClipboard", "()Z", "EmptyClipboard", "uFormat", "hMem", "SetClipboardData", "(ILcom/sun/jna/platform/win32/WinNT$HANDLE;)Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "GetClipboardData", "(I)Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "format", "IsClipboardFormatAvailable", "(I)Z", "EnumClipboardFormats", "(I)I", "lpszFormatName", "cchMaxCount", "GetClipboardFormatName", "(I[CI)I", "Companion", "WNDPROC", "app"})
public interface User32
extends com.sun.jna.platform.win32.User32 {
    @NotNull
    public static final Companion Companion = com.crosspaste.platform.windows.api.User32$Companion.$$INSTANCE;
    public static final int GWL_WNDPROC = -4;
    public static final int WM_DESTROY = 2;
    public static final int WM_CHANGECBCHAIN = 781;
    public static final int WM_DRAWCLIPBOARD = 776;
    public static final int PM_NOREMOVE = 0;
    public static final int PM_REMOVE = 1;
    public static final int PM_NOYIELD = 2;
    public static final int QS_KEY = 1;
    public static final int QS_MOUSEMOVE = 2;
    public static final int QS_MOUSEBUTTON = 4;
    public static final int QS_POSTMESSAGE = 8;
    public static final int QS_TIMER = 16;
    public static final int QS_PAINT = 32;
    public static final int QS_SENDMESSAGE = 64;
    public static final int QS_HOTKEY = 128;
    public static final int QS_ALLPOSTMESSAGE = 256;
    public static final int QS_RAWINPUT = 1024;
    public static final int QS_TOUCH = 2048;
    public static final int QS_POINTER = 4096;
    public static final int QS_MOUSE = 6;
    public static final int QS_INPUT = 1031;
    public static final int QS_ALLEVENTS = 1215;
    public static final int QS_ALLINPUT = 1279;

    public int SetWindowLongPtr(@Nullable WinDef.HWND var1, int var2, @Nullable WNDPROC var3);

    public int SetWindowLong(@Nullable WinDef.HWND var1, int var2, @Nullable WNDPROC var3);

    @Nullable
    public WinDef.HWND CreateWindowEx(int var1, @Nullable String var2, @Nullable String var3, int var4, int var5, int var6, int var7, int var8, @Nullable WinDef.HWND var9, int var10, int var11, @Nullable Object var12);

    @Nullable
    public WinDef.HWND SetClipboardViewer(@Nullable WinDef.HWND var1);

    public boolean ChangeClipboardChain(@Nullable WinDef.HWND var1, @Nullable WinDef.HWND var2);

    public int MsgWaitForMultipleObjects(int var1, @Nullable WinNT.HANDLE[] var2, boolean var3, int var4, int var5);

    public int GetClipboardSequenceNumber();

    public boolean EnumWindows(@NotNull WndEnumProc var1, @Nullable Pointer var2);

    public boolean IsIconic(@NotNull WinDef.HWND var1);

    public int GetWindowTextLengthW(@NotNull WinDef.HWND var1);

    public int GetWindowTextW(@NotNull WinDef.HWND var1, @NotNull char[] var2, int var3);

    public boolean OpenClipboard(@Nullable WinDef.HWND var1);

    public boolean CloseClipboard();

    public boolean EmptyClipboard();

    @Nullable
    public WinNT.HANDLE SetClipboardData(int var1, @Nullable WinNT.HANDLE var2);

    @Nullable
    public WinNT.HANDLE GetClipboardData(int var1);

    public boolean IsClipboardFormatAvailable(int var1);

    public int EnumClipboardFormats(int var1);

    public int GetClipboardFormatName(int var1, @NotNull char[] var2, int var3);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\f\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0011\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0011\u0010!\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0004\b!\u0010 J\u001f\u0010$\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\f2\b\u0010#\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0004\b$\u0010%J!\u0010(\u001a\u00020\u00102\b\u0010&\u001a\u0004\u0018\u00010\u001e2\b\u0010'\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0004\b(\u0010)J/\u0010,\u001a\u00020\u00102\b\u0010&\u001a\u0004\u0018\u00010\u001e2\b\u0010'\u001a\u0004\u0018\u00010\u001e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0*\u00a2\u0006\u0004\b,\u0010-J\u001b\u0010.\u001a\u00020\u00102\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0*\u00a2\u0006\u0004\b.\u0010/J\u0017\u00101\u001a\u0004\u0018\u00010\u001e2\u0006\u00100\u001a\u00020\u0004\u00a2\u0006\u0004\b1\u00102J\u0015\u00105\u001a\u00020\u00182\u0006\u00104\u001a\u000203\u00a2\u0006\u0004\b5\u00106R\u0017\u00108\u001a\u0002078\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b>\u0010=R\u0014\u0010?\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b?\u0010=R\u0014\u0010@\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b@\u0010=R\u0014\u0010A\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bA\u0010=R\u0014\u0010B\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bB\u0010=R\u0014\u0010C\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bC\u0010=R\u0014\u0010D\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bD\u0010=R\u0014\u0010E\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bE\u0010=R\u0014\u0010F\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bF\u0010=R\u0014\u0010G\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bG\u0010=R\u0014\u0010H\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bH\u0010=R\u0014\u0010I\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bI\u0010=R\u0014\u0010J\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bJ\u0010=R\u0014\u0010K\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bK\u0010=R\u0014\u0010L\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bL\u0010=R\u0014\u0010M\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bM\u0010=R\u0014\u0010N\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bN\u0010=R\u0014\u0010O\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bO\u0010=R\u0014\u0010P\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bP\u0010=R\u0014\u0010Q\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bQ\u0010=R\u0014\u0010R\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bR\u0010=R\u0014\u0010S\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bS\u0010=R\u0014\u0010U\u001a\u00020T8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bU\u0010V\u00a8\u0006W"}, d2={"Lcom/crosspaste/platform/windows/api/User32$Companion;", "", "<init>", "()V", "", "getActiveWindowProcessFilePath", "()Ljava/lang/String;", "filePath", "getFileDescription", "(Ljava/lang/String;)Ljava/lang/String;", "", "array", "", "findLangAndCodepage", "([I)Ljava/lang/Integer;", "outputPath", "", "extractAndSaveIcon", "(Ljava/lang/String;Ljava/lang/String;)V", "Lcom/sun/jna/platform/win32/WinDef$HICON;", "hicon", "Ljava/awt/image/BufferedImage;", "hiconToImage", "(Lcom/sun/jna/platform/win32/WinDef$HICON;)Ljava/awt/image/BufferedImage;", "", "useShortcutKeys", "Lkotlin/Pair;", "Lcom/crosspaste/app/WinAppInfo;", "getForegroundWindowAppInfoAndThreadId", "(Z)Lkotlin/Pair;", "Lcom/sun/jna/platform/win32/WinDef$HWND;", "getForegroundWindowByEnumWindows", "()Lcom/sun/jna/platform/win32/WinDef$HWND;", "getForegroundWindow", "prevThreadId", "searchWindow", "bringToFront", "(ILcom/sun/jna/platform/win32/WinDef$HWND;)V", "backWindow", "previousHwnd", "backToBack", "(Lcom/sun/jna/platform/win32/WinDef$HWND;Lcom/sun/jna/platform/win32/WinDef$HWND;)V", "", "keyCodes", "bringToBackAndPaste", "(Lcom/sun/jna/platform/win32/WinDef$HWND;Lcom/sun/jna/platform/win32/WinDef$HWND;Ljava/util/List;)V", "paste", "(Ljava/util/List;)V", "windowTitle", "findPasteWindow", "(Ljava/lang/String;)Lcom/sun/jna/platform/win32/WinDef$HWND;", "Ljava/nio/file/Path;", "path", "isInstalledFromMicrosoftStore", "(Ljava/nio/file/Path;)Z", "Lcom/crosspaste/platform/windows/api/User32;", "INSTANCE", "Lcom/crosspaste/platform/windows/api/User32;", "getINSTANCE", "()Lcom/crosspaste/platform/windows/api/User32;", "GWL_WNDPROC", "I", "WM_DESTROY", "WM_CHANGECBCHAIN", "WM_DRAWCLIPBOARD", "PM_NOREMOVE", "PM_REMOVE", "PM_NOYIELD", "QS_KEY", "QS_MOUSEMOVE", "QS_MOUSEBUTTON", "QS_POSTMESSAGE", "QS_TIMER", "QS_PAINT", "QS_SENDMESSAGE", "QS_HOTKEY", "QS_ALLPOSTMESSAGE", "QS_RAWINPUT", "QS_TOUCH", "QS_POINTER", "QS_MOUSE", "QS_INPUT", "QS_ALLEVENTS", "QS_ALLINPUT", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "app"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final User32 INSTANCE;
        public static final int GWL_WNDPROC = -4;
        public static final int WM_DESTROY = 2;
        public static final int WM_CHANGECBCHAIN = 781;
        public static final int WM_DRAWCLIPBOARD = 776;
        public static final int PM_NOREMOVE = 0;
        public static final int PM_REMOVE = 1;
        public static final int PM_NOYIELD = 2;
        public static final int QS_KEY = 1;
        public static final int QS_MOUSEMOVE = 2;
        public static final int QS_MOUSEBUTTON = 4;
        public static final int QS_POSTMESSAGE = 8;
        public static final int QS_TIMER = 16;
        public static final int QS_PAINT = 32;
        public static final int QS_SENDMESSAGE = 64;
        public static final int QS_HOTKEY = 128;
        public static final int QS_ALLPOSTMESSAGE = 256;
        public static final int QS_RAWINPUT = 1024;
        public static final int QS_TOUCH = 2048;
        public static final int QS_POINTER = 4096;
        public static final int QS_MOUSE = 6;
        public static final int QS_INPUT = 1031;
        public static final int QS_ALLEVENTS = 1215;
        public static final int QS_ALLINPUT = 1279;
        @NotNull
        private static final KLogger logger;

        private Companion() {
        }

        @NotNull
        public final User32 getINSTANCE() {
            return INSTANCE;
        }

        @Nullable
        public final String getActiveWindowProcessFilePath() {
            String string2;
            WinDef.HWND hWND = INSTANCE.GetForegroundWindow();
            if (hWND != null) {
                Object $this$getActiveWindowProcessFilePath_u24lambda_u243_u24lambda_u241;
                WinDef.HWND hwnd = hWND;
                boolean bl = false;
                IntByReference processIdRef = new IntByReference();
                INSTANCE.GetWindowThreadProcessId(hwnd, processIdRef);
                WinNT.HANDLE processHandle = Kernel32.INSTANCE.OpenProcess(1040, false, processIdRef.getValue());
                Object object = $$INSTANCE;
                try {
                    $this$getActiveWindowProcessFilePath_u24lambda_u243_u24lambda_u241 = object;
                    boolean bl2 = false;
                    int bufferSize = 1024;
                    Memory memory = new Memory((long)(bufferSize * 2));
                    $this$getActiveWindowProcessFilePath_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)(Psapi.INSTANCE.GetModuleFileNameEx(processHandle, null, (Pointer)memory, bufferSize) > 0 ? memory.getWideString(0L) : null));
                }
                catch (Throwable bl2) {
                    $this$getActiveWindowProcessFilePath_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                Object $this$getActiveWindowProcessFilePath_u24lambda_u243_u24lambda_u242 = object = $this$getActiveWindowProcessFilePath_u24lambda_u243_u24lambda_u241;
                boolean bl3 = false;
                Kernel32.INSTANCE.CloseHandle(processHandle);
                string2 = (String)(Result.isFailure-impl((Object)object) ? null : object);
            } else {
                string2 = null;
            }
            return string2;
        }

        @Nullable
        public final String getFileDescription(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            IntByReference intByReference = new IntByReference();
            int versionLength = Version.INSTANCE.GetFileVersionInfoSize(filePath, intByReference);
            if (versionLength > 0) {
                Memory memory = new Memory((long)versionLength);
                PointerByReference lplpTranslate = new PointerByReference();
                if (Version.INSTANCE.GetFileVersionInfo(filePath, 0, versionLength, (Pointer)memory)) {
                    IntByReference puLen = new IntByReference();
                    if (Version.INSTANCE.VerQueryValue((Pointer)memory, "\\VarFileInfo\\Translation", lplpTranslate, puLen)) {
                        int[] nArray = lplpTranslate.getValue().getIntArray(0L, puLen.getValue() / 4);
                        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getIntArray(...)");
                        int[] array2 = nArray;
                        Integer n = this.findLangAndCodepage(array2);
                        if (n == null) {
                            return null;
                        }
                        int langAndCodepage = n;
                        int l = langAndCodepage & 0xFFFF;
                        int m = (langAndCodepage & 0xFFFF0000) >> 16;
                        Locale locale = Locale.ROOT;
                        Object object = "%04x";
                        Object object2 = new Object[]{l};
                        String string2 = String.format(locale, (String)object, Arrays.copyOf(object2, ((Object[])object2).length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        String lang = StringsKt.takeLast((String)string2, (int)4);
                        object = Locale.ROOT;
                        object2 = "%04x";
                        Object object3 = new Object[]{m};
                        String string3 = String.format((Locale)object, (String)object2, Arrays.copyOf(object3, ((Object[])object3).length));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                        String codepage = StringsKt.takeLast((String)string3, (int)4);
                        object2 = Locale.ROOT;
                        object3 = "\\StringFileInfo\\" + lang + codepage + "\\FileDescription";
                        Object[] objectArray = new Object[]{l, m};
                        String string4 = String.format((Locale)object2, (String)object3, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                        String lpSubBlock = string4;
                        PointerByReference lplpBuffer = new PointerByReference();
                        if (Version.INSTANCE.VerQueryValue((Pointer)memory, lpSubBlock, lplpBuffer, puLen)) {
                            if (puLen.getValue() > 0) {
                                return lplpBuffer.getValue().getWideString(0L);
                            }
                        } else {
                            logger.error(Companion::getFileDescription$lambda$4);
                        }
                    } else {
                        logger.error(Companion::getFileDescription$lambda$5);
                    }
                }
            }
            return null;
        }

        private final Integer findLangAndCodepage(int[] array2) {
            Integer value = null;
            for (int i : array2) {
                if ((i & 0xFFFF0000) == 0x4B00000 && (i & 0xFFFF) == 1033) {
                    return i;
                }
                value = i;
            }
            return value;
        }

        public final void extractAndSaveIcon(@NotNull String filePath, @NotNull String outputPath) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
                BufferedImage bufferedImage = JIconExtract.getIconForFile$default(JIconExtract.INSTANCE, filePath, null, 2, null);
                if (bufferedImage != null) {
                    BufferedImage icon = bufferedImage;
                    boolean bl = false;
                    ImageIO.write((RenderedImage)icon, "png", new File(outputPath));
                    return;
                }
                WinDef.HICON[] largeIcons = new WinDef.HICON[1];
                WinDef.HICON[] smallIcons = new WinDef.HICON[1];
                int iconCount = Shell32.Companion.getINSTANCE().ExtractIconEx(filePath, 0, largeIcons, smallIcons, 1);
                if (iconCount <= 0 || largeIcons[0] == null) break block2;
                WinDef.HICON hICON = largeIcons[0];
                Intrinsics.checkNotNull((Object)hICON);
                WinDef.HICON icon = hICON;
                BufferedImage bufferedImage2 = this.hiconToImage(icon);
                if (bufferedImage2 != null) {
                    BufferedImage image = bufferedImage2;
                    boolean bl = false;
                    ImageIO.write((RenderedImage)image, "png", new File(outputPath));
                }
            }
        }

        private final BufferedImage hiconToImage(WinDef.HICON hicon) {
            Object $this$hiconToImage_u24lambda_u2411;
            WinDef.HBITMAP bitmapHandle = null;
            User32 user32 = INSTANCE;
            GDI32 gdi32 = GDI32.INSTANCE;
            Object object = this;
            try {
                BufferedImage bufferedImage;
                $this$hiconToImage_u24lambda_u2411 = object;
                boolean bl = false;
                WinGDI.ICONINFO info = new WinGDI.ICONINFO();
                if (!user32.GetIconInfo(hicon, info)) {
                    return null;
                }
                info.read();
                bitmapHandle = Optional.ofNullable(info.hbmColor).orElse(info.hbmMask);
                WinGDI.BITMAP bitmap = new WinGDI.BITMAP();
                if (gdi32.GetObject((WinNT.HANDLE)bitmapHandle, bitmap.size(), bitmap.getPointer()) > 0) {
                    bitmap.read();
                    int width = bitmap.bmWidth.intValue();
                    int height = bitmap.bmHeight.intValue();
                    WinDef.HDC hDC = user32.GetDC(null);
                    if (hDC != null) {
                        WinDef.HDC deviceContext = hDC;
                        boolean bl2 = false;
                        WinGDI.BITMAPINFO bitmapInfo = new WinGDI.BITMAPINFO();
                        bitmapInfo.bmiHeader.biSize = bitmapInfo.bmiHeader.size();
                        if (!(gdi32.GetDIBits(deviceContext, bitmapHandle, 0, 0, Pointer.NULL, bitmapInfo, 0) != 0)) {
                            boolean $i$a$-require-User32$Companion$hiconToImage$1$1$32 = false;
                            String $i$a$-require-User32$Companion$hiconToImage$1$1$32 = "GetDIBits should not return 0";
                            throw new IllegalArgumentException($i$a$-require-User32$Companion$hiconToImage$1$1$32.toString());
                        }
                        bitmapInfo.read();
                        Memory pixels = new Memory((long)bitmapInfo.bmiHeader.biSizeImage);
                        bitmapInfo.bmiHeader.biCompression = 0;
                        bitmapInfo.bmiHeader.biHeight = -height;
                        if (!(gdi32.GetDIBits(deviceContext, bitmapHandle, 0, bitmapInfo.bmiHeader.biHeight, (Pointer)pixels, bitmapInfo, 0) != 0)) {
                            boolean $i$a$-require-User32$Companion$hiconToImage$1$1$42 = false;
                            String $i$a$-require-User32$Companion$hiconToImage$1$1$42 = "GetDIBits should not return 0";
                            throw new IllegalArgumentException($i$a$-require-User32$Companion$hiconToImage$1$1$42.toString());
                        }
                        int[] colorArray = pixels.getIntArray(0L, width * height);
                        BufferedImage image = new BufferedImage(width, height, 2);
                        image.setRGB(0, 0, width, height, colorArray, 0, width);
                        bufferedImage = image;
                    } else {
                        bufferedImage = null;
                    }
                } else {
                    bufferedImage = null;
                }
                $this$hiconToImage_u24lambda_u2411 = Result.constructor-impl(bufferedImage);
            }
            catch (Throwable bl) {
                $this$hiconToImage_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            Object $this$hiconToImage_u24lambda_u2414 = object = $this$hiconToImage_u24lambda_u2411;
            boolean bl = false;
            gdi32.DeleteObject((WinNT.HANDLE)hicon);
            Optional.ofNullable(bitmapHandle).ifPresent(arg_0 -> Companion.hiconToImage$lambda$14$lambda$13(arg_0 -> Companion.hiconToImage$lambda$14$lambda$12(gdi32, arg_0), arg_0));
            return (BufferedImage)(Result.isFailure-impl((Object)object) ? null : object);
        }

        @Nullable
        public final Pair<WinAppInfo, Integer> getForegroundWindowAppInfoAndThreadId(boolean useShortcutKeys) {
            Pair pair;
            WinDef.HWND hwnd;
            WinDef.HWND hWND = hwnd = useShortcutKeys ? this.getForegroundWindow() : this.getForegroundWindowByEnumWindows();
            if (hWND != null) {
                Object $this$getForegroundWindowAppInfoAndThreadId_u24lambda_u2417_u24lambda_u2415;
                WinDef.HWND previousHwnd = hWND;
                boolean bl = false;
                IntByReference processIdRef = new IntByReference();
                int threadId = INSTANCE.GetWindowThreadProcessId(previousHwnd, processIdRef);
                WinNT.HANDLE processHandle = Kernel32.INSTANCE.OpenProcess(1040, false, processIdRef.getValue());
                Object object = $$INSTANCE;
                try {
                    Pair pair2;
                    $this$getForegroundWindowAppInfoAndThreadId_u24lambda_u2417_u24lambda_u2415 = object;
                    boolean bl2 = false;
                    int bufferSize = 1024;
                    Memory memory = new Memory((long)(bufferSize * 2));
                    if (Psapi.INSTANCE.GetModuleFileNameEx(processHandle, null, (Pointer)memory, bufferSize) > 0) {
                        String filePath = memory.getWideString(0L);
                        Intrinsics.checkNotNull((Object)filePath);
                        pair2 = new Pair((Object)new WinAppInfo(previousHwnd, filePath), (Object)threadId);
                    } else {
                        pair2 = null;
                    }
                    $this$getForegroundWindowAppInfoAndThreadId_u24lambda_u2417_u24lambda_u2415 = Result.constructor-impl(pair2);
                }
                catch (Throwable bl2) {
                    $this$getForegroundWindowAppInfoAndThreadId_u24lambda_u2417_u24lambda_u2415 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                Object $this$getForegroundWindowAppInfoAndThreadId_u24lambda_u2417_u24lambda_u2416 = object = $this$getForegroundWindowAppInfoAndThreadId_u24lambda_u2417_u24lambda_u2415;
                boolean bl3 = false;
                Kernel32.INSTANCE.CloseHandle(processHandle);
                pair = (Pair)(Result.isFailure-impl((Object)object) ? null : object);
            } else {
                pair = null;
            }
            return pair;
        }

        private final WinDef.HWND getForegroundWindowByEnumWindows() {
            Ref.ObjectRef foregroundHwnd = new Ref.ObjectRef();
            INSTANCE.EnumWindows(new WndEnumProc((Ref.ObjectRef<WinDef.HWND>)foregroundHwnd){
                final /* synthetic */ Ref.ObjectRef<WinDef.HWND> $foregroundHwnd;
                {
                    this.$foregroundHwnd = $foregroundHwnd;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean callback(WinDef.HWND hWnd, Pointer lParam) {
                    Intrinsics.checkNotNullParameter((Object)hWnd, (String)"hWnd");
                    if (!com.crosspaste.platform.windows.api.User32$Companion.$$INSTANCE.getINSTANCE().IsWindowVisible(hWnd)) {
                        return true;
                    }
                    if (com.crosspaste.platform.windows.api.User32$Companion.$$INSTANCE.getINSTANCE().IsIconic(hWnd)) {
                        return true;
                    }
                    WinDef.HWND parent = com.crosspaste.platform.windows.api.User32$Companion.$$INSTANCE.getINSTANCE().GetParent(hWnd);
                    if (parent != null && !Intrinsics.areEqual((Object)parent, (Object)com.crosspaste.platform.windows.api.User32$Companion.$$INSTANCE.getINSTANCE().GetDesktopWindow())) {
                        return true;
                    }
                    int titleLength = com.crosspaste.platform.windows.api.User32$Companion.$$INSTANCE.getINSTANCE().GetWindowTextLengthW(hWnd);
                    if (titleLength == 0) {
                        return true;
                    }
                    char[] buffer = new char[titleLength + 1];
                    com.crosspaste.platform.windows.api.User32$Companion.$$INSTANCE.getINSTANCE().GetWindowTextW(hWnd, buffer, titleLength + 1);
                    String string2 = Native.toString((char[])buffer);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    String title = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    if (((CharSequence)title).length() == 0) {
                        return true;
                    }
                    IntByReference processIdRef = new IntByReference();
                    com.crosspaste.platform.windows.api.User32$Companion.$$INSTANCE.getINSTANCE().GetWindowThreadProcessId(hWnd, processIdRef);
                    WinNT.HANDLE processHandle = Kernel32.INSTANCE.OpenProcess(1040, false, processIdRef.getValue());
                    if (processHandle != null) {
                        try {
                            int bufferSize = 1024;
                            Memory memory = new Memory((long)(bufferSize * 2));
                            if (Psapi.INSTANCE.GetModuleFileNameEx(processHandle, null, (Pointer)memory, bufferSize) > 0) {
                                String filePath = memory.getWideString(0L);
                                Intrinsics.checkNotNull((Object)filePath);
                                String string3 = filePath.toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                                if (StringsKt.endsWith$default((String)string3, (String)"explorer.exe", (boolean)false, (int)2, null)) {
                                    boolean bl = true;
                                    return bl;
                                }
                            }
                        }
                        finally {
                            Kernel32.INSTANCE.CloseHandle(processHandle);
                        }
                    }
                    this.$foregroundHwnd.element = hWnd;
                    return false;
                }
            }, null);
            return (WinDef.HWND)foregroundHwnd.element;
        }

        private final WinDef.HWND getForegroundWindow() {
            return INSTANCE.GetForegroundWindow();
        }

        public final synchronized void bringToFront(int prevThreadId, @Nullable WinDef.HWND searchWindow) {
            block4: {
                WinDef.HWND hWND = searchWindow;
                if (hWND == null) break block4;
                WinDef.HWND searchHWND = hWND;
                boolean bl = false;
                IntByReference targetProcessId = new IntByReference();
                int targetThreadId = INSTANCE.GetWindowThreadProcessId(searchHWND, targetProcessId);
                if (INSTANCE.AttachThreadInput(new WinDef.DWORD((long)prevThreadId), new WinDef.DWORD((long)targetThreadId), true)) {
                    INSTANCE.ShowWindow(searchHWND, 9);
                    boolean result2 = INSTANCE.SetForegroundWindow(searchHWND);
                    INSTANCE.AttachThreadInput(new WinDef.DWORD((long)prevThreadId), new WinDef.DWORD((long)targetThreadId), false);
                    if (!result2) {
                        logger.info(Companion::bringToFront$lambda$21$lambda$18);
                    } else {
                        logger.info(Companion::bringToFront$lambda$21$lambda$19);
                    }
                } else {
                    logger.error(Companion::bringToFront$lambda$21$lambda$20);
                }
            }
        }

        public final void backToBack(@Nullable WinDef.HWND backWindow, @Nullable WinDef.HWND previousHwnd) {
            block1: {
                WinDef.HWND hwnd;
                WinDef.HWND hWND = backWindow;
                if (hWND != null) {
                    hwnd = hWND;
                    boolean bl = false;
                    INSTANCE.ShowWindow(hwnd, 0);
                }
                WinDef.HWND hWND2 = previousHwnd;
                if (hWND2 == null) break block1;
                hwnd = hWND2;
                boolean bl = false;
                INSTANCE.ShowWindow(hwnd, 5);
                INSTANCE.SetForegroundWindow(hwnd);
            }
        }

        public final void bringToBackAndPaste(@Nullable WinDef.HWND backWindow, @Nullable WinDef.HWND previousHwnd, @NotNull List<Integer> keyCodes) {
            Intrinsics.checkNotNullParameter(keyCodes, (String)"keyCodes");
            this.backToBack(backWindow, previousHwnd);
            this.paste(keyCodes);
        }

        public final void paste(@NotNull List<Integer> keyCodes) {
            int i;
            Intrinsics.checkNotNullParameter(keyCodes, (String)"keyCodes");
            if (keyCodes.isEmpty()) {
                return;
            }
            Structure[] structureArray = new WinUser.INPUT().toArray(keyCodes.size());
            Intrinsics.checkNotNull((Object)structureArray, (String)"null cannot be cast to non-null type kotlin.Array<com.sun.jna.platform.win32.WinUser.INPUT>");
            WinUser.INPUT[] inputs = (WinUser.INPUT[])structureArray;
            int n = ((Collection)keyCodes).size();
            for (i = 0; i < n; ++i) {
                inputs[i].type = new WinDef.DWORD(1L);
                inputs[i].input.setType("ki");
                inputs[i].input.ki.wScan = new WinDef.WORD(0L);
                inputs[i].input.ki.time = new WinDef.DWORD(0L);
                inputs[i].input.ki.dwExtraInfo = new BaseTSD.ULONG_PTR(0L);
                inputs[i].input.ki.wVk = new WinDef.WORD((long)((Number)keyCodes.get(i)).intValue());
                inputs[i].input.ki.dwFlags = new WinDef.DWORD(0L);
            }
            INSTANCE.SendInput(new WinDef.DWORD((long)inputs.length), inputs, inputs[0].size());
            n = ((Collection)keyCodes).size();
            for (i = 0; i < n; ++i) {
                inputs[i].input.ki.dwFlags = new WinDef.DWORD(2L);
            }
            INSTANCE.SendInput(new WinDef.DWORD((long)inputs.length), inputs, inputs[0].size());
        }

        @Nullable
        public final WinDef.HWND findPasteWindow(@NotNull String windowTitle) {
            WinDef.HWND hWND;
            Intrinsics.checkNotNullParameter((Object)windowTitle, (String)"windowTitle");
            WinDef.HWND hWND2 = INSTANCE.FindWindow(null, windowTitle);
            if (hWND2 != null) {
                WinDef.HWND hWND3;
                WinDef.HWND hwnd = hWND3 = hWND2;
                boolean bl = false;
                int style = INSTANCE.GetWindowLong(hwnd, -20);
                INSTANCE.SetWindowLong(hwnd, -20, style | 0x80);
                hWND = hWND3;
            } else {
                hWND = null;
            }
            return hWND;
        }

        public final boolean isInstalledFromMicrosoftStore(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path path2 = Paths.get("C:\\Program Files\\WindowsApps", new String[0]).toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
            Path windowsAppsPath = path2;
            return path.startsWith(windowsAppsPath);
        }

        private static final Unit logger$lambda$0() {
            return Unit.INSTANCE;
        }

        private static final Object getFileDescription$lambda$4() {
            return "FileDescription GetLastError " + Kernel32.INSTANCE.GetLastError();
        }

        private static final Object getFileDescription$lambda$5() {
            return "Translation GetLastError " + Kernel32.INSTANCE.GetLastError();
        }

        private static final Unit hiconToImage$lambda$14$lambda$12(GDI32 $gdi32, WinNT.HANDLE hObject) {
            $gdi32.DeleteObject(hObject);
            return Unit.INSTANCE;
        }

        private static final void hiconToImage$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Object bringToFront$lambda$21$lambda$18() {
            return "Failed to set foreground window. Please switch manually";
        }

        private static final Object bringToFront$lambda$21$lambda$19() {
            return "Foreground window set successfully";
        }

        private static final Object bringToFront$lambda$21$lambda$20() {
            return "AttachThreadInput failed: " + Kernel32.INSTANCE.GetLastError();
        }

        static {
            $$INSTANCE = new Companion();
            Map map2 = W32APIOptions.DEFAULT_OPTIONS;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"DEFAULT_OPTIONS");
            Library library = Native.load((String)"user32", User32.class, (Map)MapsKt.plus((Map)map2, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"allow-get-last-error", (Object)true))));
            Intrinsics.checkNotNull((Object)library, (String)"null cannot be cast to non-null type com.crosspaste.platform.windows.api.User32");
            INSTANCE = (User32)library;
            logger = KotlinLogging.INSTANCE.logger(Companion::logger$lambda$0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J5\u0010\n\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\bH&\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lcom/crosspaste/platform/windows/api/User32$WNDPROC;", "Lcom/sun/jna/win32/StdCallLibrary$StdCallCallback;", "Lcom/sun/jna/platform/win32/WinDef$HWND;", "hWnd", "", "uMsg", "Lcom/sun/jna/platform/win32/WinDef$WPARAM;", "uParam", "Lcom/sun/jna/platform/win32/WinDef$LPARAM;", "lParam", "callback", "(Lcom/sun/jna/platform/win32/WinDef$HWND;ILcom/sun/jna/platform/win32/WinDef$WPARAM;Lcom/sun/jna/platform/win32/WinDef$LPARAM;)I", "app"})
    public static interface WNDPROC
    extends StdCallLibrary.StdCallCallback {
        public int callback(@Nullable WinDef.HWND var1, int var2, @Nullable WinDef.WPARAM var3, @Nullable WinDef.LPARAM var4);
    }
}

