/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.platform.windows;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.platform.windows.api.Kernel32;
import com.crosspaste.platform.windows.api.User32;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/crosspaste/platform/windows/WindowClipboard;", "", "<init>", "()V", "", "text", "", "supplementCFText", "(Ljava/lang/String;)V", "", "addAnsiText", "(Ljava/lang/String;)Z", "addLocale", "", "codePage", "getCharsetForCodePage", "(I)Ljava/lang/String;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/platform/windows/api/User32;", "user32", "Lcom/crosspaste/platform/windows/api/User32;", "Lcom/crosspaste/platform/windows/api/Kernel32;", "kernel32", "Lcom/crosspaste/platform/windows/api/Kernel32;", "app"})
@StabilityInferred(parameters=0)
public final class WindowClipboard {
    @NotNull
    public static final WindowClipboard INSTANCE = new WindowClipboard();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(WindowClipboard::logger$lambda$0);
    @NotNull
    private static final User32 user32 = User32.Companion.getINSTANCE();
    @NotNull
    private static final Kernel32 kernel32 = Kernel32.Companion.getINSTANCE();
    public static final int $stable = 8;

    private WindowClipboard() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void supplementCFText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!user32.OpenClipboard(null)) {
            logger.error(WindowClipboard::supplementCFText$lambda$1);
            return;
        }
        try {
            boolean success = this.addAnsiText(text);
            if (success) {
                logger.info(WindowClipboard::supplementCFText$lambda$2);
                this.addLocale();
            } else {
                logger.error(WindowClipboard::supplementCFText$lambda$3);
            }
        }
        finally {
            user32.CloseClipboard();
        }
    }

    private final boolean addAnsiText(String text) {
        Object object;
        Object $this$addAnsiText_u24lambda_u247;
        Object object2 = this;
        try {
            $this$addAnsiText_u24lambda_u247 = object2;
            boolean bl = false;
            int codePage = kernel32.GetACP();
            String charsetName = super.getCharsetForCodePage(codePage);
            logger.info(() -> WindowClipboard.addAnsiText$lambda$7$lambda$4(codePage, charsetName));
            String string2 = text + "\u0000";
            Charset charset = Charset.forName(charsetName);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] data = byArray;
            WinNT.HANDLE hGlobal = kernel32.GlobalAlloc(8194, data.length);
            if (hGlobal == null) {
                logger.error(WindowClipboard::addAnsiText$lambda$7$lambda$5);
                return false;
            }
            Pointer ptr = kernel32.GlobalLock(hGlobal);
            if (ptr == null) {
                kernel32.GlobalFree(hGlobal);
                logger.error(WindowClipboard::addAnsiText$lambda$7$lambda$6);
                return false;
            }
            ptr.write(0L, data, 0, data.length);
            kernel32.GlobalUnlock(hGlobal);
            WinNT.HANDLE result2 = user32.SetClipboardData(1, hGlobal);
            $this$addAnsiText_u24lambda_u247 = Result.constructor-impl((Object)(result2 != null ? 1 : 0));
        }
        catch (Throwable bl) {
            $this$addAnsiText_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$addAnsiText_u24lambda_u247;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            logger.error(e, WindowClipboard::addAnsiText$lambda$9$lambda$8);
            object = false;
        }
        return (Boolean)object;
    }

    private final void addLocale() {
        WindowClipboard windowClipboard = this;
        try {
            WindowClipboard $this$addLocale_u24lambda_u2411 = windowClipboard;
            boolean bl = false;
            if (user32.IsClipboardFormatAvailable(16)) {
                return;
            }
            WinDef.LCID lcid = kernel32.GetUserDefaultLCID();
            int lcidValue = lcid.intValue();
            WinNT.HANDLE hGlobal = kernel32.GlobalAlloc(8194, 4);
            if (hGlobal == null) {
                return;
            }
            Pointer ptr = kernel32.GlobalLock(hGlobal);
            if (ptr == null) {
                kernel32.GlobalFree(hGlobal);
                return;
            }
            ptr.setInt(0L, lcidValue);
            kernel32.GlobalUnlock(hGlobal);
            user32.SetClipboardData(16, hGlobal);
            logger.info(() -> WindowClipboard.addLocale$lambda$11$lambda$10(lcidValue));
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final String getCharsetForCodePage(int codePage) {
        return switch (codePage) {
            case 936 -> "GBK";
            case 950 -> "Big5";
            case 932 -> "Shift_JIS";
            case 949 -> "EUC-KR";
            case 1252 -> "Windows-1252";
            case 65001 -> "UTF-8";
            default -> {
                Object v3;
                Object $this$getCharsetForCodePage_u24lambda_u2412;
                Object var2_2 = this;
                try {
                    $this$getCharsetForCodePage_u24lambda_u2412 = var2_2;
                    boolean $i$a$-runCatching-WindowClipboard$getCharsetForCodePage$1 = false;
                    String cpName = "cp" + codePage;
                    String var6_7 = "test";
                    Charset v1 = Charset.forName(cpName);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"forName(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)var6_7.getBytes(v1), (String)"getBytes(...)");
                    $this$getCharsetForCodePage_u24lambda_u2412 = Result.constructor-impl((Object)cpName);
                }
                catch (Throwable $i$a$-runCatching-WindowClipboard$getCharsetForCodePage$1) {
                    $this$getCharsetForCodePage_u24lambda_u2412 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-WindowClipboard$getCharsetForCodePage$1));
                }
                var2_2 = $this$getCharsetForCodePage_u24lambda_u2412;
                Throwable v2 = Result.exceptionOrNull-impl((Object)var2_2);
                if (v2 == null) {
                    v3 = var2_2;
                } else {
                    Throwable it = v2;
                    boolean $i$a$-getOrElse-WindowClipboard$getCharsetForCodePage$2 = false;
                    v3 = "GBK";
                }
                yield (String)v3;
            }
        };
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object supplementCFText$lambda$1() {
        return "Failed to open clipboard to supplement CF_TEXT";
    }

    private static final Object supplementCFText$lambda$2() {
        return "Successfully supplemented CF_TEXT format";
    }

    private static final Object supplementCFText$lambda$3() {
        return "Failed to add CF_TEXT format";
    }

    private static final Object addAnsiText$lambda$7$lambda$4(int $codePage, String $charsetName) {
        return "Using code page: " + $codePage + " (" + $charsetName + ")";
    }

    private static final Object addAnsiText$lambda$7$lambda$5() {
        return "Memory allocation failed";
    }

    private static final Object addAnsiText$lambda$7$lambda$6() {
        return "Memory lock failed";
    }

    private static final Object addAnsiText$lambda$9$lambda$8() {
        return "Error adding CF_TEXT format";
    }

    private static final Object addLocale$lambda$11$lambda$10(int $lcidValue) {
        String string2 = Integer.toString($lcidValue, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return "Added locale information: " + $lcidValue + " (0x" + string2 + ")";
    }
}

