/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.platform.windows;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/crosspaste/platform/windows/WinProcessUtils;", "", "<init>", "()V", "", "parentProcessId", "", "Lkotlin/Pair;", "", "getChildProcessIds", "(J)Ljava/util/List;", "", "pids", "", "killProcessSet", "(Ljava/util/Set;)V", "", "GET_CHILD_PROCESS_IDS", "[Ljava/lang/String;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWinProcessUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WinProcessUtils.kt\ncom/crosspaste/platform/windows/WinProcessUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,52:1\n11228#2:53\n11563#2,3:54\n*S KotlinDebug\n*F\n+ 1 WinProcessUtils.kt\ncom/crosspaste/platform/windows/WinProcessUtils\n*L\n13#1:53\n13#1:54,3\n*E\n"})
public final class WinProcessUtils {
    @NotNull
    public static final WinProcessUtils INSTANCE = new WinProcessUtils();
    @NotNull
    private static final String[] GET_CHILD_PROCESS_IDS;
    @NotNull
    private static final KLogger logger;
    public static final int $stable;

    private WinProcessUtils() {
    }

    @NotNull
    public final List<Pair<String, Long>> getChildProcessIds(long parentProcessId) {
        Regex it;
        InputStream $this$mapTo$iv$iv;
        String[] $this$map$iv = GET_CHILD_PROCESS_IDS;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (CharSequence item$iv$iv : $this$mapTo$iv$iv) {
            void var12_14 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var14_16 = it;
            Object[] objectArray = new Object[]{parentProcessId};
            String string2 = String.format((String)var14_16, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            collection.add(string2);
        }
        List command = (List)destination$iv$iv;
        Process process = new ProcessBuilder(command).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        $this$mapTo$iv$iv = inputStream;
        destination$iv$iv = Charsets.UTF_8;
        Object object = new InputStreamReader($this$mapTo$iv$iv, (Charset)destination$iv$iv);
        int n = 8192;
        BufferedReader reader = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        List lines = TextStreamsKt.readLines((Reader)reader);
        List processIds = new ArrayList();
        object = lines.iterator();
        while (object.hasNext()) {
            int n2;
            CharSequence item$iv$iv;
            it = new Regex("\\s+");
            String line = (String)object.next();
            item$iv$iv = ((Object)StringsKt.trim((CharSequence)line)).toString();
            List parts = it.split(item$iv$iv, n2 = 0);
            if (parts.size() != 2) continue;
            String processName = (String)parts.get(0);
            Long processId = StringsKt.toLongOrNull((String)((String)parts.get(1)));
            if (processId == null) continue;
            processIds.add(TuplesKt.to((Object)processName, (Object)processId));
        }
        return processIds;
    }

    public final void killProcessSet(@NotNull Set<Long> pids) {
        Intrinsics.checkNotNullParameter(pids, (String)"pids");
        Iterator<Long> iterator = pids.iterator();
        while (iterator.hasNext()) {
            Object object;
            long pid = ((Number)iterator.next()).longValue();
            Object object2 = this;
            try {
                WinProcessUtils $this$killProcessSet_u24lambda_u244 = object2;
                boolean bl = false;
                Object[] objectArray = new String[]{"taskkill", "/F", "/PID", String.valueOf(pid)};
                List command = CollectionsKt.listOf((Object[])objectArray);
                Process process = new ProcessBuilder(command).start();
                int exitValue = process.waitFor();
                if (exitValue == 0) {
                    logger.info(() -> WinProcessUtils.killProcessSet$lambda$4$lambda$2(pid));
                } else {
                    logger.error(() -> WinProcessUtils.killProcessSet$lambda$4$lambda$3(pid));
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object e = object = throwable;
            boolean bl = false;
            if (e instanceof InterruptedException) {
                logger.error((Throwable)e, () -> WinProcessUtils.killProcessSet$lambda$7$lambda$5(pid));
                continue;
            }
            logger.error((Throwable)e, () -> WinProcessUtils.killProcessSet$lambda$7$lambda$6(pid));
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object killProcessSet$lambda$4$lambda$2(long $pid) {
        return "Successfully terminated process PID: " + $pid;
    }

    private static final Object killProcessSet$lambda$4$lambda$3(long $pid) {
        return "Failed to terminate process PID: " + $pid;
    }

    private static final Object killProcessSet$lambda$7$lambda$5(long $pid) {
        return "Error trying to terminate process PID: " + $pid;
    }

    private static final Object killProcessSet$lambda$7$lambda$6(long $pid) {
        return "Error trying to terminate process PID: " + $pid;
    }

    static {
        String[] stringArray = new String[]{"wmic", "process", "where", "(ParentProcessId=%d)", "get", "Name,", "ProcessId"};
        GET_CHILD_PROCESS_IDS = stringArray;
        logger = KotlinLogging.INSTANCE.logger(WinProcessUtils::logger$lambda$0);
        $stable = 8;
    }
}

