/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.platform.windows;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.platform.windows.IShellItemImageFactory;
import com.crosspaste.platform.windows.IconSize;
import com.crosspaste.platform.windows.SIZEByValue;
import com.crosspaste.platform.windows.api.Shell32;
import com.crosspaste.platform.windows.api.User32;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinGDI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\rJ!\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ)\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/crosspaste/platform/windows/JIconExtract;", "", "<init>", "()V", "Ljava/io/File;", "file", "Lcom/crosspaste/platform/windows/IconSize;", "size", "Ljava/awt/image/BufferedImage;", "getIconForFile", "(Ljava/io/File;Lcom/crosspaste/platform/windows/IconSize;)Ljava/awt/image/BufferedImage;", "", "filePath", "(Ljava/lang/String;Lcom/crosspaste/platform/windows/IconSize;)Ljava/awt/image/BufferedImage;", "tryGetIconForSize", "", "width", "height", "Lcom/sun/jna/platform/win32/WinDef$HBITMAP;", "getHBITMAPForFile", "(IILjava/lang/String;)Lcom/sun/jna/platform/win32/WinDef$HBITMAP;", "", "ICON_SIZES", "Ljava/util/List;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nJIconExtract.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JIconExtract.kt\ncom/crosspaste/platform/windows/JIconExtract\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public final class JIconExtract {
    @NotNull
    public static final JIconExtract INSTANCE = new JIconExtract();
    @NotNull
    private static final List<IconSize> ICON_SIZES;
    public static final int $stable;

    private JIconExtract() {
    }

    @Nullable
    public final BufferedImage getIconForFile(@NotNull File file, @Nullable IconSize size) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        return this.getIconForFile(string2, size);
    }

    public static /* synthetic */ BufferedImage getIconForFile$default(JIconExtract jIconExtract, File file, IconSize iconSize, int n, Object object) {
        if ((n & 2) != 0) {
            iconSize = null;
        }
        return jIconExtract.getIconForFile(file, iconSize);
    }

    @Nullable
    public final BufferedImage getIconForFile(@NotNull String filePath, @Nullable IconSize size) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        List sizesToTry = size != null ? CollectionsKt.listOf((Object)size) : ICON_SIZES;
        for (IconSize iconSize : sizesToTry) {
            BufferedImage result2 = this.tryGetIconForSize(filePath, iconSize);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public static /* synthetic */ BufferedImage getIconForFile$default(JIconExtract jIconExtract, String string2, IconSize iconSize, int n, Object object) {
        if ((n & 2) != 0) {
            iconSize = null;
        }
        return jIconExtract.getIconForFile(string2, iconSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BufferedImage tryGetIconForSize(String filePath, IconSize size) {
        WinDef.HBITMAP hBITMAP;
        BufferedImage bufferedImage;
        Memory lpPixels;
        int h;
        int w;
        WinDef.HBITMAP hdc;
        WinDef.HBITMAP hBitmap;
        block18: {
            WinDef.HBITMAP it;
            WinGDI.BITMAPINFO bitmapInfo;
            block17: {
                WinDef.HBITMAP it2;
                block16: {
                    WinGDI.BITMAP bitmap;
                    block15: {
                        WinDef.HBITMAP hBITMAP2;
                        block14: {
                            hBitmap = null;
                            hdc = null;
                            if (this.getHBITMAPForFile(size.getWidth(), size.getHeight(), filePath) != null) break block14;
                            return null;
                        }
                        hBitmap = hBITMAP2;
                        bitmap = new WinGDI.BITMAP();
                        int result2 = GDI32.INSTANCE.GetObject((WinNT.HANDLE)hBitmap, bitmap.size(), bitmap.getPointer());
                        if (result2 > 0) break block15;
                        BufferedImage bufferedImage2 = null;
                        WinDef.HBITMAP it3 = hBitmap;
                        boolean bl = false;
                        GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)it3);
                        return bufferedImage2;
                    }
                    bitmap.read();
                    w = bitmap.bmWidth.intValue();
                    h = bitmap.bmHeight.intValue();
                    if (w >= size.getWidth() / 2 && h >= size.getHeight() / 2) break block16;
                    BufferedImage bufferedImage3 = null;
                    WinDef.HBITMAP it4 = hBitmap;
                    boolean bl = false;
                    GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)it4);
                    return bufferedImage3;
                }
                hdc = User32.Companion.getINSTANCE().GetDC(null);
                bitmapInfo = new WinGDI.BITMAPINFO();
                bitmapInfo.bmiHeader.biSize = bitmapInfo.bmiHeader.size();
                if (GDI32.INSTANCE.GetDIBits((WinDef.HDC)hdc, hBitmap, 0, 0, Pointer.NULL, bitmapInfo, 0) != 0) break block17;
                BufferedImage it3 = null;
                WinDef.HBITMAP hBITMAP3 = hdc;
                if (hBITMAP3 != null) {
                    it2 = hBITMAP3;
                    boolean bl = false;
                    User32.Companion.getINSTANCE().ReleaseDC(null, (WinDef.HDC)it2);
                }
                it2 = hBitmap;
                boolean bl = false;
                GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)it2);
                return it3;
            }
            bitmapInfo.read();
            lpPixels = new Memory((long)bitmapInfo.bmiHeader.biSizeImage);
            bitmapInfo.bmiHeader.biCompression = 0;
            bitmapInfo.bmiHeader.biHeight = -h;
            if (GDI32.INSTANCE.GetDIBits((WinDef.HDC)hdc, hBitmap, 0, bitmapInfo.bmiHeader.biHeight, (Pointer)lpPixels, bitmapInfo, 0) != 0) break block18;
            BufferedImage bl = null;
            WinDef.HBITMAP hBITMAP4 = hdc;
            if (hBITMAP4 != null) {
                it = hBITMAP4;
                boolean bl2 = false;
                User32.Companion.getINSTANCE().ReleaseDC(null, (WinDef.HDC)it);
            }
            it = hBitmap;
            boolean $i$a$-let-JIconExtract$tryGetIconForSize$5 = false;
            GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)it);
            return bl;
        }
        try {
            BufferedImage bufferedImage4;
            int[] nArray = lpPixels.getIntArray(0L, w * h);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getIntArray(...)");
            int[] colorArray = nArray;
            BufferedImage $this$tryGetIconForSize_u24lambda_u240 = bufferedImage4 = new BufferedImage(w, h, 2);
            boolean bl = false;
            $this$tryGetIconForSize_u24lambda_u240.setRGB(0, 0, w, h, colorArray, 0, w);
            bufferedImage = bufferedImage4;
            hBITMAP = hdc;
        }
        catch (Exception exception) {
            WinDef.HBITMAP hBITMAP5;
            try {
                bufferedImage = null;
                hBITMAP5 = hdc;
            }
            catch (Throwable throwable) {
                WinDef.HBITMAP it;
                WinDef.HBITMAP hBITMAP6 = hdc;
                if (hBITMAP6 != null) {
                    it = hBITMAP6;
                    boolean bl = false;
                    User32.Companion.getINSTANCE().ReleaseDC(null, (WinDef.HDC)it);
                }
                WinDef.HBITMAP hBITMAP7 = hBitmap;
                if (hBITMAP7 == null) throw throwable;
                it = hBITMAP7;
                boolean bl = false;
                GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)it);
                throw throwable;
            }
            if (hBITMAP5 != null) {
                WinDef.HBITMAP it = hBITMAP5;
                boolean bl = false;
                User32.Companion.getINSTANCE().ReleaseDC(null, (WinDef.HDC)it);
            }
            WinDef.HBITMAP hBITMAP8 = hBitmap;
            if (hBITMAP8 == null) return bufferedImage;
            WinDef.HBITMAP it = hBITMAP8;
            boolean bl = false;
            GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)it);
            return bufferedImage;
        }
        if (hBITMAP != null) {
            WinDef.HBITMAP it = hBITMAP;
            boolean bl = false;
            User32.Companion.getINSTANCE().ReleaseDC(null, (WinDef.HDC)it);
        }
        WinDef.HBITMAP it = hBitmap;
        boolean bl = false;
        GDI32.INSTANCE.DeleteObject((WinNT.HANDLE)it);
        return bufferedImage;
    }

    private final WinDef.HBITMAP getHBITMAPForFile(int width, int height, String filePath) {
        WinNT.HRESULT h1 = Ole32.INSTANCE.CoInitialize(null);
        if (COMUtils.SUCCEEDED((WinNT.HRESULT)h1)) {
            PointerByReference factory = new PointerByReference();
            WinNT.HRESULT h2 = Shell32.Companion.getINSTANCE().SHCreateItemFromParsingName(new WString(filePath), null, new Guid.REFIID(new Guid.IID("BCC18B79-BA16-442F-80C4-8A59C30C463B")), factory);
            if (COMUtils.SUCCEEDED((WinNT.HRESULT)h2)) {
                Pointer pointer = factory.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getValue(...)");
                IShellItemImageFactory imageFactory = new IShellItemImageFactory(pointer);
                PointerByReference hBitmapPointer = new PointerByReference();
                WinNT.HRESULT h3 = imageFactory.GetImage(new SIZEByValue(width, height), 0, hBitmapPointer);
                WinDef.HBITMAP bitmap = null;
                if (COMUtils.SUCCEEDED((WinNT.HRESULT)h3)) {
                    bitmap = new WinDef.HBITMAP(hBitmapPointer.getValue());
                }
                imageFactory.Release();
                return bitmap;
            }
        }
        return null;
    }

    static {
        Object[] objectArray = new IconSize[]{new IconSize(512, 512), new IconSize(256, 256), new IconSize(128, 128), new IconSize(96, 96), new IconSize(64, 64), new IconSize(48, 48), new IconSize(32, 32), new IconSize(16, 16)};
        ICON_SIZES = CollectionsKt.listOf((Object[])objectArray);
        $stable = 8;
    }
}

