/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.platform.macos;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.platform.macos.api.MacosApi;
import com.sun.jna.Pointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u000eJ%\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010 \u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010\u000bJ%\u0010$\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004\u00a2\u0006\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/crosspaste/platform/macos/MacAppUtils;", "", "<init>", "()V", "", "getCurrentActiveApp", "()Ljava/lang/String;", "bundleIdentifier", "path", "", "saveAppIcon", "(Ljava/lang/String;Ljava/lang/String;)V", "appName", "mainToBack", "(Ljava/lang/String;)V", "Lcom/sun/jna/Pointer;", "array", "", "count", "mainToBackAndPaste", "(Ljava/lang/String;Lcom/sun/jna/Pointer;I)V", "searchToBack", "searchToBackAndPaste", "windowPtr", "setWindowLevelScreenSaver", "(Lcom/sun/jna/Pointer;)V", "bringToFront", "(Ljava/lang/String;)Ljava/lang/String;", "", "checkAccessibilityPermissions", "()Z", "ext", "saveIconByExt", "originalImagePath", "thumbnailImagePath", "metadataPath", "createThumbnail", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", "app"})
@StabilityInferred(parameters=1)
public final class MacAppUtils {
    @NotNull
    public static final MacAppUtils INSTANCE = new MacAppUtils();
    public static final int $stable;

    private MacAppUtils() {
    }

    @Nullable
    public final String getCurrentActiveApp() {
        return MacosApi.Companion.getString(MacosApi.Companion.getINSTANCE().getCurrentActiveApp());
    }

    public final void saveAppIcon(@NotNull String bundleIdentifier, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)bundleIdentifier, (String)"bundleIdentifier");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        MacosApi.Companion.getINSTANCE().saveAppIcon(bundleIdentifier, path);
    }

    public final void mainToBack(@NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        MacosApi.Companion.getINSTANCE().mainToBack(appName);
    }

    public final void mainToBackAndPaste(@NotNull String appName, @NotNull Pointer array2, int count) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        MacosApi.Companion.getINSTANCE().mainToBackAndPaste(appName, array2, count);
    }

    public final void searchToBack(@NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        MacosApi.Companion.getINSTANCE().searchToBack(appName);
    }

    public final void searchToBackAndPaste(@NotNull String appName, @NotNull Pointer array2, int count) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        MacosApi.Companion.getINSTANCE().searchToBackAndPaste(appName, array2, count);
    }

    public final void setWindowLevelScreenSaver(@Nullable Pointer windowPtr) {
        MacosApi.Companion.getINSTANCE().setWindowLevelScreenSaver(windowPtr);
    }

    @NotNull
    public final String bringToFront(@NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        String string2 = MacosApi.Companion.getString(MacosApi.Companion.getINSTANCE().bringToFront(appName));
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    public final boolean checkAccessibilityPermissions() {
        return MacosApi.Companion.getINSTANCE().checkAccessibilityPermissions();
    }

    public final void saveIconByExt(@NotNull String ext, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        MacosApi.Companion.getINSTANCE().saveIconByExt(ext, path);
    }

    public final boolean createThumbnail(@NotNull String originalImagePath, @NotNull String thumbnailImagePath, @NotNull String metadataPath) {
        Intrinsics.checkNotNullParameter((Object)originalImagePath, (String)"originalImagePath");
        Intrinsics.checkNotNullParameter((Object)thumbnailImagePath, (String)"thumbnailImagePath");
        Intrinsics.checkNotNullParameter((Object)metadataPath, (String)"metadataPath");
        return MacosApi.Companion.getINSTANCE().createThumbnail(originalImagePath, thumbnailImagePath, metadataPath);
    }
}

