/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.platform.linux.api;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.platform.linux.api.X11Api;
import com.crosspaste.platform.linux.api.X11Ext;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.X11;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u0013J!\u0010\u001a\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u001a\u0010\u0013J!\u0010\u001b\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u001b\u0010\u0013J\u001f\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\u001f\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u001e2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001f\u0010 J+\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u001e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010'\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b'\u0010\u0018J\u001f\u0010(\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b(\u0010)J1\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010+\u001a\u00020*2\b\u0010,\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b.\u0010/J\u0017\u00100\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b0\u00101J\u001f\u00104\u001a\u0004\u0018\u0001032\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0006\u00a2\u0006\u0004\b4\u00105J!\u00106\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b6\u00107J)\u00108\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b8\u00109JK\u0010=\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010:2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00062\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\b2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00028\u00000;H\u0002\u00a2\u0006\u0004\b=\u0010>J;\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00062\u0006\u0010+\u001a\u00020*2\b\u0010,\u001a\u0004\u0018\u00010\b2\b\u0010@\u001a\u0004\u0018\u00010?\u00a2\u0006\u0004\b.\u0010AJU\u0010H\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010B\u001a\u0004\u0018\u00010\b2\u0006\u0010C\u001a\u00020\f2\u0006\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bH\u0010IJ\u0017\u0010K\u001a\u00020\b2\u0006\u0010J\u001a\u00020-H\u0002\u00a2\u0006\u0004\bK\u0010LJ\u0019\u0010N\u001a\u00020M2\b\u0010J\u001a\u0004\u0018\u00010-H\u0002\u00a2\u0006\u0004\bN\u0010OR\u0014\u0010P\u001a\u00020\f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0014\u0010S\u001a\u00020R8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010T\u00a8\u0006U"}, d2={"Lcom/crosspaste/platform/linux/api/WMCtrl;", "", "<init>", "()V", "Lcom/sun/jna/platform/unix/X11$Display;", "display", "Lcom/sun/jna/platform/unix/X11$Window;", "rootWindow", "", "title", "findWindowByTitle", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;Ljava/lang/String;)Lcom/sun/jna/platform/unix/X11$Window;", "", "target", "", "switchDesktop", "(Lcom/sun/jna/platform/unix/X11$Display;J)Z", "win", "windowToDesktop", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;)Z", "", "desktop", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;I)Z", "getCurrentDesktop", "(Lcom/sun/jna/platform/unix/X11$Display;)I", "activeWindow", "iconifyWindow", "closeWindow", "getWindowIconName", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;)Ljava/lang/String;", "Lkotlin/Pair;", "getActiveWindowInstanceAndClass", "(Lcom/sun/jna/platform/unix/X11$Display;)Lkotlin/Pair;", "getWindowClass", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;)Lkotlin/Pair;", "getActiveWindowId", "(Lcom/sun/jna/platform/unix/X11$Display;)J", "getWindowId", "(Lcom/sun/jna/platform/unix/X11$Window;)J", "getActiveWindowPid", "getWindowPid", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;)I", "Lcom/sun/jna/platform/unix/X11$Atom;", "xaPropType", "propName", "Lcom/sun/jna/Pointer;", "getProperty", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;Lcom/sun/jna/platform/unix/X11$Atom;Ljava/lang/String;)Lcom/sun/jna/Pointer;", "getActiveWindow", "(Lcom/sun/jna/platform/unix/X11$Display;)Lcom/sun/jna/platform/unix/X11$Window;", "window", "Ljava/awt/image/BufferedImage;", "getPropertyAsIcon", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;)Ljava/awt/image/BufferedImage;", "getPropertyAsWindow", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;)Lcom/sun/jna/platform/unix/X11$Window;", "getPropertyAsInt", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;Ljava/lang/String;)Ljava/lang/Integer;", "T", "Lkotlin/Function1;", "convertTo", "getPropertyAs", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;Lcom/sun/jna/platform/unix/X11$Atom;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lcom/sun/jna/ptr/NativeLongByReference;", "size", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;Lcom/sun/jna/platform/unix/X11$Atom;Ljava/lang/String;Lcom/sun/jna/ptr/NativeLongByReference;)Lcom/sun/jna/Pointer;", "msg", "data0", "data1", "data2", "data3", "data4", "clientMsg", "(Lcom/sun/jna/platform/unix/X11$Display;Lcom/sun/jna/platform/unix/X11$Window;Ljava/lang/String;JJJJJ)Z", "pointer", "getString", "(Lcom/sun/jna/Pointer;)Ljava/lang/String;", "", "free", "(Lcom/sun/jna/Pointer;)V", "MAX_PROPERTY_VALUE_LEN", "J", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWMCtrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WMCtrl.kt\ncom/crosspaste/platform/linux/api/WMCtrl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,521:1\n1#2:522\n*E\n"})
public final class WMCtrl {
    @NotNull
    public static final WMCtrl INSTANCE = new WMCtrl();
    private static final long MAX_PROPERTY_VALUE_LEN = 0x800000L;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(WMCtrl::logger$lambda$0);
    public static final int $stable = 8;

    private WMCtrl() {
    }

    @Nullable
    public final X11.Window findWindowByTitle(@NotNull X11.Display display, @NotNull X11.Window rootWindow, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Intrinsics.checkNotNullParameter((Object)rootWindow, (String)"rootWindow");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        X11Api x11 = X11Api.Companion.getINSTANCE();
        X11.WindowByReference windowRef = new X11.WindowByReference();
        X11.WindowByReference parentRef = new X11.WindowByReference();
        PointerByReference childrenRef = new PointerByReference();
        IntByReference childCountRef = new IntByReference();
        x11.XQueryTree(display, rootWindow, windowRef, parentRef, childrenRef, childCountRef);
        if (childrenRef.getValue() == null) {
            return null;
        }
        int childrenCount = childCountRef.getValue();
        if (childrenCount == 0) {
            return null;
        }
        long[] ids = null;
        switch (Native.LONG_SIZE) {
            case 8: {
                long[] lArray = childrenRef.getValue().getLongArray(0L, childCountRef.getValue());
                Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"getLongArray(...)");
                ids = lArray;
                break;
            }
            case 4: {
                int[] intIds = childrenRef.getValue().getIntArray(0L, childCountRef.getValue());
                ids = new long[intIds.length];
                int n = intIds.length;
                for (int i = 0; i < n; ++i) {
                    ids[i] = intIds[i];
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected size for Native.LONG_SIZE" + Native.LONG_SIZE);
            }
        }
        for (long id : ids) {
            if (id == 0L) continue;
            X11.Window window = new X11.Window(id);
            PointerByReference namePtr = new PointerByReference();
            if (X11Api.Companion.getINSTANCE().XFetchName(display, window, namePtr) != 0) {
                String name = namePtr.getValue().getString(0L);
                this.free(namePtr.getValue());
                if (!Intrinsics.areEqual((Object)title, (Object)name)) continue;
                return window;
            }
            this.free(namePtr.getValue());
        }
        return null;
    }

    public final boolean switchDesktop(@NotNull X11.Display display, long target) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        if (target < 0L) {
            logger.error(WMCtrl::switchDesktop$lambda$1);
            return false;
        }
        if (this.clientMsg(display, X11Api.Companion.getINSTANCE().XDefaultRootWindow(display), "_NET_CURRENT_DESKTOP", target, 0L, 0L, 0L, 0L)) {
            X11Api.Companion.getINSTANCE().XFlush(display);
            return true;
        }
        return false;
    }

    public final boolean windowToDesktop(@NotNull X11.Display display, @NotNull X11.Window win) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Intrinsics.checkNotNullParameter((Object)win, (String)"win");
        return this.windowToDesktop(display, win, -1);
    }

    private final boolean windowToDesktop(X11.Display display, X11.Window win, int desktop) {
        int currentDesktop = desktop;
        if (currentDesktop < 0 && (currentDesktop = this.getCurrentDesktop(display)) < 0) {
            logger.error(WMCtrl::windowToDesktop$lambda$2);
            return false;
        }
        return this.clientMsg(display, win, "_NET_WM_DESKTOP", currentDesktop, 0L, 0L, 0L, 0L);
    }

    private final int getCurrentDesktop(X11.Display display) {
        Integer n;
        X11.Window window = X11Api.Companion.getINSTANCE().XDefaultRootWindow(display);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"XDefaultRootWindow(...)");
        X11.Window root = window;
        Integer curDesktop = null;
        Integer it = n = this.getPropertyAsInt(display, root, "_NET_CURRENT_DESKTOP");
        boolean bl = false;
        curDesktop = it;
        if (n == null) {
            it = n = this.getPropertyAsInt(display, root, "_WIN_WORKSPACE");
            boolean bl2 = false;
            curDesktop = it;
            if (n == null) {
                logger.error(WMCtrl::getCurrentDesktop$lambda$5);
            }
        }
        Integer n2 = curDesktop;
        return n2 != null ? n2 : -1;
    }

    public final boolean activeWindow(@NotNull X11.Display display, @NotNull X11.Window win) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Intrinsics.checkNotNullParameter((Object)win, (String)"win");
        X11Api.Companion.getINSTANCE().XMapRaised(display, win);
        X11Api.Companion.getINSTANCE().XFlush(display);
        this.clientMsg(display, win, "_NET_ACTIVE_WINDOW", 1L, 0L, 0L, 0L, 0L);
        X11Api.Companion.getINSTANCE().XFlush(display);
        X11Ext.Companion.getINSTANCE().XSetInputFocus(display, win, 2, 0);
        X11Api.Companion.getINSTANCE().XFlush(display);
        return true;
    }

    public final boolean iconifyWindow(@Nullable X11.Display display, @Nullable X11.Window win) {
        return X11Ext.Companion.getINSTANCE().XIconifyWindow(display, win, X11Api.Companion.getINSTANCE().XDefaultScreen(display)) == 1;
    }

    public final boolean closeWindow(@Nullable X11.Display display, @Nullable X11.Window win) {
        return this.clientMsg(display, win, "_NET_CLOSE_WINDOW", 0L, 0L, 0L, 0L, 0L);
    }

    @Nullable
    public final String getWindowIconName(@NotNull X11.Display display, @NotNull X11.Window win) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Intrinsics.checkNotNullParameter((Object)win, (String)"win");
        PointerByReference iconNameReturn = new PointerByReference();
        if (X11Ext.Companion.getINSTANCE().XGetIconName(display, win, iconNameReturn) == 0) {
            this.free(iconNameReturn.getPointer());
            return null;
        }
        Pointer pointer = iconNameReturn.getPointer();
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getPointer(...)");
        return this.getString(pointer);
    }

    @Nullable
    public final Pair<String, String> getActiveWindowInstanceAndClass(@NotNull X11.Display display) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        X11.Window window = this.getActiveWindow(display);
        if (window != null) {
            X11.Window it = window;
            boolean bl = false;
            return INSTANCE.getWindowClass(display, it);
        }
        return null;
    }

    @Nullable
    public final Pair<String, String> getWindowClass(@NotNull X11.Display display, @NotNull X11.Window win) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Intrinsics.checkNotNullParameter((Object)win, (String)"win");
        NativeLongByReference size = new NativeLongByReference();
        X11.Atom atom = X11.XA_STRING;
        Intrinsics.checkNotNullExpressionValue((Object)atom, (String)"XA_STRING");
        Pointer pointer = this.getProperty(display, win, atom, "WM_CLASS", size);
        if (pointer != null) {
            String instanceName;
            Pointer pointer2 = pointer;
            boolean bl = false;
            String string2 = instanceName = pointer2.getString(0L, Native.getDefaultStringEncoding());
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                long endOfInstanceName = instanceName.length();
                String className = pointer2.getString(endOfInstanceName + 1L, Native.getDefaultStringEncoding());
                INSTANCE.free(pointer2);
                return new Pair((Object)instanceName, (Object)className);
            }
            return null;
        }
        return null;
    }

    public final long getActiveWindowId(@NotNull X11.Display display) {
        long l;
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        X11.Window window = this.getActiveWindow(display);
        if (window != null) {
            X11.Window it = window;
            boolean bl = false;
            l = INSTANCE.getWindowId(it);
        } else {
            l = -1L;
        }
        return l;
    }

    private final long getWindowId(X11.Window win) {
        return win.longValue();
    }

    public final int getActiveWindowPid(@NotNull X11.Display display) {
        int n;
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        X11.Window window = this.getActiveWindow(display);
        if (window != null) {
            X11.Window it = window;
            boolean bl = false;
            n = INSTANCE.getWindowPid(display, it);
        } else {
            n = -1;
        }
        return n;
    }

    private final int getWindowPid(X11.Display display, X11.Window win) {
        Integer n = this.getPropertyAsInt(display, win, "_NET_WM_PID");
        return n != null ? n : -1;
    }

    @Nullable
    public final Pointer getProperty(@NotNull X11.Display display, @NotNull X11.Window win, @NotNull X11.Atom xaPropType, @Nullable String propName) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Intrinsics.checkNotNullParameter((Object)win, (String)"win");
        Intrinsics.checkNotNullParameter((Object)xaPropType, (String)"xaPropType");
        return this.getProperty(display, win, xaPropType, propName, null);
    }

    @Nullable
    public final X11.Window getActiveWindow(@NotNull X11.Display display) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        X11.Window window = X11Api.Companion.getINSTANCE().XDefaultRootWindow(display);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"XDefaultRootWindow(...)");
        return this.getPropertyAsWindow(display, window);
    }

    @Nullable
    public final BufferedImage getPropertyAsIcon(@NotNull X11.Display display, @NotNull X11.Window window) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        X11.Atom atom = X11.XA_CARDINAL;
        Intrinsics.checkNotNullExpressionValue((Object)atom, (String)"XA_CARDINAL");
        Pointer pointer = this.getProperty(display, window, atom, "_NET_WM_ICON", null);
        if (pointer != null) {
            Pointer prop = pointer;
            boolean bl = false;
            int width = (int)prop.getLong(0L);
            int height = (int)prop.getLong(8L);
            BufferedImage buffer = new BufferedImage(width, height, 2);
            int numPixels = width * height;
            int bytesPerPixel = 8;
            byte[] imageData = new byte[numPixels * bytesPerPixel];
            prop.read(16L, imageData, 0, imageData.length);
            int offset = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int bgraIndex = offset;
                    int blue = imageData[bgraIndex] & 0xFF;
                    int green = imageData[bgraIndex + 1] & 0xFF;
                    int red = imageData[bgraIndex + 2] & 0xFF;
                    int alpha = imageData[bgraIndex + 3] & 0xFF;
                    int argb = alpha << 24 | red << 16 | green << 8 | blue;
                    buffer.setRGB(x, y, argb);
                    offset += bytesPerPixel;
                }
            }
            bufferedImage = buffer;
        } else {
            bufferedImage = null;
        }
        return bufferedImage;
    }

    private final X11.Window getPropertyAsWindow(X11.Display display, X11.Window window) {
        X11.Atom atom = X11.XA_WINDOW;
        Intrinsics.checkNotNullExpressionValue((Object)atom, (String)"XA_WINDOW");
        return (X11.Window)this.getPropertyAs(display, window, atom, "_NET_ACTIVE_WINDOW", WMCtrl::getPropertyAsWindow$lambda$12);
    }

    private final Integer getPropertyAsInt(X11.Display display, X11.Window window, String propName) {
        X11.Atom atom = X11.XA_CARDINAL;
        Intrinsics.checkNotNullExpressionValue((Object)atom, (String)"XA_CARDINAL");
        return (Integer)this.getPropertyAs(display, window, atom, propName, WMCtrl::getPropertyAsInt$lambda$13);
    }

    private final <T> T getPropertyAs(X11.Display display, X11.Window window, X11.Atom xaPropType, String propName, Function1<? super Pointer, ? extends T> convertTo) {
        Object object;
        Pointer pointer = this.getProperty(display, window, xaPropType, propName, null);
        if (pointer != null) {
            Pointer pointer2 = pointer;
            boolean bl = false;
            Object result2 = convertTo.invoke((Object)pointer2);
            INSTANCE.free(pointer2);
            object = result2;
        } else {
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public final Pointer getProperty(@NotNull X11.Display display, @NotNull X11.Window window, @NotNull X11.Atom xaPropType, @Nullable String propName, @Nullable NativeLongByReference size) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)xaPropType, (String)"xaPropType");
        X11.AtomByReference xaRetType = new X11.AtomByReference();
        IntByReference retFormat = new IntByReference();
        NativeLongByReference retNitems = new NativeLongByReference();
        NativeLongByReference retBytesAfter = new NativeLongByReference();
        PointerByReference retProp = new PointerByReference();
        X11.Atom xaPropName = X11Api.Companion.getINSTANCE().XInternAtom(display, propName, false);
        if (X11Api.Companion.getINSTANCE().XGetWindowProperty(display, window, xaPropName, new NativeLong(0L), new NativeLong(0x200000L), false, xaPropType, xaRetType, retFormat, retNitems, retBytesAfter, retProp) != 0) {
            logger.error(() -> WMCtrl.getProperty$lambda$15(propName));
            return null;
        }
        if (xaRetType.getValue() == null || xaRetType.getValue().longValue() != xaPropType.longValue()) {
            logger.error(() -> WMCtrl.getProperty$lambda$16(propName));
            this.free(retProp.getPointer());
            return null;
        }
        if (size != null) {
            long tmp_size = (long)(retFormat.getValue() / 8) * retNitems.getValue().longValue();
            if (retFormat.getValue() == 32) {
                tmp_size *= (long)(NativeLong.SIZE / 4);
            }
            size.setValue(new NativeLong(tmp_size));
        }
        return retProp.getValue();
    }

    private final boolean clientMsg(X11.Display display, X11.Window win, String msg, long data0, long data1, long data2, long data3, long data4) {
        boolean bl;
        NativeLong mask = new NativeLong(0x180000L);
        X11.XClientMessageEvent xclient = new X11.XClientMessageEvent();
        xclient.type = 33;
        xclient.serial = new NativeLong(0L);
        xclient.send_event = 1;
        xclient.message_type = X11Api.Companion.getINSTANCE().XInternAtom(display, msg, false);
        xclient.window = win;
        xclient.format = 32;
        xclient.data.setType(NativeLong[].class);
        xclient.data.l[0] = new NativeLong(data0);
        xclient.data.l[1] = new NativeLong(data1);
        xclient.data.l[2] = new NativeLong(data2);
        xclient.data.l[3] = new NativeLong(data3);
        xclient.data.l[4] = new NativeLong(data4);
        X11.XEvent event = new X11.XEvent();
        event.setTypedValue((Object)xclient);
        if (X11Api.Companion.getINSTANCE().XSendEvent(display, X11Api.Companion.getINSTANCE().XDefaultRootWindow(display), 0, mask, event) != 0) {
            bl = true;
        } else {
            logger.error(() -> WMCtrl.clientMsg$lambda$17(msg));
            bl = false;
        }
        return bl;
    }

    private final String getString(Pointer pointer) {
        String string2 = pointer.getString(0L);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return string2;
    }

    private final void free(Pointer pointer) {
        if (pointer != null) {
            X11Api.Companion.getINSTANCE().XFree(pointer);
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object switchDesktop$lambda$1() {
        return "Invalid desktop ID.";
    }

    private static final Object windowToDesktop$lambda$2() {
        return "Cannot get current desktop properties. (_NET_CURRENT_DESKTOP or _WIN_WORKSPACE property)";
    }

    private static final Object getCurrentDesktop$lambda$5() {
        return "Cannot get current desktop properties. (_NET_CURRENT_DESKTOP or _WIN_WORKSPACE property)";
    }

    private static final X11.Window getPropertyAsWindow$lambda$12(Pointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        return new X11.Window(pointer.getLong(0L));
    }

    private static final int getPropertyAsInt$lambda$13(Pointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        return pointer.getInt(0L);
    }

    private static final Object getProperty$lambda$15(String $propName) {
        return "Cannot get " + $propName + " property.";
    }

    private static final Object getProperty$lambda$16(String $propName) {
        return "Invalid type of " + $propName + " property.";
    }

    private static final Object clientMsg$lambda$17(String $msg) {
        return "Cannot send " + $msg + " event.";
    }
}

