/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.platform.linux;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u0006J\u000f\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0006J\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\u0006J\u000f\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u0006J\u000f\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0006J\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/crosspaste/platform/linux/LinuxPlatform;", "", "<init>", "()V", "", "getOsVersion", "()Ljava/lang/String;", "", "commandExists", "()Z", "getLsbReleaseInfo", "getOsReleaseInfo", "getDebianVersion", "getRedHatVersion", "getGenericLinuxInfo", "info", "parseOsInfo", "(Ljava/lang/String;)Ljava/lang/String;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLinuxPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxPlatform.kt\ncom/crosspaste/platform/linux/LinuxPlatform\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1#2:86\n543#3,6:87\n*S KotlinDebug\n*F\n+ 1 LinuxPlatform.kt\ncom/crosspaste/platform/linux/LinuxPlatform\n*L\n81#1:87,6\n*E\n"})
public final class LinuxPlatform {
    @NotNull
    public static final LinuxPlatform INSTANCE = new LinuxPlatform();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(LinuxPlatform::logger$lambda$0);
    public static final int $stable = 8;

    private LinuxPlatform() {
    }

    @NotNull
    public final String getOsVersion() {
        Object object;
        Object $this$getOsVersion_u24lambda_u242;
        String osName = System.getProperty("os.name");
        Intrinsics.checkNotNull((Object)osName);
        if (!StringsKt.startsWith$default((String)osName, (String)"Linux", (boolean)false, (int)2, null)) {
            logger.warn(LinuxPlatform::getOsVersion$lambda$1);
            return "Unknown";
        }
        Object object2 = this;
        try {
            $this$getOsVersion_u24lambda_u242 = object2;
            boolean bl = false;
            $this$getOsVersion_u24lambda_u242 = Result.constructor-impl((Object)(super.commandExists() ? super.getLsbReleaseInfo() : (new File("/etc/os-release").exists() ? super.getOsReleaseInfo() : (new File("/etc/debian_version").exists() ? super.getDebianVersion() : (new File("/etc/redhat-release").exists() ? super.getRedHatVersion() : super.getGenericLinuxInfo())))));
        }
        catch (Throwable bl) {
            $this$getOsVersion_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$getOsVersion_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = $this$getOsVersion_u24lambda_u242 = throwable;
            boolean bl = false;
            logger.warn((Throwable)e, LinuxPlatform::getOsVersion$lambda$4$lambda$3);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 == null) {
            object = object2;
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            object = "Unknown";
        }
        return (String)object;
    }

    private final boolean commandExists() {
        Object object;
        Object $this$commandExists_u24lambda_u246;
        Object object2 = this;
        try {
            $this$commandExists_u24lambda_u246 = object2;
            boolean bl = false;
            String[] stringArray = new String[]{"which", "lsb_release"};
            $this$commandExists_u24lambda_u246 = Result.constructor-impl((Object)(new ProcessBuilder(stringArray).start().waitFor() == 0 ? 1 : 0));
        }
        catch (Throwable bl) {
            $this$commandExists_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$commandExists_u24lambda_u246;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = false;
        }
        return (Boolean)object;
    }

    private final String getLsbReleaseInfo() {
        String[] stringArray = new String[]{"lsb_release", "-ds"};
        Process process = new ProcessBuilder(stringArray).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        String output = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))))).toString();
        return this.parseOsInfo(output);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final String getOsReleaseInfo() {
        block7: {
            block6: {
                content = FilesKt.readText$default((File)new File("/etc/os-release"), null, (int)1, null);
                var5_2 /* !! */  = StringsKt.lineSequence((CharSequence)content);
                for (E var7_4 : var5_2 /* !! */ ) {
                    it = (String)var7_4 /* !! */ ;
                    $i$a$-find-LinuxPlatform$getOsReleaseInfo$name$1 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"NAME=", (boolean)false, (int)2, null)) continue;
                    v0 = var7_4 /* !! */ ;
                    break block6;
                }
                v0 = null;
            }
            var3_8 = v0;
            if (var3_8 == null || (var4_9 = StringsKt.substringAfter$default((String)var3_8, (String)"NAME=", null, (int)2, null)) == null) ** GOTO lbl-1000
            var6_3 = new char[1];
            var6_3[0] = 34;
            var5_2 /* !! */  = StringsKt.trim((String)var4_9, (char[])var6_3);
            if (var5_2 /* !! */  != null) {
                v1 = var5_2 /* !! */ ;
            } else lbl-1000:
            // 2 sources

            {
                v1 = "Unknown";
            }
            name = v1;
            var6_3 = StringsKt.lineSequence((CharSequence)content);
            var7_4 /* !! */  = var6_3.iterator();
            while (var7_4 /* !! */ .hasNext()) {
                var8_5 = var7_4 /* !! */ .next();
                it = (String)var8_5;
                $i$a$-find-LinuxPlatform$getOsReleaseInfo$version$1 = false;
                if (!StringsKt.startsWith$default((String)it, (String)"VERSION_ID=", (boolean)false, (int)2, null)) continue;
                v2 = var8_5;
                break block7;
            }
            v2 = null;
        }
        var4_9 = v2;
        if (var4_9 == null || (var5_2 /* !! */  = StringsKt.substringAfter$default((String)var4_9, (String)"VERSION_ID=", null, (int)2, null)) == null) ** GOTO lbl-1000
        var7_4 /* !! */  = (E)new char[1];
        var7_4 /* !! */ [0] = 34;
        var6_3 = StringsKt.trim((String)var5_2 /* !! */ , var7_4 /* !! */ );
        if (var6_3 != null) {
            v3 = var6_3;
        } else lbl-1000:
        // 2 sources

        {
            v3 = "Unknown";
        }
        version = v3;
        return name + " " + version;
    }

    private final String getDebianVersion() {
        String version = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)new File("/etc/debian_version"), null, (int)1, null))).toString();
        return "Debian " + version;
    }

    private final String getRedHatVersion() {
        return this.parseOsInfo(((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)new File("/etc/redhat-release"), null, (int)1, null))).toString());
    }

    private final String getGenericLinuxInfo() {
        String kernelVersion = System.getProperty("os.version");
        return "Linux (Kernel " + kernelVersion + ")";
    }

    private final String parseOsInfo(String info) {
        String string2;
        Object v1;
        String name;
        block3: {
            String[] stringArray = new String[]{" "};
            List parts = StringsKt.split$default((CharSequence)info, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String string3 = (String)CollectionsKt.firstOrNull((List)parts);
            if (string3 == null) {
                string3 = "Unknown";
            }
            name = string3;
            List $this$lastOrNull$iv = parts;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                String it = (String)element$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                if (!new Regex("\\d+(\\.\\d+)*").matches(charSequence)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        if ((string2 = (String)v1) == null) {
            string2 = "Unknown";
        }
        String version = string2;
        return name + " " + version;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object getOsVersion$lambda$1() {
        return "Not a Linux system";
    }

    private static final Object getOsVersion$lambda$4$lambda$3() {
        return "Unable to determine Linux version";
    }
}

