/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.path;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.path.DesktopPathProvider;
import com.crosspaste.path.PathProvider;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.OkioPathExtensionKt;
import com.crosspaste.utils.SystemProperty;
import com.crosspaste.utils.SystemProperty_desktop_ktKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0006J!\u0010\r\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0006R\u001a\u0010\u0015\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0013\u001a\u0004\b\u0016\u0010\u0006R\u001a\u0010\u0017\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0013\u001a\u0004\b\u0018\u0010\u0006R\u001a\u0010\u0019\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u001a\u0010\u0006R\u001a\u0010\u001b\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0013\u001a\u0004\b\u001c\u0010\u0006R\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/crosspaste/path/MacosAppPathProvider;", "Lcom/crosspaste/path/AppPathProvider;", "<init>", "()V", "Lokio/Path;", "getAppJarPath", "()Lokio/Path;", "getAppExePath", "getUserPath", "", "fileName", "Lcom/crosspaste/app/AppFileType;", "appFileType", "resolve", "(Ljava/lang/String;Lcom/crosspaste/app/AppFileType;)Lokio/Path;", "Lcom/crosspaste/utils/SystemProperty;", "systemProperty", "Lcom/crosspaste/utils/SystemProperty;", "userHome", "Lokio/Path;", "getUserHome", "pasteAppPath", "getPasteAppPath", "pasteAppJarPath", "getPasteAppJarPath", "pasteAppExePath", "getPasteAppExePath", "pasteUserPath", "getPasteUserPath", "Lcom/crosspaste/path/PathProvider;", "pathProvider", "Lcom/crosspaste/path/PathProvider;", "app"})
@StabilityInferred(parameters=0)
public final class MacosAppPathProvider
implements AppPathProvider {
    @NotNull
    private final SystemProperty systemProperty = SystemProperty_desktop_ktKt.getSystemProperty();
    @NotNull
    private final Path userHome;
    @NotNull
    private final Path pasteAppPath;
    @NotNull
    private final Path pasteAppJarPath;
    @NotNull
    private final Path pasteAppExePath;
    @NotNull
    private final Path pasteUserPath;
    @NotNull
    private final PathProvider pathProvider;
    public static final int $stable = 8;

    public MacosAppPathProvider() {
        java.nio.file.Path path = Paths.get(this.systemProperty.get("user.home"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.userHome = Path.Companion.get$default((Path.Companion)Path.Companion, (java.nio.file.Path)path, (boolean)false, (int)1, null);
        this.pasteAppPath = OkioPathExtensionKt.getNoOptionParent((Path)OkioPathExtensionKt.getNoOptionParent((Path)this.getAppJarPath())).normalized();
        this.pasteAppJarPath = this.getAppJarPath();
        this.pasteAppExePath = this.getAppExePath();
        this.pasteUserPath = this.getUserPath();
        this.pathProvider = new DesktopPathProvider(this.getPasteAppPath(), this.getPasteUserPath());
    }

    @Override
    @NotNull
    public Path getUserHome() {
        return this.userHome;
    }

    @Override
    @NotNull
    public Path getPasteAppPath() {
        return this.pasteAppPath;
    }

    @Override
    @NotNull
    public Path getPasteAppJarPath() {
        return this.pasteAppJarPath;
    }

    @Override
    @NotNull
    public Path getPasteAppExePath() {
        return this.pasteAppExePath;
    }

    @Override
    @NotNull
    public Path getPasteUserPath() {
        return this.pasteUserPath;
    }

    private final Path getAppJarPath() {
        String string2 = this.systemProperty.getOption("compose.application.resources.dir");
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return Path.Companion.get$default((Path.Companion)Path.Companion, (String)it, (boolean)false, (int)1, null);
        }
        String string3 = this.systemProperty.getOption("skiko.library.path");
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            return Path.Companion.get$default((Path.Companion)Path.Companion, (String)it, (boolean)false, (int)1, null);
        }
        throw new IllegalStateException("Could not find app path");
    }

    private final Path getAppExePath() {
        return Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)OkioPathExtensionKt.getNoOptionParent((Path)this.getAppJarPath()), (String)"runtime", (boolean)false, (int)2, null), (String)"Contents", (boolean)false, (int)2, null), (String)"Home", (boolean)false, (int)2, null), (String)"lib", (boolean)false, (int)2, null).normalized();
    }

    private final Path getUserPath() {
        Path appSupportPath = Path.resolve$default((Path)Path.resolve$default((Path)Path.resolve$default((Path)this.getUserHome(), (String)"Library", (boolean)false, (int)2, null), (String)"Application Support", (boolean)false, (int)2, null), (String)"CrossPaste", (boolean)false, (int)2, null);
        java.nio.file.Path appSupportNioPath = appSupportPath.toNioPath();
        if (Files.notExists(appSupportNioPath, new LinkOption[0])) {
            Files.createDirectories(appSupportNioPath, new FileAttribute[0]);
        }
        return appSupportPath;
    }

    @NotNull
    public Path resolve(@Nullable String fileName, @NotNull AppFileType appFileType) {
        Intrinsics.checkNotNullParameter((Object)appFileType, (String)"appFileType");
        return this.pathProvider.resolve(fileName, appFileType);
    }

    @NotNull
    public Path resolve(@NotNull Path basePath, @NotNull String path, boolean autoCreate, boolean isFile) {
        return AppPathProvider.super.resolve(basePath, path, autoCreate, isFile);
    }

    public void autoCreateDir(@NotNull Path path) {
        AppPathProvider.super.autoCreateDir(path);
    }

    @NotNull
    public FileUtils getFileUtils() {
        return AppPathProvider.super.getFileUtils();
    }
}

