/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.path;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.config.DevConfig;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.path.DesktopPathProvider;
import com.crosspaste.path.PathProvider;
import com.crosspaste.platform.Platform;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.SystemProperty;
import com.crosspaste.utils.SystemProperty_desktop_ktKt;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ!\u0010\u000f\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\bR\u001a\u0010\u001a\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0018\u001a\u0004\b\u001b\u0010\bR\u001a\u0010\u001c\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0018\u001a\u0004\b\u001d\u0010\bR\u001a\u0010\u001e\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0018\u001a\u0004\b\u001f\u0010\bR\u001a\u0010 \u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b \u0010\u0018\u001a\u0004\b!\u0010\bR\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/crosspaste/path/DevelopmentAppPathProvider;", "Lcom/crosspaste/path/AppPathProvider;", "Lcom/crosspaste/platform/Platform;", "platform", "<init>", "(Lcom/crosspaste/platform/Platform;)V", "Lokio/Path;", "getAppPath", "()Lokio/Path;", "getUserPath", "getResources", "", "fileName", "Lcom/crosspaste/app/AppFileType;", "appFileType", "resolve", "(Ljava/lang/String;Lcom/crosspaste/app/AppFileType;)Lokio/Path;", "Lcom/crosspaste/platform/Platform;", "Lcom/crosspaste/utils/SystemProperty;", "systemProperty", "Lcom/crosspaste/utils/SystemProperty;", "composeAppDir", "Ljava/lang/String;", "userHome", "Lokio/Path;", "getUserHome", "pasteAppPath", "getPasteAppPath", "pasteAppJarPath", "getPasteAppJarPath", "pasteAppExePath", "getPasteAppExePath", "pasteUserPath", "getPasteUserPath", "Lcom/crosspaste/path/PathProvider;", "pathProvider", "Lcom/crosspaste/path/PathProvider;", "app"})
@StabilityInferred(parameters=0)
public final class DevelopmentAppPathProvider
implements AppPathProvider {
    @NotNull
    private final Platform platform;
    @NotNull
    private final SystemProperty systemProperty;
    @NotNull
    private final String composeAppDir;
    @NotNull
    private final Path userHome;
    @NotNull
    private final Path pasteAppPath;
    @NotNull
    private final Path pasteAppJarPath;
    @NotNull
    private final Path pasteAppExePath;
    @NotNull
    private final Path pasteUserPath;
    @NotNull
    private final PathProvider pathProvider;
    public static final int $stable = 8;

    public DevelopmentAppPathProvider(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
        this.systemProperty = SystemProperty_desktop_ktKt.getSystemProperty();
        this.composeAppDir = this.systemProperty.get("user.dir");
        java.nio.file.Path path = Paths.get(this.systemProperty.get("user.home"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.userHome = Path.Companion.get$default((Path.Companion)Path.Companion, (java.nio.file.Path)path, (boolean)false, (int)1, null);
        this.pasteAppPath = this.getAppPath();
        this.pasteAppJarPath = this.getResources();
        this.pasteAppExePath = this.getResources();
        this.pasteUserPath = this.getUserPath();
        this.pathProvider = new DesktopPathProvider(this.getPasteAppPath(), this.getPasteUserPath());
    }

    @Override
    @NotNull
    public Path getUserHome() {
        return this.userHome;
    }

    @Override
    @NotNull
    public Path getPasteAppPath() {
        return this.pasteAppPath;
    }

    @Override
    @NotNull
    public Path getPasteAppJarPath() {
        return this.pasteAppJarPath;
    }

    @Override
    @NotNull
    public Path getPasteAppExePath() {
        return this.pasteAppExePath;
    }

    @Override
    @NotNull
    public Path getPasteUserPath() {
        return this.pasteUserPath;
    }

    private final Path getAppPath() {
        String string2;
        block4: {
            block3: {
                string2 = DevConfig.INSTANCE.getPasteAppPath();
                if (string2 == null) break block3;
                String it = string2;
                boolean bl = false;
                Path path = Path.Companion.get(it, true);
                Path path2 = path.isAbsolute() ? path : Path.resolve$default((Path)Path.Companion.get$default((Path.Companion)Path.Companion, (String)this.composeAppDir, (boolean)false, (int)1, null), (String)it, (boolean)false, (int)2, null);
                string2 = path2;
                if (path2 != null) break block4;
            }
            string2 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)this.composeAppDir, (boolean)false, (int)1, null);
        }
        return string2;
    }

    private final Path getUserPath() {
        String string2;
        block4: {
            block3: {
                string2 = DevConfig.INSTANCE.getPasteUserPath();
                if (string2 == null) break block3;
                String it = string2;
                boolean bl = false;
                Path path = Path.Companion.get(it, true);
                Path path2 = path.isAbsolute() ? path : Path.resolve$default((Path)Path.Companion.get$default((Path.Companion)Path.Companion, (String)this.composeAppDir, (boolean)false, (int)1, null), (String)it, (boolean)false, (int)2, null);
                string2 = path2;
                if (path2 != null) break block4;
            }
            string2 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)this.composeAppDir, (boolean)false, (int)1, null);
        }
        return string2;
    }

    private final Path getResources() {
        String string2;
        Path resources = Path.resolve$default((Path)Path.Companion.get$default((Path.Companion)Path.Companion, (String)this.composeAppDir, (boolean)false, (int)1, null), (String)"resources", (boolean)false, (int)2, null);
        if (this.platform.isWindows() && this.platform.is64bit()) {
            string2 = "windows-x64";
        } else if (this.platform.isMacos()) {
            string2 = StringsKt.contains$default((CharSequence)this.platform.getArch(), (CharSequence)"x86_64", (boolean)false, (int)2, null) ? "macos-x64" : "macos-arm64";
        } else if (this.platform.isLinux() && this.platform.is64bit()) {
            string2 = "linux-x64";
        } else {
            throw new IllegalStateException("Unknown platform: " + this.platform.getName());
        }
        String platformAndArch = string2;
        return Path.resolve$default((Path)resources, (String)platformAndArch, (boolean)false, (int)2, null);
    }

    @NotNull
    public Path resolve(@Nullable String fileName, @NotNull AppFileType appFileType) {
        Intrinsics.checkNotNullParameter((Object)appFileType, (String)"appFileType");
        return this.pathProvider.resolve(fileName, appFileType);
    }

    @NotNull
    public Path resolve(@NotNull Path basePath, @NotNull String path, boolean autoCreate, boolean isFile) {
        return AppPathProvider.super.resolve(basePath, path, autoCreate, isFile);
    }

    public void autoCreateDir(@NotNull Path path) {
        AppPathProvider.super.autoCreateDir(path);
    }

    @NotNull
    public FileUtils getFileUtils() {
        return AppPathProvider.super.getFileUtils();
    }
}

