/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.path;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.config.AppConfig;
import com.crosspaste.config.ConfigManager;
import com.crosspaste.db.DriverFactory;
import com.crosspaste.i18n.GlobalCopywriter;
import com.crosspaste.notification.MessageType;
import com.crosspaste.notification.NotificationManager;
import com.crosspaste.path.PathProvider;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import com.crosspaste.utils.OkioPathExtensionKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0017R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0018R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/crosspaste/path/DesktopMigration;", "", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/config/AppConfig;", "Lcom/crosspaste/config/CommonConfigManager;", "configManager", "Lcom/crosspaste/db/DriverFactory;", "driverFactory", "Lcom/crosspaste/notification/NotificationManager;", "notificationManager", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/config/ConfigManager;Lcom/crosspaste/db/DriverFactory;Lcom/crosspaste/notification/NotificationManager;Lcom/crosspaste/path/UserDataPathProvider;)V", "Lokio/Path;", "migrationPath", "", "migration", "(Lokio/Path;)V", "", "checkMigrationPath", "(Lokio/Path;)Ljava/lang/String;", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/db/DriverFactory;", "Lcom/crosspaste/notification/NotificationManager;", "Lcom/crosspaste/path/UserDataPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "", "Lcom/crosspaste/app/AppFileType;", "types", "Ljava/util/List;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesktopMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopMigration.kt\ncom/crosspaste/path/DesktopMigration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,151:1\n1869#2,2:152\n84#3:154\n191#3:155\n95#3:156\n96#3:161\n58#4,4:157\n66#4,10:162\n62#4,18:172\n*S KotlinDebug\n*F\n+ 1 DesktopMigration.kt\ncom/crosspaste/path/DesktopMigration\n*L\n91#1:152,2\n140#1:154\n140#1:155\n140#1:156\n140#1:161\n140#1:157,4\n140#1:162,10\n140#1:172,18\n*E\n"})
public final class DesktopMigration {
    @NotNull
    private final ConfigManager<AppConfig> configManager;
    @NotNull
    private final DriverFactory driverFactory;
    @NotNull
    private final NotificationManager notificationManager;
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final List<AppFileType> types;
    public static final int $stable = 8;

    public DesktopMigration(@NotNull ConfigManager<AppConfig> configManager, @NotNull DriverFactory driverFactory, @NotNull NotificationManager notificationManager, @NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter(configManager, (String)"configManager");
        Intrinsics.checkNotNullParameter((Object)driverFactory, (String)"driverFactory");
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.configManager = configManager;
        this.driverFactory = driverFactory;
        this.notificationManager = notificationManager;
        this.userDataPathProvider = userDataPathProvider;
        this.logger = KotlinLogging.INSTANCE.logger(DesktopMigration::logger$lambda$0);
        this.fileUtils = FileUtils_desktopKt.getFileUtils();
        Object[] objectArray = new AppFileType[]{AppFileType.FILE, AppFileType.IMAGE, AppFileType.HTML, AppFileType.RTF, AppFileType.ICON, AppFileType.FAVICON, AppFileType.FILE_EXT_ICON, AppFileType.VIDEO, AppFileType.TEMP, AppFileType.MARKETING};
        this.types = CollectionsKt.listOf((Object[])objectArray);
    }

    public final void migration(@NotNull Path migrationPath) {
        Intrinsics.checkNotNullParameter((Object)migrationPath, (String)"migrationPath");
        String string2 = this.checkMigrationPath(migrationPath);
        if (string2 != null) {
            String errorMessage = string2;
            boolean bl = false;
            NotificationManager.sendNotification$default(this.notificationManager, arg_0 -> DesktopMigration.migration$lambda$2$lambda$1(errorMessage, arg_0), null, MessageType.Error, null, 2, null);
        } else {
            Object object;
            Object[] objectArray;
            DesktopMigration $this$migration_u24lambda_u2419 = this;
            boolean bl = false;
            Object object2 = $this$migration_u24lambda_u2419;
            try {
                Object $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411;
                DesktopMigration $this$migration_u24lambda_u2419_u24lambda_u2414 = object2;
                boolean bl2 = false;
                $this$migration_u24lambda_u2419_u24lambda_u2414.logger.info(DesktopMigration::migration$lambda$19$lambda$14$lambda$3);
                Path originDataPath = Path.resolve$default((Path)PathProvider.resolve$default((PathProvider)((PathProvider)$this$migration_u24lambda_u2419_u24lambda_u2414.userDataPathProvider), null, (AppFileType)AppFileType.DATA, (int)1, null), (String)$this$migration_u24lambda_u2419_u24lambda_u2414.driverFactory.getDbName(), (boolean)false, (int)2, null);
                Path migrationDataPath = Path.resolve$default((Path)$this$migration_u24lambda_u2419_u24lambda_u2414.userDataPathProvider.resolve(null, AppFileType.DATA, () -> DesktopMigration.migration$lambda$19$lambda$14$lambda$4(migrationPath)), (String)$this$migration_u24lambda_u2419_u24lambda_u2414.driverFactory.getDbName(), (boolean)false, (int)2, null);
                $this$migration_u24lambda_u2419_u24lambda_u2414.fileUtils.copyPath-gIAlu-s(originDataPath, migrationDataPath);
                $this$migration_u24lambda_u2419_u24lambda_u2414.logger.info(() -> DesktopMigration.migration$lambda$19$lambda$14$lambda$5(migrationPath));
                for (AppFileType type : $this$migration_u24lambda_u2419_u24lambda_u2414.types) {
                    $this$migration_u24lambda_u2419_u24lambda_u2414.logger.info(() -> DesktopMigration.migration$lambda$19$lambda$14$lambda$6(type));
                    Path originTypePath = PathProvider.resolve$default((PathProvider)((PathProvider)$this$migration_u24lambda_u2419_u24lambda_u2414.userDataPathProvider), null, (AppFileType)type, (int)1, null);
                    Path migrationTypePath = $this$migration_u24lambda_u2419_u24lambda_u2414.userDataPathProvider.resolve(null, type, () -> DesktopMigration.migration$lambda$19$lambda$14$lambda$7(migrationPath));
                    $this$migration_u24lambda_u2419_u24lambda_u2414.fileUtils.copyPath-gIAlu-s(originTypePath, migrationTypePath);
                    $this$migration_u24lambda_u2419_u24lambda_u2414.logger.info(() -> DesktopMigration.migration$lambda$19$lambda$14$lambda$8(originTypePath, migrationPath));
                }
                objectArray = $this$migration_u24lambda_u2419_u24lambda_u2414;
                try {
                    $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411 = objectArray;
                    boolean bl3 = false;
                    $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411.fileUtils.deleteFile-IoAF18A(originDataPath);
                    $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411.logger.info(DesktopMigration::migration$lambda$19$lambda$14$lambda$11$lambda$9);
                    for (AppFileType type : $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411.types) {
                        Path originTypePath = PathProvider.resolve$default((PathProvider)((PathProvider)$this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411.userDataPathProvider), null, (AppFileType)type, (int)1, null);
                        $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411.fileUtils.getFileSystem().deleteRecursively(originTypePath);
                        $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411.logger.info(() -> DesktopMigration.migration$lambda$19$lambda$14$lambda$11$lambda$10(originTypePath));
                    }
                    $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl3) {
                    $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                }
                objectArray = $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411;
                Throwable throwable = Result.exceptionOrNull-impl((Object)objectArray);
                if (throwable != null) {
                    Object[] e = $this$migration_u24lambda_u2419_u24lambda_u2414_u24lambda_u2411 = throwable;
                    boolean bl4 = false;
                    $this$migration_u24lambda_u2419_u24lambda_u2414.logger.error((Throwable)e, DesktopMigration::migration$lambda$19$lambda$14$lambda$13$lambda$12);
                }
                objectArray = new String[]{"storagePath", "useDefaultStoragePath"};
                List list = CollectionsKt.listOf((Object[])objectArray);
                objectArray = new Object[]{migrationPath.toString(), false};
                $this$migration_u24lambda_u2419_u24lambda_u2414.configManager.updateConfig(list, CollectionsKt.listOf((Object[])objectArray));
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object e = object = throwable;
                boolean bl5 = false;
                $this$migration_u24lambda_u2419.logger.error((Throwable)e, DesktopMigration::migration$lambda$19$lambda$18$lambda$15);
                DesktopMigration desktopMigration = $this$migration_u24lambda_u2419;
                try {
                    DesktopMigration $this$migration_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417 = desktopMigration;
                    boolean bl6 = false;
                    FileSystem fileSystem = $this$migration_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417.fileUtils.getFileSystem();
                    Iterable $this$forEach$iv = fileSystem.list(migrationPath);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Path subPath = (Path)element$iv;
                        boolean bl7 = false;
                        if (fileSystem.metadata(subPath).isDirectory()) {
                            fileSystem.deleteRecursively(subPath);
                            continue;
                        }
                        fileSystem.delete(subPath);
                    }
                    objectArray = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    objectArray = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                throw e;
            }
            Result.box-impl((Object)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final String checkMigrationPath(@NotNull Path migrationPath) {
        String currentStoragePathString;
        Intrinsics.checkNotNullParameter((Object)migrationPath, (String)"migrationPath");
        FileSystem fileSystem = this.fileUtils.getFileSystem();
        Path currentStoragePath = this.userDataPathProvider.getUserDataPath();
        if (!this.fileUtils.existFile(migrationPath)) {
            return "directory_not_exist";
        }
        if (!OkioPathExtensionKt.getSafeIsDirectory((Path)migrationPath)) {
            return "not_a_directory";
        }
        Object migrationPathString = migrationPath.toString();
        if (!StringsKt.endsWith$default((String)migrationPathString, (String)Path.DIRECTORY_SEPARATOR, (boolean)false, (int)2, null)) {
            migrationPathString = (String)migrationPathString + Path.DIRECTORY_SEPARATOR;
        }
        if (StringsKt.startsWith$default((String)(currentStoragePathString = currentStoragePath.toString()), (String)migrationPathString, (boolean)false, (int)2, null)) {
            return "cant_select_child_directory";
        }
        if (StringsKt.startsWith$default((String)migrationPathString, (String)currentStoragePathString, (boolean)false, (int)2, null)) {
            return "cant_select_parent_directory";
        }
        if (!((Collection)this.fileUtils.listFiles(migrationPath, DesktopMigration::checkMigrationPath$lambda$20)).isEmpty()) {
            return "directory_not_empty";
        }
        boolean bl = false;
        if (bl) {
            return "directory_not_empty";
        }
        Path testFile = migrationPath.resolve("permission_test_" + System.currentTimeMillis() + ".tmp");
        try {
            BufferedSink bufferedSink;
            Throwable thrown$iv$iv;
            block24: {
                void $this$iv;
                Object object = fileSystem;
                Path file$iv = testFile;
                boolean mustCreate$iv = false;
                boolean bl2 = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl22 = false;
                    BufferedSink $this$checkMigrationPath_u24lambda_u2421 = it$iv;
                    boolean bl3 = false;
                    bufferedSink = $this$checkMigrationPath_u24lambda_u2421.writeUtf8("permission_test");
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        bufferedSink = null;
                        break block24;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block25: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block25;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            BufferedSink result$iv$iv = bufferedSink;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            this.fileUtils.deleteFile-IoAF18A(testFile);
            return null;
        }
        catch (Exception exception) {
            return "no_write_permission";
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final String migration$lambda$2$lambda$1(String $errorMessage, GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText($errorMessage, new Object[0]);
    }

    private static final Object migration$lambda$19$lambda$14$lambda$3() {
        return "Migrating Data";
    }

    private static final Path migration$lambda$19$lambda$14$lambda$4(Path $migrationPath) {
        return $migrationPath;
    }

    private static final Object migration$lambda$19$lambda$14$lambda$5(Path $migrationPath) {
        return "Migrated Data to " + $migrationPath;
    }

    private static final Object migration$lambda$19$lambda$14$lambda$6(AppFileType $type) {
        return "Migrating " + $type;
    }

    private static final Path migration$lambda$19$lambda$14$lambda$7(Path $migrationPath) {
        return $migrationPath;
    }

    private static final Object migration$lambda$19$lambda$14$lambda$8(Path $originTypePath, Path $migrationPath) {
        return "Migrated " + $originTypePath + " to " + $migrationPath;
    }

    private static final Object migration$lambda$19$lambda$14$lambda$11$lambda$9() {
        return "Delete Data";
    }

    private static final Object migration$lambda$19$lambda$14$lambda$11$lambda$10(Path $originTypePath) {
        return "Delete " + $originTypePath;
    }

    private static final Object migration$lambda$19$lambda$14$lambda$13$lambda$12() {
        return "Delete originPath fail";
    }

    private static final Object migration$lambda$19$lambda$18$lambda$15() {
        return "Migrated fail";
    }

    private static final boolean checkMigrationPath$lambda$20(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.startsWith$default((String)it.name(), (String)".", (boolean)false, (int)2, null);
    }
}

