/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.path;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.path.AppPathProvider;
import com.crosspaste.path.DevelopmentAppPathProvider;
import com.crosspaste.path.LinuxAppPathProvider;
import com.crosspaste.path.MacosAppPathProvider;
import com.crosspaste.path.WindowsAppPathProvider;
import com.crosspaste.platform.Platform;
import com.crosspaste.utils.AppEnvUtils;
import com.crosspaste.utils.AppEnvUtils_desktopKt;
import com.crosspaste.utils.FileUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u000b\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u001a\u0010\u001b\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u001c\u0010\u0018R\u001a\u0010\u001d\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0016\u001a\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0016\u001a\u0004\b \u0010\u0018\u00a8\u0006!"}, d2={"Lcom/crosspaste/path/DesktopAppPathProvider;", "Lcom/crosspaste/path/AppPathProvider;", "Lcom/crosspaste/platform/Platform;", "platform", "<init>", "(Lcom/crosspaste/platform/Platform;)V", "", "fileName", "Lcom/crosspaste/app/AppFileType;", "appFileType", "Lokio/Path;", "resolve", "(Ljava/lang/String;Lcom/crosspaste/app/AppFileType;)Lokio/Path;", "getAppPathProvider", "()Lcom/crosspaste/path/AppPathProvider;", "Lcom/crosspaste/platform/Platform;", "Lcom/crosspaste/utils/AppEnvUtils;", "appEnvUtils", "Lcom/crosspaste/utils/AppEnvUtils;", "appPathProvider", "Lcom/crosspaste/path/AppPathProvider;", "userHome", "Lokio/Path;", "getUserHome", "()Lokio/Path;", "pasteAppPath", "getPasteAppPath", "pasteAppJarPath", "getPasteAppJarPath", "pasteAppExePath", "getPasteAppExePath", "pasteUserPath", "getPasteUserPath", "app"})
@StabilityInferred(parameters=0)
public final class DesktopAppPathProvider
implements AppPathProvider {
    @NotNull
    private final Platform platform;
    @NotNull
    private final AppEnvUtils appEnvUtils;
    @NotNull
    private final AppPathProvider appPathProvider;
    @NotNull
    private final Path userHome;
    @NotNull
    private final Path pasteAppPath;
    @NotNull
    private final Path pasteAppJarPath;
    @NotNull
    private final Path pasteAppExePath;
    @NotNull
    private final Path pasteUserPath;
    public static final int $stable = 8;

    public DesktopAppPathProvider(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
        this.appEnvUtils = AppEnvUtils_desktopKt.getAppEnvUtils();
        this.appPathProvider = this.getAppPathProvider();
        this.userHome = this.appPathProvider.getUserHome();
        this.pasteAppPath = this.appPathProvider.getPasteAppPath();
        this.pasteAppJarPath = this.appPathProvider.getPasteAppJarPath();
        this.pasteAppExePath = this.appPathProvider.getPasteAppExePath();
        this.pasteUserPath = this.appPathProvider.getPasteUserPath();
    }

    @Override
    @NotNull
    public Path getUserHome() {
        return this.userHome;
    }

    @Override
    @NotNull
    public Path getPasteAppPath() {
        return this.pasteAppPath;
    }

    @Override
    @NotNull
    public Path getPasteAppJarPath() {
        return this.pasteAppJarPath;
    }

    @Override
    @NotNull
    public Path getPasteAppExePath() {
        return this.pasteAppExePath;
    }

    @Override
    @NotNull
    public Path getPasteUserPath() {
        return this.pasteUserPath;
    }

    @NotNull
    public Path resolve(@Nullable String fileName, @NotNull AppFileType appFileType) {
        Intrinsics.checkNotNullParameter((Object)appFileType, (String)"appFileType");
        return this.appPathProvider.resolve(fileName, appFileType);
    }

    private final AppPathProvider getAppPathProvider() {
        AppPathProvider appPathProvider;
        if (this.appEnvUtils.isDevelopment()) {
            appPathProvider = new DevelopmentAppPathProvider(this.platform);
        } else if (this.appEnvUtils.isTest()) {
            appPathProvider = this;
        } else if (this.platform.isWindows()) {
            appPathProvider = new WindowsAppPathProvider();
        } else if (this.platform.isMacos()) {
            appPathProvider = new MacosAppPathProvider();
        } else if (this.platform.isLinux()) {
            appPathProvider = new LinuxAppPathProvider();
        } else {
            throw new IllegalStateException("Unknown platform: " + this.platform.getName());
        }
        return appPathProvider;
    }

    @NotNull
    public Path resolve(@NotNull Path basePath, @NotNull String path, boolean autoCreate, boolean isFile) {
        return AppPathProvider.super.resolve(basePath, path, autoCreate, isFile);
    }

    public void autoCreateDir(@NotNull Path path) {
        AppPathProvider.super.autoCreateDir(path);
    }

    @NotNull
    public FileUtils getFileUtils() {
        return AppPathProvider.super.getFileUtils();
    }
}

