/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste.plugin.type;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.paste.DesktopPasteDataFlavorKt;
import com.crosspaste.paste.PasteCollector;
import com.crosspaste.paste.PasteDataFlavor;
import com.crosspaste.paste.PasteDataFlavors;
import com.crosspaste.paste.PasteTransferable;
import com.crosspaste.paste.PasteType;
import com.crosspaste.paste.item.PasteItem;
import com.crosspaste.paste.item.UrlPasteItem;
import com.crosspaste.paste.plugin.type.PasteTypePlugin;
import com.crosspaste.paste.plugin.type.UrlTypePlugin;
import com.crosspaste.platform.Platform;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016JY\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001b2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\t0\u001d2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010#\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b#\u0010$J3\u0010+\u001a\u00020\u00142\u0006\u0010&\u001a\u00020%2\u0006\u0010(\u001a\u00020'2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00170)H\u0016\u00a2\u0006\u0004\b+\u0010,R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010-\u00a8\u0006/"}, d2={"Lcom/crosspaste/paste/plugin/type/DesktopUrlTypePlugin;", "Lcom/crosspaste/paste/plugin/type/UrlTypePlugin;", "Lcom/crosspaste/platform/Platform;", "platform", "<init>", "(Lcom/crosspaste/platform/Platform;)V", "Lcom/crosspaste/paste/PasteType;", "getPasteType", "()Lcom/crosspaste/paste/PasteType;", "", "", "getIdentifiers", "()Ljava/util/List;", "", "itemIndex", "identifier", "Lcom/crosspaste/paste/PasteTransferable;", "pasteTransferable", "Lcom/crosspaste/paste/PasteCollector;", "pasteCollector", "", "createPrePasteItem", "(ILjava/lang/String;Lcom/crosspaste/paste/PasteTransferable;Lcom/crosspaste/paste/PasteCollector;)V", "", "transferData", "", "pasteId", "Lcom/crosspaste/paste/PasteDataFlavor;", "dataFlavor", "", "dataFlavorMap", "doLoadRepresentation", "(Ljava/lang/Object;JILcom/crosspaste/paste/PasteDataFlavor;Ljava/util/Map;Lcom/crosspaste/paste/PasteTransferable;Lcom/crosspaste/paste/PasteCollector;)V", "", "error", "collectError", "(Ljava/lang/Throwable;JILcom/crosspaste/paste/PasteCollector;)V", "Lcom/crosspaste/paste/item/PasteItem;", "pasteItem", "", "mixedCategory", "", "map", "buildTransferable", "(Lcom/crosspaste/paste/item/PasteItem;ZLjava/util/Map;)V", "Lcom/crosspaste/platform/Platform;", "Companion", "app"})
@StabilityInferred(parameters=1)
public final class DesktopUrlTypePlugin
implements UrlTypePlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    public static final int $stable;
    @NotNull
    public static final String URL = "application/x-java-url";
    @NotNull
    private static final CodecsUtils codecsUtils;

    public DesktopUrlTypePlugin(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
    }

    @Override
    @NotNull
    public PasteType getPasteType() {
        return PasteType.Companion.getURL_TYPE();
    }

    @Override
    @NotNull
    public List<String> getIdentifiers() {
        return CollectionsKt.listOf((Object)URL);
    }

    @Override
    public void createPrePasteItem(int itemIndex, @NotNull String identifier, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)pasteTransferable, (String)"pasteTransferable");
        Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
        UrlPasteItem it = new UrlPasteItem(CollectionsKt.listOf((Object)identifier), "", 0L, "", null, 16, null);
        boolean bl = false;
        pasteCollector.preCollectItem(itemIndex, (KClass<? extends PasteTypePlugin>)Reflection.getOrCreateKotlinClass(this.getClass()), (PasteItem)it);
    }

    @Override
    public void doLoadRepresentation(@NotNull Object transferData, long pasteId, int itemIndex, @NotNull PasteDataFlavor dataFlavor, @NotNull Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        Intrinsics.checkNotNullParameter((Object)transferData, (String)"transferData");
        Intrinsics.checkNotNullParameter((Object)dataFlavor, (String)"dataFlavor");
        Intrinsics.checkNotNullParameter(dataFlavorMap, (String)"dataFlavorMap");
        Intrinsics.checkNotNullParameter((Object)pasteTransferable, (String)"pasteTransferable");
        Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
        if (transferData instanceof String) {
            byte[] urlBytes = StringsKt.encodeToByteArray((String)((String)transferData));
            String hash = codecsUtils.hash(urlBytes);
            Function1 update = arg_0 -> DesktopUrlTypePlugin.doLoadRepresentation$lambda$1(hash, urlBytes, transferData, arg_0);
            pasteCollector.updateCollectItem(itemIndex, (KClass<? extends PasteTypePlugin>)Reflection.getOrCreateKotlinClass(this.getClass()), (Function1<? super PasteItem, ? extends PasteItem>)update);
        }
    }

    @Override
    public void collectError(@NotNull Throwable error, long pasteId, int itemIndex, @NotNull PasteCollector pasteCollector) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
        if (!this.platform.isWindows() || !(error instanceof MalformedURLException)) {
            UrlTypePlugin.super.collectError(error, pasteId, itemIndex, pasteCollector);
        }
    }

    @Override
    public void buildTransferable(@NotNull PasteItem pasteItem, boolean mixedCategory, @NotNull Map<PasteDataFlavor, Object> map2) {
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        UrlPasteItem cfr_ignored_0 = (UrlPasteItem)pasteItem;
        map2.put(DesktopPasteDataFlavorKt.toPasteDataFlavor(PasteDataFlavors.INSTANCE.getURL_FLAVOR()), new URL(((UrlPasteItem)pasteItem).getUrl()));
    }

    @Override
    public void loadRepresentation(long pasteId, int itemIndex, @NotNull PasteDataFlavor dataFlavor, @NotNull Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        UrlTypePlugin.super.loadRepresentation(pasteId, itemIndex, dataFlavor, dataFlavorMap, pasteTransferable, pasteCollector);
    }

    private static final UrlPasteItem doLoadRepresentation$lambda$1(String $hash, byte[] $urlBytes, Object $transferData, PasteItem pasteItem) {
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        return new UrlPasteItem(pasteItem.getIdentifiers(), $hash, (long)$urlBytes.length, (String)$transferData, pasteItem.getExtraInfo());
    }

    static {
        codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/crosspaste/paste/plugin/type/DesktopUrlTypePlugin$Companion;", "", "<init>", "()V", "", "URL", "Ljava/lang/String;", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

