/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste.plugin.type;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.db.paste.PasteDao;
import com.crosspaste.paste.DesktopPasteDataFlavorKt;
import com.crosspaste.paste.PasteCollector;
import com.crosspaste.paste.PasteData;
import com.crosspaste.paste.PasteDataFlavor;
import com.crosspaste.paste.PasteTransferable;
import com.crosspaste.paste.PasteType;
import com.crosspaste.paste.SearchContentService;
import com.crosspaste.paste.item.PasteItem;
import com.crosspaste.paste.item.TextPasteItem;
import com.crosspaste.paste.plugin.type.PasteTypePlugin;
import com.crosspaste.paste.plugin.type.TextTypePlugin;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import java.awt.datatransfer.DataFlavor;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016JY\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001b2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\t0\u001d2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010&\u001a\u00020$2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\n2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J/\u0010,\u001a\u00020$2\u0006\u0010)\u001a\u00020(2\u0006\u0010!\u001a\u00020\n2\u0006\u0010%\u001a\u00020$2\u0006\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b,\u0010-J3\u00102\u001a\u00020\u00142\u0006\u0010%\u001a\u00020$2\u0006\u0010/\u001a\u00020.2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001700H\u0016\u00a2\u0006\u0004\b2\u00103R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00104\u00a8\u00066"}, d2={"Lcom/crosspaste/paste/plugin/type/DesktopTextTypePlugin;", "Lcom/crosspaste/paste/plugin/type/TextTypePlugin;", "Lcom/crosspaste/paste/SearchContentService;", "searchContentService", "<init>", "(Lcom/crosspaste/paste/SearchContentService;)V", "Lcom/crosspaste/paste/PasteType;", "getPasteType", "()Lcom/crosspaste/paste/PasteType;", "", "", "getIdentifiers", "()Ljava/util/List;", "", "itemIndex", "identifier", "Lcom/crosspaste/paste/PasteTransferable;", "pasteTransferable", "Lcom/crosspaste/paste/PasteCollector;", "pasteCollector", "", "createPrePasteItem", "(ILjava/lang/String;Lcom/crosspaste/paste/PasteTransferable;Lcom/crosspaste/paste/PasteCollector;)V", "", "transferData", "", "pasteId", "Lcom/crosspaste/paste/PasteDataFlavor;", "dataFlavor", "", "dataFlavorMap", "doLoadRepresentation", "(Ljava/lang/Object;JILcom/crosspaste/paste/PasteDataFlavor;Ljava/util/Map;Lcom/crosspaste/paste/PasteTransferable;Lcom/crosspaste/paste/PasteCollector;)V", "newText", "size", "hash", "Lcom/crosspaste/paste/item/PasteItem;", "pasteItem", "buildNewPasteItem", "(Ljava/lang/String;JLjava/lang/String;Lcom/crosspaste/paste/item/PasteItem;)Lcom/crosspaste/paste/item/PasteItem;", "Lcom/crosspaste/paste/PasteData;", "pasteData", "Lcom/crosspaste/db/paste/PasteDao;", "pasteDao", "updateText", "(Lcom/crosspaste/paste/PasteData;Ljava/lang/String;Lcom/crosspaste/paste/item/PasteItem;Lcom/crosspaste/db/paste/PasteDao;)Lcom/crosspaste/paste/item/PasteItem;", "", "mixedCategory", "", "map", "buildTransferable", "(Lcom/crosspaste/paste/item/PasteItem;ZLjava/util/Map;)V", "Lcom/crosspaste/paste/SearchContentService;", "Companion", "app"})
@StabilityInferred(parameters=0)
public final class DesktopTextTypePlugin
implements TextTypePlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchContentService searchContentService;
    public static final int $stable = 8;
    @NotNull
    public static final String UNICODE_STRING = "Unicode String";
    @NotNull
    public static final String TEXT = "text/plain";
    @NotNull
    public static final String PLAIN_TEXT = "Plain Text";
    @NotNull
    private static final CodecsUtils codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();

    public DesktopTextTypePlugin(@NotNull SearchContentService searchContentService) {
        Intrinsics.checkNotNullParameter((Object)searchContentService, (String)"searchContentService");
        this.searchContentService = searchContentService;
    }

    @Override
    @NotNull
    public PasteType getPasteType() {
        return PasteType.Companion.getTEXT_TYPE();
    }

    @Override
    @NotNull
    public List<String> getIdentifiers() {
        Object[] objectArray = new String[]{UNICODE_STRING, TEXT, PLAIN_TEXT};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void createPrePasteItem(int itemIndex, @NotNull String identifier, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)pasteTransferable, (String)"pasteTransferable");
        Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
        TextPasteItem it = new TextPasteItem(CollectionsKt.listOf((Object)identifier), "", 0L, "", null, 16, null);
        boolean bl = false;
        pasteCollector.preCollectItem(itemIndex, (KClass<? extends PasteTypePlugin>)Reflection.getOrCreateKotlinClass(this.getClass()), (PasteItem)it);
    }

    @Override
    public void doLoadRepresentation(@NotNull Object transferData, long pasteId, int itemIndex, @NotNull PasteDataFlavor dataFlavor, @NotNull Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        Intrinsics.checkNotNullParameter((Object)transferData, (String)"transferData");
        Intrinsics.checkNotNullParameter((Object)dataFlavor, (String)"dataFlavor");
        Intrinsics.checkNotNullParameter(dataFlavorMap, (String)"dataFlavorMap");
        Intrinsics.checkNotNullParameter((Object)pasteTransferable, (String)"pasteTransferable");
        Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
        if (transferData instanceof String) {
            byte[] textBytes = StringsKt.encodeToByteArray((String)((String)transferData));
            String hash = codecsUtils.hash(textBytes);
            Function1 update = arg_0 -> DesktopTextTypePlugin.doLoadRepresentation$lambda$1(this, transferData, textBytes, hash, arg_0);
            pasteCollector.updateCollectItem(itemIndex, (KClass<? extends PasteTypePlugin>)Reflection.getOrCreateKotlinClass(this.getClass()), (Function1<? super PasteItem, ? extends PasteItem>)update);
        }
    }

    private final PasteItem buildNewPasteItem(String newText, long size, String hash, PasteItem pasteItem) {
        return (PasteItem)new TextPasteItem(pasteItem.getIdentifiers(), hash, size, newText, pasteItem.getExtraInfo());
    }

    @Override
    @NotNull
    public PasteItem updateText(@NotNull PasteData pasteData, @NotNull String newText, @NotNull PasteItem pasteItem, @NotNull PasteDao pasteDao) {
        Intrinsics.checkNotNullParameter((Object)pasteData, (String)"pasteData");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        Intrinsics.checkNotNullParameter((Object)pasteDao, (String)"pasteDao");
        byte[] textBytes = StringsKt.encodeToByteArray((String)newText);
        String hash = codecsUtils.hash(textBytes);
        PasteItem newPasteItem = this.buildNewPasteItem(newText, textBytes.length, hash, pasteItem);
        pasteDao.updatePasteAppearItem(pasteData.getId(), newPasteItem, this.searchContentService.createSearchContent(pasteData.getSource(), newPasteItem.getSearchContent()), newPasteItem.getSize() - pasteItem.getSize());
        return newPasteItem;
    }

    @Override
    public void buildTransferable(@NotNull PasteItem pasteItem, boolean mixedCategory, @NotNull Map<PasteDataFlavor, Object> map2) {
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        TextPasteItem cfr_ignored_0 = (TextPasteItem)pasteItem;
        Map<PasteDataFlavor, Object> map3 = map2;
        DataFlavor dataFlavor = DataFlavor.stringFlavor;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"stringFlavor");
        PasteDataFlavor pasteDataFlavor = DesktopPasteDataFlavorKt.toPasteDataFlavor(dataFlavor);
        String string2 = ((TextPasteItem)pasteItem).getText();
        map3.put(pasteDataFlavor, string2);
    }

    @Override
    public void loadRepresentation(long pasteId, int itemIndex, @NotNull PasteDataFlavor dataFlavor, @NotNull Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        TextTypePlugin.super.loadRepresentation(pasteId, itemIndex, dataFlavor, dataFlavorMap, pasteTransferable, pasteCollector);
    }

    @Override
    public void collectError(@NotNull Throwable error, long pasteId, int itemIndex, @NotNull PasteCollector pasteCollector) {
        TextTypePlugin.super.collectError(error, pasteId, itemIndex, pasteCollector);
    }

    private static final PasteItem doLoadRepresentation$lambda$1(DesktopTextTypePlugin this$0, Object $transferData, byte[] $textBytes, String $hash, PasteItem pasteItem) {
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        return this$0.buildNewPasteItem((String)$transferData, $textBytes.length, $hash, pasteItem);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/crosspaste/paste/plugin/type/DesktopTextTypePlugin$Companion;", "", "<init>", "()V", "", "UNICODE_STRING", "Ljava/lang/String;", "TEXT", "PLAIN_TEXT", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

