/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste.plugin.type;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import com.crosspaste.paste.DesktopPasteDataFlavorKt;
import com.crosspaste.paste.PasteCollector;
import com.crosspaste.paste.PasteDataFlavor;
import com.crosspaste.paste.PasteTransferable;
import com.crosspaste.paste.PasteType;
import com.crosspaste.paste.item.PasteItem;
import com.crosspaste.paste.item.RtfPasteItem;
import com.crosspaste.paste.plugin.type.PasteTypePlugin;
import com.crosspaste.paste.plugin.type.RtfTypePlugin;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import com.crosspaste.utils.HtmlColorUtils;
import com.crosspaste.utils.RtfUtils;
import com.crosspaste.utils.RtfUtils_desktopKt;
import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ/\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014JY\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00192\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00070\u001b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ3\u0010%\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020!2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150#H\u0016\u00a2\u0006\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lcom/crosspaste/paste/plugin/type/DesktopRtfTypePlugin;", "Lcom/crosspaste/paste/plugin/type/RtfTypePlugin;", "<init>", "()V", "Lcom/crosspaste/paste/PasteType;", "getPasteType", "()Lcom/crosspaste/paste/PasteType;", "", "", "getIdentifiers", "()Ljava/util/List;", "", "itemIndex", "identifier", "Lcom/crosspaste/paste/PasteTransferable;", "pasteTransferable", "Lcom/crosspaste/paste/PasteCollector;", "pasteCollector", "", "createPrePasteItem", "(ILjava/lang/String;Lcom/crosspaste/paste/PasteTransferable;Lcom/crosspaste/paste/PasteCollector;)V", "", "transferData", "", "pasteId", "Lcom/crosspaste/paste/PasteDataFlavor;", "dataFlavor", "", "dataFlavorMap", "doLoadRepresentation", "(Ljava/lang/Object;JILcom/crosspaste/paste/PasteDataFlavor;Ljava/util/Map;Lcom/crosspaste/paste/PasteTransferable;Lcom/crosspaste/paste/PasteCollector;)V", "Lcom/crosspaste/paste/item/PasteItem;", "pasteItem", "", "mixedCategory", "", "map", "buildTransferable", "(Lcom/crosspaste/paste/item/PasteItem;ZLjava/util/Map;)V", "Companion", "app"})
@StabilityInferred(parameters=1)
public final class DesktopRtfTypePlugin
implements RtfTypePlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    public static final String RTF_ID = "text/rtf";
    @NotNull
    private static final DataFlavor RTF_DATA_FLAVOR;
    @NotNull
    private static final CodecsUtils codecsUtils;
    @NotNull
    private static final RtfUtils rtfUtils;

    @Override
    @NotNull
    public PasteType getPasteType() {
        return PasteType.Companion.getRTF_TYPE();
    }

    @Override
    @NotNull
    public List<String> getIdentifiers() {
        return CollectionsKt.listOf((Object)RTF_ID);
    }

    @Override
    public void createPrePasteItem(int itemIndex, @NotNull String identifier, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)pasteTransferable, (String)"pasteTransferable");
        Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
        List list = CollectionsKt.listOf((Object)identifier);
        RtfPasteItem it = new RtfPasteItem(list, "", "", 0L, null, null, 48, null);
        boolean bl = false;
        pasteCollector.preCollectItem(itemIndex, (KClass<? extends PasteTypePlugin>)Reflection.getOrCreateKotlinClass(this.getClass()), (PasteItem)it);
    }

    @Override
    public void doLoadRepresentation(@NotNull Object transferData, long pasteId, int itemIndex, @NotNull PasteDataFlavor dataFlavor, @NotNull Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        Intrinsics.checkNotNullParameter((Object)transferData, (String)"transferData");
        Intrinsics.checkNotNullParameter((Object)dataFlavor, (String)"dataFlavor");
        Intrinsics.checkNotNullParameter(dataFlavorMap, (String)"dataFlavorMap");
        Intrinsics.checkNotNullParameter((Object)pasteTransferable, (String)"pasteTransferable");
        Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
        if (transferData instanceof InputStream) {
            byte[] rtfBytes = ByteStreamsKt.readBytes((InputStream)((InputStream)transferData));
            String hash = codecsUtils.hash(rtfBytes);
            long size = rtfBytes.length;
            String rtf = new String(rtfBytes, Charsets.UTF_8);
            String string2 = rtfUtils.rtfToHtml(rtf);
            if (string2 == null) {
                return;
            }
            String html = string2;
            Color color = HtmlColorUtils.INSTANCE.getBackgroundColor-ijrfgN4(html);
            long background = color != null ? color.unbox-impl() : Color.Companion.getTransparent-0d7_KjU();
            Function1 update = arg_0 -> DesktopRtfTypePlugin.doLoadRepresentation$lambda$2(hash, rtf, size, background, arg_0);
            pasteCollector.updateCollectItem(itemIndex, (KClass<? extends PasteTypePlugin>)Reflection.getOrCreateKotlinClass(this.getClass()), (Function1<? super PasteItem, ? extends PasteItem>)update);
        }
    }

    @Override
    public void buildTransferable(@NotNull PasteItem pasteItem, boolean mixedCategory, @NotNull Map<PasteDataFlavor, Object> map2) {
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        RtfPasteItem cfr_ignored_0 = (RtfPasteItem)pasteItem;
        String currentRtf = ((RtfPasteItem)pasteItem).getRtf();
        Map<PasteDataFlavor, Object> map3 = map2;
        PasteDataFlavor pasteDataFlavor = DesktopPasteDataFlavorKt.toPasteDataFlavor(RTF_DATA_FLAVOR);
        Object object = currentRtf;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        object = new ByteArrayInputStream(byArray);
        map3.put(pasteDataFlavor, object);
    }

    @Override
    public void loadRepresentation(long pasteId, int itemIndex, @NotNull PasteDataFlavor dataFlavor, @NotNull Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        RtfTypePlugin.super.loadRepresentation(pasteId, itemIndex, dataFlavor, dataFlavorMap, pasteTransferable, pasteCollector);
    }

    @Override
    public void collectError(@NotNull Throwable error, long pasteId, int itemIndex, @NotNull PasteCollector pasteCollector) {
        RtfTypePlugin.super.collectError(error, pasteId, itemIndex, pasteCollector);
    }

    private static final Unit doLoadRepresentation$lambda$2$lambda$1(long $background, JsonObjectBuilder $this$updateExtraInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$updateExtraInfo, (String)"$this$updateExtraInfo");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$updateExtraInfo, (String)"background", (Number)ColorKt.toArgb-8_81llA((long)$background));
        return Unit.INSTANCE;
    }

    private static final RtfPasteItem doLoadRepresentation$lambda$2(String $hash, String $rtf, long $size, long $background, PasteItem pasteItem) {
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        List list = pasteItem.getIdentifiers();
        JsonObject jsonObject = PasteItem.Companion.updateExtraInfo(pasteItem.getExtraInfo(), arg_0 -> DesktopRtfTypePlugin.doLoadRepresentation$lambda$2$lambda$1($background, arg_0));
        return new RtfPasteItem(list, $hash, $rtf, $size, jsonObject, null, 32, null);
    }

    static {
        RTF_DATA_FLAVOR = new DataFlavor("text/rtf;  class=java.io.InputStream", "Rich Text Format");
        codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
        rtfUtils = RtfUtils_desktopKt.getRtfUtils();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/crosspaste/paste/plugin/type/DesktopRtfTypePlugin$Companion;", "", "<init>", "()V", "", "RTF_ID", "Ljava/lang/String;", "Ljava/awt/datatransfer/DataFlavor;", "RTF_DATA_FLAVOR", "Ljava/awt/datatransfer/DataFlavor;", "getRTF_DATA_FLAVOR", "()Ljava/awt/datatransfer/DataFlavor;", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "Lcom/crosspaste/utils/RtfUtils;", "rtfUtils", "Lcom/crosspaste/utils/RtfUtils;", "app"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataFlavor getRTF_DATA_FLAVOR() {
            return RTF_DATA_FLAVOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

