/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste.plugin.type;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.app.AppInfo;
import com.crosspaste.image.ImageHandler;
import com.crosspaste.paste.DesktopPasteDataFlavor;
import com.crosspaste.paste.DesktopPasteDataFlavorKt;
import com.crosspaste.paste.PasteCollector;
import com.crosspaste.paste.PasteDataFlavor;
import com.crosspaste.paste.PasteDataFlavors;
import com.crosspaste.paste.PasteTransferable;
import com.crosspaste.paste.PasteType;
import com.crosspaste.paste.item.ImagesPasteItem;
import com.crosspaste.paste.item.PasteCoordinate;
import com.crosspaste.paste.item.PasteItem;
import com.crosspaste.paste.plugin.type.ImageTypePlugin;
import com.crosspaste.paste.plugin.type.PasteTypePlugin;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.platform.Platform;
import com.crosspaste.presist.FileInfoTree;
import com.crosspaste.utils.FileNameNormalizer;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import com.fleeksoft.ksoup.Ksoup;
import com.fleeksoft.ksoup.nodes.Document;
import com.fleeksoft.ksoup.nodes.Element;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSource;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 E2\u00020\u0001:\u0001EB-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJY\u0010&\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\"2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00100$2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b&\u0010'J3\u0010(\u001a\u0004\u0018\u00010\u00112\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00100$2\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0019\u0010+\u001a\u0004\u0018\u00010\u00112\u0006\u0010*\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0019\u0010.\u001a\u0004\u0018\u00010\u00112\u0006\u0010-\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b.\u0010,J\u0017\u00101\u001a\u00020\u00052\u0006\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0004\b1\u00102J3\u00109\u001a\u00020\u001b2\u0006\u00104\u001a\u0002032\u0006\u00106\u001a\u0002052\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001e07H\u0016\u00a2\u0006\u0004\b9\u0010:R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010;R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010<R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010=R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010>R\u0014\u0010@\u001a\u00020?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0014\u0010C\u001a\u00020B8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010D\u00a8\u0006F"}, d2={"Lcom/crosspaste/paste/plugin/type/DesktopImageTypePlugin;", "Lcom/crosspaste/paste/plugin/type/ImageTypePlugin;", "Lcom/crosspaste/app/AppInfo;", "appInfo", "Lcom/crosspaste/image/ImageHandler;", "Ljava/awt/image/BufferedImage;", "imageHandler", "Lcom/crosspaste/platform/Platform;", "platform", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/app/AppInfo;Lcom/crosspaste/image/ImageHandler;Lcom/crosspaste/platform/Platform;Lcom/crosspaste/path/UserDataPathProvider;)V", "Lcom/crosspaste/paste/PasteType;", "getPasteType", "()Lcom/crosspaste/paste/PasteType;", "", "", "getIdentifiers", "()Ljava/util/List;", "", "itemIndex", "identifier", "Lcom/crosspaste/paste/PasteTransferable;", "pasteTransferable", "Lcom/crosspaste/paste/PasteCollector;", "pasteCollector", "", "createPrePasteItem", "(ILjava/lang/String;Lcom/crosspaste/paste/PasteTransferable;Lcom/crosspaste/paste/PasteCollector;)V", "", "transferData", "", "pasteId", "Lcom/crosspaste/paste/PasteDataFlavor;", "dataFlavor", "", "dataFlavorMap", "doLoadRepresentation", "(Ljava/lang/Object;JILcom/crosspaste/paste/PasteDataFlavor;Ljava/util/Map;Lcom/crosspaste/paste/PasteTransferable;Lcom/crosspaste/paste/PasteCollector;)V", "tryGetImageName", "(Ljava/util/Map;Lcom/crosspaste/paste/PasteTransferable;)Ljava/lang/String;", "imageHtml", "getImageNameFromHtml", "(Ljava/lang/String;)Ljava/lang/String;", "urlString", "getLastPathSegment", "Ljava/awt/Image;", "img", "toBufferedImage", "(Ljava/awt/Image;)Ljava/awt/image/BufferedImage;", "Lcom/crosspaste/paste/item/PasteItem;", "pasteItem", "", "mixedCategory", "", "map", "buildTransferable", "(Lcom/crosspaste/paste/item/PasteItem;ZLjava/util/Map;)V", "Lcom/crosspaste/app/AppInfo;", "Lcom/crosspaste/image/ImageHandler;", "Lcom/crosspaste/platform/Platform;", "Lcom/crosspaste/path/UserDataPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "Companion", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesktopImageTypePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopImageTypePlugin.kt\ncom/crosspaste/paste/plugin/type/DesktopImageTypePlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1563#2:265\n1634#2,3:266\n1#3:269\n*S KotlinDebug\n*F\n+ 1 DesktopImageTypePlugin.kt\ncom/crosspaste/paste/plugin/type/DesktopImageTypePlugin\n*L\n223#1:265\n223#1:266,3\n*E\n"})
public final class DesktopImageTypePlugin
implements ImageTypePlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppInfo appInfo;
    @NotNull
    private final ImageHandler<BufferedImage> imageHandler;
    @NotNull
    private final Platform platform;
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final FileUtils fileUtils;
    public static final int $stable = 8;
    @NotNull
    public static final String X_JAVA_IMAGE = "image/x-java-image";
    @NotNull
    public static final String IMAGE_PNG = "image/png";
    @NotNull
    public static final String IMAGE_JPEG = "image/jpeg";
    @NotNull
    public static final String IMAGE = "image";

    public DesktopImageTypePlugin(@NotNull AppInfo appInfo, @NotNull ImageHandler<BufferedImage> imageHandler, @NotNull Platform platform, @NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        Intrinsics.checkNotNullParameter(imageHandler, (String)"imageHandler");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.appInfo = appInfo;
        this.imageHandler = imageHandler;
        this.platform = platform;
        this.userDataPathProvider = userDataPathProvider;
        this.logger = KotlinLogging.INSTANCE.logger(DesktopImageTypePlugin::logger$lambda$0);
        this.fileUtils = FileUtils_desktopKt.getFileUtils();
    }

    @Override
    @NotNull
    public PasteType getPasteType() {
        return PasteType.Companion.getIMAGE_TYPE();
    }

    @Override
    @NotNull
    public List<String> getIdentifiers() {
        Object[] objectArray = new String[]{X_JAVA_IMAGE, IMAGE_PNG, IMAGE_JPEG, IMAGE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void createPrePasteItem(int itemIndex, @NotNull String identifier, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)pasteTransferable, (String)"pasteTransferable");
        Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
        ImagesPasteItem it = new ImagesPasteItem(CollectionsKt.listOf((Object)identifier), 0L, "", 0L, null, MapsKt.emptyMap(), CollectionsKt.emptyList(), null, 144, null);
        boolean bl = false;
        pasteCollector.preCollectItem(itemIndex, (KClass<? extends PasteTypePlugin>)Reflection.getOrCreateKotlinClass(this.getClass()), (PasteItem)it);
    }

    @Override
    public void doLoadRepresentation(@NotNull Object transferData, long pasteId, int itemIndex, @NotNull PasteDataFlavor dataFlavor, @NotNull Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        block7: {
            String relativePath;
            Path imagePath;
            String ext;
            Intrinsics.checkNotNullParameter((Object)transferData, (String)"transferData");
            Intrinsics.checkNotNullParameter((Object)dataFlavor, (String)"dataFlavor");
            Intrinsics.checkNotNullParameter(dataFlavorMap, (String)"dataFlavorMap");
            Intrinsics.checkNotNullParameter((Object)pasteTransferable, (String)"pasteTransferable");
            Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
            if (dataFlavorMap.keySet().contains("application/x-java-file-list")) {
                return;
            }
            BufferedImage image = null;
            if (transferData instanceof Image) {
                image = this.toBufferedImage((Image)transferData);
            } else if (transferData instanceof InputStream) {
                image = this.imageHandler.readImage(CoreKt.buffered((RawSource)JvmCoreKt.asSource((InputStream)((InputStream)transferData))));
            }
            BufferedImage bufferedImage = image;
            if (bufferedImage == null) break block7;
            BufferedImage it = bufferedImage;
            boolean bl = false;
            Ref.ObjectRef name = new Ref.ObjectRef();
            String string2 = this.tryGetImageName(dataFlavorMap, pasteTransferable);
            if (string2 == null) {
                string2 = this.fileUtils.createRandomFileName("png");
            }
            name.element = FileNameNormalizer.normalize$default(FileNameNormalizer.INSTANCE, string2, '\u0000', false, 6, null);
            String string3 = this.fileUtils.getImageExtFromFileName((String)name.element);
            if (string3 == null) {
                DesktopImageTypePlugin $this$doLoadRepresentation_u24lambda_u244_u24lambda_u242 = this;
                boolean bl2 = false;
                name.element = name.element + ".png";
                string3 = "png";
            }
            if (this.imageHandler.writeImage(image, ext = string3, imagePath = this.fileUtils.createPastePath(relativePath = this.fileUtils.createPasteRelativePath(new PasteCoordinate(pasteId, this.appInfo.getAppInstanceId(), 0L, 4, null), (String)name.element), true, AppFileType.IMAGE, this.userDataPathProvider))) {
                FileInfoTree fileTree = this.fileUtils.getFileInfoTree(imagePath);
                long count = fileTree.getCount();
                long size = fileTree.getSize();
                String hash = fileTree.getHash();
                Function1 update = arg_0 -> DesktopImageTypePlugin.doLoadRepresentation$lambda$4$lambda$3(count, hash, size, name, fileTree, relativePath, arg_0);
                pasteCollector.updateCollectItem(itemIndex, (KClass<? extends PasteTypePlugin>)Reflection.getOrCreateKotlinClass(this.getClass()), (Function1<? super PasteItem, ? extends PasteItem>)update);
            }
        }
    }

    private final String tryGetImageName(Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, PasteTransferable pasteTransferable) {
        block1: {
            List<? extends PasteDataFlavor> list = dataFlavorMap.get("text/html");
            if (list == null) break block1;
            List<? extends PasteDataFlavor> it = list;
            boolean bl = false;
            for (PasteDataFlavor pasteDataFlavor : it) {
                Intrinsics.checkNotNull((Object)pasteDataFlavor, (String)"null cannot be cast to non-null type com.crosspaste.paste.DesktopPasteDataFlavor");
                DataFlavor dataFlavor = ((DesktopPasteDataFlavor)pasteDataFlavor).getDataFlavor();
                if (!Intrinsics.areEqual(dataFlavor.getRepresentationClass(), String.class)) continue;
                Object object = pasteTransferable.getTransferData(pasteDataFlavor);
                String string2 = object instanceof String ? (String)object : null;
                if (string2 == null) continue;
                String imageHtml = string2;
                boolean bl2 = false;
                return this.getImageNameFromHtml(imageHtml);
            }
        }
        return null;
    }

    private final String getImageNameFromHtml(String imageHtml) {
        Document doc = Ksoup.parse$default((Ksoup)Ksoup.INSTANCE, (String)imageHtml, null, (int)2, null);
        Element element = doc.select("img").first();
        if (element == null) {
            return null;
        }
        Element imgElement = element;
        String src = imgElement.attr("src");
        return this.getLastPathSegment(src);
    }

    private final String getLastPathSegment(String urlString) {
        Object object;
        Object object2 = this;
        try {
            String path;
            String normalizedPath;
            DesktopImageTypePlugin $this$getLastPathSegment_u24lambda_u247 = object2;
            boolean bl = false;
            URI uri = new URI(urlString);
            String string2 = uri.getPath();
            object = Result.constructor-impl(string2 == null ? null : (((CharSequence)(normalizedPath = StringsKt.removeSuffix((String)(path = string2), (CharSequence)"/"))).length() == 0 || Intrinsics.areEqual((Object)normalizedPath, (Object)"/") ? null : StringsKt.substringAfterLast$default((String)normalizedPath, (char)'/', null, (int)2, null)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (String)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private final BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bufferedImage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void buildTransferable(@NotNull PasteItem pasteItem, boolean mixedCategory, @NotNull Map<PasteDataFlavor, Object> map2) {
        String $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        ImagesPasteItem cfr_ignored_0 = (ImagesPasteItem)pasteItem;
        List filePaths = ((ImagesPasteItem)pasteItem).getFilePaths(this.userDataPathProvider);
        Object $this$map$iv = filePaths;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toFile());
        }
        List fileList = (List)destination$iv$iv;
        $this$map$iv = map2;
        DataFlavor dataFlavor = DataFlavor.javaFileListFlavor;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"javaFileListFlavor");
        $this$map$iv.put(DesktopPasteDataFlavorKt.toPasteDataFlavor(dataFlavor), fileList);
        if (mixedCategory) {
            map2.put(DesktopPasteDataFlavorKt.toPasteDataFlavor(PasteDataFlavors.INSTANCE.getURI_LIST_FLAVOR()), new ByteArrayInputStream(StringsKt.encodeToByteArray((String)CollectionsKt.joinToString$default((Iterable)fileList, (CharSequence)"\n", null, null, (int)0, null, DesktopImageTypePlugin::buildTransferable$lambda$9, (int)30, null))));
            $this$map$iv = map2;
            DataFlavor dataFlavor2 = DataFlavor.stringFlavor;
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavor2, (String)"stringFlavor");
            PasteDataFlavor $i$f$map2 = DesktopPasteDataFlavorKt.toPasteDataFlavor(dataFlavor2);
            $this$mapTo$iv$iv = CollectionsKt.joinToString$default((Iterable)fileList, (CharSequence)"\n", null, null, (int)0, null, DesktopImageTypePlugin::buildTransferable$lambda$10, (int)30, null);
            $this$map$iv.put((PasteDataFlavor)$i$f$map2, (Object)$this$mapTo$iv$iv);
            if (fileList.size() == 1) {
                Object $this$buildTransferable_u24lambda_u2413;
                map2.put(DesktopPasteDataFlavorKt.toPasteDataFlavor(PasteDataFlavors.INSTANCE.getURL_FLAVOR()), ((File)fileList.get(0)).toURI().toURL());
                $this$map$iv = this;
                try {
                    BufferedImage image;
                    $this$buildTransferable_u24lambda_u2413 = (DesktopImageTypePlugin)$this$map$iv;
                    boolean bl = false;
                    long start2 = System.currentTimeMillis();
                    BufferedImage bufferedImage = image = ((DesktopImageTypePlugin)$this$buildTransferable_u24lambda_u2413).imageHandler.readImage(Path.Companion.get$default((Path.Companion)Path.Companion, (File)((File)fileList.get(0)), (boolean)false, (int)1, null));
                    if (bufferedImage != null) {
                        BufferedImage it = bufferedImage;
                        boolean bl2 = false;
                        Map<PasteDataFlavor, Object> map3 = map2;
                        DataFlavor dataFlavor3 = DataFlavor.imageFlavor;
                        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor3, (String)"imageFlavor");
                        map3.put(DesktopPasteDataFlavorKt.toPasteDataFlavor(dataFlavor3), it);
                    }
                    long end = System.currentTimeMillis();
                    ((DesktopImageTypePlugin)$this$buildTransferable_u24lambda_u2413).logger.debug(() -> DesktopImageTypePlugin.buildTransferable$lambda$13$lambda$12(fileList, end, start2));
                    $this$buildTransferable_u24lambda_u2413 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$buildTransferable_u24lambda_u2413 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                $this$map$iv = $this$buildTransferable_u24lambda_u2413;
                Throwable throwable = Result.exceptionOrNull-impl((Object)$this$map$iv);
                if (throwable != null) {
                    Object e = $this$buildTransferable_u24lambda_u2413 = throwable;
                    boolean bl = false;
                    this.logger.error((Throwable)e, DesktopImageTypePlugin::buildTransferable$lambda$15$lambda$14);
                }
            }
        }
        if (this.platform.isLinux()) {
            String content2 = CollectionsKt.joinToString$default((Iterable)fileList, (CharSequence)"\n", (CharSequence)"copy\n", null, (int)0, null, DesktopImageTypePlugin::buildTransferable$lambda$16, (int)28, null);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(StringsKt.encodeToByteArray((String)content2));
            map2.put(DesktopPasteDataFlavorKt.toPasteDataFlavor(PasteDataFlavors.INSTANCE.getGNOME_COPIED_FILES_FLAVOR()), inputStream);
        }
    }

    @Override
    public void loadRepresentation(long pasteId, int itemIndex, @NotNull PasteDataFlavor dataFlavor, @NotNull Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        ImageTypePlugin.super.loadRepresentation(pasteId, itemIndex, dataFlavor, dataFlavorMap, pasteTransferable, pasteCollector);
    }

    @Override
    public void collectError(@NotNull Throwable error, long pasteId, int itemIndex, @NotNull PasteCollector pasteCollector) {
        ImageTypePlugin.super.collectError(error, pasteId, itemIndex, pasteCollector);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final ImagesPasteItem doLoadRepresentation$lambda$4$lambda$3(long $count, String $hash, long $size, Ref.ObjectRef $name, FileInfoTree $fileTree, String $relativePath, PasteItem pasteItem) {
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        return new ImagesPasteItem(pasteItem.getIdentifiers(), $count, $hash, $size, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)$name.element, (Object)$fileTree)), CollectionsKt.listOf((Object)$relativePath), pasteItem.getExtraInfo(), 16, null);
    }

    private static final CharSequence buildTransferable$lambda$9(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        return string2;
    }

    private static final CharSequence buildTransferable$lambda$10(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return string2;
    }

    private static final Object buildTransferable$lambda$13$lambda$12(List $fileList, long $end, long $start) {
        return "read image " + ((File)$fileList.get(0)).getAbsolutePath() + " use time: " + ($end - $start) + " ms";
    }

    private static final Object buildTransferable$lambda$15$lambda$14() {
        return "read image fail";
    }

    private static final CharSequence buildTransferable$lambda$16(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it.toURI().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/crosspaste/paste/plugin/type/DesktopImageTypePlugin$Companion;", "", "<init>", "()V", "", "X_JAVA_IMAGE", "Ljava/lang/String;", "IMAGE_PNG", "IMAGE_JPEG", "IMAGE", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

