/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste.plugin.type;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import com.crosspaste.paste.DesktopPasteDataFlavorKt;
import com.crosspaste.paste.PasteCollector;
import com.crosspaste.paste.PasteDataFlavor;
import com.crosspaste.paste.PasteTransferable;
import com.crosspaste.paste.PasteType;
import com.crosspaste.paste.item.HtmlPasteItem;
import com.crosspaste.paste.item.PasteItem;
import com.crosspaste.paste.plugin.type.HtmlTypePlugin;
import com.crosspaste.paste.plugin.type.PasteTypePlugin;
import com.crosspaste.platform.Platform;
import com.crosspaste.platform.windows.html.HTMLCodec;
import com.crosspaste.plugin.office.OfficeHtmlPlugin;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import com.crosspaste.utils.HtmlColorUtils;
import com.crosspaste.utils.HtmlUtils;
import com.crosspaste.utils.HtmlUtilsKt;
import java.awt.datatransfer.DataFlavor;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\b\u000e\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016JY\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001b2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\t0\u001d2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J3\u0010'\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00170%H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010,\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b,\u0010+J!\u0010/\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n2\b\u0010.\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b/\u00100R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00101\u00a8\u00063"}, d2={"Lcom/crosspaste/paste/plugin/type/DesktopHtmlTypePlugin;", "Lcom/crosspaste/paste/plugin/type/HtmlTypePlugin;", "Lcom/crosspaste/platform/Platform;", "platform", "<init>", "(Lcom/crosspaste/platform/Platform;)V", "Lcom/crosspaste/paste/PasteType;", "getPasteType", "()Lcom/crosspaste/paste/PasteType;", "", "", "getIdentifiers", "()Ljava/util/List;", "", "itemIndex", "identifier", "Lcom/crosspaste/paste/PasteTransferable;", "pasteTransferable", "Lcom/crosspaste/paste/PasteCollector;", "pasteCollector", "", "createPrePasteItem", "(ILjava/lang/String;Lcom/crosspaste/paste/PasteTransferable;Lcom/crosspaste/paste/PasteCollector;)V", "", "transferData", "", "pasteId", "Lcom/crosspaste/paste/PasteDataFlavor;", "dataFlavor", "", "dataFlavorMap", "doLoadRepresentation", "(Ljava/lang/Object;JILcom/crosspaste/paste/PasteDataFlavor;Ljava/util/Map;Lcom/crosspaste/paste/PasteTransferable;Lcom/crosspaste/paste/PasteCollector;)V", "Lcom/crosspaste/paste/item/PasteItem;", "pasteItem", "", "mixedCategory", "", "map", "buildTransferable", "(Lcom/crosspaste/paste/item/PasteItem;ZLjava/util/Map;)V", "inputStr", "extractHtml", "(Ljava/lang/String;)Ljava/lang/String;", "extractHtmlFromMicrosoftHtml", "html", "source", "normalizeHtml", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Lcom/crosspaste/platform/Platform;", "Companion", "app"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nDesktopHtmlTypePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopHtmlTypePlugin.kt\ncom/crosspaste/paste/plugin/type/DesktopHtmlTypePlugin\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,140:1\n158#2,6:141\n*S KotlinDebug\n*F\n+ 1 DesktopHtmlTypePlugin.kt\ncom/crosspaste/paste/plugin/type/DesktopHtmlTypePlugin\n*L\n118#1:141,6\n*E\n"})
public final class DesktopHtmlTypePlugin
implements HtmlTypePlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    public static final int $stable;
    @NotNull
    public static final String HTML_ID = "text/html";
    @NotNull
    private static final CodecsUtils codecsUtils;
    @NotNull
    private static final HtmlUtils htmlUtils;
    @NotNull
    private static final OfficeHtmlPlugin officeHtmlPlugin;

    public DesktopHtmlTypePlugin(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
    }

    @Override
    @NotNull
    public PasteType getPasteType() {
        return PasteType.Companion.getHTML_TYPE();
    }

    @Override
    @NotNull
    public List<String> getIdentifiers() {
        return CollectionsKt.listOf((Object)HTML_ID);
    }

    @Override
    public void createPrePasteItem(int itemIndex, @NotNull String identifier, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)pasteTransferable, (String)"pasteTransferable");
        Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
        List list = CollectionsKt.listOf((Object)HTML_ID);
        HtmlPasteItem it = new HtmlPasteItem(list, "", "", 0L, null, null, 48, null);
        boolean bl = false;
        pasteCollector.preCollectItem(itemIndex, (KClass<? extends PasteTypePlugin>)Reflection.getOrCreateKotlinClass(this.getClass()), (PasteItem)it);
    }

    @Override
    public void doLoadRepresentation(@NotNull Object transferData, long pasteId, int itemIndex, @NotNull PasteDataFlavor dataFlavor, @NotNull Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        Intrinsics.checkNotNullParameter((Object)transferData, (String)"transferData");
        Intrinsics.checkNotNullParameter((Object)dataFlavor, (String)"dataFlavor");
        Intrinsics.checkNotNullParameter(dataFlavorMap, (String)"dataFlavorMap");
        Intrinsics.checkNotNullParameter((Object)pasteTransferable, (String)"pasteTransferable");
        Intrinsics.checkNotNullParameter((Object)pasteCollector, (String)"pasteCollector");
        if (transferData instanceof String) {
            String html = this.extractHtml((String)transferData);
            Color color = HtmlColorUtils.INSTANCE.getBackgroundColor-ijrfgN4(html);
            long background = color != null ? color.unbox-impl() : Color.Companion.getTransparent-0d7_KjU();
            byte[] htmlBytes = StringsKt.encodeToByteArray((String)html);
            String hash = codecsUtils.hash(htmlBytes);
            long size = htmlBytes.length;
            Function1 update = arg_0 -> DesktopHtmlTypePlugin.doLoadRepresentation$lambda$2(hash, html, size, background, arg_0);
            pasteCollector.updateCollectItem(itemIndex, (KClass<? extends PasteTypePlugin>)Reflection.getOrCreateKotlinClass(this.getClass()), (Function1<? super PasteItem, ? extends PasteItem>)update);
        }
    }

    @Override
    public void buildTransferable(@NotNull PasteItem pasteItem, boolean mixedCategory, @NotNull Map<PasteDataFlavor, Object> map2) {
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        HtmlPasteItem cfr_ignored_0 = (HtmlPasteItem)pasteItem;
        String currentHtml = ((HtmlPasteItem)pasteItem).getHtml();
        if (this.platform.isWindows()) {
            currentHtml = new String(HTMLCodec.Companion.convertToHTMLFormat(currentHtml), Charsets.UTF_8);
        }
        Map<PasteDataFlavor, Object> map3 = map2;
        DataFlavor dataFlavor = DataFlavor.selectionHtmlFlavor;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"selectionHtmlFlavor");
        map3.put(DesktopPasteDataFlavorKt.toPasteDataFlavor(dataFlavor), currentHtml);
        map3 = map2;
        DataFlavor dataFlavor2 = DataFlavor.fragmentHtmlFlavor;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor2, (String)"fragmentHtmlFlavor");
        map3.put(DesktopPasteDataFlavorKt.toPasteDataFlavor(dataFlavor2), currentHtml);
        map3 = map2;
        DataFlavor dataFlavor3 = DataFlavor.allHtmlFlavor;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor3, (String)"allHtmlFlavor");
        map3.put(DesktopPasteDataFlavorKt.toPasteDataFlavor(dataFlavor3), currentHtml);
    }

    private final String extractHtml(String inputStr) {
        return StringsKt.startsWith$default((String)inputStr, (String)"Version:", (boolean)false, (int)2, null) ? this.extractHtmlFromMicrosoftHtml(inputStr) : inputStr;
    }

    private final String extractHtmlFromMicrosoftHtml(String inputStr) {
        String string2;
        int start2;
        block3: {
            int n;
            CharSequence $this$indexOfFirst$iv = inputStr;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it == '<')) continue;
                n = index$iv;
                break block3;
            }
            n = start2 = -1;
        }
        if (start2 != -1) {
            String string3 = inputStr.substring(start2);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string2 = inputStr;
        }
        String html = string2;
        return htmlUtils.ensureHtmlCharsetUtf8(html);
    }

    @Override
    @NotNull
    public String normalizeHtml(@NotNull String html, @Nullable String source2) {
        String string2;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                string2 = source2;
                if (string2 == null) break block3;
                String it = string2;
                boolean bl = false;
                String string3 = officeHtmlPlugin.match(source2) ? officeHtmlPlugin.officeNormalizationHTML(html) : html;
                string2 = string3;
                if (string3 != null) break block4;
            }
            string2 = html;
        }
        return string2;
    }

    @Override
    public void loadRepresentation(long pasteId, int itemIndex, @NotNull PasteDataFlavor dataFlavor, @NotNull Map<String, ? extends List<? extends PasteDataFlavor>> dataFlavorMap, @NotNull PasteTransferable pasteTransferable, @NotNull PasteCollector pasteCollector) {
        HtmlTypePlugin.super.loadRepresentation(pasteId, itemIndex, dataFlavor, dataFlavorMap, pasteTransferable, pasteCollector);
    }

    @Override
    public void collectError(@NotNull Throwable error, long pasteId, int itemIndex, @NotNull PasteCollector pasteCollector) {
        HtmlTypePlugin.super.collectError(error, pasteId, itemIndex, pasteCollector);
    }

    private static final Unit doLoadRepresentation$lambda$2$lambda$1(long $background, JsonObjectBuilder $this$updateExtraInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$updateExtraInfo, (String)"$this$updateExtraInfo");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$updateExtraInfo, (String)"background", (Number)ColorKt.toArgb-8_81llA((long)$background));
        return Unit.INSTANCE;
    }

    private static final HtmlPasteItem doLoadRepresentation$lambda$2(String $hash, String $html, long $size, long $background, PasteItem pasteItem) {
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        List list = pasteItem.getIdentifiers();
        JsonObject jsonObject = PasteItem.Companion.updateExtraInfo(pasteItem.getExtraInfo(), arg_0 -> DesktopHtmlTypePlugin.doLoadRepresentation$lambda$2$lambda$1($background, arg_0));
        return new HtmlPasteItem(list, $hash, $html, $size, jsonObject, null, 32, null);
    }

    static {
        codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
        htmlUtils = HtmlUtilsKt.getHtmlUtils();
        officeHtmlPlugin = new OfficeHtmlPlugin();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/crosspaste/paste/plugin/type/DesktopHtmlTypePlugin$Companion;", "", "<init>", "()V", "", "HTML_ID", "Ljava/lang/String;", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "Lcom/crosspaste/utils/HtmlUtils;", "htmlUtils", "Lcom/crosspaste/utils/HtmlUtils;", "Lcom/crosspaste/plugin/office/OfficeHtmlPlugin;", "officeHtmlPlugin", "Lcom/crosspaste/plugin/office/OfficeHtmlPlugin;", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

