/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste.plugin.process;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.paste.item.FilesPasteItem;
import com.crosspaste.paste.item.PasteCoordinate;
import com.crosspaste.paste.item.PasteItem;
import com.crosspaste.paste.item.UrlPasteItem;
import com.crosspaste.paste.plugin.process.PasteProcessPlugin;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import com.crosspaste.utils.DesktopFileUtils;
import com.crosspaste.utils.OkioPathExtensionKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileMetadata;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/crosspaste/paste/plugin/process/FileToUrlPlugin;", "Lcom/crosspaste/paste/plugin/process/PasteProcessPlugin;", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/path/UserDataPathProvider;)V", "Lcom/crosspaste/paste/item/PasteCoordinate;", "pasteCoordinate", "", "Lcom/crosspaste/paste/item/PasteItem;", "pasteItems", "", "source", "process", "(Lcom/crosspaste/paste/item/PasteCoordinate;Ljava/util/List;Ljava/lang/String;)Ljava/util/List;", "Lokio/Path;", "path", "extractUrlFromFile", "(Lokio/Path;)Ljava/lang/String;", "content", "parseUrlFromContent", "(Ljava/lang/String;)Ljava/lang/String;", "Lcom/crosspaste/path/UserDataPathProvider;", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "Companion", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFileToUrlPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileToUrlPlugin.kt\ncom/crosspaste/paste/plugin/process/FileToUrlPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1617#2,9:105\n1869#2:114\n1761#2,3:115\n1870#2:119\n1626#2:120\n1#3:118\n*S KotlinDebug\n*F\n+ 1 FileToUrlPlugin.kt\ncom/crosspaste/paste/plugin/process/FileToUrlPlugin\n*L\n31#1:105,9\n31#1:114\n37#1:115,3\n31#1:119\n31#1:120\n31#1:118\n*E\n"})
public final class FileToUrlPlugin
implements PasteProcessPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final CodecsUtils codecsUtils;
    public static final int $stable = 8;
    @NotNull
    public static final String INTERNET_SHORTCUT = "[InternetShortcut]";
    public static final int MAX_FILE_SIZE = 65536;
    @NotNull
    public static final String URL_PREFIX = "URL=";

    public FileToUrlPlugin(@NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.userDataPathProvider = userDataPathProvider;
        this.codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PasteItem> process(@NotNull PasteCoordinate pasteCoordinate, @NotNull List<? extends PasteItem> pasteItems, @Nullable String source2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pasteCoordinate, (String)"pasteCoordinate");
        Intrinsics.checkNotNullParameter(pasteItems, (String)"pasteItems");
        Iterable $this$mapNotNull$iv = pasteItems;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PasteItem pasteItem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PasteItem pasteAppearItem = (PasteItem)element$iv$iv;
            boolean bl2 = false;
            if (pasteAppearItem instanceof FilesPasteItem) {
                List filePaths = ((FilesPasteItem)pasteAppearItem).getFilePaths(this.userDataPathProvider);
                if (filePaths.size() == 1 && Intrinsics.areEqual((Object)OkioPathExtensionKt.getExtension((Path)((Path)filePaths.get(0))), (Object)"url")) {
                    String url = this.extractUrlFromFile((Path)filePaths.get(0));
                    if (url != null) {
                        UrlPasteItem urlPasteItem;
                        boolean bl3;
                        block12: {
                            Iterable $this$any$iv = pasteItems;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    PasteItem it = (PasteItem)element$iv;
                                    boolean bl4 = false;
                                    if (!(it instanceof UrlPasteItem && Intrinsics.areEqual((Object)((UrlPasteItem)it).getUrl(), (Object)url))) continue;
                                    bl3 = true;
                                    break block12;
                                }
                                bl3 = false;
                            }
                        }
                        if (bl3) {
                            urlPasteItem = null;
                        } else {
                            byte[] urlBytes = StringsKt.encodeToByteArray((String)url);
                            String hash = this.codecsUtils.hash(urlBytes);
                            urlPasteItem = new UrlPasteItem(((FilesPasteItem)pasteAppearItem).getIdentifiers(), hash, (long)urlBytes.length, url, null, 16, null);
                        }
                        pasteItem = (PasteItem)urlPasteItem;
                    } else {
                        pasteItem = pasteAppearItem;
                    }
                } else {
                    pasteItem = pasteAppearItem;
                }
            } else {
                pasteItem = pasteAppearItem;
            }
            if (pasteItem == null) continue;
            PasteItem it$iv$iv = pasteItem;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String extractUrlFromFile(Path path) {
        String string2;
        try {
            String string3;
            FileMetadata metadata = DesktopFileUtils.INSTANCE.getFileSystem().metadata(path);
            Long l = metadata.getSize();
            if (l == null) {
                return null;
            }
            long fileSize = l;
            if (fileSize > 65536L) {
                return null;
            }
            Closeable closeable = (Closeable)Okio.buffer((Source)DesktopFileUtils.INSTANCE.getFileSystem().source(path));
            Throwable throwable = null;
            try {
                BufferedSource source2 = (BufferedSource)closeable;
                boolean bl = false;
                string3 = source2.readUtf8();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String content2 = string3;
            string2 = this.parseUrlFromContent(content2);
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }

    private final String parseUrlFromContent(String content2) {
        List lines = StringsKt.lines((CharSequence)content2);
        boolean foundInternetShortcut = false;
        for (String line : lines) {
            String trimmedLine = ((Object)StringsKt.trim((CharSequence)line)).toString();
            if (Intrinsics.areEqual((Object)trimmedLine, (Object)INTERNET_SHORTCUT)) {
                foundInternetShortcut = true;
                continue;
            }
            if (!foundInternetShortcut || !StringsKt.startsWith((String)trimmedLine, (String)URL_PREFIX, (boolean)true)) continue;
            String string2 = trimmedLine.substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/crosspaste/paste/plugin/process/FileToUrlPlugin$Companion;", "", "<init>", "()V", "", "INTERNET_SHORTCUT", "Ljava/lang/String;", "", "MAX_FILE_SIZE", "I", "URL_PREFIX", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

