/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.DesktopAppWindowManager;
import com.crosspaste.config.AppConfig;
import com.crosspaste.config.ConfigManager;
import com.crosspaste.config.DesktopAppConfig;
import com.crosspaste.config.DesktopConfigManager;
import com.crosspaste.db.paste.PasteDao;
import com.crosspaste.notification.NotificationManager;
import com.crosspaste.paste.AbstractPasteboardService;
import com.crosspaste.paste.CurrentPaste;
import com.crosspaste.paste.DesktopReadTransferable;
import com.crosspaste.paste.DesktopWriteTransferable;
import com.crosspaste.paste.PasteData;
import com.crosspaste.paste.TransferableConsumer;
import com.crosspaste.paste.TransferableProducer;
import com.crosspaste.paste.item.PasteItem;
import com.crosspaste.paste.item.PasteText;
import com.crosspaste.platform.Platform;
import com.crosspaste.platform.windows.WindowClipboard;
import com.crosspaste.platform.windows.api.User32;
import com.crosspaste.sound.SoundService;
import com.crosspaste.utils.ControlUtils;
import com.crosspaste.utils.ControlUtils_desktopKt;
import com.crosspaste.utils.DesktopControlUtils;
import com.crosspaste.utils.DispatcherUtils_desktopKt;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002BY\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010 \u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\"\u0010\u001bJ\u000f\u0010#\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b#\u0010\u001bJ\u0019\u0010&\u001a\u00020\u00192\b\b\u0002\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J5\u00100\u001a\u00020*2\b\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010+\u001a\u00020*2\b\u0010-\u001a\u0004\u0018\u00010,2\b\u0010/\u001a\u0004\u0018\u00010.H\u0016\u00a2\u0006\u0004\b0\u00101J\u001f\u00106\u001a\u00020\u00192\u0006\u00103\u001a\u0002022\u0006\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b6\u00107J\u001f\u00106\u001a\u00020\u00192\u0006\u00109\u001a\u0002082\u0006\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b6\u0010:R\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010;\u001a\u0004\b<\u0010=R$\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\b\u0010>\u001a\u0004\b?\u0010@R\u001a\u0010\n\u001a\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010A\u001a\u0004\bB\u0010CR\u001a\u0010\f\u001a\u00020\u000b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010D\u001a\u0004\bE\u0010FR\u001a\u0010\u000e\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010G\u001a\u0004\bH\u0010IR\u001a\u0010\u0010\u001a\u00020\u000f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010J\u001a\u0004\bK\u0010LR\u001a\u0010\u0012\u001a\u00020\u00118\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010M\u001a\u0004\bN\u0010OR\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010PR\u001a\u0010\u0016\u001a\u00020\u00158\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010Q\u001a\u0004\bR\u0010SR\u001a\u0010U\u001a\u00020T8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bU\u0010V\u001a\u0004\bW\u0010XR\u0014\u0010Z\u001a\u00020Y8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bZ\u0010[R\u0014\u0010]\u001a\u00020\\8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u0016\u0010_\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b_\u0010`R\u0016\u0010a\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\ba\u0010bR\"\u0010c\u001a\u00020$8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\bc\u0010`\u001a\u0004\bd\u0010e\"\u0004\bf\u0010'R$\u0010g\u001a\u0004\u0018\u00010\u001e8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\bg\u0010h\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\u001a\u0010m\u001a\u00020\u001c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bm\u0010n\u001a\u0004\bo\u0010pR\u0014\u0010r\u001a\u00020q8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\br\u0010sR\u0018\u0010u\u001a\u0004\u0018\u00010t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bu\u0010vR\u0018\u0010w\u001a\u0004\u0018\u00010(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bw\u0010xR\u0018\u0010y\u001a\u0004\u0018\u00010(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\by\u0010xR\u001c\u0010|\u001a\n {*\u0004\u0018\u00010z0z8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b|\u0010}\u00a8\u0006~"}, d2={"Lcom/crosspaste/paste/WindowsPasteboardService;", "Lcom/crosspaste/paste/AbstractPasteboardService;", "Lcom/crosspaste/platform/windows/api/User32$WNDPROC;", "Lcom/crosspaste/app/DesktopAppWindowManager;", "appWindowManager", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/config/AppConfig;", "Lcom/crosspaste/config/CommonConfigManager;", "configManager", "Lcom/crosspaste/paste/CurrentPaste;", "currentPaste", "Lcom/crosspaste/notification/NotificationManager;", "notificationManager", "Lcom/crosspaste/paste/TransferableConsumer;", "pasteConsumer", "Lcom/crosspaste/paste/TransferableProducer;", "pasteProducer", "Lcom/crosspaste/db/paste/PasteDao;", "pasteDao", "Lcom/crosspaste/platform/Platform;", "platform", "Lcom/crosspaste/sound/SoundService;", "soundService", "<init>", "(Lcom/crosspaste/app/DesktopAppWindowManager;Lcom/crosspaste/config/ConfigManager;Lcom/crosspaste/paste/CurrentPaste;Lcom/crosspaste/notification/NotificationManager;Lcom/crosspaste/paste/TransferableConsumer;Lcom/crosspaste/paste/TransferableProducer;Lcom/crosspaste/db/paste/PasteDao;Lcom/crosspaste/platform/Platform;Lcom/crosspaste/sound/SoundService;)V", "", "run", "()V", "Ljava/awt/datatransfer/Clipboard;", "clipboard", "Ljava/awt/datatransfer/Transferable;", "contents", "lostOwnership", "(Ljava/awt/datatransfer/Clipboard;Ljava/awt/datatransfer/Transferable;)V", "start", "stop", "", "firstChange", "onChange", "(Z)V", "Lcom/sun/jna/platform/win32/WinDef$HWND;", "hWnd", "", "uMsg", "Lcom/sun/jna/platform/win32/WinDef$WPARAM;", "uParam", "Lcom/sun/jna/platform/win32/WinDef$LPARAM;", "lParam", "callback", "(Lcom/sun/jna/platform/win32/WinDef$HWND;ILcom/sun/jna/platform/win32/WinDef$WPARAM;Lcom/sun/jna/platform/win32/WinDef$LPARAM;)I", "Lcom/crosspaste/paste/item/PasteItem;", "pasteItem", "Lcom/crosspaste/paste/DesktopWriteTransferable;", "transferable", "writePasteboard", "(Lcom/crosspaste/paste/item/PasteItem;Lcom/crosspaste/paste/DesktopWriteTransferable;)V", "Lcom/crosspaste/paste/PasteData;", "pasteData", "(Lcom/crosspaste/paste/PasteData;Lcom/crosspaste/paste/DesktopWriteTransferable;)V", "Lcom/crosspaste/app/DesktopAppWindowManager;", "getAppWindowManager", "()Lcom/crosspaste/app/DesktopAppWindowManager;", "Lcom/crosspaste/config/ConfigManager;", "getConfigManager", "()Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/paste/CurrentPaste;", "getCurrentPaste", "()Lcom/crosspaste/paste/CurrentPaste;", "Lcom/crosspaste/notification/NotificationManager;", "getNotificationManager", "()Lcom/crosspaste/notification/NotificationManager;", "Lcom/crosspaste/paste/TransferableConsumer;", "getPasteConsumer", "()Lcom/crosspaste/paste/TransferableConsumer;", "Lcom/crosspaste/paste/TransferableProducer;", "getPasteProducer", "()Lcom/crosspaste/paste/TransferableProducer;", "Lcom/crosspaste/db/paste/PasteDao;", "getPasteDao", "()Lcom/crosspaste/db/paste/PasteDao;", "Lcom/crosspaste/platform/Platform;", "Lcom/crosspaste/sound/SoundService;", "getSoundService", "()Lcom/crosspaste/sound/SoundService;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/DesktopControlUtils;", "controlUtils", "Lcom/crosspaste/utils/DesktopControlUtils;", "Lcom/crosspaste/config/DesktopConfigManager;", "desktopConfigManager", "Lcom/crosspaste/config/DesktopConfigManager;", "existNew", "Z", "changeCount", "I", "owner", "getOwner", "()Z", "setOwner", "ownerTransferable", "Ljava/awt/datatransfer/Transferable;", "getOwnerTransferable", "()Ljava/awt/datatransfer/Transferable;", "setOwnerTransferable", "(Ljava/awt/datatransfer/Transferable;)V", "systemClipboard", "Ljava/awt/datatransfer/Clipboard;", "getSystemClipboard", "()Ljava/awt/datatransfer/Clipboard;", "Lkotlinx/coroutines/CoroutineScope;", "serviceConsumerScope", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlinx/coroutines/Job;", "job", "Lkotlinx/coroutines/Job;", "viewer", "Lcom/sun/jna/platform/win32/WinDef$HWND;", "nextViewer", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "kotlin.jvm.PlatformType", "event", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWindowsPasteboardService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsPasteboardService.kt\ncom/crosspaste/paste/WindowsPasteboardService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n295#2,2:294\n*S KotlinDebug\n*F\n+ 1 WindowsPasteboardService.kt\ncom/crosspaste/paste/WindowsPasteboardService\n*L\n283#1:294,2\n*E\n"})
public final class WindowsPasteboardService
extends AbstractPasteboardService
implements User32.WNDPROC {
    @NotNull
    private final DesktopAppWindowManager appWindowManager;
    @NotNull
    private final ConfigManager<AppConfig> configManager;
    @NotNull
    private final CurrentPaste currentPaste;
    @NotNull
    private final NotificationManager notificationManager;
    @NotNull
    private final TransferableConsumer pasteConsumer;
    @NotNull
    private final TransferableProducer pasteProducer;
    @NotNull
    private final PasteDao pasteDao;
    @NotNull
    private final Platform platform;
    @NotNull
    private final SoundService soundService;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final DesktopControlUtils controlUtils;
    @NotNull
    private final DesktopConfigManager desktopConfigManager;
    private volatile boolean existNew;
    private int changeCount;
    private volatile boolean owner;
    @Nullable
    private volatile Transferable ownerTransferable;
    @NotNull
    private final Clipboard systemClipboard;
    @NotNull
    private final CoroutineScope serviceConsumerScope;
    @Nullable
    private Job job;
    @Nullable
    private WinDef.HWND viewer;
    @Nullable
    private WinDef.HWND nextViewer;
    private final WinNT.HANDLE event;
    public static final int $stable = 8;

    public WindowsPasteboardService(@NotNull DesktopAppWindowManager appWindowManager, @NotNull ConfigManager<AppConfig> configManager, @NotNull CurrentPaste currentPaste, @NotNull NotificationManager notificationManager, @NotNull TransferableConsumer pasteConsumer, @NotNull TransferableProducer pasteProducer, @NotNull PasteDao pasteDao, @NotNull Platform platform, @NotNull SoundService soundService) {
        Intrinsics.checkNotNullParameter((Object)appWindowManager, (String)"appWindowManager");
        Intrinsics.checkNotNullParameter(configManager, (String)"configManager");
        Intrinsics.checkNotNullParameter((Object)currentPaste, (String)"currentPaste");
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        Intrinsics.checkNotNullParameter((Object)pasteConsumer, (String)"pasteConsumer");
        Intrinsics.checkNotNullParameter((Object)pasteProducer, (String)"pasteProducer");
        Intrinsics.checkNotNullParameter((Object)pasteDao, (String)"pasteDao");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)soundService, (String)"soundService");
        this.appWindowManager = appWindowManager;
        this.configManager = configManager;
        this.currentPaste = currentPaste;
        this.notificationManager = notificationManager;
        this.pasteConsumer = pasteConsumer;
        this.pasteProducer = pasteProducer;
        this.pasteDao = pasteDao;
        this.platform = platform;
        this.soundService = soundService;
        this.logger = KotlinLogging.INSTANCE.logger(WindowsPasteboardService::logger$lambda$0);
        ControlUtils controlUtils = ControlUtils_desktopKt.getControlUtils();
        Intrinsics.checkNotNull((Object)controlUtils, (String)"null cannot be cast to non-null type com.crosspaste.utils.DesktopControlUtils");
        this.controlUtils = (DesktopControlUtils)controlUtils;
        ConfigManager<AppConfig> configManager2 = this.getConfigManager();
        Intrinsics.checkNotNull(configManager2, (String)"null cannot be cast to non-null type com.crosspaste.config.DesktopConfigManager");
        this.desktopConfigManager = (DesktopConfigManager)configManager2;
        this.changeCount = this.getConfigManager().getCurrentConfig().getLastPasteboardChangeCount();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Intrinsics.checkNotNullExpressionValue((Object)clipboard, (String)"getSystemClipboard(...)");
        this.systemClipboard = clipboard;
        this.serviceConsumerScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)DispatcherUtils_desktopKt.getCpuDispatcher().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.event = Kernel32.INSTANCE.CreateEvent(null, false, false, null);
        this.startRemotePasteboardListener();
    }

    @Override
    @NotNull
    public DesktopAppWindowManager getAppWindowManager() {
        return this.appWindowManager;
    }

    @Override
    @NotNull
    public ConfigManager<AppConfig> getConfigManager() {
        return this.configManager;
    }

    @Override
    @NotNull
    public CurrentPaste getCurrentPaste() {
        return this.currentPaste;
    }

    @Override
    @NotNull
    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Override
    @NotNull
    public TransferableConsumer getPasteConsumer() {
        return this.pasteConsumer;
    }

    @Override
    @NotNull
    public TransferableProducer getPasteProducer() {
        return this.pasteProducer;
    }

    @Override
    @NotNull
    public PasteDao getPasteDao() {
        return this.pasteDao;
    }

    @Override
    @NotNull
    public SoundService getSoundService() {
        return this.soundService;
    }

    @Override
    @NotNull
    public KLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(boolean bl) {
        this.owner = bl;
    }

    @Override
    @Nullable
    public Transferable getOwnerTransferable() {
        return this.ownerTransferable;
    }

    @Override
    public void setOwnerTransferable(@Nullable Transferable transferable) {
        this.ownerTransferable = transferable;
    }

    @Override
    @NotNull
    public Clipboard getSystemClipboard() {
        return this.systemClipboard;
    }

    private final void run() {
        this.viewer = User32.Companion.getINSTANCE().CreateWindowEx(0, "STATIC", "", 0, 0, 0, 0, 0, null, 0, 0, null);
        this.nextViewer = User32.Companion.getINSTANCE().SetClipboardViewer(this.viewer);
        int n = this.platform.is64bit() ? User32.Companion.getINSTANCE().SetWindowLongPtr(this.viewer, -4, this) : User32.Companion.getINSTANCE().SetWindowLong(this.viewer, -4, this);
        WinUser.MSG msg = new WinUser.MSG();
        WinNT.HANDLE[] hANDLEArray = new WinNT.HANDLE[]{this.event};
        WinNT.HANDLE[] handles = hANDLEArray;
        block0: while (true) {
            int result2 = User32.Companion.getINSTANCE().MsgWaitForMultipleObjects(handles.length, handles, false, -1, 1279);
            this.existNew = true;
            if (result2 == 0) {
                User32.Companion.getINSTANCE().DestroyWindow(this.viewer);
                return;
            }
            if (result2 != 0 + handles.length) break;
            while (true) {
                if (!User32.Companion.getINSTANCE().PeekMessage(msg, null, 0, 0, 1)) continue block0;
                User32.Companion.getINSTANCE().TranslateMessage(msg);
                User32.Companion.getINSTANCE().DispatchMessage(msg);
            }
            break;
        }
    }

    @Override
    public void lostOwnership(@Nullable Clipboard clipboard, @Nullable Transferable contents2) {
        this.setOwner(false);
    }

    @Override
    public void start() {
        Job job = this.job;
        if (!(job != null ? job.isActive() : false)) {
            this.job = BuildersKt.launch$default((CoroutineScope)this.getServiceScope(), (CoroutineContext)((CoroutineContext)new CoroutineName("WindowsPasteboardService")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ WindowsPasteboardService this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            boolean firstChange;
                            ResultKt.throwOnFailure((Object)$result);
                            boolean bl = firstChange = WindowsPasteboardService.access$getChangeCount$p(this.this$0) == this.this$0.getConfigManager().getCurrentConfig().getLastPasteboardChangeCount();
                            if (firstChange && !this.this$0.getConfigManager().getCurrentConfig().getEnableSkipPreLaunchPasteboardContent()) {
                                WindowsPasteboardService.access$onChange(this.this$0, true);
                            }
                            WindowsPasteboardService.access$run(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @Override
    public void stop() {
        Kernel32.INSTANCE.SetEvent(this.event);
        Job job = this.job;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.getConfigManager().updateConfig("lastPasteboardChangeCount", (Object)this.changeCount);
    }

    private final void onChange(boolean firstChange) {
        block4: {
            Object object;
            Object object2 = this;
            try {
                Job job;
                Transferable contents2;
                WindowsPasteboardService $this$onChange_u24lambda_u244 = object2;
                boolean bl = false;
                String source2 = firstChange ? null : (String)$this$onChange_u24lambda_u244.controlUtils.blockEnsureMinExecutionTime(20, () -> WindowsPasteboardService.onChange$lambda$4$lambda$1($this$onChange_u24lambda_u244));
                Transferable transferable = contents2 = (Transferable)$this$onChange_u24lambda_u244.controlUtils.blockExponentialBackoffUntilValid(20L, 1000L, (Function1)new Function1<Transferable, Boolean>((Object)$this$onChange_u24lambda_u244){

                    public final Boolean invoke(Transferable p0) {
                        return ((WindowsPasteboardService)this.receiver).isValidContents(p0);
                    }
                }, () -> WindowsPasteboardService.onChange$lambda$4$lambda$2($this$onChange_u24lambda_u244));
                if (transferable != null) {
                    Transferable it = transferable;
                    boolean bl2 = false;
                    job = BuildersKt.launch$default((CoroutineScope)$this$onChange_u24lambda_u244.serviceConsumerScope, (CoroutineContext)((CoroutineContext)new CoroutineName("WindowsPasteboardConsumer")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, $this$onChange_u24lambda_u244, source2, null){
                        Object L$0;
                        int label;
                        final /* synthetic */ Transferable $it;
                        final /* synthetic */ WindowsPasteboardService $this_runCatching;
                        final /* synthetic */ String $source;
                        {
                            this.$it = $it;
                            this.$this_runCatching = $receiver;
                            this.$source = $source;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    if (Intrinsics.areEqual((Object)this.$it, (Object)this.$this_runCatching.getOwnerTransferable())) return Unit.INSTANCE;
                                    this.$this_runCatching.setOwnerTransferable(this.$it);
                                    DesktopReadTransferable pasteTransferable = new DesktopReadTransferable(this.$it);
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)pasteTransferable);
                                    this.label = 1;
                                    Object object2 = this.$this_runCatching.getPasteConsumer().consume-BWLJW6A(pasteTransferable, this.$source, false, (Continuation<? super Result<Unit>>)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    DesktopReadTransferable pasteTransferable = (DesktopReadTransferable)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = ((Result)$result).unbox-impl();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                } else {
                    job = null;
                }
                object = Result.constructor-impl(job);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block4;
            Object e = object = throwable;
            boolean bl = false;
            this.getLogger().error((Throwable)e, WindowsPasteboardService::onChange$lambda$6$lambda$5);
        }
    }

    static /* synthetic */ void onChange$default(WindowsPasteboardService windowsPasteboardService, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        windowsPasteboardService.onChange(bl);
    }

    @Override
    public int callback(@Nullable WinDef.HWND hWnd, int uMsg, @Nullable WinDef.WPARAM uParam, @Nullable WinDef.LPARAM lParam) {
        switch (uMsg) {
            case 781: {
                WinDef.HWND hWND = this.nextViewer;
                Intrinsics.checkNotNull((Object)hWND);
                Object object = hWND.toNative();
                WinDef.WPARAM wPARAM = uParam;
                Intrinsics.checkNotNull((Object)wPARAM);
                if (Intrinsics.areEqual((Object)object, (Object)wPARAM.toNative())) {
                    WinDef.LPARAM lPARAM = lParam;
                    Intrinsics.checkNotNull((Object)lPARAM);
                    this.nextViewer = new WinDef.HWND(Pointer.createConstant((long)lPARAM.longValue()));
                } else if (this.nextViewer != null) {
                    User32.Companion.getINSTANCE().SendMessage(this.nextViewer, uMsg, uParam, lParam);
                }
                return 0;
            }
            case 776: {
                if (this.existNew) {
                    Object $this$callback_u24lambda_u247;
                    this.existNew = false;
                    Object object = this;
                    try {
                        $this$callback_u24lambda_u247 = object;
                        boolean bl = false;
                        int clipboardSequenceNumber = User32.Companion.getINSTANCE().GetClipboardSequenceNumber();
                        if (((WindowsPasteboardService)$this$callback_u24lambda_u247).changeCount != clipboardSequenceNumber) {
                            ((WindowsPasteboardService)$this$callback_u24lambda_u247).changeCount = clipboardSequenceNumber;
                            WindowsPasteboardService.onChange$default((WindowsPasteboardService)$this$callback_u24lambda_u247, false, 1, null);
                        }
                        $this$callback_u24lambda_u247 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        $this$callback_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    Object $this$callback_u24lambda_u248 = object = $this$callback_u24lambda_u247;
                    boolean bl = false;
                    User32.Companion.getINSTANCE().SendMessage(this.nextViewer, uMsg, uParam, lParam);
                }
                return 0;
            }
            case 2: {
                User32.Companion.getINSTANCE().ChangeClipboardChain(this.viewer, this.nextViewer);
            }
        }
        return User32.Companion.getINSTANCE().DefWindowProc(hWnd, uMsg, uParam, lParam).intValue();
    }

    @Override
    public void writePasteboard(@NotNull PasteItem pasteItem, @NotNull DesktopWriteTransferable transferable) {
        Intrinsics.checkNotNullParameter((Object)pasteItem, (String)"pasteItem");
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        super.writePasteboard(pasteItem, transferable);
        if (((DesktopAppConfig)this.desktopConfigManager.getCurrentConfig()).getLegacySoftwareCompatibility() && pasteItem instanceof PasteText) {
            WindowClipboard.INSTANCE.supplementCFText(((PasteText)pasteItem).getText());
        }
    }

    @Override
    public void writePasteboard(@NotNull PasteData pasteData, @NotNull DesktopWriteTransferable transferable) {
        Intrinsics.checkNotNullParameter((Object)pasteData, (String)"pasteData");
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        super.writePasteboard(pasteData, transferable);
        if (((DesktopAppConfig)this.desktopConfigManager.getCurrentConfig()).getLegacySoftwareCompatibility()) {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = pasteData.getPasteAppearItems();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PasteItem it = (PasteItem)element$iv;
                    boolean bl = false;
                    if (!(it instanceof PasteText)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            PasteItem pasteItem = v0;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)pasteItem, (String)"null cannot be cast to non-null type com.crosspaste.paste.item.PasteText");
            PasteText textPasteItem = (PasteText)pasteItem;
            boolean bl2 = false;
            WindowClipboard.INSTANCE.supplementCFText(textPasteItem.getText());
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final String onChange$lambda$4$lambda$1(WindowsPasteboardService $this_runCatching) {
        return $this_runCatching.getAppWindowManager().getCurrentActiveAppName();
    }

    private static final Transferable onChange$lambda$4$lambda$2(WindowsPasteboardService $this_runCatching) {
        return $this_runCatching.getPasteboardContentsBySafe();
    }

    private static final Object onChange$lambda$6$lambda$5() {
        return "Failed to consume transferable";
    }

    public static final /* synthetic */ int access$getChangeCount$p(WindowsPasteboardService $this) {
        return $this.changeCount;
    }

    public static final /* synthetic */ void access$onChange(WindowsPasteboardService $this, boolean firstChange) {
        $this.onChange(firstChange);
    }

    public static final /* synthetic */ void access$run(WindowsPasteboardService $this) {
        $this.run();
    }
}

