/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.db.paste.PasteDao;
import com.crosspaste.exception.PasteException;
import com.crosspaste.exception.StandardErrorCode;
import com.crosspaste.i18n.GlobalCopywriter;
import com.crosspaste.notification.MessageType;
import com.crosspaste.notification.NotificationManager;
import com.crosspaste.paste.PasteCollection;
import com.crosspaste.paste.PasteData;
import com.crosspaste.paste.PasteImportParam;
import com.crosspaste.paste.SearchContentService;
import com.crosspaste.paste.item.PasteCoordinate;
import com.crosspaste.paste.item.PasteFiles;
import com.crosspaste.paste.item.PasteItem;
import com.crosspaste.path.PathProvider;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import com.crosspaste.utils.CompressUtils;
import com.crosspaste.utils.CompressUtils_desktopKt;
import com.crosspaste.utils.DateUtils;
import com.crosspaste.utils.DispatcherUtils_desktopKt;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import com.crosspaste.utils.OkioPathExtensionKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import okio.BufferedSource;
import okio.Path;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J+\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J'\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ/\u0010 \u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u0019\u0010$\u001a\u0004\u0018\u00010\u00192\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010'\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b'\u0010(R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010)R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010*R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010+R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0014\u0010:\u001a\u0002098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0014\u0010=\u001a\u00020<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Lcom/crosspaste/paste/PasteImportService;", "", "Lcom/crosspaste/notification/NotificationManager;", "notificationManager", "Lcom/crosspaste/db/paste/PasteDao;", "pasteDao", "Lcom/crosspaste/paste/SearchContentService;", "searchContentService", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/notification/NotificationManager;Lcom/crosspaste/db/paste/PasteDao;Lcom/crosspaste/paste/SearchContentService;Lcom/crosspaste/path/UserDataPathProvider;)V", "Lcom/crosspaste/paste/PasteImportParam;", "pasteImportParam", "Lkotlin/Function1;", "", "", "updateProgress", "import", "(Lcom/crosspaste/paste/PasteImportParam;Lkotlin/jvm/functions/Function1;)V", "doImport", "Lokio/Path;", "basePath", "", "index", "Lcom/crosspaste/paste/PasteData;", "pasteData", "", "importPasteData", "(Lokio/Path;JLcom/crosspaste/paste/PasteData;)Z", "Lcom/crosspaste/paste/item/PasteFiles;", "pasteFiles", "moveResource", "(Lokio/Path;JLcom/crosspaste/paste/PasteData;Lcom/crosspaste/paste/item/PasteFiles;)V", "", "line", "readPasteData", "(Ljava/lang/String;)Lcom/crosspaste/paste/PasteData;", "decompressPath", "decompress", "(Lcom/crosspaste/paste/PasteImportParam;Lokio/Path;)V", "Lcom/crosspaste/notification/NotificationManager;", "Lcom/crosspaste/db/paste/PasteDao;", "Lcom/crosspaste/paste/SearchContentService;", "Lcom/crosspaste/path/UserDataPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "Lcom/crosspaste/utils/CompressUtils;", "compressUtils", "Lcom/crosspaste/utils/CompressUtils;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "Lkotlinx/coroutines/CoroutineScope;", "ioCoroutineDispatcher", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlinx/coroutines/sync/Mutex;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPasteImportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasteImportService.kt\ncom/crosspaste/paste/PasteImportService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1#2:211\n808#3,11:212\n*S KotlinDebug\n*F\n+ 1 PasteImportService.kt\ncom/crosspaste/paste/PasteImportService\n*L\n147#1:212,11\n*E\n"})
public final class PasteImportService {
    @NotNull
    private final NotificationManager notificationManager;
    @NotNull
    private final PasteDao pasteDao;
    @NotNull
    private final SearchContentService searchContentService;
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final CodecsUtils codecsUtils;
    @NotNull
    private final CompressUtils compressUtils;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final CoroutineScope ioCoroutineDispatcher;
    @NotNull
    private final Mutex mutex;
    public static final int $stable = 8;

    public PasteImportService(@NotNull NotificationManager notificationManager, @NotNull PasteDao pasteDao, @NotNull SearchContentService searchContentService, @NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        Intrinsics.checkNotNullParameter((Object)pasteDao, (String)"pasteDao");
        Intrinsics.checkNotNullParameter((Object)searchContentService, (String)"searchContentService");
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.notificationManager = notificationManager;
        this.pasteDao = pasteDao;
        this.searchContentService = searchContentService;
        this.userDataPathProvider = userDataPathProvider;
        this.logger = KotlinLogging.INSTANCE.logger(PasteImportService::logger$lambda$0);
        this.codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
        this.compressUtils = CompressUtils_desktopKt.getCompressUtils();
        this.fileUtils = FileUtils_desktopKt.getFileUtils();
        this.ioCoroutineDispatcher = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)DispatcherUtils_desktopKt.getIoDispatcher()));
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    public final void import(@NotNull PasteImportParam pasteImportParam, @NotNull Function1<? super Float, Unit> updateProgress) {
        Intrinsics.checkNotNullParameter((Object)pasteImportParam, (String)"pasteImportParam");
        Intrinsics.checkNotNullParameter(updateProgress, (String)"updateProgress");
        BuildersKt.launch$default((CoroutineScope)this.ioCoroutineDispatcher, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pasteImportParam, updateProgress, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int label;
            final /* synthetic */ PasteImportService this$0;
            final /* synthetic */ PasteImportParam $pasteImportParam;
            final /* synthetic */ Function1<Float, Unit> $updateProgress;
            {
                this.this$0 = $receiver;
                this.$pasteImportParam = $pasteImportParam;
                this.$updateProgress = $updateProgress;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = PasteImportService.access$getMutex$p(this.this$0);
                        var4_4 = this.this$0;
                        var5_5 = this.$pasteImportParam;
                        var6_6 = this.$updateProgress;
                        owner$iv = null;
                        $i$f$withLock = 0;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.L$2 = var5_5;
                        this.L$3 = var6_6;
                        this.I$0 = $i$f$withLock;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl30
                    }
                    case 1: {
                        $i$f$withLock = this.I$0;
                        var6_6 = (Function1<Float, Unit>)this.L$3;
                        var5_5 = (PasteImportParam)this.L$2;
                        var4_4 = (PasteImportService)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        try {
                            $i$a$-withLock$default-PasteImportService$import$1$1 = false;
                            PasteImportService.access$doImport(var4_4, var5_5, var6_6);
                            var9_11 = Unit.INSTANCE;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void doImport(PasteImportParam pasteImportParam, Function1<? super Float, Unit> updateProgress) {
        block6: {
            Object $this$doImport_u24lambda_u248;
            Path importTempPath = null;
            Object object = this;
            try {
                Path basePath;
                $this$doImport_u24lambda_u248 = object;
                boolean bl = false;
                Path tempDir = PathProvider.resolve$default((PathProvider)((PathProvider)((PasteImportService)$this$doImport_u24lambda_u248).userDataPathProvider), null, (AppFileType)AppFileType.TEMP, (int)1, null);
                long epochMilliseconds = DateUtils.INSTANCE.nowEpochMilliseconds();
                importTempPath = basePath = tempDir.resolve("import-" + epochMilliseconds, true);
                ((PasteImportService)$this$doImport_u24lambda_u248).userDataPathProvider.autoCreateDir(basePath);
                super.decompress(pasteImportParam, basePath);
                long importCount = Long.parseLong(StringsKt.removeSuffix((String)((Path)CollectionsKt.first((List)((PasteImportService)$this$doImport_u24lambda_u248).fileUtils.listFiles(basePath, PasteImportService::doImport$lambda$8$lambda$1))).name(), (CharSequence)".count"));
                Path pasteDataFile = Path.resolve$default((Path)basePath, (String)"paste.data", (boolean)false, (int)2, null);
                if (!((PasteImportService)$this$doImport_u24lambda_u248).fileUtils.existFile(pasteDataFile)) {
                    throw new PasteException(StandardErrorCode.IMPORT_FAIL.toErrorCode(), "Failed to find paste.data file");
                }
                Ref.LongRef count = new Ref.LongRef();
                Ref.LongRef failCount = new Ref.LongRef();
                ((PasteImportService)$this$doImport_u24lambda_u248).fileUtils.readByLines(pasteDataFile, arg_0 -> PasteImportService.doImport$lambda$8$lambda$5(count, (PasteImportService)$this$doImport_u24lambda_u248, basePath, updateProgress, importCount, failCount, arg_0));
                if (count.element > 0L) {
                    NotificationManager.sendNotification$default(((PasteImportService)$this$doImport_u24lambda_u248).notificationManager, PasteImportService::doImport$lambda$8$lambda$6, null, MessageType.Success, null, 10, null);
                } else {
                    NotificationManager.sendNotification$default(((PasteImportService)$this$doImport_u24lambda_u248).notificationManager, PasteImportService::doImport$lambda$8$lambda$7, null, MessageType.Warning, null, 10, null);
                }
                updateProgress.invoke((Object)Float.valueOf(1.0f));
                $this$doImport_u24lambda_u248 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$doImport_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$doImport_u24lambda_u248;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object e = $this$doImport_u24lambda_u248 = throwable;
                boolean bl = false;
                updateProgress.invoke((Object)Float.valueOf(-1.0f));
                this.logger.error((Throwable)e, PasteImportService::doImport$lambda$11$lambda$9);
                NotificationManager.sendNotification$default(this.notificationManager, PasteImportService::doImport$lambda$11$lambda$10, null, MessageType.Error, null, 10, null);
            }
            Object $this$doImport_u24lambda_u2413 = object;
            boolean bl = false;
            Path path = importTempPath;
            if (path == null) break block6;
            Path it = path;
            boolean bl2 = false;
            this.fileUtils.deleteFile-IoAF18A(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean importPasteData(Path basePath, long index, PasteData pasteData) {
        Object object;
        block5: {
            Object object2;
            object = this;
            try {
                void $this$filterIsInstanceTo$iv$iv;
                PasteImportService $this$importPasteData_u24lambda_u2414 = object;
                boolean bl = false;
                long id = PasteDao.createPasteData$default($this$importPasteData_u24lambda_u2414.pasteDao, pasteData, null, 2, null);
                PasteCoordinate pasteCoordinate = pasteData.getPasteCoordinate(Long.valueOf(index));
                PasteItem pasteAppearItem = pasteData.getPasteAppearItem();
                PasteCollection pasteCollection = pasteData.getPasteCollection();
                PasteItem pasteItem = pasteAppearItem;
                PasteItem newPasteAppearItem = pasteItem != null ? pasteItem.bind(pasteCoordinate) : null;
                PasteCollection newPasteCollection = pasteCollection.bind(pasteCoordinate);
                PasteItem pasteItem2 = newPasteAppearItem;
                PasteData importPasteData = PasteData.copy$default((PasteData)pasteData, (long)id, null, (boolean)false, (PasteItem)newPasteAppearItem, (PasteCollection)newPasteCollection, (int)0, null, (long)0L, null, (long)0L, (String)$this$importPasteData_u24lambda_u2414.searchContentService.createSearchContent(pasteData.getSource(), pasteItem2 != null ? pasteItem2.getSearchContent() : null), (int)0, (boolean)false, (int)7142, null);
                Iterable $this$filterIsInstance$iv = importPasteData.getPasteAppearItems();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PasteFiles)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List pasteFilesList = (List)destination$iv$iv;
                if (!((Collection)pasteFilesList).isEmpty()) {
                    $this$importPasteData_u24lambda_u2414.pasteDao.updateFilePath(importPasteData);
                }
                for (PasteFiles pasteFiles : pasteFilesList) {
                    $this$importPasteData_u24lambda_u2414.moveResource(basePath, index, importPasteData, pasteFiles);
                }
                $this$importPasteData_u24lambda_u2414.pasteDao.updatePasteState(id, 1);
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block5;
            Object e = object2 = throwable;
            boolean bl = false;
            this.logger.error((Throwable)e, () -> PasteImportService.importPasteData$lambda$16$lambda$15(index));
        }
        return Result.isSuccess-impl((Object)object);
    }

    private final void moveResource(Path basePath, long index, PasteData importPasteData, PasteFiles pasteFiles) {
        Path path = Path.resolve$default((Path)Path.resolve$default((Path)basePath, (String)importPasteData.getAppInstanceId(), (boolean)false, (int)2, null), (String)String.valueOf(index), (boolean)false, (int)2, null);
        for (Path filePath : pasteFiles.getFilePaths(this.userDataPathProvider)) {
            Path importFilePath = Path.resolve$default((Path)path, (String)filePath.name(), (boolean)false, (int)2, null);
            this.userDataPathProvider.autoCreateDir(OkioPathExtensionKt.getNoOptionParent((Path)filePath));
            this.fileUtils.moveFile-gIAlu-s(importFilePath, filePath);
        }
    }

    private final PasteData readPasteData(String line) {
        String json = StringsKt.decodeToString((byte[])this.codecsUtils.base64Decode(line));
        return PasteData.Companion.fromJson(json);
    }

    private final void decompress(PasteImportParam pasteImportParam, Path decompressPath) {
        BufferedSource bufferedSource = pasteImportParam.importBufferedSource();
        if (bufferedSource != null) {
            BufferedSource bufferSource = bufferedSource;
            boolean bl = false;
            Object object = this.compressUtils.unzip-gIAlu-s(bufferSource, decompressPath);
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl2 = false;
                PasteImportService pasteImportService = this;
                try {
                    PasteImportService $this$decompress_u24lambda_u2421_u24lambda_u2418_u24lambda_u2417 = pasteImportService;
                    boolean bl3 = false;
                    bufferSource.close();
                    Object object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl4 = false;
                this.logger.error(it, PasteImportService::decompress$lambda$21$lambda$20$lambda$19);
                throw new PasteException(StandardErrorCode.IMPORT_FAIL.toErrorCode(), "Failed to decompress the file");
            }
        } else {
            PasteImportService $this$decompress_u24lambda_u2422 = this;
            boolean bl = false;
            throw new PasteException(StandardErrorCode.IMPORT_FAIL.toErrorCode(), "Failed to read the file");
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final boolean doImport$lambda$8$lambda$1(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.endsWith$default((String)it.name(), (String)".count", (boolean)false, (int)2, null);
    }

    private static final Object doImport$lambda$8$lambda$5$lambda$4$lambda$3(Ref.LongRef $count) {
        return "Error parsing paste data, index = " + $count.element;
    }

    private static final Unit doImport$lambda$8$lambda$5(Ref.LongRef $count, PasteImportService $this_runCatching, Path $basePath, Function1 $updateProgress, long $importCount, Ref.LongRef $failCount, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        long l = $count.element;
        $count.element = l + 1L;
        PasteData pasteData = $this_runCatching.readPasteData(line);
        if (pasteData != null) {
            PasteData pasteData2 = pasteData;
            boolean bl = false;
            if ($this_runCatching.importPasteData($basePath, $count.element, pasteData2)) {
                $updateProgress.invoke((Object)Float.valueOf((float)$count.element / (float)$importCount));
            }
        } else {
            PasteImportService $this$doImport_u24lambda_u248_u24lambda_u245_u24lambda_u244 = $this_runCatching;
            boolean bl = false;
            $this$doImport_u24lambda_u248_u24lambda_u245_u24lambda_u244.logger.error(() -> PasteImportService.doImport$lambda$8$lambda$5$lambda$4$lambda$3($count));
            long l2 = $failCount.element;
            $failCount.element = l2 + 1L;
        }
        return Unit.INSTANCE;
    }

    private static final String doImport$lambda$8$lambda$6(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("import_successful", new Object[0]);
    }

    private static final String doImport$lambda$8$lambda$7(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("no_data_import", new Object[0]);
    }

    private static final Object doImport$lambda$11$lambda$9() {
        return "Error importing paste data";
    }

    private static final String doImport$lambda$11$lambda$10(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("import_fail", new Object[0]);
    }

    private static final Object importPasteData$lambda$16$lambda$15(long $index) {
        return "Error importing paste data, index = " + $index;
    }

    private static final Object decompress$lambda$21$lambda$20$lambda$19() {
        return "Failed to decompress the file";
    }

    public static final /* synthetic */ Mutex access$getMutex$p(PasteImportService $this) {
        return $this.mutex;
    }

    public static final /* synthetic */ void access$doImport(PasteImportService $this, PasteImportParam pasteImportParam, Function1 updateProgress) {
        $this.doImport(pasteImportParam, (Function1<? super Float, Unit>)updateProgress);
    }
}

