/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.db.paste.PasteDao;
import com.crosspaste.exception.PasteException;
import com.crosspaste.exception.StandardErrorCode;
import com.crosspaste.i18n.GlobalCopywriter;
import com.crosspaste.notification.MessageType;
import com.crosspaste.notification.NotificationManager;
import com.crosspaste.paste.PasteData;
import com.crosspaste.paste.PasteExportParam;
import com.crosspaste.paste.item.PasteFiles;
import com.crosspaste.path.PathProvider;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import com.crosspaste.utils.CompressUtils;
import com.crosspaste.utils.CompressUtils_desktopKt;
import com.crosspaste.utils.DateUtils;
import com.crosspaste.utils.DispatcherUtils_desktopKt;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import okio.BufferedSink;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J+\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J7\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010#\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010%R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010&R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0014\u00102\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00105\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0014\u00108\u001a\u0002078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109\u00a8\u0006:"}, d2={"Lcom/crosspaste/paste/PasteExportService;", "", "Lcom/crosspaste/notification/NotificationManager;", "notificationManager", "Lcom/crosspaste/db/paste/PasteDao;", "pasteDao", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/notification/NotificationManager;Lcom/crosspaste/db/paste/PasteDao;Lcom/crosspaste/path/UserDataPathProvider;)V", "Lcom/crosspaste/paste/PasteExportParam;", "pasteExportParam", "Lkotlin/Function1;", "", "", "updateProgress", "export", "(Lcom/crosspaste/paste/PasteExportParam;Lkotlin/jvm/functions/Function1;)V", "doExport", "Lokio/Path;", "basePath", "", "index", "Lcom/crosspaste/paste/PasteData;", "pasteData", "Lokio/BufferedSink;", "sink", "exportPasteData", "(Lokio/Path;Lcom/crosspaste/paste/PasteExportParam;JLcom/crosspaste/paste/PasteData;Lokio/BufferedSink;)J", "Lcom/crosspaste/paste/item/PasteFiles;", "pasteFiles", "copyResource", "(Lokio/Path;JLcom/crosspaste/paste/PasteData;Lcom/crosspaste/paste/item/PasteFiles;)V", "", "exportFileName", "compressExportFile", "(Lokio/Path;Lcom/crosspaste/paste/PasteExportParam;Ljava/lang/String;)V", "Lcom/crosspaste/notification/NotificationManager;", "Lcom/crosspaste/db/paste/PasteDao;", "Lcom/crosspaste/path/UserDataPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "Lcom/crosspaste/utils/CompressUtils;", "compressUtils", "Lcom/crosspaste/utils/CompressUtils;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "Lkotlinx/coroutines/CoroutineScope;", "ioCoroutineDispatcher", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlinx/coroutines/sync/Mutex;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPasteExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasteExportService.kt\ncom/crosspaste/paste/PasteExportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n808#2,11:201\n774#2:212\n865#2,2:213\n*S KotlinDebug\n*F\n+ 1 PasteExportService.kt\ncom/crosspaste/paste/PasteExportService\n*L\n132#1:201,11\n133#1:212\n133#1:213,2\n*E\n"})
public final class PasteExportService {
    @NotNull
    private final NotificationManager notificationManager;
    @NotNull
    private final PasteDao pasteDao;
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final CodecsUtils codecsUtils;
    @NotNull
    private final CompressUtils compressUtils;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final CoroutineScope ioCoroutineDispatcher;
    @NotNull
    private final Mutex mutex;
    public static final int $stable = 8;

    public PasteExportService(@NotNull NotificationManager notificationManager, @NotNull PasteDao pasteDao, @NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        Intrinsics.checkNotNullParameter((Object)pasteDao, (String)"pasteDao");
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.notificationManager = notificationManager;
        this.pasteDao = pasteDao;
        this.userDataPathProvider = userDataPathProvider;
        this.logger = KotlinLogging.INSTANCE.logger(PasteExportService::logger$lambda$0);
        this.codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
        this.compressUtils = CompressUtils_desktopKt.getCompressUtils();
        this.fileUtils = FileUtils_desktopKt.getFileUtils();
        this.ioCoroutineDispatcher = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)DispatcherUtils_desktopKt.getIoDispatcher()));
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    public final void export(@NotNull PasteExportParam pasteExportParam, @NotNull Function1<? super Float, Unit> updateProgress) {
        Intrinsics.checkNotNullParameter((Object)pasteExportParam, (String)"pasteExportParam");
        Intrinsics.checkNotNullParameter(updateProgress, (String)"updateProgress");
        BuildersKt.launch$default((CoroutineScope)this.ioCoroutineDispatcher, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pasteExportParam, updateProgress, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int label;
            final /* synthetic */ PasteExportService this$0;
            final /* synthetic */ PasteExportParam $pasteExportParam;
            final /* synthetic */ Function1<Float, Unit> $updateProgress;
            {
                this.this$0 = $receiver;
                this.$pasteExportParam = $pasteExportParam;
                this.$updateProgress = $updateProgress;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = PasteExportService.access$getMutex$p(this.this$0);
                        var4_4 = this.this$0;
                        var5_5 = this.$pasteExportParam;
                        var6_6 = this.$updateProgress;
                        owner$iv = null;
                        $i$f$withLock = 0;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.L$2 = var5_5;
                        this.L$3 = var6_6;
                        this.I$0 = $i$f$withLock;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl30
                    }
                    case 1: {
                        $i$f$withLock = this.I$0;
                        var6_6 = (Function1<Float, Unit>)this.L$3;
                        var5_5 = (PasteExportParam)this.L$2;
                        var4_4 = (PasteExportService)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        try {
                            $i$a$-withLock$default-PasteExportService$export$1$1 = false;
                            PasteExportService.access$doExport(var4_4, var5_5, var6_6);
                            var9_11 = Unit.INSTANCE;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void doExport(PasteExportParam pasteExportParam, Function1<? super Float, Unit> updateProgress) {
        block5: {
            Object $this$doExport_u24lambda_u2410;
            Path exportTempPath = null;
            Object object = this;
            try {
                Path basePath;
                $this$doExport_u24lambda_u2410 = object;
                boolean bl = false;
                Path tempDir = PathProvider.resolve$default((PathProvider)((PathProvider)((PasteExportService)$this$doExport_u24lambda_u2410).userDataPathProvider), null, (AppFileType)AppFileType.TEMP, (int)1, null);
                long epochMilliseconds = DateUtils.INSTANCE.nowEpochMilliseconds();
                exportTempPath = basePath = tempDir.resolve("export-" + epochMilliseconds, true);
                ((PasteExportService)$this$doExport_u24lambda_u2410).userDataPathProvider.autoCreateDir(basePath);
                Path pasteDataFile = Path.resolve$default((Path)basePath, (String)"paste.data", (boolean)false, (int)2, null);
                Ref.LongRef count = new Ref.LongRef();
                count.element = 1L;
                ((PasteExportService)$this$doExport_u24lambda_u2410).fileUtils.writeFile(pasteDataFile, arg_0 -> PasteExportService.doExport$lambda$10$lambda$6((PasteExportService)$this$doExport_u24lambda_u2410, pasteExportParam, count, basePath, updateProgress, arg_0));
                String exportFileName = "crosspaste-export-" + epochMilliseconds + ".data";
                if (count.element > 0L) {
                    Path countFile = Path.resolve$default((Path)basePath, (String)(count.element + ".count"), (boolean)false, (int)2, null);
                    FileUtils.createFile-gIAlu-s$default((FileUtils)((PasteExportService)$this$doExport_u24lambda_u2410).fileUtils, (Path)countFile, (boolean)false, (int)2, null);
                    super.compressExportFile(basePath, pasteExportParam, exportFileName);
                    ((PasteExportService)$this$doExport_u24lambda_u2410).notificationManager.sendNotification((Function1<? super GlobalCopywriter, String>)((Function1)PasteExportService::doExport$lambda$10$lambda$7), (Function1<? super GlobalCopywriter, String>)((Function1)arg_0 -> PasteExportService.doExport$lambda$10$lambda$8(exportFileName, arg_0)), MessageType.Success, null);
                } else {
                    NotificationManager.sendNotification$default(((PasteExportService)$this$doExport_u24lambda_u2410).notificationManager, PasteExportService::doExport$lambda$10$lambda$9, null, MessageType.Warning, null, 10, null);
                }
                updateProgress.invoke((Object)Float.valueOf(1.0f));
                $this$doExport_u24lambda_u2410 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$doExport_u24lambda_u2410 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$doExport_u24lambda_u2410;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object e = $this$doExport_u24lambda_u2410 = throwable;
                boolean bl = false;
                updateProgress.invoke((Object)Float.valueOf(-1.0f));
                this.logger.error((Throwable)e, PasteExportService::doExport$lambda$13$lambda$11);
                NotificationManager.sendNotification$default(this.notificationManager, PasteExportService::doExport$lambda$13$lambda$12, null, MessageType.Error, null, 10, null);
            }
            Object $this$doExport_u24lambda_u2415 = object;
            boolean bl = false;
            Path path = exportTempPath;
            if (path == null) break block5;
            Path it = path;
            boolean bl2 = false;
            this.fileUtils.deleteFile-IoAF18A(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long exportPasteData(Path basePath, PasteExportParam pasteExportParam, long index, PasteData pasteData, BufferedSink sink) {
        Object object;
        Object $this$exportPasteData_u24lambda_u2418;
        Object object2 = this;
        try {
            void $this$filterTo$iv$iv;
            Iterator $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            $this$exportPasteData_u24lambda_u2418 = object2;
            boolean bl = false;
            Iterable iterable = pasteData.getPasteAppearItems();
            boolean $i$f$filterIsInstance = false;
            void var12_14 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PasteFiles)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl2;
                PasteFiles pasteData2 = (PasteFiles)element$iv$iv;
                boolean bl3 = false;
                Long l = pasteExportParam.getMaxFileSize();
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl4 = false;
                    boolean bl5 = pasteData2.getSize() <= pasteExportParam.getMaxFileSize();
                    bl2 = !bl5;
                } else {
                    bl2 = false;
                }
                boolean bl6 = !bl2;
                if (!bl6) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List pasteFilesList = (List)destination$iv$iv;
            for (PasteFiles pasteFiles : pasteFilesList) {
                super.copyResource(basePath, index, pasteData, pasteFiles);
            }
            String json = pasteData.toJson();
            String base64 = ((PasteExportService)$this$exportPasteData_u24lambda_u2418).codecsUtils.base64Encode(StringsKt.encodeToByteArray((String)json));
            sink.write(StringsKt.encodeToByteArray((String)base64));
            sink.writeUtf8("\n");
            $this$exportPasteData_u24lambda_u2418 = Result.constructor-impl((Object)1L);
        }
        catch (Throwable bl) {
            $this$exportPasteData_u24lambda_u2418 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$exportPasteData_u24lambda_u2418;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            this.logger.error(e, () -> PasteExportService.exportPasteData$lambda$20$lambda$19(pasteData));
            object = 0L;
        }
        return ((Number)object).longValue();
    }

    private final void copyResource(Path basePath, long index, PasteData pasteData, PasteFiles pasteFiles) {
        Path path = Path.resolve$default((Path)Path.resolve$default((Path)basePath, (String)pasteData.getAppInstanceId(), (boolean)false, (int)2, null), (String)String.valueOf(index), (boolean)false, (int)2, null);
        this.userDataPathProvider.autoCreateDir(path);
        for (Path filePath : pasteFiles.getFilePaths(this.userDataPathProvider)) {
            this.fileUtils.copyPath-gIAlu-s(filePath, Path.resolve$default((Path)path, (String)filePath.name(), (boolean)false, (int)2, null));
        }
    }

    private final void compressExportFile(Path basePath, PasteExportParam pasteExportParam, String exportFileName) {
        BufferedSink bufferedSink = pasteExportParam.exportBufferedSink(exportFileName);
        if (bufferedSink != null) {
            BufferedSink bufferedSink2 = bufferedSink;
            boolean bl = false;
            Object object = this.compressUtils.zipDir-gIAlu-s(basePath, bufferedSink2);
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl2 = false;
                PasteExportService pasteExportService = this;
                try {
                    PasteExportService $this$compressExportFile_u24lambda_u2425_u24lambda_u2422_u24lambda_u2421 = pasteExportService;
                    boolean bl3 = false;
                    bufferedSink2.flush();
                    bufferedSink2.close();
                    Object object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl4 = false;
                this.logger.error(PasteExportService::compressExportFile$lambda$25$lambda$24$lambda$23);
                throw new PasteException(StandardErrorCode.EXPORT_FAIL.toErrorCode(), "compress export file fail");
            }
        } else {
            PasteExportService $this$compressExportFile_u24lambda_u2427 = this;
            boolean bl = false;
            $this$compressExportFile_u24lambda_u2427.logger.error(PasteExportService::compressExportFile$lambda$27$lambda$26);
            throw new PasteException(StandardErrorCode.EXPORT_FAIL.toErrorCode(), "cant to write fail");
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final List doExport$lambda$10$lambda$6$lambda$3$lambda$1(PasteExportService $this_runCatching, PasteExportParam $pasteExportParam, long id, long limit) {
        return $this_runCatching.pasteDao.getExportPasteData(id, limit, $pasteExportParam);
    }

    private static final Unit doExport$lambda$10$lambda$6$lambda$3$lambda$2(Ref.LongRef $count, PasteExportService $this_runCatching, Path $basePath, PasteExportParam $pasteExportParam, BufferedSink $sink, long $exportCount, Function1 $updateProgress, PasteData pasteData) {
        Intrinsics.checkNotNullParameter((Object)pasteData, (String)"pasteData");
        $count.element += $this_runCatching.exportPasteData($basePath, $pasteExportParam, $count.element, pasteData, $sink);
        float currentProgress = $count.element != $exportCount ? (float)$count.element / (float)$exportCount : 0.99f;
        $updateProgress.invoke((Object)Float.valueOf(currentProgress));
        return Unit.INSTANCE;
    }

    private static final Object doExport$lambda$10$lambda$6$lambda$5$lambda$4() {
        return "read pasteData list fail";
    }

    private static final Unit doExport$lambda$10$lambda$6(PasteExportService $this_runCatching, PasteExportParam $pasteExportParam, Ref.LongRef $count, Path $basePath, Function1 $updateProgress, BufferedSink sink) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Object object2 = $this_runCatching;
            try {
                PasteExportService $this$doExport_u24lambda_u2410_u24lambda_u246_u24lambda_u243 = object2;
                boolean bl = false;
                long exportCount = $this$doExport_u24lambda_u2410_u24lambda_u246_u24lambda_u243.pasteDao.getExportNum($pasteExportParam);
                object = Result.constructor-impl((Object)PasteDao.batchReadPasteData$default($this$doExport_u24lambda_u2410_u24lambda_u246_u24lambda_u243.pasteDao, 0L, (arg_0, arg_1) -> PasteExportService.doExport$lambda$10$lambda$6$lambda$3$lambda$1($this$doExport_u24lambda_u2410_u24lambda_u246_u24lambda_u243, $pasteExportParam, arg_0, arg_1), arg_0 -> PasteExportService.doExport$lambda$10$lambda$6$lambda$3$lambda$2($count, $this$doExport_u24lambda_u2410_u24lambda_u246_u24lambda_u243, $basePath, $pasteExportParam, sink, exportCount, $updateProgress, arg_0), 1, null));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object e = object = throwable;
            boolean bl = false;
            $this_runCatching.logger.error((Throwable)e, PasteExportService::doExport$lambda$10$lambda$6$lambda$5$lambda$4);
        }
        return Unit.INSTANCE;
    }

    private static final String doExport$lambda$10$lambda$7(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("export_successful", new Object[0]);
    }

    private static final String doExport$lambda$10$lambda$8(String $exportFileName, GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $exportFileName;
    }

    private static final String doExport$lambda$10$lambda$9(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("no_data_found", new Object[0]);
    }

    private static final Object doExport$lambda$13$lambda$11() {
        return "export pasteData failed";
    }

    private static final String doExport$lambda$13$lambda$12(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("export_fail", new Object[0]);
    }

    private static final Object exportPasteData$lambda$20$lambda$19(PasteData $pasteData) {
        return "export pasteData fail, id = " + $pasteData.getId();
    }

    private static final Object compressExportFile$lambda$25$lambda$24$lambda$23() {
        return "compress export file fail";
    }

    private static final Object compressExportFile$lambda$27$lambda$26() {
        return "cant to write fail";
    }

    public static final /* synthetic */ Mutex access$getMutex$p(PasteExportService $this) {
        return $this.mutex;
    }

    public static final /* synthetic */ void access$doExport(PasteExportService $this, PasteExportParam pasteExportParam, Function1 updateProgress) {
        $this.doExport(pasteExportParam, (Function1<? super Float, Unit>)updateProgress);
    }
}

