/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppInfo;
import com.crosspaste.app.AppLaunchState;
import com.crosspaste.db.paste.PasteDao;
import com.crosspaste.i18n.GlobalCopywriter;
import com.crosspaste.paste.PasteCollection;
import com.crosspaste.paste.PasteData;
import com.crosspaste.paste.PasteType;
import com.crosspaste.paste.SearchContentService;
import com.crosspaste.paste.item.PasteItem;
import com.crosspaste.paste.item.TextPasteItem;
import com.crosspaste.paste.item.UrlPasteItem;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b'\u0018\u0000 02\u00020\u0001:\u00010B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001c\u0010\u0013J\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u0011\u00a2\u0006\u0004\b#\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010&R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010'R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010(R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010/\u001a\u00020,8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00061"}, d2={"Lcom/crosspaste/paste/GuidePasteDataService;", "", "Lcom/crosspaste/app/AppInfo;", "appInfo", "Lcom/crosspaste/app/AppLaunchState;", "appLaunchState", "Lcom/crosspaste/i18n/GlobalCopywriter;", "copywriter", "Lcom/crosspaste/db/paste/PasteDao;", "pasteDao", "Lcom/crosspaste/paste/SearchContentService;", "searchContentService", "<init>", "(Lcom/crosspaste/app/AppInfo;Lcom/crosspaste/app/AppLaunchState;Lcom/crosspaste/i18n/GlobalCopywriter;Lcom/crosspaste/db/paste/PasteDao;Lcom/crosspaste/paste/SearchContentService;)V", "", "isFirstLaunch", "()Z", "", "saveData", "()V", "", "index", "Lkotlinx/serialization/json/JsonObject;", "buildJson", "(I)Lkotlinx/serialization/json/JsonObject;", "jsonObject", "getGuideIndexFromJson", "(Lkotlinx/serialization/json/JsonObject;)Ljava/lang/Integer;", "updateData", "Lcom/crosspaste/paste/item/PasteItem;", "getGuidePasteItem", "(I)Lcom/crosspaste/paste/item/PasteItem;", "Lcom/crosspaste/paste/PasteData;", "getGuidePasteData", "(I)Lcom/crosspaste/paste/PasteData;", "initData", "Lcom/crosspaste/app/AppInfo;", "Lcom/crosspaste/app/AppLaunchState;", "Lcom/crosspaste/i18n/GlobalCopywriter;", "Lcom/crosspaste/db/paste/PasteDao;", "Lcom/crosspaste/paste/SearchContentService;", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "", "getGuideKey", "()Ljava/lang/String;", "guideKey", "Companion", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGuidePasteDataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuidePasteDataService.kt\ncom/crosspaste/paste/GuidePasteDataService\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n29#2,3:150\n1869#3,2:153\n*S KotlinDebug\n*F\n+ 1 GuidePasteDataService.kt\ncom/crosspaste/paste/GuidePasteDataService\n*L\n43#1:150,3\n52#1:153,2\n*E\n"})
public abstract class GuidePasteDataService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppInfo appInfo;
    @NotNull
    private final AppLaunchState appLaunchState;
    @NotNull
    private final GlobalCopywriter copywriter;
    @NotNull
    private final PasteDao pasteDao;
    @NotNull
    private final SearchContentService searchContentService;
    @NotNull
    private final CodecsUtils codecsUtils;
    public static final int $stable = 8;
    @NotNull
    public static final String CROSSPASTE_GUIDE = "CrossPaste Guide";

    public GuidePasteDataService(@NotNull AppInfo appInfo, @NotNull AppLaunchState appLaunchState, @NotNull GlobalCopywriter copywriter, @NotNull PasteDao pasteDao, @NotNull SearchContentService searchContentService) {
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        Intrinsics.checkNotNullParameter((Object)appLaunchState, (String)"appLaunchState");
        Intrinsics.checkNotNullParameter((Object)copywriter, (String)"copywriter");
        Intrinsics.checkNotNullParameter((Object)pasteDao, (String)"pasteDao");
        Intrinsics.checkNotNullParameter((Object)searchContentService, (String)"searchContentService");
        this.appInfo = appInfo;
        this.appLaunchState = appLaunchState;
        this.copywriter = copywriter;
        this.pasteDao = pasteDao;
        this.searchContentService = searchContentService;
        this.codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
    }

    @NotNull
    public abstract String getGuideKey();

    public final boolean isFirstLaunch() {
        return this.appLaunchState.getFirstLaunch();
    }

    public final void saveData() {
        for (int i = 5; -1 < i; --i) {
            PasteData pasteData = this.getGuidePasteData(i);
            PasteDao.createPasteData$default(this.pasteDao, pasteData, null, 2, null);
        }
    }

    private final JsonObject buildJson(int index) {
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$buildJson_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$buildJson_u24lambda_u240, (String)"guideIndex", (Number)index);
        return builder$iv.build();
    }

    private final Integer getGuideIndexFromJson(JsonObject jsonObject) {
        JsonElement jsonElement = (JsonElement)jsonObject.get((Object)"guideIndex");
        return jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? Integer.valueOf(JsonElementKt.getInt((JsonPrimitive)jsonElement)) : null;
    }

    public final void updateData() {
        List<PasteData> pasteDataList2 = this.pasteDao.searchBySource(CROSSPASTE_GUIDE);
        if (!((Collection)pasteDataList2).isEmpty()) {
            Iterable $this$forEach$iv = pasteDataList2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonObject extraInfo;
                PasteItem pasteItem;
                PasteData pasteData = (PasteData)element$iv;
                boolean bl = false;
                if (pasteData.getPasteAppearItem() == null) continue;
                boolean bl2 = false;
                long oldSize = pasteItem.getSize();
                if (pasteItem.getExtraInfo() == null) continue;
                boolean bl3 = false;
                Integer n = this.getGuideIndexFromJson(extraInfo);
                if (n == null) continue;
                int index = ((Number)n).intValue();
                boolean bl4 = false;
                PasteItem newPasteItem = this.getGuidePasteItem(index);
                this.pasteDao.updatePasteAppearItem(pasteData.getId(), pasteItem, this.searchContentService.createSearchContent(pasteData.getSource(), pasteItem.getSearchContent()), newPasteItem.getSize() - oldSize);
            }
        }
    }

    private final PasteItem getGuidePasteItem(int index) {
        PasteItem pasteItem;
        JsonObject extraInfo = this.buildJson(index);
        if (index == 5) {
            String githubUrl = "https://github.com/CrossPaste/crosspaste-desktop";
            byte[] githubUrlBytes = StringsKt.encodeToByteArray((String)githubUrl);
            String githubUrlHash = this.codecsUtils.hash(githubUrlBytes);
            long githubUrlSize = githubUrlBytes.length;
            List list = CollectionsKt.emptyList();
            pasteItem = (PasteItem)new UrlPasteItem(list, githubUrlHash, githubUrlSize, githubUrl, extraInfo);
        } else {
            String text = StringsKt.replace$default((String)this.copywriter.getText(this.getGuideKey() + index, new Object[0]), (String)"\\n", (String)"\n", (boolean)false, (int)4, null);
            byte[] byteArray = StringsKt.encodeToByteArray((String)text);
            long size = byteArray.length;
            String hash = this.codecsUtils.hash(byteArray);
            List list = CollectionsKt.emptyList();
            pasteItem = (PasteItem)new TextPasteItem(list, hash, size, text, extraInfo);
        }
        return pasteItem;
    }

    private final PasteData getGuidePasteData(int index) {
        PasteData pasteData;
        if (index == 5) {
            String githubUrl = "https://github.com/CrossPaste/crosspaste-desktop";
            byte[] githubUrlBytes = StringsKt.encodeToByteArray((String)githubUrl);
            String githubUrlHash = this.codecsUtils.hash(githubUrlBytes);
            long githubUrlSize = githubUrlBytes.length;
            pasteData = new PasteData(0L, this.appInfo.getAppInstanceId(), false, this.getGuidePasteItem(index), new PasteCollection(CollectionsKt.emptyList()), PasteType.Companion.getURL_TYPE().getType(), CROSSPASTE_GUIDE, githubUrlSize, githubUrlHash, 0L, null, 1, false, 5633, null);
        } else {
            String text = StringsKt.replace$default((String)this.copywriter.getText(this.getGuideKey() + index, new Object[0]), (String)"\\n", (String)"\n", (boolean)false, (int)4, null);
            byte[] byteArray = StringsKt.encodeToByteArray((String)text);
            long size = byteArray.length;
            String hash = this.codecsUtils.hash(byteArray);
            pasteData = new PasteData(0L, this.appInfo.getAppInstanceId(), false, this.getGuidePasteItem(index), new PasteCollection(CollectionsKt.emptyList()), PasteType.Companion.getTEXT_TYPE().getType(), CROSSPASTE_GUIDE, size, hash, 0L, null, 1, false, 5633, null);
        }
        return pasteData;
    }

    public final void initData() {
        if (this.isFirstLaunch() && this.pasteDao.getSize(true) == 0L) {
            this.saveData();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/crosspaste/paste/GuidePasteDataService$Companion;", "", "<init>", "()V", "", "CROSSPASTE_GUIDE", "Ljava/lang/String;", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

