/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.paste;

import com.crosspaste.app.DesktopAppWindowManager;
import com.crosspaste.config.AppConfig;
import com.crosspaste.config.ConfigManager;
import com.crosspaste.db.paste.PasteDao;
import com.crosspaste.notification.NotificationManager;
import com.crosspaste.paste.AbstractPasteboardService;
import com.crosspaste.paste.CurrentPaste;
import com.crosspaste.paste.LinuxPasteboardService;
import com.crosspaste.paste.MacosPasteboardService;
import com.crosspaste.paste.TransferableConsumer;
import com.crosspaste.paste.TransferableProducer;
import com.crosspaste.paste.WindowsPasteboardService;
import com.crosspaste.platform.Platform;
import com.crosspaste.sound.SoundService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a_\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0001\u001a\u00020\u00002\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/crosspaste/app/DesktopAppWindowManager;", "appWindowManager", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/config/AppConfig;", "Lcom/crosspaste/config/CommonConfigManager;", "configManager", "Lcom/crosspaste/paste/CurrentPaste;", "currentPaste", "Lcom/crosspaste/notification/NotificationManager;", "notificationManager", "Lcom/crosspaste/paste/TransferableConsumer;", "pasteConsumer", "Lcom/crosspaste/paste/TransferableProducer;", "pasteProducer", "Lcom/crosspaste/db/paste/PasteDao;", "pasteDao", "Lcom/crosspaste/platform/Platform;", "platform", "Lcom/crosspaste/sound/SoundService;", "soundService", "Lcom/crosspaste/paste/AbstractPasteboardService;", "getDesktopPasteboardService", "(Lcom/crosspaste/app/DesktopAppWindowManager;Lcom/crosspaste/config/ConfigManager;Lcom/crosspaste/paste/CurrentPaste;Lcom/crosspaste/notification/NotificationManager;Lcom/crosspaste/paste/TransferableConsumer;Lcom/crosspaste/paste/TransferableProducer;Lcom/crosspaste/db/paste/PasteDao;Lcom/crosspaste/platform/Platform;Lcom/crosspaste/sound/SoundService;)Lcom/crosspaste/paste/AbstractPasteboardService;", "app"})
public final class DesktopPasteboardServiceKt {
    @NotNull
    public static final AbstractPasteboardService getDesktopPasteboardService(@NotNull DesktopAppWindowManager appWindowManager, @NotNull ConfigManager<AppConfig> configManager, @NotNull CurrentPaste currentPaste, @NotNull NotificationManager notificationManager, @NotNull TransferableConsumer pasteConsumer, @NotNull TransferableProducer pasteProducer, @NotNull PasteDao pasteDao, @NotNull Platform platform, @NotNull SoundService soundService) {
        AbstractPasteboardService abstractPasteboardService;
        Intrinsics.checkNotNullParameter((Object)appWindowManager, (String)"appWindowManager");
        Intrinsics.checkNotNullParameter(configManager, (String)"configManager");
        Intrinsics.checkNotNullParameter((Object)currentPaste, (String)"currentPaste");
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        Intrinsics.checkNotNullParameter((Object)pasteConsumer, (String)"pasteConsumer");
        Intrinsics.checkNotNullParameter((Object)pasteProducer, (String)"pasteProducer");
        Intrinsics.checkNotNullParameter((Object)pasteDao, (String)"pasteDao");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)soundService, (String)"soundService");
        if (platform.isMacos()) {
            abstractPasteboardService = new MacosPasteboardService(appWindowManager, configManager, currentPaste, notificationManager, pasteConsumer, pasteProducer, pasteDao, soundService);
        } else if (platform.isWindows()) {
            abstractPasteboardService = new WindowsPasteboardService(appWindowManager, configManager, currentPaste, notificationManager, pasteConsumer, pasteProducer, pasteDao, platform, soundService);
        } else if (platform.isLinux()) {
            abstractPasteboardService = new LinuxPasteboardService(appWindowManager, configManager, currentPaste, notificationManager, pasteConsumer, pasteProducer, pasteDao, soundService);
        } else {
            throw new IllegalStateException("Unsupported platform: " + platform.getName());
        }
        return abstractPasteboardService;
    }
}

