/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.net.exception;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.net.exception.ExceptionHandler;
import java.net.BindException;
import java.net.ConnectException;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\b\u00a8\u0006\r"}, d2={"Lcom/crosspaste/net/exception/DesktopExceptionHandler;", "Lcom/crosspaste/net/exception/ExceptionHandler;", "<init>", "()V", "", "throwable", "", "containsPortInUseMessage", "(Ljava/lang/Throwable;)Z", "isExceptionMessageContainsPortInUse", "e", "isPortAlreadyInUse", "isConnectionRefused", "app"})
@StabilityInferred(parameters=0)
public final class DesktopExceptionHandler
extends ExceptionHandler {
    public static final int $stable = 8;

    private final boolean containsPortInUseMessage(Throwable throwable) {
        if (this.isExceptionMessageContainsPortInUse(throwable)) {
            return true;
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            if (this.containsPortInUseMessage(it)) {
                return true;
            }
        }
        Iterator iterator = ArrayIteratorKt.iterator((Object[])throwable.getSuppressed());
        while (iterator.hasNext()) {
            Throwable suppressed = (Throwable)iterator.next();
            Intrinsics.checkNotNull((Object)suppressed);
            if (!this.containsPortInUseMessage(suppressed)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExceptionMessageContainsPortInUse(Throwable throwable) {
        if (!(throwable instanceof BindException)) return false;
        String string2 = throwable.getMessage();
        String string3 = string2;
        if (string2 == null) return false;
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        string3 = string4;
        if (string4 == null) return false;
        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"already in use", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Override
    public boolean isPortAlreadyInUse(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.containsPortInUseMessage(e);
    }

    @Override
    public boolean isConnectionRefused(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e instanceof ConnectException;
    }
}

