/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.net;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.db.sync.HostInfo;
import com.crosspaste.net.HostInfoFilter;
import io.ktor.network.sockets.InetSocketAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0014\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\"R\u001d\u0010'\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u001b\u0010*\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010$\u001a\u0004\b)\u0010\u001c\u00a8\u0006+"}, d2={"Lcom/crosspaste/net/HostInfoFilterImpl;", "Lcom/crosspaste/net/HostInfoFilter;", "", "hostAddress", "", "networkPrefixLength", "<init>", "(Ljava/lang/String;S)V", "Lcom/crosspaste/db/sync/HostInfo;", "hostInfo", "", "filter", "(Lcom/crosspaste/db/sync/HostInfo;)Z", "host", "", "resolveIpBytes", "(Ljava/lang/String;)[B", "a", "b", "", "prefixLength", "compareWithMask", "([B[BI)Z", "", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/lang/String;", "getHostAddress", "()Ljava/lang/String;", "S", "getNetworkPrefixLength", "()S", "selfBytes$delegate", "Lkotlin/Lazy;", "getSelfBytes", "()[B", "selfBytes", "selfMaxBits$delegate", "getSelfMaxBits", "selfMaxBits", "app"})
@StabilityInferred(parameters=0)
public final class HostInfoFilterImpl
implements HostInfoFilter {
    @NotNull
    private final String hostAddress;
    private final short networkPrefixLength;
    @NotNull
    private final Lazy selfBytes$delegate;
    @NotNull
    private final Lazy selfMaxBits$delegate;
    public static final int $stable = 8;

    public HostInfoFilterImpl(@NotNull String hostAddress, short networkPrefixLength) {
        Intrinsics.checkNotNullParameter((Object)hostAddress, (String)"hostAddress");
        this.hostAddress = hostAddress;
        this.networkPrefixLength = networkPrefixLength;
        this.selfBytes$delegate = LazyKt.lazy(() -> HostInfoFilterImpl.selfBytes_delegate$lambda$0(this));
        this.selfMaxBits$delegate = LazyKt.lazy(() -> HostInfoFilterImpl.selfMaxBits_delegate$lambda$1(this));
    }

    @NotNull
    public final String getHostAddress() {
        return this.hostAddress;
    }

    public final short getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    private final byte[] getSelfBytes() {
        Lazy lazy = this.selfBytes$delegate;
        return (byte[])lazy.getValue();
    }

    private final int getSelfMaxBits() {
        Lazy lazy = this.selfMaxBits$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public boolean filter(@NotNull HostInfo hostInfo) {
        Intrinsics.checkNotNullParameter((Object)hostInfo, (String)"hostInfo");
        byte[] byArray = this.resolveIpBytes(hostInfo.getHostAddress());
        if (byArray == null) {
            return false;
        }
        byte[] otherBytes = byArray;
        byte[] byArray2 = this.getSelfBytes();
        if (byArray2 == null) {
            return false;
        }
        byte[] self = byArray2;
        if (self.length != otherBytes.length) {
            return false;
        }
        int maxBits = this.getSelfMaxBits();
        int plen = RangesKt.coerceIn((int)this.networkPrefixLength, (int)0, (int)maxBits);
        return this.compareWithMask(self, otherBytes, plen);
    }

    private final byte[] resolveIpBytes(String host) {
        byte[] byArray;
        try {
            byArray = new InetSocketAddress(host, 0).resolveAddress();
        }
        catch (Throwable throwable) {
            byArray = null;
        }
        return byArray;
    }

    private final boolean compareWithMask(byte[] a, byte[] b, int prefixLength) {
        if (a.length != b.length) {
            return false;
        }
        int fullBytes = prefixLength / 8;
        int remainBits = prefixLength % 8;
        for (int i = 0; i < fullBytes; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        if (remainBits == 0) {
            return true;
        }
        int aa = a[fullBytes] & 0xFF;
        int mask = 255 << 8 - remainBits & 0xFF;
        int bb = b[fullBytes] & 0xFF;
        return (aa & mask) == (bb & mask);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HostInfoFilterImpl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hostAddress, (Object)((HostInfoFilterImpl)other).hostAddress)) {
            return false;
        }
        return this.networkPrefixLength == ((HostInfoFilterImpl)other).networkPrefixLength;
    }

    public int hashCode() {
        int result2 = this.hostAddress.hashCode();
        result2 = 31 * result2 + this.networkPrefixLength;
        return result2;
    }

    private static final byte[] selfBytes_delegate$lambda$0(HostInfoFilterImpl this$0) {
        return this$0.resolveIpBytes(this$0.hostAddress);
    }

    private static final int selfMaxBits_delegate$lambda$1(HostInfoFilterImpl this$0) {
        byte[] byArray = this$0.getSelfBytes();
        return (byArray != null ? byArray.length : 0) * 8;
    }
}

