/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.net;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.net.NetworkInterfaceInfo;
import com.crosspaste.net.NetworkInterfaceService;
import com.crosspaste.utils.ValueProvider;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0011\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0003R\u001a\u0010\u001a\u001a\u00020\u00198\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR&\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u001e8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\"\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001e8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b#\u0010 \u001a\u0004\b$\u0010\"\u00a8\u0006&"}, d2={"Lcom/crosspaste/net/AbstractNetworkInterfaceService;", "Lcom/crosspaste/net/NetworkInterfaceService;", "<init>", "()V", "", "hostAddress", "", "isValidLocalAddress", "(Ljava/lang/String;)Z", "", "Lcom/crosspaste/net/NetworkInterfaceInfo;", "getAllNetworkInterfaceInfo", "()Ljava/util/List;", "Ljava/net/InterfaceAddress;", "addr", "nicName", "processAddress", "(Ljava/net/InterfaceAddress;Ljava/lang/String;)Lcom/crosspaste/net/NetworkInterfaceInfo;", "addresses", "sortAddresses", "(Ljava/util/List;)Ljava/util/List;", "getPreferredNetworkInterface", "()Lcom/crosspaste/net/NetworkInterfaceInfo;", "", "clearProviderCache", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/ValueProvider;", "networkInterfaceInfoProvider", "Lcom/crosspaste/utils/ValueProvider;", "getNetworkInterfaceInfoProvider", "()Lcom/crosspaste/utils/ValueProvider;", "preferredNetworkInterfaceInfo", "getPreferredNetworkInterfaceInfo", "Companion", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAbstractNetworkInterfaceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractNetworkInterfaceService.kt\ncom/crosspaste/net/AbstractNetworkInterfaceService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1617#2,9:120\n1869#2:129\n1870#2:131\n1626#2:132\n1387#2:133\n1475#2,5:134\n1617#2,9:139\n1869#2:148\n1870#2:150\n1626#2:151\n1#3:130\n1#3:149\n*S KotlinDebug\n*F\n+ 1 AbstractNetworkInterfaceService.kt\ncom/crosspaste/net/AbstractNetworkInterfaceService\n*L\n33#1:120,9\n33#1:129\n33#1:131\n33#1:132\n43#1:133\n43#1:134,5\n45#1:139,9\n45#1:148\n45#1:150\n45#1:151\n33#1:130\n45#1:149\n*E\n"})
public abstract class AbstractNetworkInterfaceService
implements NetworkInterfaceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(AbstractNetworkInterfaceService::logger$lambda$0);
    @NotNull
    private final ValueProvider<List<NetworkInterfaceInfo>> networkInterfaceInfoProvider = new ValueProvider();
    @NotNull
    private final ValueProvider<NetworkInterfaceInfo> preferredNetworkInterfaceInfo = new ValueProvider();
    public static final int $stable = 8;
    @NotNull
    private static final String INVALID_END_OCTET_0 = ".0";
    @NotNull
    private static final String INVALID_END_OCTET_1 = ".1";
    @NotNull
    private static final String INVALID_END_OCTET_255 = ".255";

    @NotNull
    protected final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final ValueProvider<List<NetworkInterfaceInfo>> getNetworkInterfaceInfoProvider() {
        return this.networkInterfaceInfoProvider;
    }

    @NotNull
    protected final ValueProvider<NetworkInterfaceInfo> getPreferredNetworkInterfaceInfo() {
        return this.preferredNetworkInterfaceInfo;
    }

    protected final boolean isValidLocalAddress(@NotNull String hostAddress) {
        Intrinsics.checkNotNullParameter((Object)hostAddress, (String)"hostAddress");
        return ((CharSequence)hostAddress).length() > 0 && !StringsKt.endsWith$default((String)hostAddress, (String)INVALID_END_OCTET_0, (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)hostAddress, (String)INVALID_END_OCTET_1, (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)hostAddress, (String)INVALID_END_OCTET_255, (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public List<NetworkInterfaceInfo> getAllNetworkInterfaceInfo() {
        Iterable $this$flatMapTo$iv$iv;
        boolean bl;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        ArrayList<NetworkInterface> arrayList = Collections.list(NetworkInterface.getNetworkInterfaces());
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable $this$mapNotNull$iv = arrayList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NetworkInterface it$iv$iv;
            Object $this$getAllNetworkInterfaceInfo_u24lambda_u244_u24lambda_u241;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            NetworkInterface nic = (NetworkInterface)element$iv$iv;
            boolean bl2 = false;
            Object object = this;
            try {
                $this$getAllNetworkInterfaceInfo_u24lambda_u244_u24lambda_u241 = object;
                boolean bl3 = false;
                $this$getAllNetworkInterfaceInfo_u24lambda_u244_u24lambda_u241 = Result.constructor-impl(!nic.isUp() || nic.isLoopback() || nic.isVirtual() ? null : nic);
            }
            catch (Throwable bl3) {
                $this$getAllNetworkInterfaceInfo_u24lambda_u244_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object = $this$getAllNetworkInterfaceInfo_u24lambda_u244_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object e = $this$getAllNetworkInterfaceInfo_u24lambda_u244_u24lambda_u241 = throwable;
                boolean bl4 = false;
                this.logger.warn((Throwable)e, () -> AbstractNetworkInterfaceService.getAllNetworkInterfaceInfo$lambda$4$lambda$3$lambda$2(nic));
            }
            if ((NetworkInterface)(Result.isFailure-impl((Object)object) ? null : object) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapSequence = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            NetworkInterface nic = (NetworkInterface)element$iv$iv2;
            boolean bl6 = false;
            List<InterfaceAddress> list = nic.getInterfaceAddresses();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getInterfaceAddresses(...)");
            Sequence list$iv$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> AbstractNetworkInterfaceService.getAllNetworkInterfaceInfo$lambda$6$lambda$5(nic, arg_0));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NetworkInterfaceInfo it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl7 = false;
            InterfaceAddress addr = (InterfaceAddress)pair.component1();
            String nicName = (String)pair.component2();
            Object object2 = this;
            try {
                AbstractNetworkInterfaceService $this$getAllNetworkInterfaceInfo_u24lambda_u2410_u24lambda_u247 = object2;
                boolean bl8 = false;
                Intrinsics.checkNotNull((Object)addr);
                Intrinsics.checkNotNull((Object)nicName);
                object = Result.constructor-impl((Object)$this$getAllNetworkInterfaceInfo_u24lambda_u2410_u24lambda_u247.processAddress(addr, nicName));
            }
            catch (Throwable bl8) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl8));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object e = object = throwable;
                boolean bl9 = false;
                this.logger.warn((Throwable)e, () -> AbstractNetworkInterfaceService.getAllNetworkInterfaceInfo$lambda$10$lambda$9$lambda$8(nicName));
            }
            if ((NetworkInterfaceInfo)(Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    protected final NetworkInterfaceInfo processAddress(@NotNull InterfaceAddress addr, @NotNull String nicName) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        Intrinsics.checkNotNullParameter((Object)nicName, (String)"nicName");
        InetAddress address = addr.getAddress();
        if (!(address instanceof Inet4Address)) {
            return null;
        }
        String string2 = ((Inet4Address)address).getHostAddress();
        if (string2 == null) {
            return null;
        }
        String hostAddress = string2;
        short networkPrefixLength = addr.getNetworkPrefixLength();
        if (!this.isValidLocalAddress(hostAddress)) {
            this.logger.debug(() -> AbstractNetworkInterfaceService.processAddress$lambda$11(nicName, hostAddress, networkPrefixLength));
            return null;
        }
        this.logger.info(() -> AbstractNetworkInterfaceService.processAddress$lambda$12(nicName, hostAddress, networkPrefixLength));
        return new NetworkInterfaceInfo(nicName, networkPrefixLength, hostAddress);
    }

    @NotNull
    protected final List<NetworkInterfaceInfo> sortAddresses(@NotNull List<NetworkInterfaceInfo> addresses) {
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                NetworkInterfaceInfo networkInterfaceInfo = (NetworkInterfaceInfo)b;
                boolean bl = false;
                Comparable comparable = Short.valueOf(networkInterfaceInfo.getNetworkPrefixLength());
                networkInterfaceInfo = (NetworkInterfaceInfo)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Short.valueOf(networkInterfaceInfo.getNetworkPrefixLength()));
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    NetworkInterfaceInfo networkInterfaceInfo = (NetworkInterfaceInfo)b;
                    boolean bl = false;
                    Object object = new String[]{"."};
                    String string2 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)networkInterfaceInfo.getHostAddress(), (String[])object, (boolean)false, (int)0, (int)6, null));
                    Comparable comparable = string2 != null && (object = StringsKt.toIntOrNull((String)string2)) != null ? (Comparable)object : (Comparable)Integer.valueOf(Integer.MIN_VALUE);
                    networkInterfaceInfo = (NetworkInterfaceInfo)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    object = new String[]{"."};
                    string2 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)networkInterfaceInfo.getHostAddress(), (String[])object, (boolean)false, (int)0, (int)6, null));
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)(string2 != null && (object = StringsKt.toIntOrNull((String)string2)) != null ? (Comparable)object : (Comparable)Integer.valueOf(Integer.MIN_VALUE)));
                }
                return n;
            }
        };
        return CollectionsKt.sortedWith((Iterable)addresses, (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    NetworkInterfaceInfo networkInterfaceInfo = (NetworkInterfaceInfo)a;
                    boolean bl = false;
                    Comparable comparable = StringsKt.startsWith$default((String)networkInterfaceInfo.getName(), (String)"eth", (boolean)false, (int)2, null) ? (Comparable)Integer.valueOf(0) : (StringsKt.startsWith$default((String)networkInterfaceInfo.getName(), (String)"en", (boolean)false, (int)2, null) ? (Comparable)Integer.valueOf(1) : (Comparable)Integer.valueOf(2));
                    networkInterfaceInfo = (NetworkInterfaceInfo)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)(StringsKt.startsWith$default((String)networkInterfaceInfo.getName(), (String)"eth", (boolean)false, (int)2, null) ? (Comparable)Integer.valueOf(0) : (StringsKt.startsWith$default((String)networkInterfaceInfo.getName(), (String)"en", (boolean)false, (int)2, null) ? (Comparable)Integer.valueOf(1) : (Comparable)Integer.valueOf(2))));
                }
                return n;
            }
        });
    }

    @Override
    @Nullable
    public NetworkInterfaceInfo getPreferredNetworkInterface() {
        return this.preferredNetworkInterfaceInfo.getValue((Function0<NetworkInterfaceInfo>)((Function0)() -> AbstractNetworkInterfaceService.getPreferredNetworkInterface$lambda$17(this)));
    }

    @Override
    public void clearProviderCache() {
        this.networkInterfaceInfoProvider.clear();
        this.preferredNetworkInterfaceInfo.clear();
    }

    @Override
    @NotNull
    public List<NetworkInterfaceInfo> getCurrentUseNetworkInterfaces() {
        return NetworkInterfaceService.super.getCurrentUseNetworkInterfaces();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object getAllNetworkInterfaceInfo$lambda$4$lambda$3$lambda$2(NetworkInterface $nic) {
        return "Failed to check network interface status: " + $nic.getName();
    }

    private static final Pair getAllNetworkInterfaceInfo$lambda$6$lambda$5(NetworkInterface $nic, InterfaceAddress it) {
        return new Pair((Object)it, (Object)$nic.getName());
    }

    private static final Object getAllNetworkInterfaceInfo$lambda$10$lambda$9$lambda$8(String $nicName) {
        return "Failed to process address for interface: " + $nicName;
    }

    private static final Object processAddress$lambda$11(String $nicName, String $hostAddress, short $networkPrefixLength) {
        return "Not a local address, Network interface: " + $nicName + " address: " + $hostAddress + " networkPrefixLength: " + $networkPrefixLength;
    }

    private static final Object processAddress$lambda$12(String $nicName, String $hostAddress, short $networkPrefixLength) {
        return "Local address found, Network interface: " + $nicName + " address: " + $hostAddress + " networkPrefixLength: " + $networkPrefixLength;
    }

    private static final NetworkInterfaceInfo getPreferredNetworkInterface$lambda$17(AbstractNetworkInterfaceService this$0) {
        Object object;
        Object object2 = this$0;
        try {
            AbstractNetworkInterfaceService $this$getPreferredNetworkInterface_u24lambda_u2417_u24lambda_u2416 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)((NetworkInterfaceInfo)CollectionsKt.firstOrNull($this$getPreferredNetworkInterface_u24lambda_u2417_u24lambda_u2416.sortAddresses($this$getPreferredNetworkInterface_u24lambda_u2417_u24lambda_u2416.getAllNetworkInterfaceInfo()))));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (NetworkInterfaceInfo)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/crosspaste/net/AbstractNetworkInterfaceService$Companion;", "", "<init>", "()V", "", "INVALID_END_OCTET_0", "Ljava/lang/String;", "INVALID_END_OCTET_1", "INVALID_END_OCTET_255", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

