/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.module;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.module.ModuleLoader;
import com.crosspaste.module.ModuleLoaderConfig;
import com.crosspaste.net.ClientResponse;
import com.crosspaste.net.ResourcesClient;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import com.crosspaste.utils.RetryUtils;
import io.github.oshai.kotlinlogging.KLogger;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.jvm.javaio.BlockingKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ/\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00138&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0018\u001a\u00020\u00178\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\u00020\u001c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\u00020!8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0014\u0010)\u001a\u00020&8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lcom/crosspaste/module/AbstractModuleLoader;", "Lcom/crosspaste/module/ModuleLoader;", "<init>", "()V", "", "url", "Lokio/Path;", "path", "", "downloadModule", "(Ljava/lang/String;Lokio/Path;)Z", "Ljava/time/Instant;", "currentTime", "", "progress", "lastLogTime", "lastLoggedProgress", "shouldLogProgress", "(Ljava/time/Instant;JLjava/time/Instant;J)Z", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lcom/crosspaste/utils/RetryUtils;", "retryUtils", "Lcom/crosspaste/utils/RetryUtils;", "getRetryUtils", "()Lcom/crosspaste/utils/RetryUtils;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "getFileUtils", "()Lcom/crosspaste/utils/FileUtils;", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "getCodecsUtils", "()Lcom/crosspaste/utils/CodecsUtils;", "Lcom/crosspaste/net/ResourcesClient;", "getResourcesClient", "()Lcom/crosspaste/net/ResourcesClient;", "resourcesClient", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAbstractModuleLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractModuleLoader.kt\ncom/crosspaste/module/AbstractModuleLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public abstract class AbstractModuleLoader
implements ModuleLoader {
    @NotNull
    private final RetryUtils retryUtils = RetryUtils.INSTANCE;
    @NotNull
    private final FileUtils fileUtils = FileUtils_desktopKt.getFileUtils();
    @NotNull
    private final CodecsUtils codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
    public static final int $stable = 8;

    @NotNull
    public abstract KLogger getLogger();

    @Override
    @NotNull
    public RetryUtils getRetryUtils() {
        return this.retryUtils;
    }

    @Override
    @NotNull
    public FileUtils getFileUtils() {
        return this.fileUtils;
    }

    @Override
    @NotNull
    public CodecsUtils getCodecsUtils() {
        return this.codecsUtils;
    }

    @NotNull
    public abstract ResourcesClient getResourcesClient();

    @Override
    public boolean downloadModule(@NotNull String url, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.getFileUtils().deleteFile-IoAF18A(path);
        this.getLogger().info(() -> AbstractModuleLoader.downloadModule$lambda$0(url));
        Boolean bl = (Boolean)this.getResourcesClient().request(url, arg_0 -> AbstractModuleLoader.downloadModule$lambda$6(this, path, arg_0));
        return bl != null ? bl : false;
    }

    private final boolean shouldLogProgress(Instant currentTime, long progress, Instant lastLogTime, long lastLoggedProgress) {
        Duration logInterval = Duration.ofSeconds(5L);
        Duration timeSinceLastLog = Duration.between(lastLogTime, currentTime);
        long progressDelta = progress - lastLoggedProgress;
        return timeSinceLastLog.compareTo(logInterval) >= 0 || progressDelta >= 5L && timeSinceLastLog.compareTo(Duration.ofSeconds(1L)) >= 0 || progress == 100L;
    }

    @Override
    public boolean verifyInstall(@NotNull Path path, @NotNull String sha256) {
        return ModuleLoader.super.verifyInstall(path, sha256);
    }

    @Override
    public void makeInstalled(@NotNull Path installPath) {
        ModuleLoader.super.makeInstalled(installPath);
    }

    @Override
    public boolean installed(@NotNull Path installPath) {
        return ModuleLoader.super.installed(installPath);
    }

    @Override
    @Nullable
    public Object load(@NotNull ModuleLoaderConfig value, @NotNull Continuation<? super Boolean> $completion) {
        return ModuleLoader.super.load(value, $completion);
    }

    private static final Object downloadModule$lambda$0(String $url) {
        return "Downloading: " + $url;
    }

    private static final Object downloadModule$lambda$6$lambda$4$lambda$3$lambda$2(Ref.LongRef $bytesRead, long $progress) {
        return "Downloaded: " + $bytesRead.element + " bytes (" + $progress + "%)";
    }

    private static final Object downloadModule$lambda$6$lambda$5(Path $path) {
        return "Download completed: " + $path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean downloadModule$lambda$6(AbstractModuleLoader this$0, Path $path, ClientResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        long contentLength = response.getContentLength();
        Ref.LongRef bytesRead = new Ref.LongRef();
        Instant lastLogTime = null;
        lastLogTime = Instant.EPOCH;
        long lastLoggedProgress = 0L;
        lastLoggedProgress = -1L;
        Closeable closeable = BlockingKt.toInputStream$default((ByteReadChannel)response.getBody(), null, (int)1, null);
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream($path.toFile());
            int n = 8192;
            closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream output = (BufferedOutputStream)closeable2;
                boolean bl2 = false;
                byte[] buffer = new byte[8192];
                int read = 0;
                while (true) {
                    int n2;
                    int it = n2 = input.read(buffer);
                    boolean bl3 = false;
                    read = it;
                    if (n2 == -1) break;
                    output.write(buffer, 0, read);
                    bytesRead.element += (long)read;
                    Instant currentTime = Instant.now();
                    long progress = contentLength > 0L ? bytesRead.element * (long)100 / contentLength : -1L;
                    Intrinsics.checkNotNull((Object)currentTime);
                    Instant instant = lastLogTime;
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"element");
                    if (!this$0.shouldLogProgress(currentTime, progress, instant, lastLoggedProgress)) continue;
                    this$0.getLogger().info(() -> AbstractModuleLoader.downloadModule$lambda$6$lambda$4$lambda$3$lambda$2(bytesRead, progress));
                    lastLogTime = currentTime;
                    lastLoggedProgress = progress;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this$0.getLogger().info(() -> AbstractModuleLoader.downloadModule$lambda$6$lambda$5($path));
        return true;
    }
}

