/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.log;

import androidx.compose.runtime.internal.StabilityInferred;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.crosspaste.config.DesktopAppConfig;
import com.crosspaste.config.DesktopConfigManager;
import com.crosspaste.log.CrossPasteLogger;
import com.crosspaste.utils.SystemProperty;
import com.crosspaste.utils.SystemProperty_desktop_ktKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0012R\"\u0010\b\u001a\u00020\u00028\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b\b\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011\"\u0004\b\u0014\u0010\u000bR\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000f\u001a\u0004\b\u0016\u0010\u0011R$\u0010\u0018\u001a\u0004\u0018\u00010\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u0004\u0018\u00010\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR$\u0010!\u001a\u0004\u0018\u00010\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u0019\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001d\u00a8\u0006$"}, d2={"Lcom/crosspaste/log/DesktopCrossPasteLogger;", "Lcom/crosspaste/log/CrossPasteLogger;", "", "logPath", "Lcom/crosspaste/config/DesktopConfigManager;", "configManager", "<init>", "(Ljava/lang/String;Lcom/crosspaste/config/DesktopConfigManager;)V", "logLevel", "", "updateRootLogLevel", "(Ljava/lang/String;)V", "Lch/qos/logback/classic/Level;", "getLevel", "(Ljava/lang/String;)Lch/qos/logback/classic/Level;", "Ljava/lang/String;", "getLogPath", "()Ljava/lang/String;", "Lcom/crosspaste/config/DesktopConfigManager;", "getLogLevel", "setLogLevel", "loggerDebugPackages", "getLoggerDebugPackages", "Lch/qos/logback/classic/Logger;", "rootLogger", "Lch/qos/logback/classic/Logger;", "getRootLogger", "()Lch/qos/logback/classic/Logger;", "setRootLogger", "(Lch/qos/logback/classic/Logger;)V", "jThemeLogger", "getJThemeLogger", "setJThemeLogger", "jmDNSLogger", "getJmDNSLogger", "setJmDNSLogger", "app"})
@StabilityInferred(parameters=0)
public final class DesktopCrossPasteLogger
implements CrossPasteLogger {
    @NotNull
    private final String logPath;
    @NotNull
    private final DesktopConfigManager configManager;
    public String logLevel;
    @Nullable
    private final String loggerDebugPackages;
    @Nullable
    private Logger rootLogger;
    @Nullable
    private Logger jThemeLogger;
    @Nullable
    private Logger jmDNSLogger;
    public static final int $stable = 8;

    public DesktopCrossPasteLogger(@NotNull String logPath, @NotNull DesktopConfigManager configManager) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
            Intrinsics.checkNotNullParameter((Object)configManager, (String)"configManager");
            this.logPath = logPath;
            this.configManager = configManager;
            SystemProperty systemProperty = SystemProperty_desktop_ktKt.getSystemProperty();
            DesktopAppConfig config = (DesktopAppConfig)this.configManager.getCurrentConfig();
            String string2 = systemProperty.getOption("loggerLevel");
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                this.setLogLevel(it);
                if (Intrinsics.areEqual((Object)this.getLogLevel(), (Object)"debug") && !config.getEnableDebugMode()) {
                    this.configManager.updateConfig("enableDebugMode", true);
                } else if (!Intrinsics.areEqual((Object)this.getLogLevel(), (Object)"debug") && config.getEnableDebugMode()) {
                    this.configManager.updateConfig("enableDebugMode", false);
                }
            } else {
                DesktopCrossPasteLogger $this$_init__u24lambda_u241 = this;
                boolean bl = false;
                $this$_init__u24lambda_u241.setLogLevel(config.getEnableDebugMode() ? "debug" : "info");
            }
            ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
            Intrinsics.checkNotNull((Object)iLoggerFactory, (String)"null cannot be cast to non-null type ch.qos.logback.classic.LoggerContext");
            LoggerContext context = (LoggerContext)iLoggerFactory;
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)context);
            encoder.setPattern("%date %level [%thread] %logger{10} [%file:%line] %msg%n");
            encoder.start();
            RollingFileAppender rollingFileAppender = new RollingFileAppender();
            rollingFileAppender.setContext((Context)context);
            rollingFileAppender.setFile(this.getLogPath());
            rollingFileAppender.setEncoder((Encoder)encoder);
            TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
            rollingPolicy.setContext((Context)context);
            rollingPolicy.setParent((FileAppender)rollingFileAppender);
            rollingPolicy.setFileNamePattern(this.getLogPath() + ".%d{yyyy-MM-dd}.log");
            rollingPolicy.setMaxHistory(30);
            rollingPolicy.start();
            rollingFileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
            rollingFileAppender.start();
            Logger logger = context.getLogger("ROOT");
            Intrinsics.checkNotNull((Object)logger, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
            Logger logger2 = this.rootLogger = logger;
            if (logger2 != null) {
                logger2.setLevel(this.getLevel(this.getLogLevel()));
            }
            Logger logger3 = this.rootLogger;
            if (logger3 != null) {
                logger3.addAppender((Appender)rollingFileAppender);
            }
            Logger logger4 = context.getLogger("com.jthemedetecor");
            Intrinsics.checkNotNull((Object)logger4, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
            Logger logger5 = this.jThemeLogger = logger4;
            if (logger5 != null) {
                logger5.setLevel(Level.OFF);
            }
            Logger logger6 = context.getLogger("javax.jmdns");
            Intrinsics.checkNotNull((Object)logger6, (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
            Logger logger7 = this.jmDNSLogger = logger6;
            if (logger7 != null) {
                logger7.setLevel(Level.OFF);
            }
            this.loggerDebugPackages = systemProperty.getOption("loggerDebugPackages");
            String string3 = this.getLoggerDebugPackages();
            if (string3 == null) break block10;
            String debugPackages = string3;
            boolean bl = false;
            String[] stringArray = new String[]{","};
            for (String packageName : StringsKt.split$default((CharSequence)debugPackages, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                Logger logger8;
                Intrinsics.checkNotNull((Object)context.getLogger(packageName), (String)"null cannot be cast to non-null type ch.qos.logback.classic.Logger");
                logger8.setLevel(Level.DEBUG);
            }
        }
    }

    @Override
    @NotNull
    public String getLogPath() {
        return this.logPath;
    }

    @Override
    @NotNull
    public String getLogLevel() {
        String string2 = this.logLevel;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"logLevel");
        return null;
    }

    public void setLogLevel(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.logLevel = string2;
    }

    @Override
    @Nullable
    public String getLoggerDebugPackages() {
        return this.loggerDebugPackages;
    }

    @Nullable
    public final Logger getRootLogger() {
        return this.rootLogger;
    }

    public final void setRootLogger(@Nullable Logger logger) {
        this.rootLogger = logger;
    }

    @Nullable
    public final Logger getJThemeLogger() {
        return this.jThemeLogger;
    }

    public final void setJThemeLogger(@Nullable Logger logger) {
        this.jThemeLogger = logger;
    }

    @Nullable
    public final Logger getJmDNSLogger() {
        return this.jmDNSLogger;
    }

    public final void setJmDNSLogger(@Nullable Logger logger) {
        this.jmDNSLogger = logger;
    }

    @Override
    public void updateRootLogLevel(@NotNull String logLevel) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
            Level level = this.getLevel(logLevel);
            if (Intrinsics.areEqual((Object)level, (Object)Level.DEBUG)) {
                this.configManager.updateConfig("enableDebugMode", true);
                Logger logger = this.jThemeLogger;
                if (logger != null) {
                    logger.setLevel(Level.DEBUG);
                }
                Logger logger2 = this.jmDNSLogger;
                if (logger2 != null) {
                    logger2.setLevel(Level.DEBUG);
                }
            } else {
                this.configManager.updateConfig("enableDebugMode", false);
                Logger logger = this.jThemeLogger;
                if (logger != null) {
                    logger.setLevel(Level.OFF);
                }
                Logger logger3 = this.jmDNSLogger;
                if (logger3 != null) {
                    logger3.setLevel(Level.OFF);
                }
            }
            Logger logger = this.rootLogger;
            if (logger == null) break block6;
            logger.setLevel(this.getLevel(logLevel));
        }
    }

    private final Level getLevel(String logLevel) {
        Level level;
        switch (logLevel) {
            case "trace": {
                Level level2 = Level.TRACE;
                level = level2;
                Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"TRACE");
                break;
            }
            case "debug": {
                Level level3 = Level.DEBUG;
                level = level3;
                Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"DEBUG");
                break;
            }
            case "info": {
                Level level4 = Level.INFO;
                level = level4;
                Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"INFO");
                break;
            }
            case "warn": {
                Level level5 = Level.WARN;
                level = level5;
                Intrinsics.checkNotNullExpressionValue((Object)level5, (String)"WARN");
                break;
            }
            case "error": {
                Level level6 = Level.ERROR;
                level = level6;
                Intrinsics.checkNotNullExpressionValue((Object)level6, (String)"ERROR");
                break;
            }
            default: {
                Level level7 = Level.INFO;
                level = level7;
                Intrinsics.checkNotNullExpressionValue((Object)level7, (String)"INFO");
            }
        }
        return level;
    }
}

