/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.image.coil;

import androidx.compose.runtime.internal.StabilityInferred;
import coil3.size.Size;
import coil3.transform.Transformation;
import com.crosspaste.platform.Platform;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.IRect;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\f\u001a\u00060\u0007j\u0002`\b2\n\u0010\t\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u000b\u001a\u00020\nH\u0096@\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0015\u001a\u00020\u00148\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/crosspaste/image/coil/CropTransformation;", "Lcoil3/transform/Transformation;", "Lcom/crosspaste/platform/Platform;", "currentPlatform", "syncPlatform", "<init>", "(Lcom/crosspaste/platform/Platform;Lcom/crosspaste/platform/Platform;)V", "Lorg/jetbrains/skia/Bitmap;", "Lcoil3/Bitmap;", "input", "Lcoil3/size/Size;", "size", "transform", "(Lorg/jetbrains/skia/Bitmap;Lcoil3/size/Size;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "cropTop", "F", "cropBottom", "cropLeft", "cropRight", "", "cacheKey", "Ljava/lang/String;", "getCacheKey", "()Ljava/lang/String;", "app"})
@StabilityInferred(parameters=0)
public final class CropTransformation
extends Transformation {
    private final float cropTop;
    private final float cropBottom;
    private final float cropLeft;
    private final float cropRight;
    @NotNull
    private final String cacheKey;
    public static final int $stable = 8;

    public CropTransformation(@NotNull Platform currentPlatform, @Nullable Platform syncPlatform) {
        Intrinsics.checkNotNullParameter((Object)currentPlatform, (String)"currentPlatform");
        Platform platform = syncPlatform;
        if (platform == null) {
            platform = currentPlatform;
        }
        if (platform.isMacos()) {
            this.cropTop = 0.18f;
            this.cropBottom = 0.18f;
            this.cropLeft = 0.0f;
            this.cropRight = 0.18f;
        } else {
            this.cropTop = 0.0f;
            this.cropBottom = 0.0f;
            this.cropLeft = 0.0f;
            this.cropRight = 0.18f;
        }
        this.cacheKey = "CropTransformation(" + this.cropTop + "," + this.cropBottom + "," + this.cropLeft + "," + this.cropRight + ")";
    }

    @NotNull
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Nullable
    public Object transform(@NotNull Bitmap input, @NotNull Size size, @NotNull Continuation<? super Bitmap> $completion) {
        float topPct = RangesKt.coerceIn((float)this.cropTop, (float)0.0f, (float)1.0f);
        float bottomPct = RangesKt.coerceIn((float)this.cropBottom, (float)0.0f, (float)1.0f);
        float leftPct = RangesKt.coerceIn((float)this.cropLeft, (float)0.0f, (float)1.0f);
        float rightPct = RangesKt.coerceIn((float)this.cropRight, (float)0.0f, (float)1.0f);
        int left = MathKt.roundToInt((float)((float)input.getWidth() * leftPct));
        int top = MathKt.roundToInt((float)((float)input.getHeight() * topPct));
        int right = MathKt.roundToInt((float)((float)input.getWidth() - (float)input.getWidth() * rightPct));
        int bottom = MathKt.roundToInt((float)((float)input.getHeight() - (float)input.getHeight() * bottomPct));
        int width = RangesKt.coerceAtLeast((int)(right - left), (int)1);
        int height = RangesKt.coerceAtLeast((int)(bottom - top), (int)1);
        if (width == input.getWidth() && height == input.getHeight()) {
            return input;
        }
        Bitmap result2 = new Bitmap();
        IRect subsetRect = IRect.Companion.makeXYWH(left, top, width, height);
        boolean ok = input.extractSubset(result2, subsetRect);
        if (ok) {
            return result2;
        }
        Bitmap copy = new Bitmap();
        Bitmap.allocN32Pixels$default((Bitmap)copy, (int)width, (int)height, (boolean)false, (int)4, null);
        Bitmap.readPixels$default((Bitmap)input, null, (int)0, (int)left, (int)top, (int)3, null);
        return copy;
    }
}

