/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.image;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.ColorKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Color;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Surface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/crosspaste/image/PngBackgroundAnalyzer;", "", "<init>", "()V", "", "bytes", "", "sampleSize", "", "bottomWeight", "Landroidx/compose/ui/graphics/Color;", "detect-XeAY9LY", "([BIF)J", "detect", "app"})
@StabilityInferred(parameters=1)
public final class PngBackgroundAnalyzer {
    @NotNull
    public static final PngBackgroundAnalyzer INSTANCE = new PngBackgroundAnalyzer();
    public static final int $stable;

    private PngBackgroundAnalyzer() {
    }

    public final long detect-XeAY9LY(@NotNull byte[] bytes, int sampleSize, float bottomWeight) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Image img = Image.Companion.makeFromEncoded(bytes);
        int w = img.getWidth();
        int h = img.getHeight();
        int s = Math.min(sampleSize, Math.min(w, h));
        Surface surface = Surface.Companion.makeRasterN32Premul(w, h);
        Canvas canvas = surface.getCanvas();
        canvas.drawImage(img, 0.0f, 0.0f);
        Pixmap pixmap = surface.makeImageSnapshot().peekPixels();
        Triple<Long, Long, Long> triple = PngBackgroundAnalyzer.detect_XeAY9LY$cornerAvg(s, pixmap, 0, 0);
        long rTL = ((Number)triple.component1()).longValue();
        long gTL = ((Number)triple.component2()).longValue();
        long bTL = ((Number)triple.component3()).longValue();
        Triple<Long, Long, Long> triple2 = PngBackgroundAnalyzer.detect_XeAY9LY$cornerAvg(s, pixmap, w - s, 0);
        long rTR = ((Number)triple2.component1()).longValue();
        long gTR = ((Number)triple2.component2()).longValue();
        long bTR = ((Number)triple2.component3()).longValue();
        Triple<Long, Long, Long> triple3 = PngBackgroundAnalyzer.detect_XeAY9LY$cornerAvg(s, pixmap, 0, h - s);
        long rBL = ((Number)triple3.component1()).longValue();
        long gBL = ((Number)triple3.component2()).longValue();
        long bBL = ((Number)triple3.component3()).longValue();
        Triple<Long, Long, Long> triple4 = PngBackgroundAnalyzer.detect_XeAY9LY$cornerAvg(s, pixmap, w - s, h - s);
        long rBR = ((Number)triple4.component1()).longValue();
        long gBR = ((Number)triple4.component2()).longValue();
        long bBR = ((Number)triple4.component3()).longValue();
        float topW = 1.0f;
        float tot = topW * (float)2 + bottomWeight * (float)2;
        float r = (PngBackgroundAnalyzer.detect_XeAY9LY$wSum(topW, bottomWeight, rTL, rBL) + PngBackgroundAnalyzer.detect_XeAY9LY$wSum(topW, bottomWeight, rTR, rBR)) / tot;
        float g = (PngBackgroundAnalyzer.detect_XeAY9LY$wSum(topW, bottomWeight, gTL, gBL) + PngBackgroundAnalyzer.detect_XeAY9LY$wSum(topW, bottomWeight, gTR, gBR)) / tot;
        float b = (PngBackgroundAnalyzer.detect_XeAY9LY$wSum(topW, bottomWeight, bTL, bBL) + PngBackgroundAnalyzer.detect_XeAY9LY$wSum(topW, bottomWeight, bTR, bBR)) / tot;
        return ColorKt.Color((int)(0xFF000000 | (int)r << 16 | (int)g << 8 | (int)b));
    }

    private static final Triple<Long, Long, Long> detect_XeAY9LY$cornerAvg(int s, Pixmap pixmap, int x0, int y0) {
        long r = 0L;
        long g = 0L;
        long b = 0L;
        for (int i = 0; i < s; ++i) {
            int dy = i;
            boolean bl = false;
            int n = 0;
            while (n < s) {
                int dx = n++;
                boolean bl2 = false;
                Pixmap pixmap2 = pixmap;
                Intrinsics.checkNotNull((Object)pixmap2);
                int color = pixmap2.getColor(x0 + dx, y0 + dy);
                r += (long)Color.INSTANCE.getR(color);
                g += (long)Color.INSTANCE.getG(color);
                b += (long)Color.INSTANCE.getB(color);
            }
        }
        long cnt = s * s;
        return new Triple((Object)(r / cnt), (Object)(g / cnt), (Object)(b / cnt));
    }

    private static final float detect_XeAY9LY$wSum(float topW, float $bottomWeight, float t, float b) {
        return t * topW + b * $bottomWeight;
    }
}

