/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.image;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.image.AbstractThumbnailLoader;
import com.crosspaste.image.ImageInfoBuilder;
import com.crosspaste.info.PasteInfoKt;
import com.crosspaste.paste.item.PasteFileCoordinate;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.platform.Platform;
import com.crosspaste.platform.macos.MacAppUtils;
import com.crosspaste.utils.LoggerExtension;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.Surface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u001a\u0010\u0019\u001a\u00020\u00188\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001e\u001a\u00020\u001d8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/crosspaste/image/DesktopThumbnailLoader;", "Lcom/crosspaste/image/AbstractThumbnailLoader;", "Lcom/crosspaste/platform/Platform;", "platform", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/platform/Platform;Lcom/crosspaste/path/UserDataPathProvider;)V", "Lcom/crosspaste/paste/item/PasteFileCoordinate;", "pasteFileCoordinate", "Lcom/crosspaste/image/ImageInfoBuilder;", "imageInfoBuilder", "", "readOriginMeta", "(Lcom/crosspaste/paste/item/PasteFileCoordinate;Lcom/crosspaste/image/ImageInfoBuilder;)V", "", "key", "value", "Lokio/Path;", "result", "save", "(Ljava/lang/String;Lcom/crosspaste/paste/item/PasteFileCoordinate;Lokio/Path;)V", "defaultSave", "Lcom/crosspaste/platform/Platform;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "", "thumbnailSize", "I", "getThumbnailSize", "()I", "app"})
@StabilityInferred(parameters=0)
public final class DesktopThumbnailLoader
extends AbstractThumbnailLoader {
    @NotNull
    private final Platform platform;
    @NotNull
    private final KLogger logger;
    private final int thumbnailSize;
    public static final int $stable = 8;

    public DesktopThumbnailLoader(@NotNull Platform platform, @NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        super(userDataPathProvider);
        this.platform = platform;
        this.logger = KotlinLogging.INSTANCE.logger(DesktopThumbnailLoader::logger$lambda$0);
        this.thumbnailSize = 200;
    }

    @Override
    @NotNull
    public KLogger getLogger() {
        return this.logger;
    }

    @Override
    public int getThumbnailSize() {
        return this.thumbnailSize;
    }

    @Override
    public void readOriginMeta(@NotNull PasteFileCoordinate pasteFileCoordinate, @NotNull ImageInfoBuilder imageInfoBuilder) {
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)pasteFileCoordinate, (String)"pasteFileCoordinate");
            Intrinsics.checkNotNullParameter((Object)imageInfoBuilder, (String)"imageInfoBuilder");
            Object object2 = this;
            try {
                ImageInfoBuilder imageInfoBuilder2;
                DesktopThumbnailLoader $this$readOriginMeta_u24lambda_u242 = object2;
                boolean bl = false;
                Properties properties = new Properties();
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream($this$readOriginMeta_u24lambda_u242.getOriginMetaPath(pasteFileCoordinate).toNioPath(), Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                InputStream inputStream2 = inputStream;
                int n = 8192;
                properties.load(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n));
                String string2 = properties.getProperty("dimensions");
                if (string2 != null) {
                    String it = string2;
                    boolean bl2 = false;
                    imageInfoBuilder2 = imageInfoBuilder.add(PasteInfoKt.createPasteInfoWithoutConverter("dimensions", it));
                } else {
                    imageInfoBuilder2 = null;
                }
                object = Result.constructor-impl(imageInfoBuilder2);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block4;
            Object e = object = throwable;
            boolean bl = false;
            this.getLogger().warn((Throwable)e, () -> DesktopThumbnailLoader.readOriginMeta$lambda$4$lambda$3(pasteFileCoordinate));
        }
    }

    @Override
    public void save(@NotNull String key, @NotNull PasteFileCoordinate value, @NotNull Path result2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (this.platform.isMacos()) {
            Path metadataPath = this.getOriginMetaPath(value);
            LoggerExtension.INSTANCE.logExecutionTime(this.getLogger(), "Create thumbnail by mac api for file: " + value.getFilePath(), () -> DesktopThumbnailLoader.save$lambda$5(value, result2, metadataPath, this, key));
        } else {
            LoggerExtension.INSTANCE.logExecutionTime(this.getLogger(), "Create thumbnail by default api for file: " + value.getFilePath(), () -> DesktopThumbnailLoader.save$lambda$6(this, key, value, result2));
        }
    }

    private final void defaultSave(String key, PasteFileCoordinate value, Path result2) {
        block3: {
            byte[] byArray = Files.readAllBytes(value.getFilePath().toNioPath());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            byte[] bytes = byArray;
            int fileSize = bytes.length;
            Image originalImage = Image.Companion.makeFromEncoded(bytes);
            int originalWidth = originalImage.getWidth();
            int originalHeight = originalImage.getHeight();
            int thumbnailWidth = 0;
            int thumbnailHeight = 0;
            if (originalWidth <= originalHeight) {
                thumbnailWidth = this.getThumbnailSize();
                thumbnailHeight = this.getThumbnailSize() * originalHeight / originalWidth;
            } else {
                thumbnailWidth = this.getThumbnailSize() * originalWidth / originalHeight;
                thumbnailHeight = this.getThumbnailSize();
            }
            Surface surface = Surface.Companion.makeRasterN32Premul(thumbnailWidth, thumbnailHeight);
            Canvas canvas = surface.getCanvas();
            float scale = Math.min((float)thumbnailWidth / (float)originalWidth, (float)thumbnailHeight / (float)originalHeight);
            float dx = ((float)thumbnailWidth - (float)originalWidth * scale) / (float)2;
            float dy = ((float)thumbnailHeight - (float)originalHeight * scale) / (float)2;
            canvas.drawImageRect(originalImage, Rect.Companion.makeWH((float)originalImage.getWidth(), (float)originalImage.getHeight()), Rect.Companion.makeXYWH(dx, dy, (float)originalImage.getWidth() * scale, (float)originalImage.getHeight() * scale), null);
            Object object = Image.encodeToData$default((Image)surface.makeImageSnapshot(), null, (int)0, (int)3, null);
            if (object == null) break block3;
            byte[] byArray2 = object.getBytes();
            object = byArray2;
            if (byArray2 != null) {
                Object it = object;
                boolean bl = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                Files.write(result2.toNioPath(), (byte[])it, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Properties properties = new Properties();
                properties.setProperty("size", String.valueOf(fileSize));
                properties.setProperty("dimensions", originalWidth + " x " + originalHeight);
                OpenOption[] openOptionArray2 = new OpenOption[]{};
                OutputStream outputStream = Files.newOutputStream(this.getOriginMetaPath(value).toNioPath(), Arrays.copyOf(openOptionArray2, openOptionArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                OutputStream outputStream2 = outputStream;
                int n = 8192;
                properties.store(outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2, n), null);
            }
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object readOriginMeta$lambda$4$lambda$3(PasteFileCoordinate $pasteFileCoordinate) {
        return "Failed to read meta data for file: " + $pasteFileCoordinate.getFilePath();
    }

    private static final Unit save$lambda$5(PasteFileCoordinate $value, Path $result, Path $metadataPath, DesktopThumbnailLoader this$0, String $key) {
        if (!MacAppUtils.INSTANCE.createThumbnail($value.getFilePath().toString(), $result.toString(), $metadataPath.toString())) {
            this$0.defaultSave($key, $value, $result);
        }
        return Unit.INSTANCE;
    }

    private static final Unit save$lambda$6(DesktopThumbnailLoader this$0, String $key, PasteFileCoordinate $value, Path $result) {
        this$0.defaultSave($key, $value, $result);
        return Unit.INSTANCE;
    }
}

