/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.image;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.DesktopImageConverters_desktopKt;
import com.crosspaste.image.PlatformImage;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/crosspaste/image/DesktopQRCodeImage;", "Lcom/crosspaste/image/PlatformImage;", "", "data", "<init>", "([B)V", "", "width", "height", "", "toImage", "(II)Ljava/lang/Object;", "Lcom/google/zxing/qrcode/QRCodeWriter;", "writer", "Lcom/google/zxing/qrcode/QRCodeWriter;", "app"})
@StabilityInferred(parameters=0)
public final class DesktopQRCodeImage
extends PlatformImage {
    @NotNull
    private final QRCodeWriter writer;
    public static final int $stable = 8;

    public DesktopQRCodeImage(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data);
        this.writer = new QRCodeWriter();
    }

    @Override
    @NotNull
    public Object toImage(int width, int height) {
        BitMatrix bitMatrix = this.writer.encode(StringsKt.decodeToString((byte[])this.getData()), BarcodeFormat.QR_CODE, width, height);
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
            }
        }
        return DesktopImageConverters_desktopKt.toComposeImageBitmap((BufferedImage)image);
    }
}

