/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.image;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.image.ImageHandler;
import com.crosspaste.image.ImageWriter;
import com.crosspaste.image.WebpImageWriter;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import com.crosspaste.utils.OkioPathExtensionKt;
import io.ktor.utils.io.ByteChannelCtorKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.jvm.javaio.BlockingKt;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.Source;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\r\u0010\u0011J\u0019\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\r\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R&\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00190\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/crosspaste/image/DesktopImageHandler;", "Lcom/crosspaste/image/ImageHandler;", "Ljava/awt/image/BufferedImage;", "<init>", "()V", "image", "", "formatName", "Lokio/Path;", "imagePath", "", "writeImage", "(Ljava/awt/image/BufferedImage;Ljava/lang/String;Lokio/Path;)Z", "readImage", "(Lokio/Path;)Ljava/awt/image/BufferedImage;", "Lkotlinx/io/Source;", "source", "(Lkotlinx/io/Source;)Ljava/awt/image/BufferedImage;", "Lio/ktor/utils/io/ByteReadChannel;", "byteReadChannel", "(Lio/ktor/utils/io/ByteReadChannel;)Ljava/awt/image/BufferedImage;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "", "Lcom/crosspaste/image/ImageWriter;", "specialFormatWriteMap", "Ljava/util/Map;", "app"})
@StabilityInferred(parameters=0)
public final class DesktopImageHandler
implements ImageHandler<BufferedImage> {
    @NotNull
    public static final DesktopImageHandler INSTANCE = new DesktopImageHandler();
    @NotNull
    private static final FileUtils fileUtils = FileUtils_desktopKt.getFileUtils();
    @NotNull
    private static final Map<String, ImageWriter<BufferedImage>> specialFormatWriteMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"webp", (Object)new WebpImageWriter()));
    public static final int $stable = 8;

    private DesktopImageHandler() {
    }

    @Override
    public boolean writeImage(@NotNull BufferedImage image, @NotNull String formatName, @NotNull Path imagePath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)formatName, (String)"formatName");
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        ImageWriter<BufferedImage> imageWriter = specialFormatWriteMap.get(formatName);
        if (imageWriter != null) {
            bl = imageWriter.writeImage(image, formatName, imagePath);
        } else {
            DesktopImageHandler $this$writeImage_u24lambda_u240 = this;
            boolean bl2 = false;
            FileUtils.createDir-gIAlu-s$default((FileUtils)fileUtils, (Path)OkioPathExtensionKt.getNoOptionParent((Path)imagePath), (boolean)false, (int)2, null);
            if (!ImageIO.write((RenderedImage)image, formatName, imagePath.toFile())) {
                BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                Graphics2D g2d = convertedImage.createGraphics();
                g2d.drawImage((Image)image, 0, 0, null);
                g2d.dispose();
                bl = ImageIO.write((RenderedImage)convertedImage, formatName, imagePath.toFile());
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public BufferedImage readImage(@NotNull Path imagePath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        Object object2 = this;
        try {
            DesktopImageHandler $this$readImage_u24lambda_u241 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)ImageIO.read(imagePath.toFile()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (BufferedImage)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @Override
    @Nullable
    public BufferedImage readImage(@NotNull Source source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        return this.readImage(ByteChannelCtorKt.ByteReadChannel((Source)source2));
    }

    @Override
    @Nullable
    public BufferedImage readImage(@NotNull ByteReadChannel byteReadChannel) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)byteReadChannel, (String)"byteReadChannel");
        Object object2 = this;
        try {
            DesktopImageHandler $this$readImage_u24lambda_u242 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)ImageIO.read(BlockingKt.toInputStream$default((ByteReadChannel)byteReadChannel, null, (int)1, null)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (BufferedImage)(Result.isFailure-impl((Object)object2) ? null : object2);
    }
}

