/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.image;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import com.crosspaste.app.AppFileType;
import com.crosspaste.image.DesktopIconColorExtractor;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.utils.ColorUtils;
import com.crosspaste.utils.DispatcherUtils_desktopKt;
import com.crosspaste.utils.StripedMutex;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Image;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0002QRB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0086@\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J7\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ+\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0#2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001c2\u0006\u0010\"\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010&\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001cH\u0002\u00a2\u0006\u0004\b&\u0010'J%\u0010,\u001a\u00020\u00182\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\u001c2\u0006\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0004\b,\u0010-J1\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001c2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0#H\u0002\u00a2\u0006\u0004\b/\u00100J\u0017\u00103\u001a\u0002012\u0006\u00102\u001a\u000201H\u0002\u00a2\u0006\u0004\b3\u00104J\u0017\u00106\u001a\u00020\u00182\u0006\u00105\u001a\u000201H\u0002\u00a2\u0006\u0004\b6\u00107J\u0017\u00109\u001a\u0002012\u0006\u00108\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b9\u0010:J\u001d\u0010>\u001a\u00020\b2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010B\u001a\u00020\b2\u0006\u0010?\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b@\u0010AJ\u001f\u0010E\u001a\u00020(2\u0006\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\bE\u0010FR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010GR\u0014\u0010I\u001a\u00020H8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bI\u0010JR\"\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u0014\u0010O\u001a\u00020N8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010P\u00a8\u0006S"}, d2={"Lcom/crosspaste/image/DesktopIconColorExtractor;", "", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/path/UserDataPathProvider;)V", "", "source", "Landroidx/compose/ui/graphics/Color;", "getBackgroundColor-6MYuD4A", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBackgroundColor", "", "bytes", "extractColorFromBytes-ijrfgN4", "([B)Landroidx/compose/ui/graphics/Color;", "extractColorFromBytes", "Lorg/jetbrains/skia/Image;", "image", "extractDominantColor-vNxB06k", "(Lorg/jetbrains/skia/Image;)J", "extractDominantColor", "Lorg/jetbrains/skia/Bitmap;", "bitmap", "", "width", "height", "clusterCount", "", "Lcom/crosspaste/image/DesktopIconColorExtractor$ColorCluster;", "extractColorsWithKMeans", "(Lorg/jetbrains/skia/Bitmap;III)Ljava/util/List;", "Lcom/crosspaste/image/DesktopIconColorExtractor$PixelColor;", "pixels", "k", "", "kMeansPlusPlus", "(Ljava/util/List;I)Ljava/util/List;", "selectMedianPixel", "(Ljava/util/List;)Lcom/crosspaste/image/DesktopIconColorExtractor$PixelColor;", "", "weights", "Lkotlin/random/Random;", "random", "weightedSelection", "(Ljava/util/List;Lkotlin/random/Random;)I", "initialClusters", "performStableKMeans", "(Ljava/util/List;Ljava/util/List;)Ljava/util/List;", "", "hue", "getModernColorWeight", "(F)F", "h", "huePreferRank", "(F)I", "cluster", "saturation", "(Lcom/crosspaste/image/DesktopIconColorExtractor$ColorCluster;)F", "clusters", "selectBestBackgroundColor-vNxB06k", "(Ljava/util/List;)J", "selectBestBackgroundColor", "color", "enhanceColorForBackground-l2rxGTc", "(J)J", "enhanceColorForBackground", "p1", "p2", "colorDistance", "(Lcom/crosspaste/image/DesktopIconColorExtractor$PixelColor;Lcom/crosspaste/image/DesktopIconColorExtractor$ColorCluster;)D", "Lcom/crosspaste/path/UserDataPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "", "colorCache", "Ljava/util/Map;", "Lcom/crosspaste/utils/StripedMutex;", "mutex", "Lcom/crosspaste/utils/StripedMutex;", "PixelColor", "ColorCluster", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesktopIconColorExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopIconColorExtractor.kt\ncom/crosspaste/image/DesktopIconColorExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,404:1\n1563#2:405\n1634#2,3:406\n1068#2:409\n1803#2,3:410\n1563#2:413\n1634#2,2:414\n1636#2:417\n1056#2:418\n1563#2:419\n1634#2,3:420\n1869#2,2:423\n1869#2:425\n2423#2,14:426\n1870#2:440\n1068#2:441\n774#2:442\n865#2,2:443\n1#3:416\n*S KotlinDebug\n*F\n+ 1 DesktopIconColorExtractor.kt\ncom/crosspaste/image/DesktopIconColorExtractor\n*L\n127#1:405\n127#1:406,3\n137#1:409\n152#1:410,3\n164#1:413\n164#1:414,2\n164#1:417\n181#1:418\n215#1:419\n215#1:420,3\n222#1:423,2\n226#1:425\n228#1:426,14\n226#1:440\n275#1:441\n329#1:442\n329#1:443,2\n*E\n"})
public final class DesktopIconColorExtractor {
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Map<String, Color> colorCache;
    @NotNull
    private final StripedMutex mutex;
    public static final int $stable = 8;

    public DesktopIconColorExtractor(@NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.userDataPathProvider = userDataPathProvider;
        this.logger = KotlinLogging.INSTANCE.logger(DesktopIconColorExtractor::logger$lambda$0);
        this.colorCache = new LinkedHashMap();
        this.mutex = new StripedMutex(0, 1, null);
    }

    @Nullable
    public final Object getBackgroundColor-6MYuD4A(@NotNull String source2, @NotNull Continuation<? super Color> $completion) {
        return this.mutex.withLock(source2, (Function1)new Function1<Continuation<? super Color>, Object>(this, source2, null){
            int label;
            final /* synthetic */ DesktopIconColorExtractor this$0;
            final /* synthetic */ String $source;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!DesktopIconColorExtractor.access$getColorCache$p(this.this$0).containsKey(this.$source)) ** GOTO lbl8
                        v0 = (Color)DesktopIconColorExtractor.access$getColorCache$p(this.this$0).get(this.$source);
                        ** GOTO lbl17
lbl8:
                        // 1 sources

                        this.label = 1;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)DispatcherUtils_desktopKt.getIoDispatcher()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Color>, Object>(this.this$0, this.$source, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ DesktopIconColorExtractor this$0;
                            final /* synthetic */ String $source;
                            {
                                this.this$0 = $receiver;
                                this.$source = $source;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Object object;
                                        void $this$withContext;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $this$withContext;
                                        DesktopIconColorExtractor desktopIconColorExtractor = this.this$0;
                                        String string2 = this.$source;
                                        try {
                                            void $this$invokeSuspend_u24lambda_u240 = object2;
                                            boolean bl = false;
                                            Path path = DesktopIconColorExtractor.access$getUserDataPathProvider$p(desktopIconColorExtractor).resolve(string2 + ".png", AppFileType.ICON);
                                            byte[] byArray = Files.readAllBytes(path.toNioPath());
                                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                                            byte[] bytes = byArray;
                                            object = Result.constructor-impl((Object)DesktopIconColorExtractor.access$extractColorFromBytes-ijrfgN4(desktopIconColorExtractor, bytes));
                                        }
                                        catch (Throwable throwable) {
                                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                        }
                                        object2 = object;
                                        Color color = (Color)(Result.isFailure-impl((Object)object2) ? null : object2);
                                        DesktopIconColorExtractor.access$getLogger$p(this.this$0).debug(() -> getBackgroundColor.1.invokeSuspend$lambda$1(this.$source, color));
                                        DesktopIconColorExtractor.access$getColorCache$p(this.this$0).put(this.$source, color);
                                        return color;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Color> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Object invokeSuspend$lambda$1(String $source, Color $color) {
                                Color color = $color;
                                return $source + " - " + (color != null ? ColorUtils.INSTANCE.toHexString-8_81llA(color.unbox-impl()) : null);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl16:
                        // 2 sources

                        v0 = (Color)v1;
lbl17:
                        // 2 sources

                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Color> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final Color extractColorFromBytes-ijrfgN4(byte[] bytes) {
        Object object;
        Object object2 = this;
        try {
            DesktopIconColorExtractor $this$extractColorFromBytes_ijrfgN4_u24lambda_u241 = object2;
            boolean bl = false;
            Image image = Image.Companion.makeFromEncoded(bytes);
            object = Result.constructor-impl((Object)Color.box-impl((long)$this$extractColorFromBytes_ijrfgN4_u24lambda_u241.extractDominantColor-vNxB06k(image)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Color)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private final long extractDominantColor-vNxB06k(Image image) {
        Bitmap bitmap = new Bitmap();
        bitmap.allocPixels(image.getImageInfo());
        image.readPixels(bitmap);
        int width = image.getWidth();
        int height = image.getHeight();
        List colors = DesktopIconColorExtractor.extractColorsWithKMeans$default(this, bitmap, width, height, 0, 8, null);
        return this.selectBestBackgroundColor-vNxB06k(colors);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ColorCluster> extractColorsWithKMeans(Bitmap bitmap, int width, int height, int clusterCount) {
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        IntProgression intProgression;
        List pixels = new ArrayList();
        int sampleStep = Math.max(1, Math.min(width, height) / 50);
        IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)width)), (int)sampleStep);
        int x = intProgression2.getFirst();
        int n = intProgression2.getLast();
        int n2 = intProgression2.getStep();
        if (n2 > 0 && x <= n || n2 < 0 && n <= x) {
            while (true) {
                intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)height)), (int)sampleStep);
                int y = intProgression.getFirst();
                int n3 = intProgression.getLast();
                int n4 = intProgression.getStep();
                if (n4 > 0 && y <= n3 || n4 < 0 && n3 <= y) {
                    while (true) {
                        int b;
                        int g;
                        int r;
                        int pixel;
                        int alpha;
                        if ((alpha = (pixel = bitmap.getColor(x, y)) >>> 24 & 0xFF) >= 128 && !ColorUtils.INSTANCE.isNearWhiteOrBlack(r = pixel >>> 16 & 0xFF, g = pixel >>> 8 & 0xFF, b = pixel & 0xFF)) {
                            boolean saturationOk;
                            float[] hsv = ColorUtils.INSTANCE.rgbToHsv(r, g, b);
                            int n5 = (r + g + b) / 3;
                            boolean brightnessOk = 40 <= n5 ? n5 < 231 : false;
                            boolean bl = saturationOk = hsv[1] >= 0.2f;
                            if (brightnessOk && saturationOk) {
                                pixels.add(new PixelColor(r, g, b));
                            }
                        }
                        if (y == n3) break;
                        y += n4;
                    }
                }
                if (x == n) break;
                x += n2;
            }
        }
        if (pixels.isEmpty()) {
            return CollectionsKt.listOf((Object)new ColorCluster(128, 128, 128, 1));
        }
        List<ColorCluster> clusters = this.kMeansPlusPlus(pixels, clusterCount);
        List<ColorCluster> finalClusters = this.performStableKMeans(pixels, clusters);
        Iterable iterable = finalClusters;
        boolean $i$f$map = false;
        intProgression = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cluster;
            ColorCluster alpha = (ColorCluster)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            float[] hsv = ColorUtils.INSTANCE.rgbToHsv(cluster.getR(), cluster.getG(), cluster.getB());
            float modernWeight = this.getModernColorWeight(hsv[0]);
            collection.add(new ColorCluster(cluster.getR(), cluster.getG(), cluster.getB(), (int)((float)cluster.getCount() * modernWeight)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ColorCluster it = (ColorCluster)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getCount());
                it = (ColorCluster)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getCount()));
            }
        });
    }

    static /* synthetic */ List extractColorsWithKMeans$default(DesktopIconColorExtractor desktopIconColorExtractor, Bitmap bitmap, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 5;
        }
        return desktopIconColorExtractor.extractColorsWithKMeans(bitmap, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ColorCluster> kMeansPlusPlus(List<PixelColor> pixels, int k) {
        void $this$fold$iv;
        List clusters = new ArrayList();
        Iterable iterable = pixels;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void pixel;
            PixelColor pixelColor = (PixelColor)element$iv;
            int acc = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = acc ^ pixel.getR() * 31 + pixel.getG() * 37 + pixel.getB() * 41;
        }
        int seed = accumulator$iv;
        Random random = RandomKt.Random((int)seed);
        PixelColor firstCenter = this.selectMedianPixel(pixels);
        clusters.add(new ColorCluster(firstCenter.getR(), firstCenter.getG(), firstCenter.getB(), 0));
        int n = k - 1;
        for (int i = 0; i < n; ++i) {
            void $this$mapTo$iv$iv;
            int it = i;
            boolean bl = false;
            Iterable $this$map$iv = pixels;
            boolean $i$f$map = false;
            Iterable bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void pixel;
                PixelColor pixelColor = (PixelColor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Iterator iterator = ((Iterable)clusters).iterator();
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                ColorCluster cluster = (ColorCluster)iterator.next();
                boolean bl4 = false;
                double d = this.colorDistance((PixelColor)pixel, cluster);
                while (iterator.hasNext()) {
                    ColorCluster cluster2 = (ColorCluster)iterator.next();
                    $i$a$-minOf-DesktopIconColorExtractor$kMeansPlusPlus$1$distances$1$1 = false;
                    double d2 = this.colorDistance((PixelColor)pixel, cluster2);
                    d = Math.min(d, d2);
                }
                collection.add(d);
            }
            List distances = (List)destination$iv$iv;
            int selectedIndex2 = this.weightedSelection(distances, random);
            PixelColor selectedPixel = pixels.get(selectedIndex2);
            clusters.add(new ColorCluster(selectedPixel.getR(), selectedPixel.getG(), selectedPixel.getB(), 0));
        }
        return clusters;
    }

    private final PixelColor selectMedianPixel(List<PixelColor> pixels) {
        Iterable $this$sortedBy$iv = pixels;
        boolean $i$f$sortedBy = false;
        List sortedByBrightness = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PixelColor it = (PixelColor)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf((it.getR() + it.getG() + it.getB()) / 3);
                it = (PixelColor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf((it.getR() + it.getG() + it.getB()) / 3));
            }
        });
        return (PixelColor)sortedByBrightness.get(sortedByBrightness.size() / 2);
    }

    private final int weightedSelection(List<Double> weights, Random random) {
        double totalWeight = CollectionsKt.sumOfDouble((Iterable)weights);
        if (totalWeight == 0.0) {
            return 0;
        }
        double randomValue = random.nextDouble() * totalWeight;
        double cumulativeWeight = 0.0;
        int n = ((Collection)weights).size();
        for (int i = 0; i < n; ++i) {
            if (!(randomValue <= (cumulativeWeight += ((Number)weights.get(i)).doubleValue()))) continue;
            return i;
        }
        return weights.size() - 1;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ColorCluster> performStableKMeans(List<PixelColor> pixels, List<ColorCluster> initialClusters) {
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = initialClusters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColorCluster colorCluster = (ColorCluster)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(ColorCluster.copy$default((ColorCluster)it, 0, 0, 0, 0, 15, null));
        }
        List clusters = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        int maxIterations = 30;
        double convergenceThreshold = 0.01;
        boolean hasConverged = false;
        for (int iteration = 0; iteration < maxIterations; ++iteration) {
            int n;
            Iterable $this$forEach$iv = clusters;
            int $i$f$forEach = 0;
            for (Object element$iv : $this$forEach$iv) {
                ColorCluster it2 = (ColorCluster)element$iv;
                n = 0;
                it2.setCount(0);
            }
            $i$f$forEach = clusters.size();
            ArrayList it = new ArrayList($i$f$forEach);
            int element$iv = 0;
            while (element$iv < $i$f$forEach) {
                int it2;
                n = it2 = element$iv++;
                object = it;
                boolean bl = false;
                ((ArrayList)object).add(new ColorCluster(0, 0, 0, 0));
            }
            List newClusters = it;
            Iterable $this$forEach$iv2 = pixels;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object v0;
                PixelColor pixel = (PixelColor)element$iv2;
                boolean bl = false;
                Iterable $this$minByOrNull$iv = (Iterable)CollectionsKt.getIndices((Collection)clusters);
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        int i = ((Number)minElem$iv).intValue();
                        boolean bl2 = false;
                        double minValue$iv = this.colorDistance(pixel, (ColorCluster)clusters.get(i));
                        do {
                            Object e$iv = iterator$iv.next();
                            int i2 = ((Number)e$iv).intValue();
                            $i$a$-minByOrNull-DesktopIconColorExtractor$performStableKMeans$2$nearestIndex$1 = false;
                            double v$iv = this.colorDistance(pixel, (ColorCluster)clusters.get(i2));
                            if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                Integer n2 = v0;
                int nearestIndex = n2 != null ? n2 : 0;
                Object e = newClusters.get(nearestIndex);
                ColorCluster $this$performStableKMeans_u24lambda_u2414_u24lambda_u2413 = (ColorCluster)e;
                boolean bl3 = false;
                $this$performStableKMeans_u24lambda_u2414_u24lambda_u2413.setR($this$performStableKMeans_u24lambda_u2414_u24lambda_u2413.getR() + pixel.getR());
                $this$performStableKMeans_u24lambda_u2414_u24lambda_u2413.setG($this$performStableKMeans_u24lambda_u2414_u24lambda_u2413.getG() + pixel.getG());
                $this$performStableKMeans_u24lambda_u2414_u24lambda_u2413.setB($this$performStableKMeans_u24lambda_u2414_u24lambda_u2413.getB() + pixel.getB());
                int n3 = $this$performStableKMeans_u24lambda_u2414_u24lambda_u2413.getCount();
                $this$performStableKMeans_u24lambda_u2414_u24lambda_u2413.setCount(n3 + 1);
            }
            double totalMovement = 0.0;
            int n4 = ((Collection)clusters).size();
            for (int i = 0; i < n4; ++i) {
                if (((ColorCluster)newClusters.get(i)).getCount() <= 0) continue;
                ColorCluster oldCluster = (ColorCluster)clusters.get(i);
                int newR = ((ColorCluster)newClusters.get(i)).getR() / ((ColorCluster)newClusters.get(i)).getCount();
                int newG = ((ColorCluster)newClusters.get(i)).getG() / ((ColorCluster)newClusters.get(i)).getCount();
                int newB = ((ColorCluster)newClusters.get(i)).getB() / ((ColorCluster)newClusters.get(i)).getCount();
                totalMovement += Math.sqrt((double)((oldCluster.getR() - newR) * (oldCluster.getR() - newR) + (oldCluster.getG() - newG) * (oldCluster.getG() - newG)) + (double)(oldCluster.getB() - newB) * (double)(oldCluster.getB() - newB));
                clusters.set(i, new ColorCluster(newR, newG, newB, ((ColorCluster)newClusters.get(i)).getCount()));
            }
            if (!(totalMovement < convergenceThreshold)) continue;
            this.logger.debug(() -> DesktopIconColorExtractor.performStableKMeans$lambda$15(iteration));
            hasConverged = true;
            break;
        }
        if (!hasConverged) {
            this.logger.debug(DesktopIconColorExtractor::performStableKMeans$lambda$16);
        }
        Iterable $this$sortedByDescending$iv = clusters;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ColorCluster it = (ColorCluster)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getCount());
                it = (ColorCluster)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getCount()));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final float getModernColorWeight(float hue) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        boolean bl9;
        boolean bl10;
        float f = hue;
        if (220.0f <= f) {
            if (f <= 260.0f) {
                return 1.3f;
            }
            bl10 = false;
        } else {
            bl10 = false;
        }
        if (bl10) {
            return 1.3f;
        }
        if (180.0f <= f) {
            if (f <= 220.0f) {
                return 1.25f;
            }
            bl9 = false;
        } else {
            bl9 = false;
        }
        if (bl9) {
            return 1.25f;
        }
        if (260.0f <= f) {
            if (f <= 300.0f) {
                return 1.25f;
            }
            bl8 = false;
        } else {
            bl8 = false;
        }
        if (bl8) {
            return 1.25f;
        }
        if (10.0f <= f) {
            if (f <= 30.0f) {
                return 1.2f;
            }
            bl7 = false;
        } else {
            bl7 = false;
        }
        if (bl7) {
            return 1.2f;
        }
        if (140.0f <= f) {
            if (f <= 180.0f) {
                return 1.2f;
            }
            bl6 = false;
        } else {
            bl6 = false;
        }
        if (bl6) {
            return 1.2f;
        }
        if (300.0f <= f) {
            if (f <= 340.0f) {
                return 1.2f;
            }
            bl5 = false;
        } else {
            bl5 = false;
        }
        if (bl5) {
            return 1.2f;
        }
        if (200.0f <= f) {
            if (f <= 220.0f) {
                return 1.1f;
            }
            bl4 = false;
        } else {
            bl4 = false;
        }
        if (bl4) {
            return 1.1f;
        }
        if (80.0f <= f) {
            if (f <= 140.0f) {
                return 1.1f;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) {
            return 1.1f;
        }
        if (0.0f <= f) {
            if (f <= 10.0f) {
                return 1.1f;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return 1.1f;
        if (340.0f <= f) {
            if (f <= 360.0f) {
                return 1.1f;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) {
            return 1.1f;
        }
        if (!(40.0f <= f)) return 1.0f;
        if (!(f <= 80.0f)) return 1.0f;
        return 0.9f;
    }

    private final int huePreferRank(float h) {
        int n;
        block1: {
            block2: {
                block0: {
                    boolean bl = 200.0f <= h ? h <= 260.0f : false;
                    if (!bl) break block0;
                    n = 1;
                    break block1;
                }
                boolean bl = 80.0f <= h ? h <= 160.0f : false;
                if (!bl) break block2;
                n = 2;
                break block1;
            }
            n = (0.0f <= h ? h <= 40.0f : false) || h >= 320.0f ? 3 : ((40.0f <= h ? h <= 80.0f : false) ? 4 : 5);
        }
        return n;
    }

    private final float saturation(ColorCluster cluster) {
        float max = Math.max(cluster.getR(), Math.max(cluster.getG(), cluster.getB()));
        float min = Math.min(cluster.getR(), Math.min(cluster.getG(), cluster.getB()));
        return max == 0.0f ? 0.0f : (max - min) / max;
    }

    /*
     * WARNING - void declaration
     */
    private final long selectBestBackgroundColor-vNxB06k(List<ColorCluster> clusters) {
        List<ColorCluster> list;
        void $this$filterTo$iv$iv;
        Collection<ColorCluster> $this$filter$iv = clusters;
        boolean $i$f$filter = false;
        List<ColorCluster> list2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int b;
            int g;
            ColorCluster colorCluster = (ColorCluster)element$iv$iv;
            boolean bl = false;
            int r = colorCluster.component1();
            int brightness = (r + (g = colorCluster.component2()) + (b = colorCluster.component3())) / 3;
            boolean bl2 = 60 <= brightness ? brightness < 201 : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        if ($this$filter$iv.isEmpty()) {
            boolean bl = false;
            list = clusters;
        } else {
            list = $this$filter$iv;
        }
        List candidates = list;
        Comparator bl = new Comparator(this){
            final /* synthetic */ DesktopIconColorExtractor this$0;
            {
                this.this$0 = desktopIconColorExtractor;
            }

            public final int compare(T a, T b) {
                ColorCluster it = (ColorCluster)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(DesktopIconColorExtractor.access$huePreferRank(this.this$0, ColorUtils.INSTANCE.rgbToHsv(it.getR(), it.getG(), it.getB())[0]));
                it = (ColorCluster)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(DesktopIconColorExtractor.access$huePreferRank(this.this$0, ColorUtils.INSTANCE.rgbToHsv(it.getR(), it.getG(), it.getB())[0])));
            }
        };
        bl = new Comparator(bl){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    ColorCluster it = (ColorCluster)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getCount());
                    it = (ColorCluster)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getCount()));
                }
                return n;
            }
        };
        bl = new Comparator(bl, this){
            final /* synthetic */ Comparator $this_thenByDescending;
            final /* synthetic */ DesktopIconColorExtractor this$0;
            {
                this.$this_thenByDescending = $receiver;
                this.this$0 = desktopIconColorExtractor;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    ColorCluster it = (ColorCluster)b;
                    boolean bl = false;
                    Comparable comparable = Float.valueOf(DesktopIconColorExtractor.access$saturation(this.this$0, it));
                    it = (ColorCluster)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(DesktopIconColorExtractor.access$saturation(this.this$0, it)));
                }
                return n;
            }
        };
        ColorCluster best = (ColorCluster)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)candidates, (Comparator)new Comparator(bl){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    ColorCluster it = (ColorCluster)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getR() * 1000000 + it.getG() * 1000 + it.getB());
                    it = (ColorCluster)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getR() * 1000000 + it.getG() * 1000 + it.getB()));
                }
                return n;
            }
        }));
        long baseColor = ColorKt.Color$default((float)((float)best.getR() / 255.0f), (float)((float)best.getG() / 255.0f), (float)((float)best.getB() / 255.0f), (float)0.0f, null, (int)24, null);
        return this.enhanceColorForBackground-l2rxGTc(baseColor);
    }

    private final long enhanceColorForBackground-l2rxGTc(long color) {
        int r = (int)(Color.getRed-impl((long)color) * (float)255);
        int g = (int)(Color.getGreen-impl((long)color) * (float)255);
        int b = (int)(Color.getBlue-impl((long)color) * (float)255);
        float[] hsv = ColorUtils.INSTANCE.rgbToHsv(r, g, b);
        hsv[1] = hsv[1] < 0.6f ? 0.6f : (hsv[1] > 0.7f ? 0.7f : hsv[1]);
        hsv[2] = hsv[2] < 0.8f ? 0.8f : (hsv[2] > 0.9f ? 0.9f : hsv[2]);
        int[] rgb = ColorUtils.INSTANCE.hsvToRgb(hsv[0], hsv[1], hsv[2]);
        return ColorKt.Color$default((int)rgb[0], (int)rgb[1], (int)rgb[2], (int)0, (int)8, null);
    }

    private final double colorDistance(PixelColor p1, ColorCluster p2) {
        int dr = p1.getR() - p2.getR();
        int dg = p1.getG() - p2.getG();
        int db = p1.getB() - p2.getB();
        return Math.sqrt(dr * dr + dg * dg + db * db);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object performStableKMeans$lambda$15(int $iteration) {
        return "K-means converged at iteration " + $iteration;
    }

    private static final Object performStableKMeans$lambda$16() {
        return "K-means reached maximum iterations without full convergence";
    }

    public static final /* synthetic */ Map access$getColorCache$p(DesktopIconColorExtractor $this) {
        return $this.colorCache;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(DesktopIconColorExtractor $this) {
        return $this.logger;
    }

    public static final /* synthetic */ UserDataPathProvider access$getUserDataPathProvider$p(DesktopIconColorExtractor $this) {
        return $this.userDataPathProvider;
    }

    public static final /* synthetic */ Color access$extractColorFromBytes-ijrfgN4(DesktopIconColorExtractor $this, byte[] bytes) {
        return $this.extractColorFromBytes-ijrfgN4(bytes);
    }

    public static final /* synthetic */ int access$huePreferRank(DesktopIconColorExtractor $this, float h) {
        return $this.huePreferRank(h);
    }

    public static final /* synthetic */ float access$saturation(DesktopIconColorExtractor $this, ColorCluster cluster) {
        return $this.saturation(cluster);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\nJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\nJ8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\u001bR\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u001c\u0010\n\"\u0004\b\u001d\u0010\u001bR\"\u0010\u0005\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u001e\u0010\n\"\u0004\b\u001f\u0010\u001bR\"\u0010\u0006\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b \u0010\n\"\u0004\b!\u0010\u001b\u00a8\u0006\""}, d2={"Lcom/crosspaste/image/DesktopIconColorExtractor$ColorCluster;", "", "", "r", "g", "b", "count", "<init>", "(IIII)V", "component1", "()I", "component2", "component3", "component4", "copy", "(IIII)Lcom/crosspaste/image/DesktopIconColorExtractor$ColorCluster;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getR", "setR", "(I)V", "getG", "setG", "getB", "setB", "getCount", "setCount", "app"})
    private static final class ColorCluster {
        private int r;
        private int g;
        private int b;
        private int count;

        public ColorCluster(int r, int g, int b, int count) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.count = count;
        }

        public final int getR() {
            return this.r;
        }

        public final void setR(int n) {
            this.r = n;
        }

        public final int getG() {
            return this.g;
        }

        public final void setG(int n) {
            this.g = n;
        }

        public final int getB() {
            return this.b;
        }

        public final void setB(int n) {
            this.b = n;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final int component1() {
            return this.r;
        }

        public final int component2() {
            return this.g;
        }

        public final int component3() {
            return this.b;
        }

        public final int component4() {
            return this.count;
        }

        @NotNull
        public final ColorCluster copy(int r, int g, int b, int count) {
            return new ColorCluster(r, g, b, count);
        }

        public static /* synthetic */ ColorCluster copy$default(ColorCluster colorCluster, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = colorCluster.r;
            }
            if ((n5 & 2) != 0) {
                n2 = colorCluster.g;
            }
            if ((n5 & 4) != 0) {
                n3 = colorCluster.b;
            }
            if ((n5 & 8) != 0) {
                n4 = colorCluster.count;
            }
            return colorCluster.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "ColorCluster(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.r);
            result2 = result2 * 31 + Integer.hashCode(this.g);
            result2 = result2 * 31 + Integer.hashCode(this.b);
            result2 = result2 * 31 + Integer.hashCode(this.count);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColorCluster)) {
                return false;
            }
            ColorCluster colorCluster = (ColorCluster)other;
            if (this.r != colorCluster.r) {
                return false;
            }
            if (this.g != colorCluster.g) {
                return false;
            }
            if (this.b != colorCluster.b) {
                return false;
            }
            return this.count == colorCluster.count;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\tJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\tJ.\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0018\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0019\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/crosspaste/image/DesktopIconColorExtractor$PixelColor;", "", "", "r", "g", "b", "<init>", "(III)V", "component1", "()I", "component2", "component3", "copy", "(III)Lcom/crosspaste/image/DesktopIconColorExtractor$PixelColor;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getR", "getG", "getB", "app"})
    private static final class PixelColor {
        private final int r;
        private final int g;
        private final int b;

        public PixelColor(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public final int getR() {
            return this.r;
        }

        public final int getG() {
            return this.g;
        }

        public final int getB() {
            return this.b;
        }

        public final int component1() {
            return this.r;
        }

        public final int component2() {
            return this.g;
        }

        public final int component3() {
            return this.b;
        }

        @NotNull
        public final PixelColor copy(int r, int g, int b) {
            return new PixelColor(r, g, b);
        }

        public static /* synthetic */ PixelColor copy$default(PixelColor pixelColor, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = pixelColor.r;
            }
            if ((n4 & 2) != 0) {
                n2 = pixelColor.g;
            }
            if ((n4 & 4) != 0) {
                n3 = pixelColor.b;
            }
            return pixelColor.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "PixelColor(r=" + this.r + ", g=" + this.g + ", b=" + this.b + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.r);
            result2 = result2 * 31 + Integer.hashCode(this.g);
            result2 = result2 * 31 + Integer.hashCode(this.b);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PixelColor)) {
                return false;
            }
            PixelColor pixelColor = (PixelColor)other;
            if (this.r != pixelColor.r) {
                return false;
            }
            if (this.g != pixelColor.g) {
                return false;
            }
            return this.b == pixelColor.b;
        }
    }
}

