/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.image;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.image.FileExtImageLoader;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.utils.ConcurrentLoader;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import com.crosspaste.utils.OkioPathExtensionKt;
import com.crosspaste.utils.StripedMutex;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001a\u0010 \u001a\u00020\u001f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/crosspaste/image/AbstractFileExtImageLoader;", "Lcom/crosspaste/utils/ConcurrentLoader;", "Lokio/Path;", "Lcom/crosspaste/image/FileExtImageLoader;", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/path/UserDataPathProvider;)V", "", "key", "value", "resolve", "(Ljava/lang/String;Lokio/Path;)Lokio/Path;", "result", "", "exist", "(Lokio/Path;)Z", "", "e", "", "loggerWarning", "(Lokio/Path;Ljava/lang/Throwable;)V", "convertToKey", "(Lokio/Path;)Ljava/lang/String;", "Lcom/crosspaste/path/UserDataPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "Lcom/crosspaste/utils/StripedMutex;", "mutex", "Lcom/crosspaste/utils/StripedMutex;", "getMutex", "()Lcom/crosspaste/utils/StripedMutex;", "app"})
@StabilityInferred(parameters=0)
public abstract class AbstractFileExtImageLoader
implements ConcurrentLoader<Path, Path>,
FileExtImageLoader {
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final StripedMutex mutex;
    public static final int $stable = 8;

    public AbstractFileExtImageLoader(@NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.userDataPathProvider = userDataPathProvider;
        this.logger = KotlinLogging.INSTANCE.logger(AbstractFileExtImageLoader::logger$lambda$0);
        this.fileUtils = FileUtils_desktopKt.getFileUtils();
        this.mutex = new StripedMutex(0, 1, null);
    }

    @Override
    @NotNull
    public StripedMutex getMutex() {
        return this.mutex;
    }

    @Override
    @NotNull
    public Path resolve(@NotNull String key, @NotNull Path value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.userDataPathProvider.resolve(key + ".png", AppFileType.FILE_EXT_ICON);
    }

    @Override
    public boolean exist(@NotNull Path result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        return this.fileUtils.existFile(result2);
    }

    @Override
    public void loggerWarning(@NotNull Path value, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.logger.warn(() -> AbstractFileExtImageLoader.loggerWarning$lambda$1(value));
    }

    @Override
    @NotNull
    public String convertToKey(@NotNull Path value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return OkioPathExtensionKt.getExtension((Path)value);
    }

    @Override
    @Nullable
    public Object load(@NotNull Path value, @NotNull Continuation<? super Path> $completion) {
        return ConcurrentLoader.super.load(value, $completion);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object loggerWarning$lambda$1(Path $value) {
        return "Failed to load icon for file extension: " + $value;
    }
}

