/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.image;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppFileType;
import com.crosspaste.image.FaviconLoader;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.utils.ConcurrentLoader;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import com.crosspaste.utils.StripedMutex;
import io.github.oshai.kotlinlogging.KLogger;
import io.ktor.http.URLUtilsKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ!\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0003H&\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b \u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010!R\u0014\u0010%\u001a\u00020\"8$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010'\u001a\u00020&8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020+8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lcom/crosspaste/image/AbstractFaviconLoader;", "Lcom/crosspaste/utils/ConcurrentLoader;", "", "Lokio/Path;", "Lcom/crosspaste/image/FaviconLoader;", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/path/UserDataPathProvider;)V", "host", "getGoogleIconUrl", "(Ljava/lang/String;)Ljava/lang/String;", "getDefaultIcoUrl", "url", "path", "saveIco", "(Ljava/lang/String;Lokio/Path;)Lokio/Path;", "key", "value", "resolve", "(Ljava/lang/String;Ljava/lang/String;)Lokio/Path;", "result", "", "exist", "(Lokio/Path;)Z", "", "e", "", "loggerWarning", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "save", "(Ljava/lang/String;Ljava/lang/String;Lokio/Path;)V", "convertToKey", "Lcom/crosspaste/path/UserDataPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "getFileUtils", "()Lcom/crosspaste/utils/FileUtils;", "Lcom/crosspaste/utils/StripedMutex;", "mutex", "Lcom/crosspaste/utils/StripedMutex;", "getMutex", "()Lcom/crosspaste/utils/StripedMutex;", "app"})
@StabilityInferred(parameters=0)
public abstract class AbstractFaviconLoader
implements ConcurrentLoader<String, Path>,
FaviconLoader {
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final StripedMutex mutex;
    public static final int $stable = 8;

    public AbstractFaviconLoader(@NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.userDataPathProvider = userDataPathProvider;
        this.fileUtils = FileUtils_desktopKt.getFileUtils();
        this.mutex = new StripedMutex(0, 1, null);
    }

    @NotNull
    protected abstract KLogger getLogger();

    @NotNull
    protected final FileUtils getFileUtils() {
        return this.fileUtils;
    }

    @Override
    @NotNull
    public StripedMutex getMutex() {
        return this.mutex;
    }

    private final String getGoogleIconUrl(String host) {
        return "https://t1.gstatic.com/faviconV2?client=SOCIAL&type=FAVICON&fallback_opts=TYPE,SIZE,URL&url=http://" + host + "&size=256";
    }

    private final String getDefaultIcoUrl(String host) {
        return "https://" + host + "/favicon.ico";
    }

    @Nullable
    public abstract Path saveIco(@NotNull String var1, @NotNull Path var2);

    @Override
    @NotNull
    public Path resolve(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.userDataPathProvider.resolve(key + ".ico", AppFileType.FAVICON);
    }

    @Override
    public boolean exist(@NotNull Path result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        return this.fileUtils.existFile(result2);
    }

    @Override
    public void loggerWarning(@NotNull String value, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.getLogger().warn(e, () -> AbstractFaviconLoader.loggerWarning$lambda$0(value));
    }

    @Override
    public void save(@NotNull String key, @NotNull String value, @NotNull Path result2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Path path = this.saveIco(this.getDefaultIcoUrl(key), result2);
        if (path == null) {
            path = this.saveIco(this.getGoogleIconUrl(key), result2);
        }
    }

    @Override
    @NotNull
    public String convertToKey(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return URLUtilsKt.Url((String)value).getHost();
    }

    @Override
    @Nullable
    public Object load(@NotNull String value, @NotNull Continuation<? super Path> $completion) {
        return ConcurrentLoader.super.load(value, $completion);
    }

    private static final Object loggerWarning$lambda$0(String $value) {
        return "Failed to get favicon for " + $value;
    }
}

