/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.i18n;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.config.AppConfig;
import com.crosspaste.config.ConfigManager;
import com.crosspaste.db.task.PasteTaskExtraInfo;
import com.crosspaste.db.task.SwitchLanguageInfo;
import com.crosspaste.db.task.TaskDao;
import com.crosspaste.i18n.Copywriter;
import com.crosspaste.i18n.DesktopCopywriter;
import com.crosspaste.i18n.GlobalCopywriter;
import com.crosspaste.i18n.Language;
import com.crosspaste.task.TaskExecutor;
import com.crosspaste.utils.DateTimeFormatOptions;
import com.crosspaste.utils.GlobalCoroutineScope;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.datetime.LocalDateTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>B/\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00190\u0018\"\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010$\u001a\u00020\r2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b&\u0010\u000fR\u001e\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010'R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010(R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010\u000e\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010-R+\u00106\u001a\u00020.2\u0006\u0010/\u001a\u00020.8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001b\u00109\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010(\u001a\u0004\b8\u00103R\u001b\u0010=\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010(\u001a\u0004\b;\u0010<\u00a8\u0006?"}, d2={"Lcom/crosspaste/i18n/DesktopGlobalCopywriter;", "Lcom/crosspaste/i18n/GlobalCopywriter;", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/config/AppConfig;", "Lcom/crosspaste/config/CommonConfigManager;", "configManager", "Lkotlin/Lazy;", "Lcom/crosspaste/task/TaskExecutor;", "lazyTaskExecutor", "Lcom/crosspaste/db/task/TaskDao;", "taskDao", "<init>", "(Lcom/crosspaste/config/ConfigManager;Lkotlin/Lazy;Lcom/crosspaste/db/task/TaskDao;)V", "", "language", "()Ljava/lang/String;", "", "switchLanguage", "(Ljava/lang/String;)V", "", "Lcom/crosspaste/i18n/Language;", "getAllLanguages", "()Ljava/util/List;", "id", "", "", "args", "getText", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "", "getKeys", "()Ljava/util/Set;", "Lkotlinx/datetime/LocalDateTime;", "date", "Lcom/crosspaste/utils/DateTimeFormatOptions;", "options", "getDate", "(Lkotlinx/datetime/LocalDateTime;Lcom/crosspaste/utils/DateTimeFormatOptions;)Ljava/lang/String;", "getAbridge", "Lcom/crosspaste/config/ConfigManager;", "Lkotlin/Lazy;", "Lcom/crosspaste/db/task/TaskDao;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Ljava/lang/String;", "Lcom/crosspaste/i18n/Copywriter;", "<set-?>", "copywriter$delegate", "Landroidx/compose/runtime/MutableState;", "getCopywriter", "()Lcom/crosspaste/i18n/Copywriter;", "setCopywriter", "(Lcom/crosspaste/i18n/Copywriter;)V", "copywriter", "enCopywriter$delegate", "getEnCopywriter", "enCopywriter", "taskExecutor$delegate", "getTaskExecutor", "()Lcom/crosspaste/task/TaskExecutor;", "taskExecutor", "Companion", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nI18n.kt\nKotlin\n*S Kotlin\n*F\n+ 1 I18n.kt\ncom/crosspaste/i18n/DesktopGlobalCopywriter\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n85#2:199\n117#2,2:200\n1563#3:202\n1634#3,3:203\n*S KotlinDebug\n*F\n+ 1 I18n.kt\ncom/crosspaste/i18n/DesktopGlobalCopywriter\n*L\n71#1:199\n71#1:200,2\n101#1:202\n101#1:203,3\n*E\n"})
public final class DesktopGlobalCopywriter
implements GlobalCopywriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigManager<AppConfig> configManager;
    @NotNull
    private final Lazy<TaskExecutor> lazyTaskExecutor;
    @NotNull
    private final TaskDao taskDao;
    @NotNull
    private final KLogger logger;
    @NotNull
    private String language;
    @NotNull
    private final MutableState copywriter$delegate;
    @NotNull
    private final Lazy enCopywriter$delegate;
    @NotNull
    private final Lazy taskExecutor$delegate;
    public static final int $stable = 8;
    @NotNull
    public static final String DE = "de";
    @NotNull
    public static final String EN = "en";
    @NotNull
    public static final String ES = "es";
    @NotNull
    public static final String FA = "fa";
    @NotNull
    public static final String FR = "fr";
    @NotNull
    public static final String KO = "ko";
    @NotNull
    public static final String JA = "ja";
    @NotNull
    public static final String ZH = "zh";
    @NotNull
    public static final String ZH_HANT = "zh_hant";
    @NotNull
    private static final List<String> LANGUAGE_LIST;
    @NotNull
    private static final ConcurrentHashMap<String, Copywriter> LANGUAGE_MAP;
    @NotNull
    public static final String EMPTY_STRING = "";

    /*
     * WARNING - void declaration
     */
    public DesktopGlobalCopywriter(@NotNull ConfigManager<AppConfig> configManager, @NotNull Lazy<TaskExecutor> lazyTaskExecutor, @NotNull TaskDao taskDao) {
        String string2;
        void $this$language_u24lambda_u241;
        Intrinsics.checkNotNullParameter(configManager, (String)"configManager");
        Intrinsics.checkNotNullParameter(lazyTaskExecutor, (String)"lazyTaskExecutor");
        Intrinsics.checkNotNullParameter((Object)taskDao, (String)"taskDao");
        this.configManager = configManager;
        this.lazyTaskExecutor = lazyTaskExecutor;
        this.taskDao = taskDao;
        this.logger = KotlinLogging.INSTANCE.logger(DesktopGlobalCopywriter::logger$lambda$0);
        DesktopGlobalCopywriter desktopGlobalCopywriter = this;
        DesktopGlobalCopywriter desktopGlobalCopywriter2 = this;
        boolean bl = false;
        String language = $this$language_u24lambda_u241.configManager.getCurrentConfig().getLanguage();
        if (!LANGUAGE_LIST.contains(language)) {
            $this$language_u24lambda_u241.configManager.updateConfig("language", (Object)EN);
            string2 = EN;
        } else {
            string2 = language;
        }
        desktopGlobalCopywriter2.language = string2;
        this.copywriter$delegate = SnapshotStateKt.mutableStateOf$default((Object)LANGUAGE_MAP.computeIfAbsent(this.language, arg_0 -> DesktopGlobalCopywriter.copywriter_delegate$lambda$3(arg_0 -> DesktopGlobalCopywriter.copywriter_delegate$lambda$2(this, arg_0), arg_0)), null, (int)2, null);
        this.enCopywriter$delegate = LazyKt.lazy(DesktopGlobalCopywriter::enCopywriter_delegate$lambda$6);
        this.taskExecutor$delegate = LazyKt.lazy(() -> DesktopGlobalCopywriter.taskExecutor_delegate$lambda$7(this));
    }

    /*
     * WARNING - void declaration
     */
    private final Copywriter getCopywriter() {
        void $this$getValue$iv;
        State state = (State)this.copywriter$delegate;
        DesktopGlobalCopywriter desktopGlobalCopywriter = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Copywriter)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCopywriter(Copywriter copywriter) {
        void $this$setValue$iv;
        MutableState mutableState = this.copywriter$delegate;
        DesktopGlobalCopywriter desktopGlobalCopywriter = this;
        Object var4_4 = null;
        Copywriter value$iv = copywriter;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    private final Copywriter getEnCopywriter() {
        Lazy lazy = this.enCopywriter$delegate;
        return (Copywriter)lazy.getValue();
    }

    private final TaskExecutor getTaskExecutor() {
        Lazy lazy = this.taskExecutor$delegate;
        return (TaskExecutor)lazy.getValue();
    }

    @Override
    @NotNull
    public String language() {
        return this.getCopywriter().language();
    }

    @Override
    public void switchLanguage(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.logger.info(() -> DesktopGlobalCopywriter.switchLanguage$lambda$8(language));
        Copywriter copywriter = LANGUAGE_MAP.computeIfAbsent(language, arg_0 -> DesktopGlobalCopywriter.switchLanguage$lambda$10(arg_0 -> DesktopGlobalCopywriter.switchLanguage$lambda$9(language, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)copywriter, (String)"computeIfAbsent(...)");
        this.setCopywriter(copywriter);
        this.configManager.updateConfig("language", (Object)language);
        BuildersKt.launch$default((CoroutineScope)GlobalCoroutineScope.INSTANCE.getCpuCoroutineDispatcher(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, language, null){
            int label;
            final /* synthetic */ DesktopGlobalCopywriter this$0;
            final /* synthetic */ String $language;
            {
                this.this$0 = $receiver;
                this.$language = $language;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DesktopGlobalCopywriter.access$getTaskExecutor(this.this$0).submitTask(DesktopGlobalCopywriter.access$getTaskDao$p(this.this$0).createTask(null, 8, (PasteTaskExtraInfo)new SwitchLanguageInfo(this.$language)), (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Language> getAllLanguages() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = LANGUAGE_LIST;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Copywriter copywriter;
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)LANGUAGE_MAP.computeIfAbsent((String)it, arg_0 -> DesktopGlobalCopywriter.getAllLanguages$lambda$13$lambda$12(DesktopGlobalCopywriter::getAllLanguages$lambda$13$lambda$11, arg_0)), (String)"computeIfAbsent(...)");
            String abridge = copywriter.getAbridge();
            String name = copywriter.getText("current_language", new Object[0]);
            collection.add(new Language(abridge, name));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String getText(@NotNull String id, Object ... args) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String text = this.getCopywriter().getText(id, Arrays.copyOf(args, args.length));
        if (Intrinsics.areEqual((Object)text, (Object)EMPTY_STRING) && !Intrinsics.areEqual((Object)this.getCopywriter().language(), (Object)EN)) {
            this.logger.debug(() -> DesktopGlobalCopywriter.getText$lambda$14(id, this));
            String enText = this.getEnCopywriter().getText(id, Arrays.copyOf(args, args.length));
            if (Intrinsics.areEqual((Object)enText, (Object)EMPTY_STRING)) {
                this.logger.warn(() -> DesktopGlobalCopywriter.getText$lambda$15(id));
                object = "[" + id + "]";
            } else {
                object = enText;
            }
        } else {
            object = text;
        }
        return object;
    }

    @Override
    @NotNull
    public Set<String> getKeys() {
        return this.getCopywriter().getKeys();
    }

    @Override
    @NotNull
    public String getDate(@NotNull LocalDateTime date, @NotNull DateTimeFormatOptions options) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.getCopywriter().getDate(date, options);
    }

    @Override
    @NotNull
    public String getAbridge() {
        return this.getCopywriter().getAbridge();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Copywriter copywriter_delegate$lambda$2(DesktopGlobalCopywriter this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DesktopCopywriter(this$0.language);
    }

    private static final Copywriter copywriter_delegate$lambda$3(Function1 $tmp0, Object p0) {
        return (Copywriter)$tmp0.invoke(p0);
    }

    private static final Copywriter enCopywriter_delegate$lambda$6$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DesktopCopywriter(EN);
    }

    private static final Copywriter enCopywriter_delegate$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        return (Copywriter)$tmp0.invoke(p0);
    }

    private static final Copywriter enCopywriter_delegate$lambda$6() {
        return LANGUAGE_MAP.computeIfAbsent(EN, arg_0 -> DesktopGlobalCopywriter.enCopywriter_delegate$lambda$6$lambda$5(DesktopGlobalCopywriter::enCopywriter_delegate$lambda$6$lambda$4, arg_0));
    }

    private static final TaskExecutor taskExecutor_delegate$lambda$7(DesktopGlobalCopywriter this$0) {
        return (TaskExecutor)this$0.lazyTaskExecutor.getValue();
    }

    private static final Object switchLanguage$lambda$8(String $language) {
        return "Switching language " + $language;
    }

    private static final Copywriter switchLanguage$lambda$9(String $language, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DesktopCopywriter($language);
    }

    private static final Copywriter switchLanguage$lambda$10(Function1 $tmp0, Object p0) {
        return (Copywriter)$tmp0.invoke(p0);
    }

    private static final Copywriter getAllLanguages$lambda$13$lambda$11(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DesktopCopywriter(it);
    }

    private static final Copywriter getAllLanguages$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        return (Copywriter)$tmp0.invoke(p0);
    }

    private static final Object getText$lambda$14(String $id, DesktopGlobalCopywriter this$0) {
        return "Missing text for id: " + $id + " in language: " + this$0.getCopywriter().language();
    }

    private static final Object getText$lambda$15(String $id) {
        return "Missing text for id: " + $id + " in English";
    }

    public static final /* synthetic */ TaskExecutor access$getTaskExecutor(DesktopGlobalCopywriter $this) {
        return $this.getTaskExecutor();
    }

    public static final /* synthetic */ TaskDao access$getTaskDao$p(DesktopGlobalCopywriter $this) {
        return $this.taskDao;
    }

    static {
        Object[] objectArray = new String[]{DE, EN, ES, FA, FR, KO, JA, ZH, ZH_HANT};
        LANGUAGE_LIST = CollectionsKt.listOf((Object[])objectArray);
        LANGUAGE_MAP = new ConcurrentHashMap();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006R\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/crosspaste/i18n/DesktopGlobalCopywriter$Companion;", "", "<init>", "()V", "", "DE", "Ljava/lang/String;", "EN", "ES", "FA", "FR", "KO", "JA", "ZH", "ZH_HANT", "", "LANGUAGE_LIST", "Ljava/util/List;", "getLANGUAGE_LIST", "()Ljava/util/List;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/crosspaste/i18n/Copywriter;", "LANGUAGE_MAP", "Ljava/util/concurrent/ConcurrentHashMap;", "getLANGUAGE_MAP", "()Ljava/util/concurrent/ConcurrentHashMap;", "EMPTY_STRING", "app"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getLANGUAGE_LIST() {
            return LANGUAGE_LIST;
        }

        @NotNull
        public final ConcurrentHashMap<String, Copywriter> getLANGUAGE_MAP() {
            return LANGUAGE_MAP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

