/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.i18n;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.i18n.Copywriter;
import com.crosspaste.utils.DateTimeFormatOptions;
import com.crosspaste.utils.DateUtils;
import com.crosspaste.utils.DateUtilsKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDateTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\rJ/\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001d\u0010\rR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010'R\u0016\u0010(\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010\u001e\u00a8\u0006)"}, d2={"Lcom/crosspaste/i18n/DesktopCopywriter;", "Lcom/crosspaste/i18n/Copywriter;", "", "language", "<init>", "(Ljava/lang/String;)V", "Ljava/util/Properties;", "properties", "", "load", "(Ljava/util/Properties;Ljava/lang/String;)V", "loadProperties", "()Ljava/util/Properties;", "()Ljava/lang/String;", "id", "", "", "args", "getText", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "", "getKeys", "()Ljava/util/Set;", "Lkotlinx/datetime/LocalDateTime;", "date", "Lcom/crosspaste/utils/DateTimeFormatOptions;", "options", "getDate", "(Lkotlinx/datetime/LocalDateTime;Lcom/crosspaste/utils/DateTimeFormatOptions;)Ljava/lang/String;", "getAbridge", "Ljava/lang/String;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "getLogger", "()Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/DateUtils;", "dateUtils", "Lcom/crosspaste/utils/DateUtils;", "Ljava/util/Properties;", "currentLanguage", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nI18n.kt\nKotlin\n*S Kotlin\n*F\n+ 1 I18n.kt\ncom/crosspaste/i18n/DesktopCopywriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1563#2:199\n1634#2,3:200\n*S KotlinDebug\n*F\n+ 1 I18n.kt\ncom/crosspaste/i18n/DesktopCopywriter\n*L\n189#1:199\n189#1:200,3\n*E\n"})
public final class DesktopCopywriter
implements Copywriter {
    @NotNull
    private final String language;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final DateUtils dateUtils;
    @NotNull
    private final Properties properties;
    @NotNull
    private String currentLanguage;
    public static final int $stable = 8;

    public DesktopCopywriter(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.language = language;
        this.logger = KotlinLogging.INSTANCE.logger(DesktopCopywriter::logger$lambda$0);
        this.dateUtils = DateUtilsKt.getDateUtils();
        this.properties = this.loadProperties();
        this.currentLanguage = "en";
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    private final void load(Properties properties, String language) {
        void it;
        InputStream inputStream = DesktopCopywriter.class.getResourceAsStream("/i18n/" + language + ".properties");
        if (inputStream == null) {
            throw new FileNotFoundException("No properties for " + language);
        }
        InputStream inputStream2 = inputStream;
        Properties properties2 = properties;
        boolean bl = false;
        properties2.load(new InputStreamReader((InputStream)it, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - void declaration
     */
    private final Properties loadProperties() {
        Object object;
        Object $this$loadProperties_u24lambda_u242;
        Properties properties = new Properties();
        Object object2 = this;
        DesktopCopywriter desktopCopywriter = this;
        try {
            $this$loadProperties_u24lambda_u242 = object2;
            boolean bl = false;
            super.load(properties, ((DesktopCopywriter)$this$loadProperties_u24lambda_u242).language);
            $this$loadProperties_u24lambda_u242 = Result.constructor-impl((Object)((DesktopCopywriter)$this$loadProperties_u24lambda_u242).language);
        }
        catch (Throwable bl) {
            $this$loadProperties_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        DesktopCopywriter desktopCopywriter2 = desktopCopywriter;
        object2 = $this$loadProperties_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            void e;
            $this$loadProperties_u24lambda_u242 = throwable;
            desktopCopywriter = desktopCopywriter2;
            boolean bl = false;
            this.logger.error((Throwable)e, () -> DesktopCopywriter.loadProperties$lambda$4$lambda$3(this));
            this.load(properties, "en");
            object = "en";
            desktopCopywriter2 = desktopCopywriter;
        }
        desktopCopywriter2.currentLanguage = (String)object;
        return properties;
    }

    @Override
    @NotNull
    public String language() {
        return this.language;
    }

    @Override
    @NotNull
    public String getText(@NotNull String id, Object ... args) {
        String string2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                String value = this.properties.getProperty(id);
                string2 = value;
                if (string2 == null) break block2;
                Object[] objectArray = Arrays.copyOf(args, args.length);
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                string2 = string3;
                if (string3 != null) break block3;
            }
            string2 = "";
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getKeys() {
        void $this$mapTo$iv$iv;
        Set<Object> set = this.properties.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public String getDate(@NotNull LocalDateTime date, @NotNull DateTimeFormatOptions options) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.dateUtils.getDateDesc(date, options, this.language);
    }

    @Override
    @NotNull
    public String getAbridge() {
        return this.language;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object loadProperties$lambda$4$lambda$3(DesktopCopywriter this$0) {
        return "Error loading " + this$0.language + " properties";
    }
}

