/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.db.task;

import androidx.compose.runtime.internal.StabilityInferred;
import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.TransactionWithReturn;
import com.crosspaste.Database;
import com.crosspaste.db.PasteTaskDatabaseQueries;
import com.crosspaste.db.PasteTaskEntity;
import com.crosspaste.db.task.BaseExtraInfo;
import com.crosspaste.db.task.PasteTask;
import com.crosspaste.db.task.PasteTaskExtraInfo;
import com.crosspaste.utils.DateUtils;
import com.crosspaste.utils.JsonUtils;
import com.crosspaste.utils.JsonUtils_desktopKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001e\u0010\u0011J\u0015\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001f\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/crosspaste/db/task/TaskDao;", "", "Lcom/crosspaste/Database;", "database", "<init>", "(Lcom/crosspaste/Database;)V", "", "pasteDataId", "", "taskType", "Lcom/crosspaste/db/task/PasteTaskExtraInfo;", "extraInfo", "createTask", "(Ljava/lang/Long;ILcom/crosspaste/db/task/PasteTaskExtraInfo;)J", "taskId", "", "executingTask", "(J)V", "", "newExtraInfo", "successTask", "(JLjava/lang/String;)V", "", "needRetry", "failureTask", "(JZLjava/lang/String;)V", "Lcom/crosspaste/db/task/PasteTask;", "getTask", "(J)Lcom/crosspaste/db/task/PasteTask;", "time", "cleanSuccessTask", "cleanFailureTask", "Lcom/crosspaste/Database;", "Lcom/crosspaste/utils/JsonUtils;", "jsonUtils", "Lcom/crosspaste/utils/JsonUtils;", "Lcom/crosspaste/db/PasteTaskDatabaseQueries;", "pasteTaskDatabaseQueries", "Lcom/crosspaste/db/PasteTaskDatabaseQueries;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTaskDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskDao.kt\ncom/crosspaste/db/task/TaskDao\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,96:1\n205#2:97\n*S KotlinDebug\n*F\n+ 1 TaskDao.kt\ncom/crosspaste/db/task/TaskDao\n*L\n26#1:97\n*E\n"})
public final class TaskDao {
    @NotNull
    private final Database database;
    @NotNull
    private final JsonUtils jsonUtils;
    @NotNull
    private final PasteTaskDatabaseQueries pasteTaskDatabaseQueries;
    public static final int $stable = 8;

    public TaskDao(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.jsonUtils = JsonUtils_desktopKt.getJsonUtils();
        this.pasteTaskDatabaseQueries = this.database.getPasteTaskDatabaseQueries();
    }

    public final long createTask(@Nullable Long pasteDataId, int taskType, @NotNull PasteTaskExtraInfo extraInfo) {
        Intrinsics.checkNotNullParameter((Object)extraInfo, (String)"extraInfo");
        long now = DateUtils.INSTANCE.nowEpochMilliseconds();
        return ((Number)Transacter.DefaultImpls.transactionWithResult$default((Transacter)this.database, (boolean)false, arg_0 -> TaskDao.createTask$lambda$0(this, pasteDataId, taskType, now, extraInfo, arg_0), (int)1, null)).longValue();
    }

    public static /* synthetic */ long createTask$default(TaskDao taskDao, Long l, int n, PasteTaskExtraInfo pasteTaskExtraInfo, int n2, Object object) {
        if ((n2 & 4) != 0) {
            pasteTaskExtraInfo = (PasteTaskExtraInfo)new BaseExtraInfo();
        }
        return taskDao.createTask(l, n, pasteTaskExtraInfo);
    }

    public final void executingTask(long taskId) {
        this.pasteTaskDatabaseQueries.executingTask(1, DateUtils.INSTANCE.nowEpochMilliseconds(), taskId);
    }

    public final void successTask(long taskId, @Nullable String newExtraInfo) {
        String string2 = newExtraInfo;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.pasteTaskDatabaseQueries.finishTaskWithExtraInfo(2, DateUtils.INSTANCE.nowEpochMilliseconds(), newExtraInfo, taskId);
        } else {
            TaskDao $this$successTask_u24lambda_u242 = this;
            boolean bl = false;
            $this$successTask_u24lambda_u242.pasteTaskDatabaseQueries.finishTask(2, DateUtils.INSTANCE.nowEpochMilliseconds(), taskId);
        }
    }

    public final void failureTask(long taskId, boolean needRetry, @Nullable String newExtraInfo) {
        String string2 = newExtraInfo;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.pasteTaskDatabaseQueries.finishTaskWithExtraInfo(needRetry ? 0 : 3, DateUtils.INSTANCE.nowEpochMilliseconds(), newExtraInfo, taskId);
        } else {
            TaskDao $this$failureTask_u24lambda_u244 = this;
            boolean bl = false;
            $this$failureTask_u24lambda_u244.pasteTaskDatabaseQueries.finishTask(needRetry ? 0 : 3, DateUtils.INSTANCE.nowEpochMilliseconds(), taskId);
        }
    }

    @Nullable
    public final PasteTask getTask(long taskId) {
        PasteTask pasteTask;
        PasteTaskEntity pasteTaskEntity = (PasteTaskEntity)this.pasteTaskDatabaseQueries.getTask(taskId).executeAsOneOrNull();
        if (pasteTaskEntity != null) {
            PasteTaskEntity it = pasteTaskEntity;
            boolean bl = false;
            pasteTask = new PasteTask(it.getTaskId(), it.getPasteDataId(), it.getTaskType(), it.getStatus(), it.getCreateTime(), it.getModifyTime(), it.getExtraInfo());
        } else {
            pasteTask = null;
        }
        return pasteTask;
    }

    public final void cleanSuccessTask(long time) {
        this.pasteTaskDatabaseQueries.cleanSuccess(time);
    }

    public final void cleanFailureTask(long time) {
        this.pasteTaskDatabaseQueries.cleanFail(time);
    }

    /*
     * WARNING - void declaration
     */
    private static final long createTask$lambda$0(TaskDao this$0, Long $pasteDataId, int $taskType, long $now, PasteTaskExtraInfo $extraInfo, TransactionWithReturn $this$transactionWithResult) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$transactionWithResult, (String)"$this$transactionWithResult");
        PasteTaskDatabaseQueries pasteTaskDatabaseQueries = this$0.pasteTaskDatabaseQueries;
        Json json = this$0.jsonUtils.getJSON();
        PasteTaskExtraInfo value$iv = $extraInfo;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        pasteTaskDatabaseQueries.createTask($pasteDataId, $taskType, 0, $now, $now, this_$iv.encodeToString((SerializationStrategy)PasteTaskExtraInfo.Companion.serializer(), (Object)value$iv));
        return ((Number)this$0.pasteTaskDatabaseQueries.getLastId().executeAsOne()).longValue();
    }
}

