/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.db.secure;

import androidx.compose.runtime.internal.StabilityInferred;
import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.TransactionWithReturn;
import com.crosspaste.Database;
import com.crosspaste.db.SecureDatabaseQueries;
import com.crosspaste.db.secure.SecureIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/crosspaste/db/secure/SecureDao;", "Lcom/crosspaste/db/secure/SecureIO;", "Lcom/crosspaste/Database;", "database", "<init>", "(Lcom/crosspaste/Database;)V", "", "appInstanceId", "", "serialized", "", "saveCryptPublicKey", "(Ljava/lang/String;[B)Z", "existCryptPublicKey", "(Ljava/lang/String;)Z", "", "deleteCryptPublicKey", "(Ljava/lang/String;)V", "serializedPublicKey", "(Ljava/lang/String;)[B", "Lcom/crosspaste/Database;", "Lcom/crosspaste/db/SecureDatabaseQueries;", "secureDatabaseQueries", "Lcom/crosspaste/db/SecureDatabaseQueries;", "app"})
@StabilityInferred(parameters=0)
public final class SecureDao
implements SecureIO {
    @NotNull
    private final Database database;
    @NotNull
    private final SecureDatabaseQueries secureDatabaseQueries;
    public static final int $stable = 8;

    public SecureDao(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.secureDatabaseQueries = this.database.getSecureDatabaseQueries();
    }

    @Override
    public boolean saveCryptPublicKey(@NotNull String appInstanceId, @NotNull byte[] serialized) {
        Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
        Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
        return (Boolean)Transacter.DefaultImpls.transactionWithResult$default((Transacter)this.database, (boolean)false, arg_0 -> SecureDao.saveCryptPublicKey$lambda$0(this, appInstanceId, serialized, arg_0), (int)1, null);
    }

    @Override
    public boolean existCryptPublicKey(@NotNull String appInstanceId) {
        Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
        return (Boolean)this.secureDatabaseQueries.checkKeyExists(appInstanceId).executeAsOne();
    }

    @Override
    public void deleteCryptPublicKey(@NotNull String appInstanceId) {
        Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
        this.secureDatabaseQueries.deleteCryptPublicKey(appInstanceId);
    }

    @Override
    @Nullable
    public byte[] serializedPublicKey(@NotNull String appInstanceId) {
        Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
        return (byte[])this.secureDatabaseQueries.getSerialized(appInstanceId).executeAsOneOrNull();
    }

    private static final boolean saveCryptPublicKey$lambda$0(SecureDao this$0, String $appInstanceId, byte[] $serialized, TransactionWithReturn $this$transactionWithResult) {
        Intrinsics.checkNotNullParameter((Object)$this$transactionWithResult, (String)"$this$transactionWithResult");
        boolean result2 = (Boolean)this$0.secureDatabaseQueries.checkKeyExists($appInstanceId).executeAsOne();
        this$0.secureDatabaseQueries.saveCryptPublicKey($appInstanceId, $serialized);
        return result2;
    }
}

