/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.db;

import androidx.compose.runtime.internal.StabilityInferred;
import app.cash.sqldelight.Query;
import app.cash.sqldelight.TransacterImpl;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import app.cash.sqldelight.db.SqlPreparedStatement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000bJ\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/crosspaste/db/SecureDatabaseQueries;", "Lapp/cash/sqldelight/TransacterImpl;", "Lapp/cash/sqldelight/db/SqlDriver;", "driver", "<init>", "(Lapp/cash/sqldelight/db/SqlDriver;)V", "", "appInstanceId", "Lapp/cash/sqldelight/Query;", "", "checkKeyExists", "(Ljava/lang/String;)Lapp/cash/sqldelight/Query;", "", "getSerialized", "serialized", "", "saveCryptPublicKey", "(Ljava/lang/String;[B)V", "deleteCryptPublicKey", "(Ljava/lang/String;)V", "CheckKeyExistsQuery", "GetSerializedQuery", "app"})
@StabilityInferred(parameters=0)
public final class SecureDatabaseQueries
extends TransacterImpl {
    public static final int $stable = 8;

    public SecureDatabaseQueries(@NotNull SqlDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        super(driver);
    }

    @NotNull
    public final Query<Boolean> checkKeyExists(@NotNull String appInstanceId) {
        Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
        return new CheckKeyExistsQuery(appInstanceId, SecureDatabaseQueries::checkKeyExists$lambda$0);
    }

    @NotNull
    public final Query<byte[]> getSerialized(@NotNull String appInstanceId) {
        Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
        return new GetSerializedQuery(appInstanceId, SecureDatabaseQueries::getSerialized$lambda$1);
    }

    public final void saveCryptPublicKey(@NotNull String appInstanceId, @NotNull byte[] serialized) {
        Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
        Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
        this.getDriver().execute(Integer.valueOf(1758189203), "INSERT OR REPLACE INTO CryptPublicKey(appInstanceId, serialized)\nVALUES (?, ?)", 2, arg_0 -> SecureDatabaseQueries.saveCryptPublicKey$lambda$2(appInstanceId, serialized, arg_0));
        this.notifyQueries(1758189203, SecureDatabaseQueries::saveCryptPublicKey$lambda$3);
    }

    public final void deleteCryptPublicKey(@NotNull String appInstanceId) {
        Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
        this.getDriver().execute(Integer.valueOf(-666544447), "DELETE FROM CryptPublicKey WHERE appInstanceId = ?", 1, arg_0 -> SecureDatabaseQueries.deleteCryptPublicKey$lambda$4(appInstanceId, arg_0));
        this.notifyQueries(-666544447, SecureDatabaseQueries::deleteCryptPublicKey$lambda$5);
    }

    private static final boolean checkKeyExists$lambda$0(SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        Boolean bl = cursor.getBoolean(0);
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    private static final byte[] getSerialized$lambda$1(SqlCursor cursor) {
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        byte[] byArray = cursor.getBytes(0);
        Intrinsics.checkNotNull((Object)byArray);
        return byArray;
    }

    private static final Unit saveCryptPublicKey$lambda$2(String $appInstanceId, byte[] $serialized, SqlPreparedStatement $this$execute) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"$this$execute");
        $this$execute.bindString(0, $appInstanceId);
        $this$execute.bindBytes(1, $serialized);
        return Unit.INSTANCE;
    }

    private static final Unit saveCryptPublicKey$lambda$3(Function1 emit2) {
        Intrinsics.checkNotNullParameter((Object)emit2, (String)"emit");
        emit2.invoke((Object)"CryptPublicKey");
        return Unit.INSTANCE;
    }

    private static final Unit deleteCryptPublicKey$lambda$4(String $appInstanceId, SqlPreparedStatement $this$execute) {
        Intrinsics.checkNotNullParameter((Object)$this$execute, (String)"$this$execute");
        $this$execute.bindString(0, $appInstanceId);
        return Unit.INSTANCE;
    }

    private static final Unit deleteCryptPublicKey$lambda$5(Function1 emit2) {
        Intrinsics.checkNotNullParameter((Object)emit2, (String)"emit");
        emit2.invoke((Object)"CryptPublicKey");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B#\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ5\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012\"\u0004\b\u0001\u0010\u00112\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00120\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/crosspaste/db/SecureDatabaseQueries$CheckKeyExistsQuery;", "", "T", "Lapp/cash/sqldelight/Query;", "", "appInstanceId", "Lkotlin/Function1;", "Lapp/cash/sqldelight/db/SqlCursor;", "mapper", "<init>", "(Lcom/crosspaste/db/SecureDatabaseQueries;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Lapp/cash/sqldelight/Query$Listener;", "listener", "", "addListener", "(Lapp/cash/sqldelight/Query$Listener;)V", "removeListener", "R", "Lapp/cash/sqldelight/db/QueryResult;", "execute", "(Lkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getAppInstanceId", "app"})
    private final class CheckKeyExistsQuery<T>
    extends Query<T> {
        @NotNull
        private final String appInstanceId;

        public CheckKeyExistsQuery(@NotNull String appInstanceId, Function1<? super SqlCursor, ? extends T> mapper) {
            Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            super(mapper);
            this.appInstanceId = appInstanceId;
        }

        @NotNull
        public final String getAppInstanceId() {
            return this.appInstanceId;
        }

        public void addListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"CryptPublicKey"};
            SecureDatabaseQueries.this.getDriver().addListener(stringArray, listener);
        }

        public void removeListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"CryptPublicKey"};
            SecureDatabaseQueries.this.getDriver().removeListener(stringArray, listener);
        }

        @NotNull
        public <R> QueryResult<R> execute(@NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            return SecureDatabaseQueries.this.getDriver().executeQuery(Integer.valueOf(566644929), "SELECT EXISTS(SELECT 1 FROM CryptPublicKey WHERE appInstanceId = ?) AS isExist", mapper, 1, arg_0 -> CheckKeyExistsQuery.execute$lambda$0(this, arg_0));
        }

        @NotNull
        public String toString() {
            return "SecureDatabase.sq:checkKeyExists";
        }

        private static final Unit execute$lambda$0(CheckKeyExistsQuery this$0, SqlPreparedStatement $this$executeQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$executeQuery, (String)"$this$executeQuery");
            $this$executeQuery.bindString(0, this$0.appInstanceId);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B#\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ5\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012\"\u0004\b\u0001\u0010\u00112\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00120\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/crosspaste/db/SecureDatabaseQueries$GetSerializedQuery;", "", "T", "Lapp/cash/sqldelight/Query;", "", "appInstanceId", "Lkotlin/Function1;", "Lapp/cash/sqldelight/db/SqlCursor;", "mapper", "<init>", "(Lcom/crosspaste/db/SecureDatabaseQueries;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Lapp/cash/sqldelight/Query$Listener;", "listener", "", "addListener", "(Lapp/cash/sqldelight/Query$Listener;)V", "removeListener", "R", "Lapp/cash/sqldelight/db/QueryResult;", "execute", "(Lkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getAppInstanceId", "app"})
    private final class GetSerializedQuery<T>
    extends Query<T> {
        @NotNull
        private final String appInstanceId;

        public GetSerializedQuery(@NotNull String appInstanceId, Function1<? super SqlCursor, ? extends T> mapper) {
            Intrinsics.checkNotNullParameter((Object)appInstanceId, (String)"appInstanceId");
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            super(mapper);
            this.appInstanceId = appInstanceId;
        }

        @NotNull
        public final String getAppInstanceId() {
            return this.appInstanceId;
        }

        public void addListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"CryptPublicKey"};
            SecureDatabaseQueries.this.getDriver().addListener(stringArray, listener);
        }

        public void removeListener(@NotNull Query.Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            String[] stringArray = new String[]{"CryptPublicKey"};
            SecureDatabaseQueries.this.getDriver().removeListener(stringArray, listener);
        }

        @NotNull
        public <R> QueryResult<R> execute(@NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper) {
            Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
            return SecureDatabaseQueries.this.getDriver().executeQuery(Integer.valueOf(1633999468), "SELECT serialized FROM CryptPublicKey WHERE appInstanceId = ?", mapper, 1, arg_0 -> GetSerializedQuery.execute$lambda$0(this, arg_0));
        }

        @NotNull
        public String toString() {
            return "SecureDatabase.sq:getSerialized";
        }

        private static final Unit execute$lambda$0(GetSerializedQuery this$0, SqlPreparedStatement $this$executeQuery) {
            Intrinsics.checkNotNullParameter((Object)$this$executeQuery, (String)"$this$executeQuery");
            $this$executeQuery.bindString(0, this$0.appInstanceId);
            return Unit.INSTANCE;
        }
    }
}

