/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.db;

import androidx.compose.runtime.internal.StabilityInferred;
import app.cash.sqldelight.db.SqlDriver;
import app.cash.sqldelight.driver.jdbc.sqlite.JdbcSqliteDriver;
import com.crosspaste.Database;
import com.crosspaste.app.AppFileType;
import com.crosspaste.db.DriverFactory;
import com.crosspaste.path.UserDataPathProvider;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR\u001a\u0010\u000e\u001a\u00020\r8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u0004\u0018\u00010\u00068\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/crosspaste/db/DesktopDriverFactory;", "Lcom/crosspaste/db/DriverFactory;", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/path/UserDataPathProvider;)V", "Lapp/cash/sqldelight/db/SqlDriver;", "createDriver", "()Lapp/cash/sqldelight/db/SqlDriver;", "", "closeDriver", "()V", "Lcom/crosspaste/path/UserDataPathProvider;", "", "dbName", "Ljava/lang/String;", "getDbName", "()Ljava/lang/String;", "sqlDriver", "Lapp/cash/sqldelight/db/SqlDriver;", "getSqlDriver", "setSqlDriver", "(Lapp/cash/sqldelight/db/SqlDriver;)V", "app"})
@StabilityInferred(parameters=0)
public final class DesktopDriverFactory
implements DriverFactory {
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final String dbName;
    @Nullable
    private SqlDriver sqlDriver;
    public static final int $stable = 8;

    public DesktopDriverFactory(@NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.userDataPathProvider = userDataPathProvider;
        this.dbName = "crosspaste.db";
    }

    @Override
    @NotNull
    public String getDbName() {
        return this.dbName;
    }

    @Override
    @Nullable
    public SqlDriver getSqlDriver() {
        return this.sqlDriver;
    }

    @Override
    public void setSqlDriver(@Nullable SqlDriver sqlDriver) {
        this.sqlDriver = sqlDriver;
    }

    @Override
    @NotNull
    public SqlDriver createDriver() {
        Properties properties;
        Path path = this.userDataPathProvider.resolve(this.getDbName(), AppFileType.DATA);
        Properties $this$createDriver_u24lambda_u240 = properties = new Properties();
        boolean bl = false;
        $this$createDriver_u24lambda_u240.put("busy_timeout", "30000");
        $this$createDriver_u24lambda_u240.put("journal_mode", "WAL");
        $this$createDriver_u24lambda_u240.put("synchronous", "NORMAL");
        Properties properties2 = properties;
        SqlDriver driver = (SqlDriver)new JdbcSqliteDriver("jdbc:sqlite:" + path, properties2);
        Database.Companion.getSchema().create(driver);
        this.setSqlDriver(driver);
        return driver;
    }

    @Override
    public void closeDriver() {
        SqlDriver sqlDriver = this.getSqlDriver();
        if (sqlDriver != null) {
            sqlDriver.close();
        }
        this.setSqlDriver(null);
    }
}

