/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.config;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.config.ConfigManager;
import com.crosspaste.config.DesktopAppConfig;
import com.crosspaste.i18n.GlobalCopywriter;
import com.crosspaste.notification.MessageType;
import com.crosspaste.notification.NotificationManager;
import com.crosspaste.presist.OneFilePersist;
import com.crosspaste.utils.DeviceUtils;
import com.crosspaste.utils.LocaleUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J+\u0010\u0013\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001cR\u001a\u0010\u0006\u001a\u00020\u00058\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020$8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010%\u001a\u0004\b&\u0010'R$\u0010)\u001a\u0004\u0018\u00010(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lcom/crosspaste/config/DesktopConfigManager;", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/config/DesktopAppConfig;", "Lcom/crosspaste/presist/OneFilePersist;", "configFilePersist", "Lcom/crosspaste/utils/DeviceUtils;", "deviceUtils", "Lcom/crosspaste/utils/LocaleUtils;", "localeUtils", "<init>", "(Lcom/crosspaste/presist/OneFilePersist;Lcom/crosspaste/utils/DeviceUtils;Lcom/crosspaste/utils/LocaleUtils;)V", "loadConfig", "()Lcom/crosspaste/config/DesktopAppConfig;", "createDefaultAppConfig", "", "key", "", "value", "", "updateConfig", "(Ljava/lang/String;Ljava/lang/Object;)V", "", "keys", "values", "(Ljava/util/List;Ljava/util/List;)V", "config", "saveConfig", "(Lcom/crosspaste/config/DesktopAppConfig;)V", "Lcom/crosspaste/presist/OneFilePersist;", "Lcom/crosspaste/utils/DeviceUtils;", "getDeviceUtils", "()Lcom/crosspaste/utils/DeviceUtils;", "Lcom/crosspaste/utils/LocaleUtils;", "Lkotlinx/coroutines/flow/MutableStateFlow;", "_config", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lkotlinx/coroutines/flow/StateFlow;", "Lkotlinx/coroutines/flow/StateFlow;", "getConfig", "()Lkotlinx/coroutines/flow/StateFlow;", "Lcom/crosspaste/notification/NotificationManager;", "notificationManager", "Lcom/crosspaste/notification/NotificationManager;", "getNotificationManager", "()Lcom/crosspaste/notification/NotificationManager;", "setNotificationManager", "(Lcom/crosspaste/notification/NotificationManager;)V", "app"})
@StabilityInferred(parameters=0)
public final class DesktopConfigManager
implements ConfigManager<DesktopAppConfig> {
    @NotNull
    private final OneFilePersist configFilePersist;
    @NotNull
    private final DeviceUtils deviceUtils;
    @NotNull
    private final LocaleUtils localeUtils;
    @NotNull
    private final MutableStateFlow<DesktopAppConfig> _config;
    @NotNull
    private final StateFlow<DesktopAppConfig> config;
    @Nullable
    private NotificationManager notificationManager;
    public static final int $stable = 8;

    public DesktopConfigManager(@NotNull OneFilePersist configFilePersist, @NotNull DeviceUtils deviceUtils, @NotNull LocaleUtils localeUtils) {
        Object object;
        Object $this$_config_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)configFilePersist, (String)"configFilePersist");
        Intrinsics.checkNotNullParameter((Object)deviceUtils, (String)"deviceUtils");
        Intrinsics.checkNotNullParameter((Object)localeUtils, (String)"localeUtils");
        this.configFilePersist = configFilePersist;
        this.deviceUtils = deviceUtils;
        this.localeUtils = localeUtils;
        Object object2 = this;
        DesktopConfigManager desktopConfigManager = this;
        try {
            $this$_config_u24lambda_u240 = object2;
            boolean bl = false;
            DesktopAppConfig desktopAppConfig = ((DesktopConfigManager)$this$_config_u24lambda_u240).loadConfig();
            if (desktopAppConfig == null) {
                desktopAppConfig = super.createDefaultAppConfig();
            }
            $this$_config_u24lambda_u240 = Result.constructor-impl((Object)desktopAppConfig);
        }
        catch (Throwable bl) {
            $this$_config_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        DesktopConfigManager desktopConfigManager2 = desktopConfigManager;
        object2 = $this$_config_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            $this$_config_u24lambda_u240 = throwable;
            desktopConfigManager = desktopConfigManager2;
            boolean bl = false;
            object = this.createDefaultAppConfig();
            desktopConfigManager2 = desktopConfigManager;
        }
        desktopConfigManager2._config = StateFlowKt.MutableStateFlow((Object)object);
        this.config = (StateFlow)this._config;
    }

    @NotNull
    public DeviceUtils getDeviceUtils() {
        return this.deviceUtils;
    }

    @NotNull
    public StateFlow<DesktopAppConfig> getConfig() {
        return this.config;
    }

    @Nullable
    public final NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public final void setNotificationManager(@Nullable NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Nullable
    public DesktopAppConfig loadConfig() {
        return (DesktopAppConfig)this.configFilePersist.read(Reflection.getOrCreateKotlinClass(DesktopAppConfig.class));
    }

    private final DesktopAppConfig createDefaultAppConfig() {
        return new DesktopAppConfig(this.getDeviceUtils().createAppInstanceId(), this.localeUtils.getLanguage(), null, false, false, false, false, null, null, 0, false, false, 0, 0, false, 0L, 0, false, null, false, 0, false, false, 0L, false, 0L, false, null, false, null, false, false, null, -4, 1, null);
    }

    public synchronized void updateConfig(@NotNull String key, @NotNull Object value) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            DesktopAppConfig oldConfig = (DesktopAppConfig)this._config.getValue();
            this._config.setValue((Object)oldConfig.copy(key, value));
            Object object2 = this;
            try {
                DesktopConfigManager $this$updateConfig_u24lambda_u242 = object2;
                boolean bl = false;
                $this$updateConfig_u24lambda_u242.saveConfig((DesktopAppConfig)$this$updateConfig_u24lambda_u242._config.getValue());
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object it = object = throwable;
            boolean bl = false;
            NotificationManager notificationManager = this.notificationManager;
            if (notificationManager != null) {
                NotificationManager manager = notificationManager;
                boolean bl2 = false;
                NotificationManager.sendNotification$default(manager, DesktopConfigManager::updateConfig$lambda$5$lambda$4$lambda$3, null, MessageType.Error, null, 10, null);
            }
            this._config.setValue((Object)oldConfig);
        }
    }

    public synchronized void updateConfig(@NotNull List<String> keys, @NotNull List<? extends Object> values) {
        block5: {
            Object object;
            DesktopAppConfig oldConfig;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            if (!(keys.size() == values.size())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            DesktopAppConfig newConfig = oldConfig = (DesktopAppConfig)this._config.getValue();
            int n = ((Collection)keys).size();
            for (int i = 0; i < n; ++i) {
                newConfig = newConfig.copy(keys.get(i), values.get(i));
            }
            this._config.setValue((Object)newConfig);
            Object object2 = this;
            try {
                DesktopConfigManager $this$updateConfig_u24lambda_u246 = object2;
                boolean bl = false;
                $this$updateConfig_u24lambda_u246.saveConfig((DesktopAppConfig)$this$updateConfig_u24lambda_u246._config.getValue());
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block5;
            Object it = object = throwable;
            boolean bl = false;
            NotificationManager notificationManager = this.notificationManager;
            if (notificationManager != null) {
                NotificationManager manager = notificationManager;
                boolean bl2 = false;
                NotificationManager.sendNotification$default(manager, DesktopConfigManager::updateConfig$lambda$9$lambda$8$lambda$7, null, MessageType.Error, null, 10, null);
            }
            this._config.setValue((Object)oldConfig);
        }
    }

    public final void saveConfig(@NotNull DesktopAppConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.configFilePersist.save((Object)config);
    }

    @NotNull
    public DesktopAppConfig getCurrentConfig() {
        return (DesktopAppConfig)super.getCurrentConfig();
    }

    private static final String updateConfig$lambda$5$lambda$4$lambda$3(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("failed_to_save_config", new Object[0]);
    }

    private static final String updateConfig$lambda$9$lambda$8$lambda$7(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("failed_to_save_config", new Object[0]);
    }
}

